/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.config.Daten;
import mediathek.config.Icons;
import mediathek.config.MVConfig;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.gui.messages.ProgramLocationChangedEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.Functions;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.Log;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.TextCopyPasteHandler;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.lang3.SystemUtils;

public class PanelEinstellungenErweitert
extends PanelVorlage {
    private JButton jButtonHilfeNeuladen;
    private JButton jButtonHilfeProgrammDateimanager;
    private JButton jButtonHilfeProgrammShutdown;
    private JButton jButtonHilfeProgrammUrl;
    private JButton jButtonHilfeVideoplayer;
    private JButton jButtonProgrammDateimanager;
    private JButton jButtonProgrammShutdown;
    private JButton jButtonProgrammUrl;
    private JButton jButtonProgrammVideoplayer;
    private JCheckBox jCheckBoxAboSuchen;
    private JCheckBox jCheckBoxDownloadSofortStarten;
    private JTextField jTextFieldProgrammDateimanager;
    private JTextField jTextFieldProgrammShutdown;
    private JTextField jTextFieldProgrammUrl;
    private JTextField jTextFieldVideoplayer;

    @Handler
    private void handleProgramLocationChangedEvent(ProgramLocationChangedEvent e) {
        SwingUtilities.invokeLater(this::init);
    }

    public PanelEinstellungenErweitert(Daten d, JFrame pparentComponent) {
        super(d, pparentComponent);
        this.initComponents();
        this.daten = d;
        this.init();
        this.setIcon();
        this.setHelp();
        this.jCheckBoxAboSuchen.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ABOS_SOFORT_SUCHEN)));
        this.jCheckBoxAboSuchen.addActionListener(e -> MVConfig.add(MVConfig.Configs.SYSTEM_ABOS_SOFORT_SUCHEN, Boolean.toString(this.jCheckBoxAboSuchen.isSelected())));
        this.jCheckBoxDownloadSofortStarten.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_DOWNLOAD_SOFORT_STARTEN)));
        this.jCheckBoxDownloadSofortStarten.addActionListener(e -> MVConfig.add(MVConfig.Configs.SYSTEM_DOWNLOAD_SOFORT_STARTEN, Boolean.toString(this.jCheckBoxDownloadSofortStarten.isSelected())));
        this.jButtonProgrammDateimanager.addActionListener(new BeobPfad(MVConfig.Configs.SYSTEM_ORDNER_OEFFNEN, "Dateimanager suchen", this.jTextFieldProgrammDateimanager));
        this.jButtonProgrammVideoplayer.addActionListener(new BeobPfad(MVConfig.Configs.SYSTEM_PLAYER_ABSPIELEN, "Videoplayer suchen", this.jTextFieldVideoplayer));
        this.jButtonProgrammUrl.addActionListener(new BeobPfad(MVConfig.Configs.SYSTEM_URL_OEFFNEN, "Browser suchen", this.jTextFieldProgrammUrl));
        this.jButtonProgrammShutdown.addActionListener(new BeobPfad(MVConfig.Configs.SYSTEM_LINUX_SHUTDOWN, "Shutdown Befehl", this.jTextFieldProgrammShutdown));
        this.jTextFieldProgrammDateimanager.setText(MVConfig.get(MVConfig.Configs.SYSTEM_ORDNER_OEFFNEN));
        this.jTextFieldProgrammDateimanager.getDocument().addDocumentListener(new BeobDoc(MVConfig.Configs.SYSTEM_ORDNER_OEFFNEN, this.jTextFieldProgrammDateimanager));
        TextCopyPasteHandler<JTextField> handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldProgrammDateimanager);
        this.jTextFieldProgrammDateimanager.setComponentPopupMenu(handler.getPopupMenu());
        this.jTextFieldVideoplayer.setText(MVConfig.get(MVConfig.Configs.SYSTEM_PLAYER_ABSPIELEN));
        this.jTextFieldVideoplayer.getDocument().addDocumentListener(new BeobDoc(MVConfig.Configs.SYSTEM_PLAYER_ABSPIELEN, this.jTextFieldVideoplayer));
        handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldVideoplayer);
        this.jTextFieldVideoplayer.setComponentPopupMenu(handler.getPopupMenu());
        this.jTextFieldProgrammUrl.setText(this.getWebBrowserLocation());
        this.jTextFieldProgrammUrl.getDocument().addDocumentListener(new BeobDoc(MVConfig.Configs.SYSTEM_URL_OEFFNEN, this.jTextFieldProgrammUrl));
        handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldProgrammUrl);
        this.jTextFieldProgrammUrl.setComponentPopupMenu(handler.getPopupMenu());
        this.jTextFieldProgrammShutdown.setText(MVConfig.get(MVConfig.Configs.SYSTEM_LINUX_SHUTDOWN));
        if (this.jTextFieldProgrammShutdown.getText().isEmpty()) {
            this.jTextFieldProgrammShutdown.setText("shutdown -h now");
            MVConfig.add(MVConfig.Configs.SYSTEM_LINUX_SHUTDOWN, "shutdown -h now");
        }
        this.jTextFieldProgrammShutdown.getDocument().addDocumentListener(new BeobDoc(MVConfig.Configs.SYSTEM_LINUX_SHUTDOWN, this.jTextFieldProgrammShutdown));
        handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldProgrammShutdown);
        this.jTextFieldProgrammShutdown.setComponentPopupMenu(handler.getPopupMenu());
        if (Functions.getOs() != Functions.OperatingSystemType.LINUX) {
            this.jButtonHilfeProgrammShutdown.setEnabled(false);
            this.jTextFieldProgrammShutdown.setEnabled(false);
            this.jButtonProgrammShutdown.setEnabled(false);
        }
        this.daten.getMessageBus().subscribe(this);
    }

    private String getWebBrowserLocation() {
        return MVConfig.get(MVConfig.Configs.SYSTEM_URL_OEFFNEN);
    }

    private void init() {
        this.jTextFieldProgrammDateimanager.setText(MVConfig.get(MVConfig.Configs.SYSTEM_ORDNER_OEFFNEN));
        this.jTextFieldProgrammUrl.setText(this.getWebBrowserLocation());
    }

    private void setHelp() {
        this.jButtonHilfeProgrammDateimanager.addActionListener(e -> new DialogHilfe(this.parentComponent, true, "\nIm Tab \"Downloads\" kann man mit der rechten\nMaustaste den Downloadordner (Zielordner)\ndes jeweiligen Downloads \u00f6ffnen.\nNormalerweise wird der Dateimanager des\nBetriebssystems gefunden und ge\u00f6ffnet. Klappt das nicht,\nkann hier ein Programm daf\u00fcr angegeben werden.").setVisible(true));
        this.jButtonHilfeNeuladen.addActionListener(e -> new DialogHilfe(this.parentComponent, true, "\nAbos automatisch suchen:\nNach dem Neuladen einer Filmliste wird dann\nsofort nach neuen Abos gesucht. Ansonsten muss man\nim Tab Download auf \"Downloads aktualisieren\" klicken.\n\nDownloads sofort starten:\nNeu angelegte Downloads (aus Abos) werden\nsofort gestartet. Ansonsten muss man sie\nselbst starten.\n").setVisible(true));
        this.jButtonHilfeVideoplayer.addActionListener(e -> new DialogHilfe(this.parentComponent, true, "\nIm Tab \"Downloads\" kann man den gespeicherten\nFilm in einem Videoplayer \u00f6ffnen.\nNormalerweise wird der Videoplayer des\nBetriebssystems gefunden und ge\u00f6ffnet. Klappt das nicht,\nkann hier ein Programm daf\u00fcr angegeben werden.").setVisible(true));
        this.jButtonHilfeProgrammUrl.addActionListener(e -> new DialogHilfe(this.parentComponent, true, "\nWenn das Programm versucht, einen Link zu \u00f6ffnen\n(z.B. den Link im Men\u00fcpunkt \"Hilfe\" zu den \"Hilfeseiten\")\nund die Standardanwendung (z.B. \"Firefox\") nicht startet,\nkann damit ein Programm ausgew\u00e4hlt und\nfest zugeordnet werden (z.B. der Browser \"Firefox\").").setVisible(true));
        this.jButtonHilfeProgrammShutdown.addActionListener(e -> new DialogHilfe(this.parentComponent, true, "\nBei Linux wird das Programm/Script ausgef\u00fchrt\num den Recher herunter zu fahren\n\nm\u00f6gliche Aufrufe sind:\n\nsystemctl poweroff\npoweroff\nsudo shutdown -P now\nshutdown -h now").setVisible(true));
    }

    private void setIcon() {
        this.jButtonHilfeNeuladen.setIcon(Icons.ICON_BUTTON_HELP);
        this.jButtonHilfeProgrammDateimanager.setIcon(Icons.ICON_BUTTON_HELP);
        this.jButtonHilfeVideoplayer.setIcon(Icons.ICON_BUTTON_HELP);
        this.jButtonHilfeProgrammUrl.setIcon(Icons.ICON_BUTTON_HELP);
        this.jButtonHilfeProgrammShutdown.setIcon(Icons.ICON_BUTTON_HELP);
        this.jButtonProgrammDateimanager.setIcon(Icons.ICON_BUTTON_FILE_OPEN);
        this.jButtonProgrammVideoplayer.setIcon(Icons.ICON_BUTTON_FILE_OPEN);
        this.jButtonProgrammUrl.setIcon(Icons.ICON_BUTTON_FILE_OPEN);
        this.jButtonProgrammShutdown.setIcon(Icons.ICON_BUTTON_FILE_OPEN);
    }

    private void initComponents() {
        ButtonGroup buttonGroup1 = new ButtonGroup();
        JPanel jPanel6 = new JPanel();
        this.jCheckBoxAboSuchen = new JCheckBox();
        this.jCheckBoxDownloadSofortStarten = new JCheckBox();
        this.jButtonHilfeNeuladen = new JButton();
        JPanel jPanel2 = new JPanel();
        this.jTextFieldProgrammDateimanager = new JTextField();
        this.jButtonProgrammDateimanager = new JButton();
        this.jButtonHilfeProgrammDateimanager = new JButton();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.jTextFieldVideoplayer = new JTextField();
        this.jButtonHilfeVideoplayer = new JButton();
        this.jButtonProgrammVideoplayer = new JButton();
        JPanel jPanel4 = new JPanel();
        this.jTextFieldProgrammUrl = new JTextField();
        this.jButtonProgrammUrl = new JButton();
        this.jButtonHilfeProgrammUrl = new JButton();
        JPanel jPanel3 = new JPanel();
        this.jButtonHilfeProgrammShutdown = new JButton();
        this.jButtonProgrammShutdown = new JButton();
        this.jTextFieldProgrammShutdown = new JTextField();
        jPanel6.setBorder(BorderFactory.createTitledBorder("Nach dem Neuladen der Filmliste"));
        this.jCheckBoxAboSuchen.setText("Abos automatisch suchen");
        this.jCheckBoxDownloadSofortStarten.setText("Downloads aus Abos sofort starten");
        this.jButtonHilfeNeuladen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-help.png")));
        this.jButtonHilfeNeuladen.setToolTipText("Hilfe anzeigen");
        GroupLayout jPanel6Layout = new GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxAboSuchen).addComponent(this.jCheckBoxDownloadSofortStarten)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonHilfeNeuladen).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxAboSuchen).addComponent(this.jButtonHilfeNeuladen)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDownloadSofortStarten).addContainerGap(17, Short.MAX_VALUE)));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Tab Downloads"));
        this.jButtonProgrammDateimanager.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonProgrammDateimanager.setToolTipText("Programm ausw\u00e4hlen");
        this.jButtonHilfeProgrammDateimanager.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-help.png")));
        this.jButtonHilfeProgrammDateimanager.setToolTipText("Hilfe anzeigen");
        jLabel1.setText("Datei-Manager zum \u00d6ffnen des Downloadordners");
        jLabel2.setText("Videoplayer zum Abspielen gespeicherter Filme");
        this.jButtonHilfeVideoplayer.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-help.png")));
        this.jButtonHilfeVideoplayer.setToolTipText("Hilfe anzeigen");
        this.jButtonProgrammVideoplayer.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonProgrammVideoplayer.setToolTipText("Programm ausw\u00e4hlen");
        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jTextFieldProgrammDateimanager).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProgrammDateimanager).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHilfeProgrammDateimanager)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jTextFieldVideoplayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProgrammVideoplayer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHilfeVideoplayer)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel1).addComponent(jLabel2)).addGap(0, 180, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldProgrammDateimanager, -2, -1, -2).addComponent(this.jButtonProgrammDateimanager).addComponent(this.jButtonHilfeProgrammDateimanager)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldVideoplayer, -2, -1, -2).addGap(1, 1, 1)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonHilfeVideoplayer).addComponent(this.jButtonProgrammVideoplayer))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(1, this.jButtonHilfeProgrammDateimanager, this.jButtonProgrammDateimanager, this.jTextFieldProgrammDateimanager);
        jPanel2Layout.linkSize(1, this.jButtonHilfeVideoplayer, this.jButtonProgrammVideoplayer, this.jTextFieldVideoplayer);
        jPanel4.setBorder(BorderFactory.createTitledBorder("Webbrowser zum \u00d6ffnen von URLs"));
        this.jButtonProgrammUrl.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonProgrammUrl.setToolTipText("Programm ausw\u00e4hlen");
        this.jButtonHilfeProgrammUrl.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-help.png")));
        this.jButtonHilfeProgrammUrl.setToolTipText("Hilfe anzeigen");
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jTextFieldProgrammUrl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProgrammUrl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHilfeProgrammUrl).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldProgrammUrl, -2, -1, -2).addComponent(this.jButtonProgrammUrl).addComponent(this.jButtonHilfeProgrammUrl)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.linkSize(1, this.jButtonHilfeProgrammUrl, this.jButtonProgrammUrl, this.jTextFieldProgrammUrl);
        jPanel3.setBorder(BorderFactory.createTitledBorder("Linux: Aufruf zum Shutdown"));
        this.jButtonHilfeProgrammShutdown.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-help.png")));
        this.jButtonHilfeProgrammShutdown.setToolTipText("Hilfe anzeigen");
        this.jButtonProgrammShutdown.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonProgrammShutdown.setToolTipText("Programm/Script ausw\u00e4hlen");
        this.jTextFieldProgrammShutdown.setText("shutdown -h now");
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jTextFieldProgrammShutdown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProgrammShutdown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHilfeProgrammShutdown).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldProgrammShutdown, -2, -1, -2).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonHilfeProgrammShutdown).addComponent(this.jButtonProgrammShutdown))).addGap(0, 12, Short.MAX_VALUE)));
        jPanel3Layout.linkSize(1, this.jButtonHilfeProgrammShutdown, this.jButtonProgrammShutdown, this.jTextFieldProgrammShutdown);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel2, -1, -1, Short.MAX_VALUE).addComponent(jPanel4, -1, -1, Short.MAX_VALUE).addComponent(jPanel6, -1, -1, Short.MAX_VALUE).addComponent(jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel3, -2, -1, -2).addContainerGap(218, Short.MAX_VALUE)));
    }

    private class BeobPfad
    implements ActionListener {
        MVConfig.Configs config;
        String title;
        JTextField textField;

        public BeobPfad(MVConfig.Configs config, String title, JTextField textField) {
            this.config = config;
            this.title = title;
            this.textField = textField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemUtils.IS_OS_MAC_OSX) {
                FileDialog chooser = new FileDialog((Frame)MediathekGui.ui(), this.title);
                chooser.setMode(0);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        File destination = new File(chooser.getDirectory() + chooser.getFile());
                        this.textField.setText(destination.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.errorLog(915263014, ex);
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                if (!this.textField.getText().isEmpty()) {
                    chooser.setCurrentDirectory(new File(this.textField.getText()));
                } else {
                    chooser.setCurrentDirectory(new File(GuiFunktionen.getHomePath()));
                }
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        this.textField.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.errorLog(751214501, ex);
                    }
                }
            }
            MVConfig.add(this.config, this.textField.getText());
            String programm = this.textField.getText();
            if (!programm.isEmpty()) {
                try {
                    if (!new File(programm).exists()) {
                        MVMessageDialog.showMessageDialog(MediathekGui.ui(), "Das Programm:  \"" + programm + "\"  existiert nicht!", "Fehler", 0);
                    } else if (!new File(programm).canExecute()) {
                        MVMessageDialog.showMessageDialog(MediathekGui.ui(), "Das Programm:  \"" + programm + "\"  kann nicht ausgef\u00fchrt werden!", "Fehler", 0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class BeobDoc
    implements DocumentListener {
        MVConfig.Configs config;
        JTextField txt;

        public BeobDoc(MVConfig.Configs config, JTextField txt) {
            this.config = config;
            this.txt = txt;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tus();
        }

        private void tus() {
            MVConfig.add(this.config, this.txt.getText());
        }
    }
}

