/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.history;

import java.util.List;
import java.util.stream.Collectors;
import mediathek.config.Daten;
import mediathek.controller.history.MVUsedUrls;
import mediathek.daten.DatenFilm;
import mediathek.gui.messages.history.DownloadHistoryChangedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SeenHistoryController
extends MVUsedUrls<DownloadHistoryChangedEvent> {
    private static final Logger logger = LogManager.getLogger(SeenHistoryController.class);

    public SeenHistoryController() {
        super("history.txt", Daten.getSettingsDirectory_String(), DownloadHistoryChangedEvent.class);
    }

    @Override
    public synchronized void zeileSchreiben(String thema, String titel, String url) {
        logger.trace("zeileSchreiben(thema: {}, titel: {}, url: {})", (Object)thema, (Object)titel, (Object)url);
        super.zeileSchreiben(thema, titel, url);
    }

    @Override
    public synchronized void zeileSchreiben(List<DatenFilm> arrayFilms) {
        logger.trace("zeileSchreiben(thema: {})", (Object)arrayFilms);
        super.zeileSchreiben(arrayFilms);
    }

    public void markAsSeen(List<DatenFilm> filmList) {
        this.setGesehen(true, filmList);
    }

    public void markAsUnseen(List<DatenFilm> filmList) {
        this.setGesehen(false, filmList);
    }

    private synchronized void setGesehen(boolean gesehen, List<DatenFilm> arrayFilms) {
        logger.trace("setGesehen({})", (Object)gesehen);
        if (arrayFilms.isEmpty()) {
            return;
        }
        if (!gesehen) {
            this.urlAusLogfileLoeschen(arrayFilms);
        } else {
            List<DatenFilm> neueFilme = arrayFilms.stream().filter(film -> !this.urlPruefen(film.getUrl())).collect(Collectors.toList());
            this.zeileSchreiben(neueFilme);
            neueFilme.clear();
        }
    }
}

