/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import java.time.LocalTime;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class TimeTileSkin
extends TileSkin {
    private Text titleText;
    private Text text;
    private Text leftText;
    private Text leftUnit;
    private Text rightText;
    private Text rightUnit;
    private TextFlow timeText;
    private Label description;

    public TimeTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.titleText = new Text();
        this.titleText.setFill(this.tile.getTitleColor());
        Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill(this.tile.getUnitColor());
        Helper.enableNode(this.text, this.tile.isTextVisible());
        LocalTime duration = this.tile.getDuration();
        this.leftText = new Text(Integer.toString(duration.getHour() > 0 ? duration.getHour() : duration.getMinute()));
        this.leftText.setFill(this.tile.getValueColor());
        this.leftUnit = new Text(duration.getHour() > 0 ? "h" : "m");
        this.leftUnit.setFill(this.tile.getValueColor());
        this.rightText = new Text(Integer.toString(duration.getHour() > 0 ? duration.getMinute() : duration.getSecond()));
        this.rightText.setFill(this.tile.getValueColor());
        this.rightUnit = new Text(duration.getHour() > 0 ? "m" : "s");
        this.rightUnit.setFill(this.tile.getValueColor());
        this.timeText = new TextFlow(this.leftText, this.leftUnit, this.rightText, this.rightUnit);
        this.timeText.setTextAlignment(TextAlignment.RIGHT);
        this.timeText.setPrefWidth(225.0);
        this.description = new Label(this.tile.getDescription());
        this.description.setAlignment(Pos.TOP_RIGHT);
        this.description.setWrapText(true);
        this.description.setTextFill(this.tile.getTextColor());
        Helper.enableNode(this.description, !this.tile.getDescription().isEmpty());
        this.getPane().getChildren().addAll((Node[])new Node[]{this.titleText, this.text, this.timeText, this.description});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode(this.text, this.tile.isTextVisible());
            Helper.enableNode(this.timeText, this.tile.isValueVisible());
            Helper.enableNode(this.description, !this.tile.getDescription().isEmpty());
        }
    }

    @Override
    protected void resizeDynamicText() {
        double fontSize = this.size * 0.24;
        this.leftText.setFont(Fonts.latoRegular(fontSize));
        this.rightText.setFont(Fonts.latoRegular(fontSize));
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
        fontSize = this.size * 0.12;
        this.leftUnit.setFont(Fonts.latoRegular(fontSize));
        this.rightUnit.setFont(Fonts.latoRegular(fontSize));
        fontSize = this.size * 0.1;
        this.description.setFont(Fonts.latoRegular(fontSize));
    }

    @Override
    protected void resize() {
        super.resize();
        this.timeText.setPrefWidth(this.contentBounds.getWidth());
        this.timeText.relocate(this.contentBounds.getX(), this.contentBounds.getY());
        this.description.setPrefSize(this.contentBounds.getWidth(), this.titleText.isVisible() ? this.size * 0.43 : this.size * 0.53);
        this.description.relocate(this.contentBounds.getX(), this.titleText.isVisible() ? this.height * 0.42 : this.height * 0.32);
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        LocalTime duration = this.tile.getDuration();
        this.leftText.setText(Integer.toString(duration.getHour() > 0 ? duration.getHour() : duration.getMinute()));
        this.leftUnit.setText(duration.getHour() > 0 ? " h  " : " m  ");
        this.rightText.setText(Integer.toString(duration.getHour() > 0 ? duration.getMinute() : duration.getSecond()));
        this.rightUnit.setText(duration.getHour() > 0 ? " m" : " s");
        this.description.setText(this.tile.getDescription());
        this.resizeDynamicText();
        this.resizeStaticText();
        this.titleText.setFill(this.tile.getTitleColor());
        this.text.setFill(this.tile.getTextColor());
        this.leftText.setFill(this.tile.getValueColor());
        this.leftUnit.setFill(this.tile.getValueColor());
        this.rightText.setFill(this.tile.getValueColor());
        this.rightUnit.setFill(this.tile.getValueColor());
        this.description.setTextFill(this.tile.getDescriptionColor());
    }
}

