/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.util.ArrayList;
import org.jruby.RubySymbol;
import org.jruby.ast.DefNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.AbstractNodeVisitor;
import org.jruby.ir.IRBuilder;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.PutFieldInstr;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.ivars.MethodData;
import org.jruby.util.ByteList;

public class IRMethod
extends IRScope {
    public final boolean isInstanceMethod;
    protected ArgumentDescriptor[] argDesc = ArgumentDescriptor.EMPTY_ARRAY;
    private volatile DefNode defNode;

    public IRMethod(IRManager manager, IRScope lexicalParent, DefNode defn, ByteList name2, boolean isInstanceMethod, int lineNumber, StaticScope staticScope, boolean needsCodeCoverage) {
        super(manager, lexicalParent, name2, lineNumber, staticScope);
        this.defNode = defn;
        this.isInstanceMethod = isInstanceMethod;
        if (needsCodeCoverage) {
            this.setNeedsCodeCoverage();
        }
        if (!this.getManager().isDryRun() && staticScope != null) {
            staticScope.setIRScope(this);
        }
    }

    @Override
    public boolean hasBeenBuilt() {
        return this.defNode == null;
    }

    public MethodData getMethodData() {
        final ArrayList<String> ivarNames = new ArrayList<String>();
        DefNode def = this.defNode;
        if (def != null) {
            def.getBodyNode().accept(new AbstractNodeVisitor<Object>(){

                @Override
                protected Object defaultVisit(Node node) {
                    if (node == null) {
                        return null;
                    }
                    if (node instanceof InstVarNode) {
                        ivarNames.add(((InstVarNode)node).getName().idString());
                    } else if (node instanceof InstAsgnNode) {
                        ivarNames.add(((InstAsgnNode)node).getName().idString());
                    }
                    node.childNodes().forEach(this::defaultVisit);
                    return null;
                }
            });
        } else {
            InterpreterContext context = this.lazilyAcquireInterpreterContext();
            block4: for (Instr i2 : context.getInstructions()) {
                switch (i2.getOperation()) {
                    case GET_FIELD: {
                        ivarNames.add(((GetFieldInstr)i2).getId());
                        continue block4;
                    }
                    case PUT_FIELD: {
                        ivarNames.add(((PutFieldInstr)i2).getId());
                    }
                }
            }
        }
        return new MethodData(this.getId(), this.getFile(), ivarNames);
    }

    public final InterpreterContext lazilyAcquireInterpreterContext() {
        if (!this.hasBeenBuilt()) {
            this.buildMethodImpl();
        }
        return this.interpreterContext;
    }

    private synchronized void buildMethodImpl() {
        if (this.hasBeenBuilt()) {
            return;
        }
        IRBuilder.topIRBuilder(this.getManager(), this).defineMethodInner(this.defNode, this.getLexicalParent(), this.needsCodeCoverage());
        this.defNode = null;
    }

    @Override
    public BasicBlock[] prepareForCompilation() {
        this.buildMethodImpl();
        return super.prepareForCompilation();
    }

    @Override
    public IRScopeType getScopeType() {
        return this.isInstanceMethod ? IRScopeType.INSTANCE_METHOD : IRScopeType.CLASS_METHOD;
    }

    @Override
    protected LocalVariable findExistingLocalVariable(RubySymbol name2, int scopeDepth) {
        assert (scopeDepth == 0) : "Local variable depth in IRMethod should always be zero (" + name2 + " had depth of " + scopeDepth + ")";
        return (LocalVariable)this.localVars.get(name2);
    }

    @Override
    public LocalVariable getLocalVariable(RubySymbol name2, int scopeDepth) {
        LocalVariable lvar = this.findExistingLocalVariable(name2, scopeDepth);
        if (lvar == null) {
            lvar = this.getNewLocalVariable(name2, scopeDepth);
        }
        return lvar;
    }

    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.argDesc;
    }

    public void setArgumentDescriptors(ArgumentDescriptor[] argDesc) {
        this.argDesc = argDesc;
    }
}

