/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.DeprecationInfoProvider;
import org.jetbrains.kotlin.fir.declarations.FutureApiDeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/SinceKotlinProvider;", "Lorg/jetbrains/kotlin/fir/declarations/DeprecationInfoProvider;", "sinceVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "<init>", "(Lorg/jetbrains/kotlin/config/ApiVersion;)V", "getSinceVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "computeDeprecationInfo", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationInfo;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "providers"})
@SourceDebugExtension(value={"SMAP\ndeprecationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 deprecationUtils.kt\norg/jetbrains/kotlin/fir/declarations/SinceKotlinProvider\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,477:1\n227#2:478\n*S KotlinDebug\n*F\n+ 1 deprecationUtils.kt\norg/jetbrains/kotlin/fir/declarations/SinceKotlinProvider\n*L\n417#1:478\n*E\n"})
public final class SinceKotlinProvider
extends DeprecationInfoProvider {
    @NotNull
    private final ApiVersion sinceVersion;

    public SinceKotlinProvider(@NotNull ApiVersion sinceVersion) {
        Intrinsics.checkNotNullParameter(sinceVersion, "sinceVersion");
        this.sinceVersion = sinceVersion;
    }

    @NotNull
    public final ApiVersion getSinceVersion() {
        return this.sinceVersion;
    }

    @Override
    @Nullable
    public DeprecationInfo computeDeprecationInfo(@NotNull FirSession session2) {
        FutureApiDeprecationInfo futureApiDeprecationInfo;
        Intrinsics.checkNotNullParameter(session2, "session");
        boolean condition$iv = this.sinceVersion.compareTo(FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).getApiVersion()) <= 0;
        boolean $i$f$runUnless = false;
        if (condition$iv) {
            futureApiDeprecationInfo = null;
        } else {
            boolean bl = false;
            futureApiDeprecationInfo = new FutureApiDeprecationInfo(DeprecationLevelValue.HIDDEN, true, this.sinceVersion);
        }
        return futureApiDeprecationInfo;
    }
}

