/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirOptInAnnotationClassChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirRetentionAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.resolve.checkers.OptInDescription;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOptInAnnotationClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirOptInAnnotationClassChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirOptInAnnotationClassChecker INSTANCE = new FirOptInAnnotationClassChecker();

    private FirOptInAnnotationClassChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Set wrongTargets;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (declaration.getClassKind() != ClassKind.ANNOTATION_CLASS) {
            return;
        }
        FirSession session2 = context2.getSession();
        if (FirAnnotationUtilsKt.getAnnotationByClassId(declaration, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID(), session2) == null) {
            return;
        }
        if (FirRetentionAnnotationHelpersKt.getRetention(declaration, session2) == AnnotationRetention.SOURCE) {
            FirAnnotation target;
            FirAnnotation firAnnotation = target = FirRetentionAnnotationHelpersKt.getRetentionAnnotation(declaration, session2);
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(firAnnotation != null ? firAnnotation.getSource() : null), FirErrors.INSTANCE.getOPT_IN_MARKER_WITH_WRONG_RETENTION(), (DiagnosticContext)context2, null, 8, null);
        }
        if (!((Collection)(wrongTargets = CollectionsKt.intersect((Iterable)FirAnnotationHelpersKt.getAllowedAnnotationTargets(declaration, session2), (Iterable)OptInDescription.Companion.getWRONG_TARGETS_FOR_MARKER()))).isEmpty()) {
            FirAnnotation target;
            FirAnnotation firAnnotation = target = FirAnnotationHelpersKt.getTargetAnnotation(declaration, session2);
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(firAnnotation != null ? firAnnotation.getSource() : null), FirErrors.INSTANCE.getOPT_IN_MARKER_WITH_WRONG_TARGET(), (Object)CollectionsKt.joinToString$default(wrongTargets, null, null, null, 0, null, check.1.INSTANCE, 31, null), (DiagnosticContext)context2, null, 16, null);
        }
    }
}

