/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamReader;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.client.config.XMLLocation;

@MessageLogger(projectCode="ELY", length=5)
interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security");
    public static final ElytronMessages xmlLog = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.xml");

    @Message(id=1001, value="No module found for identifier \"%s\"")
    public ConfigXMLParseException xmlNoModuleFound(@Param XMLStreamReader var1, @Cause Exception var2, String var3);

    @Message(id=1002, value="Invalid port number \"%s\" specified for attribute \"%s\" of element \"%s\"; expected a numerical value between 1 and 65535 (inclusive)")
    public ConfigXMLParseException xmlInvalidPortNumber(@Param XMLStreamReader var1, String var2, String var3, QName var4);

    @Message(id=1028, value="Invalid port number \"%d\"")
    public IllegalArgumentException invalidPortNumber(int var1);

    @Message(id=1029, value="Invalid host specification \"%s\"")
    public IllegalArgumentException invalidHostSpec(String var1);

    @Message(id=1035, value="Unable to create key manager")
    public IOException unableToCreateKeyManager(@Cause Exception var1);

    @Message(id=1036, value="Unable to create trust manager")
    public IOException unableToCreateTrustManager(@Cause Exception var1);

    @Message(id=1041, value="Could not obtain credential")
    public RuntimeException couldNotObtainCredential();

    @Message(id=1064, value="Invalid identity name")
    public IllegalArgumentException invalidName();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1091, value="Post-association peer context action failed")
    public void postAssociationFailed(@Cause Throwable var1);

    @Message(id=1129, value="Unknown SSL context \"%s\" specified")
    public ConfigXMLParseException xmlUnknownSslContextSpecified(@Param Location var1, String var2);

    @Message(id=1130, value="Duplicate SSL context name \"%s\"")
    public ConfigXMLParseException xmlDuplicateSslContextName(String var1, @Param ConfigurationXMLStreamReader var2);

    @Message(id=1132, value="Unknown authentication configuration \"%s\" specified")
    public ConfigXMLParseException xmlUnknownAuthenticationConfigurationSpecified(@Param Location var1, String var2);

    @Message(id=1133, value="Failed to create credential")
    public ConfigXMLParseException xmlFailedToCreateCredential(@Param Location var1, @Cause Throwable var2);

    @Message(id=1134, value="Duplicate authentication configuration name \"%s\"")
    public ConfigXMLParseException xmlDuplicateAuthenticationConfigurationName(String var1, @Param ConfigurationXMLStreamReader var2);

    @Message(id=1135, value="Failed to load keystore data")
    public ConfigXMLParseException xmlFailedToLoadKeyStoreData(@Param Location var1, @Cause Throwable var2);

    @Message(id=1136, value="Failed to create keystore")
    public ConfigXMLParseException xmlFailedToCreateKeyStore(@Param Location var1, @Cause Throwable var2);

    @Message(id=1137, value="Invalid key store entry type for alias \"%s\" (expected %s, got %s)")
    public ConfigXMLParseException xmlInvalidKeyStoreEntryType(@Param Location var1, String var2, Class<?> var3, Class<?> var4);

    @Message(id=1139, value="Failed to create credential store")
    public ConfigXMLParseException xmlFailedToCreateCredentialStore(@Param Location var1, @Cause Throwable var2);

    @Message(id=1140, value="Wrong PEM content type; expected %s, actually was %s")
    public ConfigXMLParseException xmlWrongPemType(@Param ConfigurationXMLStreamReader var1, Class<?> var2, Class<?> var3);

    @Message(id=1141, value="No PEM content found")
    public ConfigXMLParseException xmlNoPemContent(@Param ConfigurationXMLStreamReader var1);

    @Message(id=1143, value="Invalid URL [%s]")
    public ConfigXMLParseException xmlInvalidUrl(String var1);

    @Message(id=1159, value="Key store entry for alias \"%s\" is missing.")
    public ConfigXMLParseException keyStoreEntryMissing(@Param Location var1, String var2);

    @Message(id=1162, value="Invalid GSS mechanism name \"%s\" - unable to convert to mechanism OID")
    public ConfigXMLParseException xmlInvalidGssMechanismName(@Param XMLStreamReader var1, String var2);

    @Message(id=1163, value="Mechanism OID conversion from string \"%s\" failed")
    public ConfigXMLParseException xmlGssMechanismOidConversionFailed(@Param XMLStreamReader var1, String var2, @Cause Throwable var3);

    @Message(id=1164, value="Unable to identify provider name=%s, for service type=%s, algorithm=%s")
    public ConfigXMLParseException xmlUnableToIdentifyProvider(@Param Location var1, String var2, String var3, String var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1166, value="%2$s: Element \"%1$s\" is deprecated")
    public void xmlDeprecatedElement(String var1, XMLLocation var2);

    @Message(id=2034, value="Alias must be specified if more than one entry exist in keystore")
    public ConfigXMLParseException missingAlias(@Param Location var1);

    @Message(id=2010, value="Unknown key store specified")
    public ConfigXMLParseException xmlUnknownKeyStoreSpecified(@Param Location var1);

    @Message(id=4005, value="No default trust manager available")
    public NoSuchAlgorithmException noDefaultTrustManager();

    @Message(id=4028, value="No default key manager available")
    public NoSuchAlgorithmException noDefaultKeyManager();

    @Message(id=9501, value="Duplicate attribute (\"%s\") found in configuration.")
    public ConfigXMLParseException duplicateAttributeFound(@Param XMLStreamReader var1, String var2);

    @Message(id=9502, value="Duplicate credential store name found in configuration \"%s\"")
    public ConfigXMLParseException duplicateCredentialStoreName(@Param XMLStreamReader var1, String var2);

    @Message(id=9503, value="Credential store name \"%s\" not defined")
    public ConfigXMLParseException xmlCredentialStoreNameNotDefined(@Param Location var1, String var2);

    @Message(id=9527, value="Invalid credential store reference")
    public ConfigXMLParseException xmlInvalidCredentialStoreRef(@Param Location var1);

    @Message(id=9529, value="Unsupported algorithm \"%s\" for %s type")
    public ConfigXMLParseException xmlUnsupportedAlgorithmForType(@Param Location var1, String var2, String var3);
}

