/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import java.util.Set;
import javax.jms.IllegalStateException;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSClientBundle;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;

public class ThreadAwareContext {
    private Thread completionListenerThread;
    private final Set<Long> messageListenerThreads = new ConcurrentHashSet<Long>();

    public void setCurrentThread(boolean isCompletionListener) {
        if (isCompletionListener) {
            this.completionListenerThread = Thread.currentThread();
        } else {
            this.messageListenerThreads.add(Thread.currentThread().getId());
        }
    }

    public void clearCurrentThread(boolean isCompletionListener) {
        if (isCompletionListener) {
            this.completionListenerThread = null;
        } else {
            this.messageListenerThreads.remove(Thread.currentThread().getId());
        }
    }

    public void assertNotCompletionListenerThreadRuntime() {
        if (this.completionListenerThread == Thread.currentThread()) {
            throw ActiveMQJMSClientBundle.BUNDLE.callingMethodFromCompletionListenerRuntime();
        }
    }

    public void assertNotCompletionListenerThread() throws IllegalStateException {
        if (this.completionListenerThread == Thread.currentThread()) {
            throw ActiveMQJMSClientBundle.BUNDLE.callingMethodFromCompletionListener();
        }
    }

    public void assertNotMessageListenerThreadRuntime() {
        if (this.messageListenerThreads.contains(Thread.currentThread().getId())) {
            throw ActiveMQJMSClientBundle.BUNDLE.callingMethodFromListenerRuntime();
        }
    }

    public void assertNotMessageListenerThread() throws IllegalStateException {
        if (this.messageListenerThreads.contains(Thread.currentThread().getId())) {
            throw ActiveMQJMSClientBundle.BUNDLE.callingMethodFromListener();
        }
    }
}

