/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.elementdesc;

import io.smallrye.metrics.elementdesc.AnnotationInfo;
import io.smallrye.metrics.elementdesc.MemberInfo;
import io.smallrye.metrics.elementdesc.MemberType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RawMemberInfo
implements MemberInfo {
    private MemberType memberType;
    private String declaringClassName;
    private String declaringClassSimpleName;
    private String name;
    private List<AnnotationInfo> annotationInfos = new ArrayList<AnnotationInfo>();

    public RawMemberInfo() {
    }

    public RawMemberInfo(MemberType memberType, String declaringClassName, String declaringClassSimpleName, String name, Collection<AnnotationInfo> annotationInfos) {
        this.memberType = memberType;
        this.declaringClassName = declaringClassName;
        this.declaringClassSimpleName = declaringClassSimpleName;
        this.name = name;
        this.annotationInfos.addAll(annotationInfos);
    }

    public void setMemberType(MemberType memberType) {
        this.memberType = memberType;
    }

    public void setDeclaringClassName(String declaringClassName) {
        this.declaringClassName = declaringClassName;
    }

    public void setDeclaringClassSimpleName(String declaringClassSimpleName) {
        this.declaringClassSimpleName = declaringClassSimpleName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAnnotationInfos(List<AnnotationInfo> annotationInfos) {
        this.annotationInfos = annotationInfos;
    }

    public List<AnnotationInfo> getAnnotationInfos() {
        return this.annotationInfos;
    }

    @Override
    public MemberType getMemberType() {
        return this.memberType;
    }

    @Override
    public String getDeclaringClassName() {
        return this.declaringClassName;
    }

    @Override
    public String getDeclaringClassSimpleName() {
        return this.declaringClassSimpleName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <T extends Annotation> AnnotationInfo getAnnotation(Class<T> metricClass) {
        return this.annotationInfos.stream().filter(annotation -> annotation.annotationName().equals(metricClass.getName())).findFirst().orElse(null);
    }

    @Override
    public <T extends Annotation> boolean isAnnotationPresent(Class<T> metricClass) {
        return this.annotationInfos.stream().anyMatch(annotation -> annotation.annotationName().equals(metricClass.getName()));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MemberInfo)) {
            return false;
        }
        MemberInfo other = (MemberInfo)obj;
        return other.getDeclaringClassName().equals(this.getDeclaringClassName()) && other.getName().equals(this.getName());
    }
}

