/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import org.keycloak.models.KeycloakSession;
import org.keycloak.urls.UrlType;

public class ResolveRelative {
    public static String resolveRelativeUri(KeycloakSession session, String rootUrl, String url) {
        if (url == null || !url.startsWith("/")) {
            return url;
        }
        if (rootUrl != null) {
            return ResolveRelative.resolveRootUrl(session, rootUrl) + url;
        }
        return session.getContext().getUri().getBaseUriBuilder().replacePath(url).build(new Object[0]).toString();
    }

    public static String resolveRootUrl(KeycloakSession session, String rootUrl) {
        if (rootUrl != null) {
            if (rootUrl.equals("${authBaseUrl}")) {
                rootUrl = session.getContext().getUri(UrlType.FRONTEND).getBaseUri().toString();
                if (rootUrl.endsWith("/")) {
                    rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
                }
            } else if (rootUrl.equals("${authAdminUrl}") && (rootUrl = session.getContext().getUri(UrlType.ADMIN).getBaseUri().toString()).endsWith("/")) {
                rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
            }
        }
        return rootUrl;
    }
}

