/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.AuthDetails;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.util.JsonSerialization;

public class AdminEventBuilder {
    protected static final Logger logger = Logger.getLogger(AdminEventBuilder.class);
    private EventStoreProvider store;
    private Map<String, EventListenerProvider> listeners;
    private RealmModel realm;
    private AdminEvent adminEvent;

    public AdminEventBuilder(RealmModel realm, AdminAuth auth, KeycloakSession session, ClientConnection clientConnection) {
        this.realm = realm;
        this.adminEvent = new AdminEvent();
        this.listeners = new HashMap<String, EventListenerProvider>();
        this.updateStore(session);
        this.addListeners(session);
        this.authRealm(auth.getRealm());
        this.authClient(auth.getClient());
        this.authUser(auth.getUser());
        this.authIpAddress(clientConnection.getRemoteAddr());
    }

    public AdminEventBuilder realm(RealmModel realm) {
        this.adminEvent.setRealmId(realm.getId());
        return this;
    }

    public AdminEventBuilder realm(String realmId) {
        this.adminEvent.setRealmId(realmId);
        return this;
    }

    public AdminEventBuilder refreshRealmEventsConfig(KeycloakSession session) {
        return this.updateStore(session).addListeners(session);
    }

    private AdminEventBuilder updateStore(KeycloakSession session) {
        if (this.realm.isAdminEventsEnabled() && this.store == null) {
            this.store = (EventStoreProvider)session.getProvider(EventStoreProvider.class);
            if (this.store == null) {
                ServicesLogger.LOGGER.noEventStoreProvider();
            }
        }
        return this;
    }

    private AdminEventBuilder addListeners(KeycloakSession session) {
        Set extraListeners = this.realm.getEventsListeners();
        if (extraListeners != null && !extraListeners.isEmpty()) {
            for (String id : extraListeners) {
                if (this.listeners.containsKey(id)) continue;
                EventListenerProvider listener = (EventListenerProvider)session.getProvider(EventListenerProvider.class, id);
                if (listener != null) {
                    this.listeners.put(id, listener);
                    continue;
                }
                ServicesLogger.LOGGER.providerNotFound(id);
            }
        }
        return this;
    }

    public AdminEventBuilder operation(OperationType operationType) {
        this.adminEvent.setOperationType(operationType);
        return this;
    }

    public AdminEventBuilder resource(ResourceType resourceType) {
        this.adminEvent.setResourceType(resourceType);
        return this;
    }

    public AdminEventBuilder resource(String resourceType) {
        this.adminEvent.setResourceTypeAsString(resourceType);
        return this;
    }

    public AdminEventBuilder authRealm(RealmModel realm) {
        AuthDetails authDetails = this.adminEvent.getAuthDetails();
        if (authDetails == null) {
            authDetails = new AuthDetails();
            authDetails.setRealmId(realm.getId());
        } else {
            authDetails.setRealmId(realm.getId());
        }
        this.adminEvent.setAuthDetails(authDetails);
        return this;
    }

    public AdminEventBuilder authClient(ClientModel client) {
        AuthDetails authDetails = this.adminEvent.getAuthDetails();
        if (authDetails == null) {
            authDetails = new AuthDetails();
            authDetails.setClientId(client.getId());
        } else {
            authDetails.setClientId(client.getId());
        }
        this.adminEvent.setAuthDetails(authDetails);
        return this;
    }

    public AdminEventBuilder authUser(UserModel user) {
        AuthDetails authDetails = this.adminEvent.getAuthDetails();
        if (authDetails == null) {
            authDetails = new AuthDetails();
            authDetails.setUserId(user.getId());
        } else {
            authDetails.setUserId(user.getId());
        }
        this.adminEvent.setAuthDetails(authDetails);
        return this;
    }

    public AdminEventBuilder authIpAddress(String ipAddress) {
        AuthDetails authDetails = this.adminEvent.getAuthDetails();
        if (authDetails == null) {
            authDetails = new AuthDetails();
            authDetails.setIpAddress(ipAddress);
        } else {
            authDetails.setIpAddress(ipAddress);
        }
        this.adminEvent.setAuthDetails(authDetails);
        return this;
    }

    public AdminEventBuilder resourcePath(String ... pathElements) {
        StringBuilder sb = new StringBuilder();
        for (String element : pathElements) {
            sb.append("/");
            sb.append(element);
        }
        if (pathElements.length > 0) {
            sb.deleteCharAt(0);
        }
        this.adminEvent.setResourcePath(sb.toString());
        return this;
    }

    public AdminEventBuilder resourcePath(UriInfo uriInfo) {
        String path = this.getResourcePath(uriInfo);
        this.adminEvent.setResourcePath(path);
        return this;
    }

    public AdminEventBuilder resourcePath(UriInfo uriInfo, String id) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getResourcePath(uriInfo));
        sb.append("/");
        sb.append(id);
        this.adminEvent.setResourcePath(sb.toString());
        return this;
    }

    private String getResourcePath(UriInfo uriInfo) {
        String path = uriInfo.getPath();
        StringBuilder sb = new StringBuilder();
        sb.append("/realms/");
        sb.append(this.realm.getName());
        sb.append("/");
        String realmRelative = sb.toString();
        return path.substring(path.indexOf(realmRelative) + realmRelative.length());
    }

    public AdminEventBuilder representation(Object value) {
        if (value == null || value.equals("")) {
            return this;
        }
        try {
            this.adminEvent.setRepresentation(JsonSerialization.writeValueAsString((Object)value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public AdminEvent getEvent() {
        return this.adminEvent;
    }

    public void success() {
        this.send();
    }

    private void send() {
        boolean includeRepresentation = false;
        if (this.realm.isAdminEventsDetailsEnabled()) {
            includeRepresentation = true;
        }
        this.adminEvent.setTime(Time.toMillis((int)Time.currentTime()));
        if (this.store != null) {
            try {
                this.store.onEvent(this.adminEvent, includeRepresentation);
            }
            catch (Throwable t) {
                ServicesLogger.LOGGER.failedToSaveEvent(t);
            }
        }
        if (this.listeners != null) {
            for (EventListenerProvider l : this.listeners.values()) {
                try {
                    l.onEvent(this.adminEvent, includeRepresentation);
                }
                catch (Throwable t) {
                    ServicesLogger.LOGGER.failedToSendType(t, l);
                }
            }
        }
    }
}

