/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.audit;

import java.util.Locale;
import java.util.Set;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.audit.SyslogAuditLogHandler;
import org.jboss.as.controller.audit.SyslogCredentialReferenceSupplier;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.domain.management.audit.SyslogAuditLogProtocolResourceDefinition;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.credential.source.CredentialSource;

public class SyslogAuditLogHandlerService
implements Service,
SyslogCredentialReferenceSupplier {
    static final ServiceName SYSLOG_AUDIT_HANDLER = ServiceName.of((String[])new String[]{"org", "wildfly", "management", "audit", "syslog-handler"});
    private final ExceptionSupplier<CredentialSource, Exception> tlsClientCertStoreKeyCredentialSourceSupplier;
    private final ExceptionSupplier<CredentialSource, Exception> tlsClientCertStoreCredentialSourceSupplier;
    private final ExceptionSupplier<CredentialSource, Exception> tlsTrustStoreSupplier;

    SyslogAuditLogHandlerService(ExceptionSupplier<CredentialSource, Exception> tlsClientCertStoreKeyCredentialSourceSupplier, ExceptionSupplier<CredentialSource, Exception> tlsClientCertStoreCredentialSourceSupplier, ExceptionSupplier<CredentialSource, Exception> tlsTrustStoreSupplier) {
        this.tlsClientCertStoreKeyCredentialSourceSupplier = tlsClientCertStoreKeyCredentialSourceSupplier;
        this.tlsClientCertStoreCredentialSourceSupplier = tlsClientCertStoreCredentialSourceSupplier;
        this.tlsTrustStoreSupplier = tlsTrustStoreSupplier;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public ExceptionSupplier<CredentialSource, Exception> getTlsClientCertStoreSupplier() {
        return this.tlsClientCertStoreCredentialSourceSupplier;
    }

    public ExceptionSupplier<CredentialSource, Exception> getTlsClientCertStoreKeySupplier() {
        return this.tlsClientCertStoreKeyCredentialSourceSupplier;
    }

    public ExceptionSupplier<CredentialSource, Exception> getTlsTrustStoreSupplier() {
        return this.tlsTrustStoreSupplier;
    }

    public static final SyslogAuditLogHandlerService installService(OperationContext context, ServiceName serviceName, Resource handlerResource) throws OperationFailedException {
        Set protocols = handlerResource.getChildren("protocol");
        if (protocols.isEmpty()) {
            throw DomainManagementLogger.ROOT_LOGGER.noSyslogProtocol();
        }
        Resource.ResourceEntry protocol = (Resource.ResourceEntry)protocols.iterator().next();
        SyslogAuditLogHandler.Transport transport = SyslogAuditLogHandler.Transport.valueOf((String)protocol.getPathElement().getValue().toUpperCase(Locale.ENGLISH));
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(serviceName);
        ExceptionSupplier tccskcsSupplier = null;
        ExceptionSupplier tccscsSupplier = null;
        ExceptionSupplier ttsSupplier = null;
        if (transport == SyslogAuditLogHandler.Transport.TLS) {
            Set tlsStores = protocol.getChildren("authentication");
            for (Resource.ResourceEntry storeEntry : tlsStores) {
                ModelNode storeModel = storeEntry.getModel();
                String type = storeEntry.getPathElement().getValue();
                if (type.equals("client-certificate-store")) {
                    if (storeModel.hasDefined(SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEY_PASSWORD_CREDENTIAL_REFERENCE.getName())) {
                        tccskcsSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEY_PASSWORD_CREDENTIAL_REFERENCE, (ModelNode)storeModel, (ServiceBuilder)serviceBuilder);
                    }
                    if (!storeModel.hasDefined(SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE.getName())) continue;
                    tccscsSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE, (ModelNode)storeModel, (ServiceBuilder)serviceBuilder);
                    continue;
                }
                if (!type.equals("truststore") || !storeModel.hasDefined(SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE.getName())) continue;
                ttsSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE, (ModelNode)storeModel, (ServiceBuilder)serviceBuilder);
            }
        }
        SyslogAuditLogHandlerService service = new SyslogAuditLogHandlerService(tccskcsSupplier, tccscsSupplier, ttsSupplier);
        serviceBuilder.setInstance((Service)service);
        serviceBuilder.install();
        return service;
    }
}

