/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.async;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import org.infinispan.commons.util.ByRef;
import org.infinispan.persistence.modifications.Clear;
import org.infinispan.persistence.modifications.Modification;
import org.infinispan.persistence.modifications.ModificationsList;
import org.infinispan.persistence.modifications.Remove;
import org.infinispan.persistence.modifications.Store;

public class State {
    static final Clear CLEAR = new Clear();
    final boolean clear;
    final ConcurrentMap<Object, Modification> modifications;
    volatile State next;
    CountDownLatch workerThreads;

    public State(boolean clear, ConcurrentMap<Object, Modification> modMap, State next) {
        this.clear = clear;
        this.modifications = modMap;
        this.next = next;
    }

    Modification get(Object key) {
        State state = this;
        while (state != null) {
            Modification mod = (Modification)state.modifications.get(key);
            if (mod != null) {
                return mod;
            }
            if (state.clear) {
                return CLEAR;
            }
            state = state.next;
        }
        return null;
    }

    Map<Object, Modification> flattenModifications(ByRef<Boolean> containsClear) {
        HashMap<Object, Modification> map = new HashMap<Object, Modification>();
        State state = this;
        while (state != null) {
            state.modifications.forEach(map::putIfAbsent);
            if (state.clear) {
                containsClear.set((Object)Boolean.TRUE);
                break;
            }
            state = state.next;
        }
        return map;
    }

    void put(Modification mod) {
        switch (mod.getType()) {
            case STORE: {
                this.modifications.put(((Store)mod).getKey(), mod);
                break;
            }
            case REMOVE: {
                this.modifications.put(((Remove)mod).getKey(), mod);
                break;
            }
            case LIST: {
                for (Modification modification : ((ModificationsList)mod).getList()) {
                    this.put(modification);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown modification type " + (Object)((Object)mod.getType()));
            }
        }
    }
}

