/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.locking.AbstractLockingInterceptor;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.concurrent.locks.KeyAwareLockPromise;
import org.infinispan.util.concurrent.locks.PendingLockManager;
import org.infinispan.util.logging.Log;

public abstract class AbstractTxLockingInterceptor
extends AbstractLockingInterceptor {
    private final boolean trace = this.getLog().isTraceEnabled();
    @Inject
    private PartitionHandlingManager partitionHandlingManager;
    @Inject
    private PendingLockManager pendingLockManager;
    final InvocationSuccessFunction invokeNextFunction = (rCtx, rCommand, rv) -> this.invokeNext(rCtx, rCommand);

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.invokeNextAndFinally(ctx, command, this.unlockAllReturnHandler);
    }

    @Override
    protected Object handleReadManyCommand(InvocationContext ctx, FlagAffectedCommand command, Collection<?> keys) throws Throwable {
        if (ctx.isInTxScope()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextAndFinally(ctx, command, this.unlockAllReturnHandler);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            if (t instanceof OutdatedTopologyException) {
                throw t;
            }
            this.releaseLockOnTxCompletion((TxInvocationContext)rCtx);
        });
    }

    final KeyAwareLockPromise lockOrRegisterBackupLock(TxInvocationContext<?> ctx, Object key, long lockTimeout) throws InterruptedException {
        switch (this.cdl.getCacheTopology().getDistribution(key).writeOwnership()) {
            case PRIMARY: {
                if (this.trace) {
                    this.getLog().tracef("Acquiring locks on %s.", Util.toStr((Object)key));
                }
                return this.checkPendingAndLockKey(ctx, key, lockTimeout);
            }
            case BACKUP: {
                if (this.trace) {
                    this.getLog().tracef("Acquiring backup locks on %s.", key);
                }
                ((AbstractCacheTransaction)ctx.getCacheTransaction()).addBackupLockForKey(key);
            }
        }
        return KeyAwareLockPromise.NO_OP;
    }

    final KeyAwareLockPromise lockAllOrRegisterBackupLock(TxInvocationContext<?> ctx, Collection<?> keys, long lockTimeout) throws InterruptedException {
        if (keys.isEmpty()) {
            return KeyAwareLockPromise.NO_OP;
        }
        Log log = this.getLog();
        ArrayList<Object> keysToLock = new ArrayList<Object>(keys.size());
        LocalizedCacheTopology cacheTopology = this.cdl.getCacheTopology();
        for (Object key : keys) {
            switch (cacheTopology.getDistribution(key).writeOwnership()) {
                case PRIMARY: {
                    if (this.trace) {
                        log.tracef("Acquiring locks on %s.", Util.toStr(key));
                    }
                    keysToLock.add(key);
                    break;
                }
                case BACKUP: {
                    if (this.trace) {
                        log.tracef("Acquiring backup locks on %s.", Util.toStr(key));
                    }
                    ((AbstractCacheTransaction)ctx.getCacheTransaction()).addBackupLockForKey(key);
                    break;
                }
            }
        }
        if (keysToLock.isEmpty()) {
            return KeyAwareLockPromise.NO_OP;
        }
        return this.checkPendingAndLockAllKeys(ctx, keysToLock, lockTimeout);
    }

    private KeyAwareLockPromise checkPendingAndLockKey(InvocationContext ctx, Object key, long lockTimeout) throws InterruptedException {
        long remaining = this.pendingLockManager.awaitPendingTransactionsForKey((TxInvocationContext)ctx, key, lockTimeout, TimeUnit.MILLISECONDS);
        return this.lockAndRecord(ctx, key, remaining);
    }

    private KeyAwareLockPromise checkPendingAndLockAllKeys(InvocationContext ctx, Collection<Object> keys, long lockTimeout) throws InterruptedException {
        long remaining = this.pendingLockManager.awaitPendingTransactionsForAllKeys((TxInvocationContext)ctx, keys, lockTimeout, TimeUnit.MILLISECONDS);
        return this.lockAllAndRecord(ctx, keys, remaining);
    }

    void releaseLockOnTxCompletion(TxInvocationContext ctx) {
        boolean shouldReleaseLocks;
        boolean bl = shouldReleaseLocks = ctx.isOriginLocal() && !this.partitionHandlingManager.isTransactionPartiallyCommitted(ctx.getGlobalTransaction());
        if (shouldReleaseLocks) {
            this.lockManager.unlockAll(ctx);
        }
    }
}

