/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.aop.Around;
import io.micronaut.aop.InterceptorKind;
import io.micronaut.aop.internal.intercepted.InterceptedMethodUtil;
import io.micronaut.aop.writer.AopProxyWriter;
import io.micronaut.ast.groovy.annotation.GroovyAnnotationMetadataBuilder;
import io.micronaut.ast.groovy.visitor.GroovyElementFactory;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.ast.beans.BeanParameterElement;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.AbstractBeanDefinitionBuilder;
import io.micronaut.inject.writer.BeanDefinitionVisitor;
import io.micronaut.inject.writer.BeanDefinitionWriter;
import java.lang.annotation.Annotation;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;

@Internal
class GroovyBeanDefinitionBuilder
extends AbstractBeanDefinitionBuilder {
    private final GroovyVisitorContext visitorContext;

    GroovyBeanDefinitionBuilder(Element originatingElement, ClassElement beanType, ConfigurationMetadataBuilder<?> metadataBuilder, GroovyVisitorContext visitorContext) {
        super(originatingElement, beanType, metadataBuilder, (VisitorContext)visitorContext);
        if (((Object)((Object)this)).getClass() == GroovyBeanDefinitionBuilder.class) {
            visitorContext.addBeanDefinitionBuilder(this);
        }
        this.visitorContext = visitorContext;
    }

    protected AbstractBeanDefinitionBuilder createChildBean(final FieldElement producerField) {
        final ClassElement parentType = this.getBeanType();
        return new GroovyBeanDefinitionBuilder(this.getOriginatingElement(), producerField.getGenericField().getType(), this.metadataBuilder, this.visitorContext){

            public Element getProducingElement() {
                return producerField;
            }

            public ClassElement getDeclaringElement() {
                return producerField.getDeclaringType();
            }

            protected BeanDefinitionVisitor createBeanDefinitionWriter() {
                BeanDefinitionVisitor writer = super.createBeanDefinitionWriter();
                GroovyElementFactory elementFactory = GroovyBeanDefinitionBuilder.this.visitorContext.getElementFactory();
                FieldNode fieldNode = (FieldNode)producerField.getNativeType();
                ClassElement resolvedParent = GroovyBeanDefinitionBuilder.this.resolveParent(parentType, elementFactory);
                writer.visitBeanFactoryField(resolvedParent, elementFactory.newFieldElement(resolvedParent, fieldNode, (AnnotationMetadata)new AnnotationMetadataHierarchy(new AnnotationMetadata[]{resolvedParent.getDeclaredMetadata(), producerField.getDeclaredMetadata()})));
                return writer;
            }
        };
    }

    protected AbstractBeanDefinitionBuilder createChildBean(final MethodElement producerMethod) {
        final ClassElement parentType = this.getBeanType();
        return new GroovyBeanDefinitionBuilder(this.getOriginatingElement(), producerMethod.getGenericReturnType().getType(), this.metadataBuilder, this.visitorContext){
            BeanParameterElement[] parameters;

            public Element getProducingElement() {
                return producerMethod;
            }

            public ClassElement getDeclaringElement() {
                return producerMethod.getDeclaringType();
            }

            protected BeanParameterElement[] getParameters() {
                if (this.parameters == null) {
                    this.parameters = this.initBeanParameters(producerMethod.getParameters());
                }
                return this.parameters;
            }

            protected BeanDefinitionVisitor createBeanDefinitionWriter() {
                BeanDefinitionVisitor writer = super.createBeanDefinitionWriter();
                GroovyElementFactory elementFactory = GroovyBeanDefinitionBuilder.this.visitorContext.getElementFactory();
                ClassElement resolvedParent = GroovyBeanDefinitionBuilder.this.resolveParent(parentType, elementFactory);
                MethodNode methodNode = (MethodNode)producerMethod.getNativeType();
                writer.visitBeanFactoryMethod(resolvedParent, elementFactory.newMethodElement(resolvedParent, methodNode, (AnnotationMetadata)new AnnotationMetadataHierarchy(new AnnotationMetadata[]{resolvedParent.getDeclaredMetadata(), producerMethod.getDeclaredMetadata()})), (ParameterElement[])this.getParameters());
                return writer;
            }
        };
    }

    protected <T extends Annotation> void annotate(AnnotationMetadata annotationMetadata, String annotationType, Consumer<AnnotationValueBuilder<T>> consumer) {
        if (consumer != null && annotationMetadata != null && annotationType != null) {
            AnnotationValueBuilder builder = AnnotationValue.builder((String)annotationType);
            consumer.accept(builder);
            AnnotationValue av = builder.build();
            GroovyAnnotationMetadataBuilder annotationBuilder = new GroovyAnnotationMetadataBuilder(this.visitorContext.getSourceUnit(), this.visitorContext.getCompilationUnit());
            annotationBuilder.annotate(annotationMetadata, av);
        }
    }

    protected <T extends Annotation> void annotate(AnnotationMetadata annotationMetadata, AnnotationValue<T> annotationValue) {
        ArgumentUtils.requireNonNull((String)"annotationMetadata", (Object)annotationMetadata);
        ArgumentUtils.requireNonNull((String)"annotationValue", annotationValue);
        GroovyAnnotationMetadataBuilder annotationBuilder = new GroovyAnnotationMetadataBuilder(this.visitorContext.getSourceUnit(), this.visitorContext.getCompilationUnit());
        annotationBuilder.annotate(annotationMetadata, annotationValue);
    }

    protected void removeStereotype(AnnotationMetadata annotationMetadata, String annotationType) {
        if (annotationMetadata != null && annotationType != null) {
            GroovyAnnotationMetadataBuilder annotationBuilder = new GroovyAnnotationMetadataBuilder(this.visitorContext.getSourceUnit(), this.visitorContext.getCompilationUnit());
            annotationBuilder.removeStereotype(annotationMetadata, annotationType);
        }
    }

    protected <T extends Annotation> void removeAnnotationIf(AnnotationMetadata annotationMetadata, Predicate<AnnotationValue<T>> predicate) {
        if (annotationMetadata != null && predicate != null) {
            GroovyAnnotationMetadataBuilder annotationBuilder = new GroovyAnnotationMetadataBuilder(this.visitorContext.getSourceUnit(), this.visitorContext.getCompilationUnit());
            annotationBuilder.removeAnnotationIf(annotationMetadata, predicate);
        }
    }

    protected void removeAnnotation(AnnotationMetadata annotationMetadata, String annotationType) {
        if (annotationMetadata != null && annotationType != null) {
            GroovyAnnotationMetadataBuilder annotationBuilder = new GroovyAnnotationMetadataBuilder(this.visitorContext.getSourceUnit(), this.visitorContext.getCompilationUnit());
            annotationBuilder.removeAnnotation(annotationMetadata, annotationType);
        }
    }

    private ClassElement resolveParent(ClassElement parentType, GroovyElementFactory elementFactory) {
        Object nativeType = parentType.getNativeType();
        ClassElement resolvedParent = parentType;
        if (nativeType instanceof ClassNode) {
            resolvedParent = elementFactory.newClassElement((ClassNode)nativeType, this.getAnnotationMetadata());
        }
        return resolvedParent;
    }

    protected BeanDefinitionVisitor createAopWriter(BeanDefinitionWriter beanDefinitionWriter, AnnotationMetadata annotationMetadata) {
        AnnotationValue[] interceptorTypes = InterceptedMethodUtil.resolveInterceptorBinding((AnnotationMetadata)annotationMetadata, (InterceptorKind)InterceptorKind.AROUND);
        return new AopProxyWriter(beanDefinitionWriter, annotationMetadata.getValues(Around.class, Boolean.class), (ConfigurationMetadataBuilder)ConfigurationMetadataBuilder.getConfigurationMetadataBuilder().orElse(null), (VisitorContext)this.visitorContext, interceptorTypes);
    }

    protected BiConsumer<TypedElement, MethodElement> createAroundMethodVisitor(BeanDefinitionVisitor aopWriter) {
        AopProxyWriter aopProxyWriter = (AopProxyWriter)aopWriter;
        return (bean, method) -> {
            AnnotationValue[] newTypes = InterceptedMethodUtil.resolveInterceptorBinding((AnnotationMetadata)method.getAnnotationMetadata(), (InterceptorKind)InterceptorKind.AROUND);
            aopProxyWriter.visitInterceptorBinding(newTypes);
            aopProxyWriter.visitAroundMethod(bean, method);
        };
    }
}

