/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.labelAdjust;

import java.util.ArrayList;
import java.util.List;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.TextProperties;
import org.gephi.graph.spi.LayoutData;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.plugin.labelAdjust.LabelAdjustLayoutData;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class LabelAdjust
extends AbstractLayout
implements Layout {
    protected Graph graph;
    private double speed = 1.0;
    private boolean adjustBySize = true;
    private float radiusScale = 1.1f;
    private float xmin;
    private float xmax;
    private float ymin;
    private float ymax;

    public LabelAdjust(LayoutBuilder layoutBuilder) {
        super(layoutBuilder);
    }

    public void resetPropertiesValues() {
        this.speed = 1.0;
        this.radiusScale = 1.1f;
        this.adjustBySize = true;
    }

    public void initAlgo() {
        this.setConverged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goAlgo() {
        this.graph = this.graphModel.getGraphVisible();
        this.graph.readLock();
        try {
            LabelAdjustLayoutData layoutData;
            Node[] nodes;
            for (Node n : nodes = this.graph.getNodes().toArray()) {
                if (n.getLayoutData() == null || !(n.getLayoutData() instanceof LabelAdjustLayoutData)) {
                    n.setLayoutData((LayoutData)new LabelAdjustLayoutData());
                }
                LabelAdjustLayoutData layoutData2 = (LabelAdjustLayoutData)n.getLayoutData();
                layoutData2.freeze = 0.0f;
                layoutData2.dx = 0.0f;
                layoutData2.dy = 0.0f;
            }
            this.xmin = Float.MAX_VALUE;
            this.xmax = Float.MIN_VALUE;
            this.ymin = Float.MAX_VALUE;
            this.ymax = Float.MIN_VALUE;
            ArrayList<Node> correctNodes = new ArrayList<Node>();
            for (Node n : nodes) {
                float x = n.x();
                float y = n.y();
                TextProperties t = n.getTextProperties();
                float w = t.getWidth();
                float h = t.getHeight();
                float radius = n.size() / 2.0f;
                if (!(w > 0.0f) || !(h > 0.0f)) continue;
                float nxmin = Math.min(x - w / 2.0f, x - radius);
                float nxmax = Math.max(x + w / 2.0f, x + radius);
                float nymin = Math.min(y - h / 2.0f, y - radius);
                float nymax = Math.max(y + h / 2.0f, y + radius);
                this.xmin = Math.min(this.xmin, nxmin);
                this.xmax = Math.max(this.xmax, nxmax);
                this.ymin = Math.min(this.ymin, nymin);
                this.ymax = Math.max(this.ymax, nymax);
                correctNodes.add(n);
            }
            if (correctNodes.isEmpty() || this.xmin == this.xmax || this.ymin == this.ymax) {
                return;
            }
            long timeStamp = 1L;
            boolean someCollision = false;
            QuadTree quadTree = new QuadTree(correctNodes.size(), (this.xmax - this.xmin) / (this.ymax - this.ymin));
            for (Node n : correctNodes) {
                quadTree.add(n);
            }
            for (Node n : correctNodes) {
                ++timeStamp;
                layoutData = (LabelAdjustLayoutData)n.getLayoutData();
                QuadNode quad = quadTree.getQuadNode(layoutData.labelAdjustQuadNode);
                for (Node neighbour : quadTree.getAdjacentNodes(quad.row, quad.col)) {
                    LabelAdjustLayoutData neighborLayoutData = (LabelAdjustLayoutData)neighbour.getLayoutData();
                    if (neighbour != n && neighborLayoutData.freeze < (float)timeStamp) {
                        boolean collision = this.repulse(n, neighbour);
                        someCollision = someCollision || collision;
                    }
                    neighborLayoutData.freeze = timeStamp;
                }
            }
            if (!someCollision) {
                this.setConverged(true);
            } else {
                for (Node n : correctNodes) {
                    layoutData = (LabelAdjustLayoutData)n.getLayoutData();
                    if (n.isFixed()) continue;
                    layoutData.dx = (float)((double)layoutData.dx * this.speed);
                    layoutData.dy = (float)((double)layoutData.dy * this.speed);
                    float x = n.x() + layoutData.dx;
                    float y = n.y() + layoutData.dy;
                    n.setX(x);
                    n.setY(y);
                }
            }
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    private boolean repulse(Node n1, Node n2) {
        boolean collision = false;
        float n1x = n1.x();
        float n1y = n1.y();
        float n2x = n2.x();
        float n2y = n2.y();
        TextProperties t1 = n1.getTextProperties();
        TextProperties t2 = n2.getTextProperties();
        float n1w = t1.getWidth();
        float n2w = t2.getWidth();
        float n1h = t1.getHeight();
        float n2h = t2.getHeight();
        LabelAdjustLayoutData n2Data = (LabelAdjustLayoutData)n2.getLayoutData();
        double n1xmin = (double)n1x - 0.5 * (double)n1w;
        double n2xmin = (double)n2x - 0.5 * (double)n2w;
        double n1ymin = (double)n1y - 0.5 * (double)n1h;
        double n2ymin = (double)n2y - 0.5 * (double)n2h;
        double n1xmax = (double)n1x + 0.5 * (double)n1w;
        double n2xmax = (double)n2x + 0.5 * (double)n2w;
        double n1ymax = (double)n1y + 0.5 * (double)n1h;
        double n2ymax = (double)n2y + 0.5 * (double)n2h;
        if (this.adjustBySize) {
            boolean sphereCollision;
            double xDist = n2x - n1x;
            double yDist = n2y - n1y;
            double dist = Math.sqrt(xDist * xDist + yDist * yDist);
            boolean bl = sphereCollision = dist < (double)(this.radiusScale * (n1.size() + n2.size()));
            if (sphereCollision) {
                double f = 0.1 * (double)n1.size() / dist;
                if (dist > 0.0) {
                    n2Data.dx = (float)((double)n2Data.dx + xDist / dist * f);
                    n2Data.dy = (float)((double)n2Data.dy + yDist / dist * f);
                } else {
                    n2Data.dx = (float)((double)n2Data.dx + 0.01 * (0.5 - Math.random()));
                    n2Data.dy = (float)((double)n2Data.dy + 0.01 * (0.5 - Math.random()));
                }
                collision = true;
            }
        }
        double upDifferential = n1ymax - n2ymin;
        double downDifferential = n2ymax - n1ymin;
        double labelCollisionXleft = n2xmax - n1xmin;
        double labelCollisionXright = n1xmax - n2xmin;
        if (upDifferential > 0.0 && downDifferential > 0.0 && labelCollisionXleft > 0.0 && labelCollisionXright > 0.0) {
            if (upDifferential > downDifferential) {
                n2Data.dy = (float)((double)n2Data.dy - 0.02 * (double)n1h * (0.8 + 0.4 * Math.random()));
                collision = true;
            } else {
                n2Data.dy = (float)((double)n2Data.dy + 0.02 * (double)n1h * (0.8 + 0.4 * Math.random()));
                collision = true;
            }
            if (labelCollisionXleft > labelCollisionXright) {
                n2Data.dx = (float)((double)n2Data.dx + 0.01 * (double)(n1h * 2.0f) * (0.8 + 0.4 * Math.random()));
                collision = true;
            } else {
                n2Data.dx = (float)((double)n2Data.dx - 0.01 * (double)(n1h * 2.0f) * (0.8 + 0.4 * Math.random()));
                collision = true;
            }
        }
        return collision;
    }

    public void endAlgo() {
        for (Node n : this.graph.getNodes()) {
            n.setLayoutData(null);
        }
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        String LABELADJUST_CATEGORY = "LabelAdjust";
        try {
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(this.getClass(), (String)"LabelAdjust.speed.name"), (String)"LabelAdjust", (String)"LabelAdjust.speed.name", (String)NbBundle.getMessage(this.getClass(), (String)"LabelAdjust.speed.desc"), (String)"getSpeed", (String)"setSpeed"));
            properties.add(LayoutProperty.createProperty((Layout)this, Boolean.class, (String)NbBundle.getMessage(this.getClass(), (String)"LabelAdjust.adjustBySize.name"), (String)"LabelAdjust", (String)"LabelAdjust.adjustBySize.name", (String)NbBundle.getMessage(this.getClass(), (String)"LabelAdjust.adjustBySize.desc"), (String)"isAdjustBySize", (String)"setAdjustBySize"));
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public Double getSpeed() {
        return this.speed;
    }

    public void setSpeed(Double speed) {
        this.speed = speed;
    }

    public Boolean isAdjustBySize() {
        return this.adjustBySize;
    }

    public void setAdjustBySize(Boolean adjustBySize) {
        this.adjustBySize = adjustBySize;
    }

    private class QuadTree {
        private final QuadNode[] quads;
        private final int COLUMNS;
        private final int ROWS;

        public QuadTree(int numberNodes, float aspectRatio) {
            if (aspectRatio > 0.0f) {
                this.COLUMNS = (int)Math.ceil((float)numberNodes / 50.0f);
                this.ROWS = (int)Math.ceil((float)this.COLUMNS / aspectRatio);
            } else {
                this.ROWS = (int)Math.ceil((float)numberNodes / 50.0f);
                this.COLUMNS = (int)Math.ceil((float)this.ROWS / aspectRatio);
            }
            this.quads = new QuadNode[this.COLUMNS * this.ROWS];
            for (int row = 0; row < this.ROWS; ++row) {
                for (int col = 0; col < this.COLUMNS; ++col) {
                    this.quads[row * this.COLUMNS + col] = new QuadNode(row * this.COLUMNS + col, row, col);
                }
            }
        }

        public void add(Node node) {
            float x = node.x();
            float y = node.y();
            TextProperties t = node.getTextProperties();
            float w = t.getWidth();
            float h = t.getHeight();
            float radius = node.size();
            float nxmin = Math.min(x - w / 2.0f, x - radius);
            float nxmax = Math.max(x + w / 2.0f, x + radius);
            float nymin = Math.min(y - h / 2.0f, y - radius);
            float nymax = Math.max(y + h / 2.0f, y + radius);
            int minXbox = (int)Math.floor((float)(this.COLUMNS - 1) * (nxmin - LabelAdjust.this.xmin) / (LabelAdjust.this.xmax - LabelAdjust.this.xmin));
            int maxXbox = (int)Math.floor((float)(this.COLUMNS - 1) * (nxmax - LabelAdjust.this.xmin) / (LabelAdjust.this.xmax - LabelAdjust.this.xmin));
            int minYbox = (int)Math.floor((float)(this.ROWS - 1) * ((LabelAdjust.this.ymax - LabelAdjust.this.ymin - (nymax - LabelAdjust.this.ymin)) / (LabelAdjust.this.ymax - LabelAdjust.this.ymin)));
            int maxYbox = (int)Math.floor((float)(this.ROWS - 1) * ((LabelAdjust.this.ymax - LabelAdjust.this.ymin - (nymin - LabelAdjust.this.ymin)) / (LabelAdjust.this.ymax - LabelAdjust.this.ymin)));
            for (int col = minXbox; col <= maxXbox && col < this.COLUMNS && col >= 0; ++col) {
                for (int row = minYbox; row <= maxYbox && row < this.ROWS && row >= 0; ++row) {
                    this.quads[row * this.COLUMNS + col].add(node);
                }
            }
            int centerX = (int)Math.floor((float)(this.COLUMNS - 1) * (x - LabelAdjust.this.xmin) / (LabelAdjust.this.xmax - LabelAdjust.this.xmin));
            int centerY = (int)Math.floor((float)(this.ROWS - 1) * ((LabelAdjust.this.ymax - LabelAdjust.this.ymin - (y - LabelAdjust.this.ymin)) / (LabelAdjust.this.ymax - LabelAdjust.this.ymin)));
            LabelAdjustLayoutData layoutData = (LabelAdjustLayoutData)node.getLayoutData();
            layoutData.labelAdjustQuadNode = this.quads[centerY * this.COLUMNS + centerX].index;
        }

        public List<Node> get(int row, int col) {
            return this.quads[row * this.ROWS + col].getNodes();
        }

        public List<Node> getAdjacentNodes(int row, int col) {
            if (this.quads.length == 1) {
                return this.quads[0].getNodes();
            }
            ArrayList<Node> adjNodes = new ArrayList<Node>();
            int left = Math.max(0, col - 1);
            int top = Math.max(0, row - 1);
            int right = Math.min(this.COLUMNS - 1, col + 1);
            int bottom = Math.min(this.ROWS - 1, row + 1);
            for (int i = left; i <= right; ++i) {
                for (int j = top; j <= bottom; ++j) {
                    adjNodes.addAll(this.quads[j * this.COLUMNS + i].getNodes());
                }
            }
            return adjNodes;
        }

        public QuadNode getQuadNode(int index) {
            return this.quads[index];
        }
    }

    private static class QuadNode {
        private final int index;
        private final int row;
        private final int col;
        private final List<Node> nodes;

        public QuadNode(int index, int row, int col) {
            this.index = index;
            this.row = row;
            this.col = col;
            this.nodes = new ArrayList<Node>();
        }

        public List<Node> getNodes() {
            return this.nodes;
        }

        public void add(Node n) {
            this.nodes.add(n);
        }
    }
}

