/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.api;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.gephi.preview.api.PreviewPreset;
import org.gephi.preview.api.PreviewProperty;
import org.gephi.utils.Serialization;

public class PreviewProperties {
    private final Map<String, Object> simpleValues;
    private final Map<String, PreviewProperty> properties = new LinkedHashMap<String, PreviewProperty>();

    public PreviewProperties() {
        this.simpleValues = new HashMap<String, Object>();
    }

    public static String getValueAsText(Object value) {
        return Serialization.getValueAsText((Object)value);
    }

    public static Object readValueFromText(String valueStr, Class valueClass) {
        return Serialization.readValueFromText((String)valueStr, (Class)valueClass);
    }

    public void addProperty(PreviewProperty property) {
        if (this.properties.containsKey(property.getName())) {
            throw new RuntimeException("The property " + property.getName() + " already exists. Each property name should be unique.");
        }
        for (String parent : property.dependencies) {
            PreviewProperty p = this.properties.get(parent);
            if (p == null || p.getType().equals(Boolean.class)) continue;
            throw new IllegalArgumentException("The property " + property.getName() + " has dependencies to non-boolean property " + p.getName());
        }
        this.properties.put(property.getName(), property);
    }

    public void removeProperty(PreviewProperty property) {
        this.properties.remove(property.getName());
    }

    public boolean hasProperty(String name) {
        return this.simpleValues.containsKey(name) || this.properties.containsKey(name);
    }

    public void putValue(String name, Object value) {
        PreviewProperty property = this.getProperty(name);
        if (property != null) {
            property.setValue(value);
        } else {
            this.simpleValues.put(name, value);
        }
    }

    public void removeSimpleValue(String name) {
        this.simpleValues.remove(name);
    }

    public int getIntValue(String property) {
        return this.getNumberValue(property, new Integer(0)).intValue();
    }

    public float getFloatValue(String property) {
        return this.getNumberValue(property, new Float(0.0f)).floatValue();
    }

    public double getDoubleValue(String property) {
        return this.getNumberValue(property, new Double(0.0)).doubleValue();
    }

    public String getStringValue(String property) {
        return this.getValue(property, "");
    }

    public Color getColorValue(String property) {
        return this.getValue(property, null);
    }

    public Font getFontValue(String property) {
        return this.getValue(property, null);
    }

    public boolean getBooleanValue(String property) {
        return this.getValue(property, Boolean.FALSE);
    }

    public <T> T getValue(String property) {
        PreviewProperty p = this.getProperty(property);
        if (p != null && p.getValue() != null) {
            Object value = p.getValue();
            return value;
        }
        if (this.simpleValues.containsKey(property)) {
            return (T)this.simpleValues.get(property);
        }
        return null;
    }

    public <T> T getValue(String property, T defaultValue) {
        PreviewProperty p = this.getProperty(property);
        if (p != null && p.getValue() != null) {
            Object value = p.getValue();
            return value;
        }
        if (this.simpleValues.containsKey(property)) {
            return (T)this.simpleValues.get(property);
        }
        return defaultValue;
    }

    public Number getNumberValue(String property, Number defaultValue) {
        PreviewProperty p = this.getProperty(property);
        if (p != null && p.getValue() != null && p.getValue() instanceof Number) {
            Number value = (Number)p.getValue();
            return value;
        }
        if (this.simpleValues.containsKey(property) && this.simpleValues.get(property) instanceof Number) {
            return (Number)this.simpleValues.get(property);
        }
        return defaultValue;
    }

    public Set<Map.Entry<String, Object>> getSimpleValues() {
        return this.simpleValues.entrySet();
    }

    public PreviewProperty[] getProperties() {
        return this.properties.values().toArray(new PreviewProperty[0]);
    }

    public PreviewProperty[] getProperties(String category) {
        ArrayList<PreviewProperty> props = new ArrayList<PreviewProperty>();
        for (PreviewProperty p : this.properties.values()) {
            if (!p.getCategory().equals(category)) continue;
            props.add(p);
        }
        return props.toArray(new PreviewProperty[0]);
    }

    public PreviewProperty getProperty(String name) {
        return this.properties.get(name);
    }

    public PreviewProperty[] getProperties(Object source) {
        ArrayList<PreviewProperty> props = new ArrayList<PreviewProperty>();
        for (PreviewProperty p : this.properties.values()) {
            if (!p.getSource().equals(source)) continue;
            props.add(p);
        }
        return props.toArray(new PreviewProperty[0]);
    }

    public PreviewProperty[] getChildProperties(PreviewProperty property) {
        ArrayList<PreviewProperty> props = new ArrayList<PreviewProperty>();
        for (PreviewProperty p : this.properties.values()) {
            for (String pn : p.dependencies) {
                if (!pn.equals(property.getName())) continue;
                props.add(p);
            }
        }
        return props.toArray(new PreviewProperty[0]);
    }

    public PreviewProperty[] getParentProperties(PreviewProperty property) {
        ArrayList<PreviewProperty> props = new ArrayList<PreviewProperty>();
        for (PreviewProperty p : this.properties.values()) {
            for (String pn : property.dependencies) {
                if (!pn.equals(p.getName())) continue;
                props.add(p);
            }
        }
        return props.toArray(new PreviewProperty[0]);
    }

    public void applyPreset(PreviewPreset previewPreset) {
        for (Map.Entry<String, Object> entry : previewPreset.getProperties().entrySet()) {
            PreviewProperty prop = this.getProperty(entry.getKey());
            if (prop != null) {
                prop.setValue(entry.getValue());
                continue;
            }
            this.simpleValues.put(entry.getKey(), entry.getValue());
        }
    }
}

