/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSTextTrack.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSTextTrackCue.h"
#include "JSTextTrackCueList.h"
#include "JSVTTRegion.h"
#include "JSVTTRegionList.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>

#if ENABLE(MEDIA_SOURCE)
#include "JSSourceBuffer.h"
#include "TextTrackMediaSource.h"
#endif


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(TextTrack::Mode enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("disabled"),
        MAKE_STATIC_STRING_IMPL("hidden"),
        MAKE_STATIC_STRING_IMPL("showing"),
    };
    static_assert(static_cast<size_t>(TextTrack::Mode::Disabled) == 0, "TextTrack::Mode::Disabled is not 0 as expected");
    static_assert(static_cast<size_t>(TextTrack::Mode::Hidden) == 1, "TextTrack::Mode::Hidden is not 1 as expected");
    static_assert(static_cast<size_t>(TextTrack::Mode::Showing) == 2, "TextTrack::Mode::Showing is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, TextTrack::Mode enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<TextTrack::Mode> parseEnumerationFromString<TextTrack::Mode>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, TextTrack::Mode> mappings[] = {
        { "disabled", TextTrack::Mode::Disabled },
        { "hidden", TextTrack::Mode::Hidden },
        { "showing", TextTrack::Mode::Showing },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<TextTrack::Mode> parseEnumeration<TextTrack::Mode>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<TextTrack::Mode>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<TextTrack::Mode>()
{
    return "\"disabled\", \"hidden\", \"showing\"";
}

String convertEnumerationToString(TextTrack::Kind enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("subtitles"),
        MAKE_STATIC_STRING_IMPL("captions"),
        MAKE_STATIC_STRING_IMPL("descriptions"),
        MAKE_STATIC_STRING_IMPL("chapters"),
        MAKE_STATIC_STRING_IMPL("metadata"),
        MAKE_STATIC_STRING_IMPL("forced"),
    };
    static_assert(static_cast<size_t>(TextTrack::Kind::Subtitles) == 0, "TextTrack::Kind::Subtitles is not 0 as expected");
    static_assert(static_cast<size_t>(TextTrack::Kind::Captions) == 1, "TextTrack::Kind::Captions is not 1 as expected");
    static_assert(static_cast<size_t>(TextTrack::Kind::Descriptions) == 2, "TextTrack::Kind::Descriptions is not 2 as expected");
    static_assert(static_cast<size_t>(TextTrack::Kind::Chapters) == 3, "TextTrack::Kind::Chapters is not 3 as expected");
    static_assert(static_cast<size_t>(TextTrack::Kind::Metadata) == 4, "TextTrack::Kind::Metadata is not 4 as expected");
    static_assert(static_cast<size_t>(TextTrack::Kind::Forced) == 5, "TextTrack::Kind::Forced is not 5 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, TextTrack::Kind enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<TextTrack::Kind> parseEnumerationFromString<TextTrack::Kind>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, TextTrack::Kind> mappings[] = {
        { "captions", TextTrack::Kind::Captions },
        { "chapters", TextTrack::Kind::Chapters },
        { "descriptions", TextTrack::Kind::Descriptions },
        { "forced", TextTrack::Kind::Forced },
        { "metadata", TextTrack::Kind::Metadata },
        { "subtitles", TextTrack::Kind::Subtitles },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<TextTrack::Kind> parseEnumeration<TextTrack::Kind>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<TextTrack::Kind>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<TextTrack::Kind>()
{
    return "\"subtitles\", \"captions\", \"descriptions\", \"chapters\", \"metadata\", \"forced\"";
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsTextTrackPrototypeFunction_addCue);
static JSC_DECLARE_HOST_FUNCTION(jsTextTrackPrototypeFunction_removeCue);
static JSC_DECLARE_HOST_FUNCTION(jsTextTrackPrototypeFunction_addRegion);
static JSC_DECLARE_HOST_FUNCTION(jsTextTrackPrototypeFunction_removeRegion);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsTextTrackConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsTextTrack_id);
static JSC_DECLARE_CUSTOM_GETTER(jsTextTrack_kind);
static JSC_DECLARE_CUSTOM_SETTER(setJSTextTrack_kind);
static JSC_DECLARE_CUSTOM_GETTER(jsTextTrack_label);
static JSC_DECLARE_CUSTOM_GETTER(jsTextTrack_language);
static JSC_DECLARE_CUSTOM_SETTER(setJSTextTrack_language);
static JSC_DECLARE_CUSTOM_GETTER(jsTextTrack_inBandMetadataTrackDispatchType);
static JSC_DECLARE_CUSTOM_GETTER(jsTextTrack_mode);
static JSC_DECLARE_CUSTOM_SETTER(setJSTextTrack_mode);
static JSC_DECLARE_CUSTOM_GETTER(jsTextTrack_cues);
static JSC_DECLARE_CUSTOM_GETTER(jsTextTrack_activeCues);
static JSC_DECLARE_CUSTOM_GETTER(jsTextTrack_oncuechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSTextTrack_oncuechange);
static JSC_DECLARE_CUSTOM_GETTER(jsTextTrack_regions);
#if ENABLE(MEDIA_SOURCE)
static JSC_DECLARE_CUSTOM_GETTER(jsTextTrack_sourceBuffer);
#endif

class JSTextTrackPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTextTrackPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTextTrackPrototype* ptr = new (NotNull, JSC::allocateCell<JSTextTrackPrototype>(vm)) JSTextTrackPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTextTrackPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTextTrackPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTextTrackPrototype, JSTextTrackPrototype::Base);

using JSTextTrackDOMConstructor = JSDOMConstructorNotConstructable<JSTextTrack>;

template<> const ClassInfo JSTextTrackDOMConstructor::s_info = { "TextTrack"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextTrackDOMConstructor) };

template<> JSValue JSTextTrackDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSTextTrackDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "TextTrack"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSTextTrack::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSTextTrackPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrackConstructor, 0 } },
    { "id"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrack_id, 0 } },
    { "kind"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrack_kind, setJSTextTrack_kind } },
    { "label"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrack_label, 0 } },
    { "language"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrack_language, setJSTextTrack_language } },
    { "inBandMetadataTrackDispatchType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrack_inBandMetadataTrackDispatchType, 0 } },
    { "mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrack_mode, setJSTextTrack_mode } },
    { "cues"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrack_cues, 0 } },
    { "activeCues"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrack_activeCues, 0 } },
    { "oncuechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrack_oncuechange, setJSTextTrack_oncuechange } },
    { "regions"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrack_regions, 0 } },
#if ENABLE(MEDIA_SOURCE)
    { "sourceBuffer"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextTrack_sourceBuffer, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "addCue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTextTrackPrototypeFunction_addCue, 1 } },
    { "removeCue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTextTrackPrototypeFunction_removeCue, 1 } },
    { "addRegion"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTextTrackPrototypeFunction_addRegion, 1 } },
    { "removeRegion"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTextTrackPrototypeFunction_removeRegion, 1 } },
};

const ClassInfo JSTextTrackPrototype::s_info = { "TextTrack"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextTrackPrototype) };

void JSTextTrackPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTextTrack::info(), JSTextTrackPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().mediaSourceEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "language"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#if ENABLE(MEDIA_SOURCE)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().mediaSourceEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "sourceBuffer"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    // Adding back attribute, but as readonly, after removing the read-write variant above. 
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().mediaSourceEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).languagePublicName(), JSC::DOMAttributeGetterSetter::create(vm, jsTextTrack_language, nullptr, JSC::DOMAttributeAnnotation { JSTextTrack::info(), nullptr }), attributesForStructure(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute));
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSTextTrack::s_info = { "TextTrack"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextTrack) };

JSTextTrack::JSTextTrack(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TextTrack>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, TextTrack>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSTextTrack::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSTextTrackPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSTextTrackPrototype::create(vm, &globalObject, structure);
}

JSObject* JSTextTrack::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTextTrack>(vm, globalObject);
}

JSValue JSTextTrack::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTextTrackDOMConstructor, DOMConstructorID::TextTrack>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrackConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTextTrackPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTextTrack::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsTextTrack_idGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrack& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.id())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrack_id, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrack>::get<jsTextTrack_idGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTextTrack_kindGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrack& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<TextTrack::Kind>>(lexicalGlobalObject, throwScope, impl.kindForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrack_kind, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrack>::get<jsTextTrack_kindGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSTextTrack_kindSetter(JSGlobalObject& lexicalGlobalObject, JSTextTrack& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<TextTrack::Kind>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setKindForBindings(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSTextTrack_kind, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrack>::set<setJSTextTrack_kindSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsTextTrack_labelGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrack& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.label())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrack_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrack>::get<jsTextTrack_labelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTextTrack_languageGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrack& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.language())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrack_language, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrack>::get<jsTextTrack_languageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSTextTrack_languageSetter(JSGlobalObject& lexicalGlobalObject, JSTextTrack& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLanguage(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSTextTrack_language, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrack>::set<setJSTextTrack_languageSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsTextTrack_inBandMetadataTrackDispatchTypeGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrack& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.inBandMetadataTrackDispatchType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrack_inBandMetadataTrackDispatchType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrack>::get<jsTextTrack_inBandMetadataTrackDispatchTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTextTrack_modeGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrack& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<TextTrack::Mode>>(lexicalGlobalObject, throwScope, impl.mode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrack_mode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrack>::get<jsTextTrack_modeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSTextTrack_modeSetter(JSGlobalObject& lexicalGlobalObject, JSTextTrack& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<TextTrack::Mode>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMode(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSTextTrack_mode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrack>::set<setJSTextTrack_modeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsTextTrack_cuesGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrack& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<TextTrackCueList>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.cues())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrack_cues, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrack>::get<jsTextTrack_cuesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTextTrack_activeCuesGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrack& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<TextTrackCueList>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.activeCues())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrack_activeCues, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrack>::get<jsTextTrack_activeCuesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTextTrack_oncuechangeGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrack& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().cuechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrack_oncuechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrack>::get<jsTextTrack_oncuechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSTextTrack_oncuechangeSetter(JSGlobalObject& lexicalGlobalObject, JSTextTrack& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().cuechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSTextTrack_oncuechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrack>::set<setJSTextTrack_oncuechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsTextTrack_regionsGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrack& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<VTTRegionList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.regions())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrack_regions, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrack>::get<jsTextTrack_regionsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(MEDIA_SOURCE)
static inline JSValue jsTextTrack_sourceBufferGetter(JSGlobalObject& lexicalGlobalObject, JSTextTrack& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<SourceBuffer>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::TextTrackMediaSource::sourceBuffer(impl))));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextTrack_sourceBuffer, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextTrack>::get<jsTextTrack_sourceBufferGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSC::EncodedJSValue jsTextTrackPrototypeFunction_addCueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTextTrack>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto cue = convert<IDLInterface<TextTrackCue>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "cue", "TextTrack", "addCue", "TextTrackCue"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.addCue(*cue); })));
}

JSC_DEFINE_HOST_FUNCTION(jsTextTrackPrototypeFunction_addCue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTextTrack>::call<jsTextTrackPrototypeFunction_addCueBody>(*lexicalGlobalObject, *callFrame, "addCue");
}

static inline JSC::EncodedJSValue jsTextTrackPrototypeFunction_removeCueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTextTrack>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto cue = convert<IDLInterface<TextTrackCue>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "cue", "TextTrack", "removeCue", "TextTrackCue"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.removeCue(*cue); })));
}

JSC_DEFINE_HOST_FUNCTION(jsTextTrackPrototypeFunction_removeCue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTextTrack>::call<jsTextTrackPrototypeFunction_removeCueBody>(*lexicalGlobalObject, *callFrame, "removeCue");
}

static inline JSC::EncodedJSValue jsTextTrackPrototypeFunction_addRegionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTextTrack>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto region = convert<IDLInterface<VTTRegion>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "region", "TextTrack", "addRegion", "VTTRegion"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.addRegion(*region); })));
}

JSC_DEFINE_HOST_FUNCTION(jsTextTrackPrototypeFunction_addRegion, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTextTrack>::call<jsTextTrackPrototypeFunction_addRegionBody>(*lexicalGlobalObject, *callFrame, "addRegion");
}

static inline JSC::EncodedJSValue jsTextTrackPrototypeFunction_removeRegionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTextTrack>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto region = convert<IDLInterface<VTTRegion>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "region", "TextTrack", "removeRegion", "VTTRegion"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.removeRegion(*region); })));
}

JSC_DEFINE_HOST_FUNCTION(jsTextTrackPrototypeFunction_removeRegion, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTextTrack>::call<jsTextTrackPrototypeFunction_removeRegionBody>(*lexicalGlobalObject, *callFrame, "removeRegion");
}

JSC::GCClient::IsoSubspace* JSTextTrack::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSTextTrack, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForTextTrack.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForTextTrack = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForTextTrack.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForTextTrack = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSTextTrack::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSTextTrack*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    addWebCoreOpaqueRoot(visitor, thisObject->wrapped().opaqueRoot());
}

DEFINE_VISIT_CHILDREN(JSTextTrack);

void JSTextTrack::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTextTrack*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSTextTrackOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsTextTrack = jsCast<JSTextTrack*>(handle.slot()->asCell());
    auto& wrapped = jsTextTrack->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    auto& owner = jsTextTrack->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsTextTrack";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSTextTrackOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTextTrack = static_cast<JSTextTrack*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsTextTrack->wrapped(), jsTextTrack);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<TextTrack>&& impl)
{
    return createWrapper<TextTrack>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, TextTrack& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

TextTrack* JSTextTrack::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTextTrack*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
