/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPURequestAdapterOptions.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSGPUPowerPreference.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPURequestAdapterOptions convertDictionary<GPURequestAdapterOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPURequestAdapterOptions result;
    JSValue forceFallbackAdapterValue;
    if (isNullOrUndefined)
        forceFallbackAdapterValue = jsUndefined();
    else {
        forceFallbackAdapterValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "forceFallbackAdapter"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!forceFallbackAdapterValue.isUndefined()) {
        result.forceFallbackAdapter = convert<IDLBoolean>(lexicalGlobalObject, forceFallbackAdapterValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.forceFallbackAdapter = false;
    JSValue powerPreferenceValue;
    if (isNullOrUndefined)
        powerPreferenceValue = jsUndefined();
    else {
        powerPreferenceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "powerPreference"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!powerPreferenceValue.isUndefined()) {
        result.powerPreference = convert<IDLEnumeration<GPUPowerPreference>>(lexicalGlobalObject, powerPreferenceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

} // namespace WebCore
