/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDedicatedWorkerGlobalScope.h"

#include "ActiveDOMObject.h"
#include "DeprecatedGlobalSettings.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSAbortController.h"
#include "JSAbortSignal.h"
#include "JSByteLengthQueuingStrategy.h"
#include "JSCompressionStream.h"
#include "JSCompressionStreamEncoder.h"
#include "JSCountQueuingStrategy.h"
#include "JSCustomEvent.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMURL.h"
#include "JSDOMWrapperCache.h"
#include "JSDecompressionStream.h"
#include "JSDecompressionStreamDecoder.h"
#include "JSDedicatedWorkerGlobalScope.h"
#include "JSErrorEvent.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSEventTarget.h"
#include "JSFileReaderSync.h"
#include "JSFileSystemSyncAccessHandle.h"
#include "JSMediaCapabilities.h"
#include "JSPerformance.h"
#include "JSPerformanceEntry.h"
#include "JSPerformanceMark.h"
#include "JSPerformanceMeasure.h"
#include "JSPerformanceObserver.h"
#include "JSPerformanceObserverEntryList.h"
#include "JSPerformanceResourceTiming.h"
#include "JSPerformanceServerTiming.h"
#include "JSPermissionStatus.h"
#include "JSPromiseRejectionEvent.h"
#include "JSReadableByteStreamController.h"
#include "JSReadableStream.h"
#include "JSReadableStreamBYOBReader.h"
#include "JSReadableStreamBYOBRequest.h"
#include "JSReadableStreamDefaultController.h"
#include "JSReadableStreamDefaultReader.h"
#include "JSStructuredSerializeOptions.h"
#include "JSTextDecoder.h"
#include "JSTextDecoderStream.h"
#include "JSTextEncoder.h"
#include "JSTextEncoderStream.h"
#include "JSTransformStream.h"
#include "JSTransformStreamDefaultController.h"
#include "JSURLSearchParams.h"
#include "JSWorker.h"
#include "JSWritableStream.h"
#include "JSWritableStreamDefaultController.h"
#include "JSWritableStreamDefaultWriter.h"
#include "JSXMLHttpRequest.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/IteratorOperations.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(NOTIFICATIONS)
#include "JSNotification.h"
#endif

#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMGlobalObject.h"
#include "JSRequestAnimationFrameCallback.h"
#endif

#if ENABLE(WEB_CODECS)
#include "JSWebCodecsEncodedVideoChunk.h"
#include "JSWebCodecsVideoDecoder.h"
#include "JSWebCodecsVideoEncoder.h"
#include "JSWebCodecsVideoFrame.h"
#endif

#if ENABLE(WEB_RTC)
#include "JSRTCEncodedAudioFrame.h"
#include "JSRTCEncodedVideoFrame.h"
#include "JSRTCRtpSFrameTransform.h"
#include "JSRTCRtpSFrameTransformErrorEvent.h"
#include "JSRTCRtpScriptTransformer.h"
#endif


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage);
static JSC_DECLARE_HOST_FUNCTION(jsDedicatedWorkerGlobalScopeInstanceFunction_close);
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
static JSC_DECLARE_HOST_FUNCTION(jsDedicatedWorkerGlobalScopeInstanceFunction_requestAnimationFrame);
#endif
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
static JSC_DECLARE_HOST_FUNCTION(jsDedicatedWorkerGlobalScopeInstanceFunction_cancelAnimationFrame);
#endif

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScopeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_name);
static JSC_DECLARE_CUSTOM_SETTER(setJSDedicatedWorkerGlobalScope_name);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_onmessage);
static JSC_DECLARE_CUSTOM_SETTER(setJSDedicatedWorkerGlobalScope_onmessage);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_onmessageerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSDedicatedWorkerGlobalScope_onmessageerror);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_CompressionStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_CompressionStreamEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_DecompressionStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_DecompressionStreamDecoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_FileSystemSyncAccessHandleConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_MediaCapabilitiesConstructor);
#if ENABLE(WEB_RTC)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_RTCEncodedAudioFrameConstructor);
#endif
#if ENABLE(WEB_RTC)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_RTCEncodedVideoFrameConstructor);
#endif
#if ENABLE(WEB_RTC)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_SFrameTransformConstructor);
#endif
#if ENABLE(WEB_RTC)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_SFrameTransformErrorEventConstructor);
#endif
#if ENABLE(WEB_RTC)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_RTCRtpScriptTransformerConstructor);
#endif
#if ENABLE(NOTIFICATIONS)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_NotificationConstructor);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PermissionStatusConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ByteLengthQueuingStrategyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_CountQueuingStrategyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableByteStreamControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamBYOBReaderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamBYOBRequestConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamDefaultControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamDefaultReaderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TransformStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TransformStreamDefaultControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_WritableStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_WritableStreamDefaultControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_WritableStreamDefaultWriterConstructor);
#if ENABLE(WEB_CODECS)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_EncodedVideoChunkConstructor);
#endif
#if ENABLE(WEB_CODECS)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_VideoDecoderConstructor);
#endif
#if ENABLE(WEB_CODECS)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_VideoEncoderConstructor);
#endif
#if ENABLE(WEB_CODECS)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_VideoFrameConstructor);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_AbortControllerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_AbortSignalConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_CustomEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ErrorEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_EventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_EventTargetConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PromiseRejectionEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TextDecoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TextDecoderStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TextEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TextEncoderStreamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_FileReaderSyncConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_URLConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_URLSearchParamsConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceEntryConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceMarkConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceMeasureConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceObserverConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceObserverEntryListConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceResourceTimingConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceServerTimingConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_DedicatedWorkerGlobalScopeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_WorkerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_XMLHttpRequestConstructor);
#if ENABLE(WEB_RTC)
static JSC_DECLARE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_onrtctransform);
static JSC_DECLARE_CUSTOM_SETTER(setJSDedicatedWorkerGlobalScope_onrtctransform);
#endif

using JSDedicatedWorkerGlobalScopeDOMConstructor = JSDOMConstructorNotConstructable<JSDedicatedWorkerGlobalScope>;

/* Hash table */

static const struct CompactHashIndex JSDedicatedWorkerGlobalScopeTableIndex[132] = {
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 22, -1 },
    { -1, -1 },
    { -1, -1 },
    { 25, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 19, -1 },
    { 17, -1 },
    { -1, -1 },
    { 6, -1 },
    { 0, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 31, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 5, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 3, -1 },
    { 14, 129 },
    { 7, -1 },
    { -1, -1 },
    { 26, -1 },
    { -1, -1 },
    { 9, 128 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 12, -1 },
    { -1, -1 },
    { -1, -1 },
    { 11, -1 },
    { -1, -1 },
    { -1, -1 },
    { 27, -1 },
    { 30, -1 },
    { -1, -1 },
    { -1, -1 },
    { 8, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 16, -1 },
    { 1, 130 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 18, -1 },
    { -1, -1 },
    { 23, -1 },
    { 2, -1 },
    { -1, -1 },
    { 10, -1 },
    { -1, -1 },
    { 13, -1 },
    { -1, -1 },
    { 15, -1 },
    { -1, -1 },
    { 29, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 21, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 32, -1 },
    { -1, -1 },
    { 4, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 20, -1 },
    { 24, 131 },
    { 28, -1 },
    { 33, -1 },
};


static const HashTableValue JSDedicatedWorkerGlobalScopeTableValues[] =
{
    { "name"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_name, setJSDedicatedWorkerGlobalScope_name } },
    { "onmessage"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_onmessage, setJSDedicatedWorkerGlobalScope_onmessage } },
    { "onmessageerror"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_onmessageerror, setJSDedicatedWorkerGlobalScope_onmessageerror } },
    { "ByteLengthQueuingStrategy"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_ByteLengthQueuingStrategyConstructor, 0 } },
    { "CountQueuingStrategy"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_CountQueuingStrategyConstructor, 0 } },
    { "ReadableStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_ReadableStreamConstructor, 0 } },
    { "ReadableStreamDefaultController"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_ReadableStreamDefaultControllerConstructor, 0 } },
    { "ReadableStreamDefaultReader"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_ReadableStreamDefaultReaderConstructor, 0 } },
    { "WritableStream"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_WritableStreamConstructor, 0 } },
    { "WritableStreamDefaultController"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_WritableStreamDefaultControllerConstructor, 0 } },
    { "WritableStreamDefaultWriter"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_WritableStreamDefaultWriterConstructor, 0 } },
    { "AbortController"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_AbortControllerConstructor, 0 } },
    { "AbortSignal"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_AbortSignalConstructor, 0 } },
    { "CustomEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_CustomEventConstructor, 0 } },
    { "ErrorEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_ErrorEventConstructor, 0 } },
    { "Event"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_EventConstructor, 0 } },
    { "EventTarget"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_EventTargetConstructor, 0 } },
    { "PromiseRejectionEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_PromiseRejectionEventConstructor, 0 } },
    { "TextDecoder"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_TextDecoderConstructor, 0 } },
    { "TextEncoder"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_TextEncoderConstructor, 0 } },
    { "URL"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_URLConstructor, 0 } },
    { "URLSearchParams"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_URLSearchParamsConstructor, 0 } },
    { "Performance"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_PerformanceConstructor, 0 } },
    { "PerformanceEntry"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_PerformanceEntryConstructor, 0 } },
    { "PerformanceMark"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_PerformanceMarkConstructor, 0 } },
    { "PerformanceMeasure"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_PerformanceMeasureConstructor, 0 } },
    { "PerformanceObserver"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_PerformanceObserverConstructor, 0 } },
    { "PerformanceObserverEntryList"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_PerformanceObserverEntryListConstructor, 0 } },
    { "PerformanceResourceTiming"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_PerformanceResourceTimingConstructor, 0 } },
    { "DedicatedWorkerGlobalScope"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_DedicatedWorkerGlobalScopeConstructor, 0 } },
    { "Worker"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_WorkerConstructor, 0 } },
    { "XMLHttpRequest"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScope_XMLHttpRequestConstructor, 0 } },
    { "postMessage"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage, 1 } },
    { "close"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDedicatedWorkerGlobalScopeInstanceFunction_close, 0 } },
};

static const HashTable JSDedicatedWorkerGlobalScopeTable = { 34, 127, static_cast<uint8_t>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::Function), JSDedicatedWorkerGlobalScope::info(), JSDedicatedWorkerGlobalScopeTableValues, JSDedicatedWorkerGlobalScopeTableIndex };
template<> const ClassInfo JSDedicatedWorkerGlobalScopeDOMConstructor::s_info = { "DedicatedWorkerGlobalScope"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDedicatedWorkerGlobalScopeDOMConstructor) };

template<> JSValue JSDedicatedWorkerGlobalScopeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSWorkerGlobalScope::getConstructor(vm, &globalObject);
}

template<> void JSDedicatedWorkerGlobalScopeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "DedicatedWorkerGlobalScope"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, globalObject.getPrototypeDirect(), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const struct CompactHashIndex JSDedicatedWorkerGlobalScopePrototypeTableIndex[2] = {
    { -1, -1 },
    { 0, -1 },
};


static const HashTableValue JSDedicatedWorkerGlobalScopePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDedicatedWorkerGlobalScopeConstructor, 0 } },
};

static const HashTable JSDedicatedWorkerGlobalScopePrototypeTable = { 1, 1, static_cast<uint8_t>(static_cast<unsigned>(PropertyAttribute::DontEnum)), JSDedicatedWorkerGlobalScope::info(), JSDedicatedWorkerGlobalScopePrototypeTableValues, JSDedicatedWorkerGlobalScopePrototypeTableIndex };
const ClassInfo JSDedicatedWorkerGlobalScopePrototype::s_info = { "DedicatedWorkerGlobalScope"_s, &Base::s_info, &JSDedicatedWorkerGlobalScopePrototypeTable, nullptr, CREATE_METHOD_TABLE(JSDedicatedWorkerGlobalScopePrototype) };

void JSDedicatedWorkerGlobalScopePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDedicatedWorkerGlobalScope::s_info = { "DedicatedWorkerGlobalScope"_s, &Base::s_info, &JSDedicatedWorkerGlobalScopeTable, nullptr, CREATE_METHOD_TABLE(JSDedicatedWorkerGlobalScope) };

JSDedicatedWorkerGlobalScope::JSDedicatedWorkerGlobalScope(VM& vm, Structure* structure, Ref<DedicatedWorkerGlobalScope>&& impl)
    : JSWorkerGlobalScope(vm, structure, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, DedicatedWorkerGlobalScope>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

void JSDedicatedWorkerGlobalScope::finishCreation(VM& vm, JSGlobalProxy* proxy)
{
    Base::finishCreation(vm, proxy);

    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CompressionStreamPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_CompressionStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).CompressionStreamEncoderPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_CompressionStreamEncoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).DecompressionStreamPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_DecompressionStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().compressionStreamEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).DecompressionStreamDecoderPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_DecompressionStreamDecoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().accessHandleEnabled))
        putDirectCustomAccessor(vm, builtinNames(vm).FileSystemSyncAccessHandlePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_FileSystemSyncAccessHandleConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().mediaCapabilitiesEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).MediaCapabilitiesPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_MediaCapabilitiesConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#if ENABLE(WEB_RTC)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webRTCEncodedTransformEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).RTCEncodedAudioFramePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_RTCEncodedAudioFrameConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webRTCEncodedTransformEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).RTCEncodedVideoFramePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_RTCEncodedVideoFrameConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webRTCSFrameTransformEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).SFrameTransformPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_SFrameTransformConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webRTCSFrameTransformEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).SFrameTransformErrorEventPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_SFrameTransformErrorEventConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webRTCEncodedTransformEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).RTCRtpScriptTransformerPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_RTCRtpScriptTransformerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(NOTIFICATIONS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().notificationsEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).NotificationPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_NotificationConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().permissionsAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).PermissionStatusPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_PermissionStatusConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().transformStreamAPIEnabled) {
        putDirectCustomAccessor(vm, builtinNames(vm).TransformStreamPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_TransformStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
        putDirectCustomAccessor(vm, builtinNames(vm).TransformStreamPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_TransformStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    }
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().transformStreamAPIEnabled) {
        putDirectCustomAccessor(vm, builtinNames(vm).TransformStreamDefaultControllerPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_TransformStreamDefaultControllerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
        putDirectCustomAccessor(vm, builtinNames(vm).TransformStreamDefaultControllerPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_TransformStreamDefaultControllerConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    }
#if ENABLE(WEB_CODECS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webCodecsEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).EncodedVideoChunkPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_EncodedVideoChunkConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_CODECS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webCodecsEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).VideoDecoderPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_VideoDecoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_CODECS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webCodecsEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).VideoEncoderPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_VideoEncoderConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_CODECS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webCodecsEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).VideoFramePublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_VideoFrameConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().transformStreamAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).TextDecoderStreamPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_TextDecoderStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().transformStreamAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).TextEncoderStreamPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_TextEncoderStreamConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().fileReaderAPIEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).FileReaderSyncPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_FileReaderSyncConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (DeprecatedGlobalSettings::serverTimingEnabled())
        putDirectCustomAccessor(vm, builtinNames(vm).PerformanceServerTimingPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_PerformanceServerTimingConstructor, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#if ENABLE(WEB_RTC)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webRTCEncodedTransformEnabled)
        putDirectCustomAccessor(vm, builtinNames(vm).onrtctransformPublicName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_onrtctransform, setJSDedicatedWorkerGlobalScope_onrtctransform), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor)));
#endif
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableByteStreamControllerPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_ReadableByteStreamControllerConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_ReadableStreamConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamBYOBReaderPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_ReadableStreamBYOBReaderConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamBYOBRequestPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_ReadableStreamBYOBRequestConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamDefaultControllerPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_ReadableStreamDefaultControllerConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).ReadableStreamDefaultReaderPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_ReadableStreamDefaultReaderConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).WritableStreamPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_WritableStreamConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).WritableStreamDefaultControllerPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_WritableStreamDefaultControllerConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).WritableStreamDefaultWriterPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_WritableStreamDefaultWriterConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
    putDirectCustomAccessor(vm, builtinNames(vm).AbortSignalPrivateName(), CustomGetterSetter::create(vm, jsDedicatedWorkerGlobalScope_AbortSignalConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().offscreenCanvasInWorkersEnabled)
        putDirectNativeFunction(vm, this, builtinNames(vm).requestAnimationFramePublicName(), 1, jsDedicatedWorkerGlobalScopeInstanceFunction_requestAnimationFrame, ImplementationVisibility::Public, NoIntrinsic, attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::Function)));
#endif
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().offscreenCanvasInWorkersEnabled)
        putDirectNativeFunction(vm, this, builtinNames(vm).cancelAnimationFramePublicName(), 1, jsDedicatedWorkerGlobalScopeInstanceFunction_cancelAnimationFrame, ImplementationVisibility::Public, NoIntrinsic, attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::Function)));
#endif
}

JSValue JSDedicatedWorkerGlobalScope::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDedicatedWorkerGlobalScopeDOMConstructor, DOMConstructorID::DedicatedWorkerGlobalScope>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScopeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDedicatedWorkerGlobalScopePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDedicatedWorkerGlobalScope::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsDedicatedWorkerGlobalScope_nameGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.name())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_nameGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDedicatedWorkerGlobalScope_nameSetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject, JSValue value, PropertyName propertyName)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    bool shouldThrow = true;
    thisObject.createDataProperty(&lexicalGlobalObject, propertyName, value, shouldThrow);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDedicatedWorkerGlobalScope_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::setPassingPropertyName<setJSDedicatedWorkerGlobalScope_nameSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_onmessageGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().messageEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_onmessage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_onmessageGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDedicatedWorkerGlobalScope_onmessageSetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().messageEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDedicatedWorkerGlobalScope_onmessage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::set<setJSDedicatedWorkerGlobalScope_onmessageSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_onmessageerrorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().messageerrorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_onmessageerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_onmessageerrorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDedicatedWorkerGlobalScope_onmessageerrorSetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().messageerrorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDedicatedWorkerGlobalScope_onmessageerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::set<setJSDedicatedWorkerGlobalScope_onmessageerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_CompressionStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCompressionStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_CompressionStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_CompressionStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_CompressionStreamEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCompressionStreamEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_CompressionStreamEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_CompressionStreamEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_DecompressionStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDecompressionStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_DecompressionStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_DecompressionStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_DecompressionStreamDecoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDecompressionStreamDecoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_DecompressionStreamDecoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_DecompressionStreamDecoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_FileSystemSyncAccessHandleConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSFileSystemSyncAccessHandle::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_FileSystemSyncAccessHandleConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_FileSystemSyncAccessHandleConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_MediaCapabilitiesConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSMediaCapabilities::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_MediaCapabilitiesConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_MediaCapabilitiesConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(WEB_RTC)
static inline JSValue jsDedicatedWorkerGlobalScope_RTCEncodedAudioFrameConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSRTCEncodedAudioFrame::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_RTCEncodedAudioFrameConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_RTCEncodedAudioFrameConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDedicatedWorkerGlobalScope_RTCEncodedVideoFrameConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSRTCEncodedVideoFrame::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_RTCEncodedVideoFrameConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_RTCEncodedVideoFrameConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDedicatedWorkerGlobalScope_SFrameTransformConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSRTCRtpSFrameTransform::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_SFrameTransformConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_SFrameTransformConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDedicatedWorkerGlobalScope_SFrameTransformErrorEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSRTCRtpSFrameTransformErrorEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_SFrameTransformErrorEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_SFrameTransformErrorEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDedicatedWorkerGlobalScope_RTCRtpScriptTransformerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSRTCRtpScriptTransformer::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_RTCRtpScriptTransformerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_RTCRtpScriptTransformerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(NOTIFICATIONS)
static inline JSValue jsDedicatedWorkerGlobalScope_NotificationConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSNotification::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_NotificationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_NotificationConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsDedicatedWorkerGlobalScope_PermissionStatusConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPermissionStatus::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PermissionStatusConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PermissionStatusConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_ByteLengthQueuingStrategyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSByteLengthQueuingStrategy::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ByteLengthQueuingStrategyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_ByteLengthQueuingStrategyConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_CountQueuingStrategyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCountQueuingStrategy::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_CountQueuingStrategyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_CountQueuingStrategyConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_ReadableByteStreamControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableByteStreamController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableByteStreamControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_ReadableByteStreamControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_ReadableStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_ReadableStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_ReadableStreamBYOBReaderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamBYOBReader::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamBYOBReaderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_ReadableStreamBYOBReaderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_ReadableStreamBYOBRequestConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamBYOBRequest::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamBYOBRequestConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_ReadableStreamBYOBRequestConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_ReadableStreamDefaultControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamDefaultController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamDefaultControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_ReadableStreamDefaultControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_ReadableStreamDefaultReaderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSReadableStreamDefaultReader::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ReadableStreamDefaultReaderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_ReadableStreamDefaultReaderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_TransformStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTransformStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TransformStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_TransformStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_TransformStreamDefaultControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTransformStreamDefaultController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TransformStreamDefaultControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_TransformStreamDefaultControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_WritableStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWritableStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_WritableStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_WritableStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_WritableStreamDefaultControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWritableStreamDefaultController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_WritableStreamDefaultControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_WritableStreamDefaultControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_WritableStreamDefaultWriterConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWritableStreamDefaultWriter::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_WritableStreamDefaultWriterConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_WritableStreamDefaultWriterConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(WEB_CODECS)
static inline JSValue jsDedicatedWorkerGlobalScope_EncodedVideoChunkConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebCodecsEncodedVideoChunk::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_EncodedVideoChunkConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_EncodedVideoChunkConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_CODECS)
static inline JSValue jsDedicatedWorkerGlobalScope_VideoDecoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebCodecsVideoDecoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_VideoDecoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_VideoDecoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_CODECS)
static inline JSValue jsDedicatedWorkerGlobalScope_VideoEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebCodecsVideoEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_VideoEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_VideoEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_CODECS)
static inline JSValue jsDedicatedWorkerGlobalScope_VideoFrameConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWebCodecsVideoFrame::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_VideoFrameConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_VideoFrameConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsDedicatedWorkerGlobalScope_AbortControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSAbortController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_AbortControllerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_AbortControllerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_AbortSignalConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSAbortSignal::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_AbortSignalConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_AbortSignalConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_CustomEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCustomEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_CustomEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_CustomEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_ErrorEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSErrorEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_ErrorEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_ErrorEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_EventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_EventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_EventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_EventTargetConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSEventTarget::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_EventTargetConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_EventTargetConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_PromiseRejectionEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPromiseRejectionEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PromiseRejectionEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PromiseRejectionEventConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_TextDecoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextDecoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TextDecoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_TextDecoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_TextDecoderStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextDecoderStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TextDecoderStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_TextDecoderStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_TextEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TextEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_TextEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_TextEncoderStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTextEncoderStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_TextEncoderStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_TextEncoderStreamConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_FileReaderSyncConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSFileReaderSync::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_FileReaderSyncConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_FileReaderSyncConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_URLConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDOMURL::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_URLConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_URLConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_URLSearchParamsConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSURLSearchParams::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_URLSearchParamsConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_URLSearchParamsConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_PerformanceConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformance::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PerformanceConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_PerformanceEntryConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceEntry::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceEntryConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PerformanceEntryConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_PerformanceMarkConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceMark::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceMarkConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PerformanceMarkConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_PerformanceMeasureConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceMeasure::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceMeasureConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PerformanceMeasureConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_PerformanceObserverConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceObserver::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceObserverConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PerformanceObserverConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_PerformanceObserverEntryListConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceObserverEntryList::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceObserverEntryListConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PerformanceObserverEntryListConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_PerformanceResourceTimingConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceResourceTiming::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceResourceTimingConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PerformanceResourceTimingConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_PerformanceServerTimingConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPerformanceServerTiming::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_PerformanceServerTimingConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_PerformanceServerTimingConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_DedicatedWorkerGlobalScopeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSDedicatedWorkerGlobalScope::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_DedicatedWorkerGlobalScopeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_DedicatedWorkerGlobalScopeConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_WorkerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSWorker::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_WorkerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_WorkerConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDedicatedWorkerGlobalScope_XMLHttpRequestConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return JSXMLHttpRequest::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_XMLHttpRequestConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_XMLHttpRequestConstructorGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(WEB_RTC)
static inline JSValue jsDedicatedWorkerGlobalScope_onrtctransformGetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().rtctransformEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDedicatedWorkerGlobalScope_onrtctransform, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::get<jsDedicatedWorkerGlobalScope_onrtctransformGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WEB_RTC)
static inline bool setJSDedicatedWorkerGlobalScope_onrtctransformSetter(JSGlobalObject& lexicalGlobalObject, JSDedicatedWorkerGlobalScope& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().rtctransformEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDedicatedWorkerGlobalScope_onrtctransform, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDedicatedWorkerGlobalScope>::set<setJSDedicatedWorkerGlobalScope_onrtctransformSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

static inline JSC::EncodedJSValue jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDedicatedWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto message = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto transfer = convert<IDLSequence<IDLObject>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.postMessage(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(message), WTFMove(transfer)); })));
}

static inline JSC::EncodedJSValue jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDedicatedWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto message = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = convert<IDLDictionary<StructuredSerializeOptions>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.postMessage(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(message), WTFMove(options)); })));
}

static inline JSC::EncodedJSValue jsDedicatedWorkerGlobalScopeInstanceFunction_postMessageOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDedicatedWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 1) {
        RELEASE_AND_RETURN(throwScope, (jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(1);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage2Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage2Body(lexicalGlobalObject, callFrame, castedThis)));
        {
            bool success = hasIteratorMethod(lexicalGlobalObject, distinguishingArg);
            RETURN_IF_EXCEPTION(throwScope, { });
            if (success)
                RELEASE_AND_RETURN(throwScope, (jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage1Body(lexicalGlobalObject, callFrame, castedThis)));
        }
        if (distinguishingArg.isObject())
            RELEASE_AND_RETURN(throwScope, (jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsDedicatedWorkerGlobalScopeInstanceFunction_postMessage, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDedicatedWorkerGlobalScope>::call<jsDedicatedWorkerGlobalScopeInstanceFunction_postMessageOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "postMessage");
}

static inline JSC::EncodedJSValue jsDedicatedWorkerGlobalScopeInstanceFunction_closeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDedicatedWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.close(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDedicatedWorkerGlobalScopeInstanceFunction_close, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDedicatedWorkerGlobalScope>::call<jsDedicatedWorkerGlobalScopeInstanceFunction_closeBody>(*lexicalGlobalObject, *callFrame, "close");
}

#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
static inline JSC::EncodedJSValue jsDedicatedWorkerGlobalScopeInstanceFunction_requestAnimationFrameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDedicatedWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto callback = convert<IDLCallbackFunction<JSRequestAnimationFrameCallback>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback", "DedicatedWorkerGlobalScope", "requestAnimationFrame"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.requestAnimationFrame(callback.releaseNonNull()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDedicatedWorkerGlobalScopeInstanceFunction_requestAnimationFrame, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDedicatedWorkerGlobalScope>::call<jsDedicatedWorkerGlobalScopeInstanceFunction_requestAnimationFrameBody>(*lexicalGlobalObject, *callFrame, "requestAnimationFrame");
}

#endif

#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
static inline JSC::EncodedJSValue jsDedicatedWorkerGlobalScopeInstanceFunction_cancelAnimationFrameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDedicatedWorkerGlobalScope>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto handle = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.cancelAnimationFrame(WTFMove(handle)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDedicatedWorkerGlobalScopeInstanceFunction_cancelAnimationFrame, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDedicatedWorkerGlobalScope>::call<jsDedicatedWorkerGlobalScopeInstanceFunction_cancelAnimationFrameBody>(*lexicalGlobalObject, *callFrame, "cancelAnimationFrame");
}

#endif

JSC::GCClient::IsoSubspace* JSDedicatedWorkerGlobalScope::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDedicatedWorkerGlobalScope, UseCustomHeapCellType::Yes>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDedicatedWorkerGlobalScope.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDedicatedWorkerGlobalScope = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDedicatedWorkerGlobalScope.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDedicatedWorkerGlobalScope = std::forward<decltype(space)>(space); },
        [] (auto& server) -> JSC::HeapCellType& { return server.m_heapCellTypeForJSDedicatedWorkerGlobalScope; }
    );
}

void JSDedicatedWorkerGlobalScope::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDedicatedWorkerGlobalScope*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

DedicatedWorkerGlobalScope* JSDedicatedWorkerGlobalScope::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDedicatedWorkerGlobalScope*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
