/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSClipboardItem.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSBlob.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "Navigator.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include "WorkerNavigator.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>
#include <wtf/Vector.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(ClipboardItem::PresentationStyle enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("unspecified"),
        MAKE_STATIC_STRING_IMPL("inline"),
        MAKE_STATIC_STRING_IMPL("attachment"),
    };
    static_assert(static_cast<size_t>(ClipboardItem::PresentationStyle::Unspecified) == 0, "ClipboardItem::PresentationStyle::Unspecified is not 0 as expected");
    static_assert(static_cast<size_t>(ClipboardItem::PresentationStyle::Inline) == 1, "ClipboardItem::PresentationStyle::Inline is not 1 as expected");
    static_assert(static_cast<size_t>(ClipboardItem::PresentationStyle::Attachment) == 2, "ClipboardItem::PresentationStyle::Attachment is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, ClipboardItem::PresentationStyle enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<ClipboardItem::PresentationStyle> parseEnumerationFromString<ClipboardItem::PresentationStyle>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, ClipboardItem::PresentationStyle> mappings[] = {
        { "attachment", ClipboardItem::PresentationStyle::Attachment },
        { "inline", ClipboardItem::PresentationStyle::Inline },
        { "unspecified", ClipboardItem::PresentationStyle::Unspecified },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<ClipboardItem::PresentationStyle> parseEnumeration<ClipboardItem::PresentationStyle>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<ClipboardItem::PresentationStyle>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<ClipboardItem::PresentationStyle>()
{
    return "\"unspecified\", \"inline\", \"attachment\"";
}

template<> ClipboardItem::Options convertDictionary<ClipboardItem::Options>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    ClipboardItem::Options result;
    JSValue presentationStyleValue;
    if (isNullOrUndefined)
        presentationStyleValue = jsUndefined();
    else {
        presentationStyleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "presentationStyle"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!presentationStyleValue.isUndefined()) {
        result.presentationStyle = convert<IDLEnumeration<ClipboardItem::PresentationStyle>>(lexicalGlobalObject, presentationStyleValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.presentationStyle = ClipboardItem::PresentationStyle::Unspecified;
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsClipboardItemPrototypeFunction_getType);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsClipboardItemConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsClipboardItem_types);
static JSC_DECLARE_CUSTOM_GETTER(jsClipboardItem_presentationStyle);

class JSClipboardItemPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSClipboardItemPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSClipboardItemPrototype* ptr = new (NotNull, JSC::allocateCell<JSClipboardItemPrototype>(vm)) JSClipboardItemPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSClipboardItemPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSClipboardItemPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSClipboardItemPrototype, JSClipboardItemPrototype::Base);

using JSClipboardItemDOMConstructor = JSDOMConstructor<JSClipboardItem>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSClipboardItemDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSClipboardItemDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto items = convert<IDLRecord<IDLDOMString, IDLPromise<IDLUnion<IDLDOMString, IDLInterface<Blob>>>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = convert<IDLDictionary<ClipboardItem::Options>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = ClipboardItem::create(WTFMove(items), WTFMove(options));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<ClipboardItem>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<ClipboardItem>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSClipboardItemDOMConstructorConstruct, JSClipboardItemDOMConstructor::construct);

template<> const ClassInfo JSClipboardItemDOMConstructor::s_info = { "ClipboardItem"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSClipboardItemDOMConstructor) };

template<> JSValue JSClipboardItemDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSClipboardItemDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ClipboardItem"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSClipboardItem::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSClipboardItemPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsClipboardItemConstructor, 0 } },
    { "types"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsClipboardItem_types, 0 } },
    { "presentationStyle"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsClipboardItem_presentationStyle, 0 } },
    { "getType"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsClipboardItemPrototypeFunction_getType, 1 } },
};

const ClassInfo JSClipboardItemPrototype::s_info = { "ClipboardItem"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSClipboardItemPrototype) };

void JSClipboardItemPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSClipboardItem::info(), JSClipboardItemPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSClipboardItem::s_info = { "ClipboardItem"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSClipboardItem) };

JSClipboardItem::JSClipboardItem(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ClipboardItem>&& impl)
    : JSDOMWrapper<ClipboardItem>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, ClipboardItem>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSClipboardItem::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSClipboardItemPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSClipboardItemPrototype::create(vm, &globalObject, structure);
}

JSObject* JSClipboardItem::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSClipboardItem>(vm, globalObject);
}

JSValue JSClipboardItem::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSClipboardItemDOMConstructor, DOMConstructorID::ClipboardItem>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSClipboardItem::destroy(JSC::JSCell* cell)
{
    JSClipboardItem* thisObject = static_cast<JSClipboardItem*>(cell);
    thisObject->JSClipboardItem::~JSClipboardItem();
}

JSC_DEFINE_CUSTOM_GETTER(jsClipboardItemConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSClipboardItemPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSClipboardItem::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsClipboardItem_typesGetter(JSGlobalObject& lexicalGlobalObject, JSClipboardItem& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFrozenArray<IDLDOMString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.types())));
}

JSC_DEFINE_CUSTOM_GETTER(jsClipboardItem_types, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSClipboardItem>::get<jsClipboardItem_typesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsClipboardItem_presentationStyleGetter(JSGlobalObject& lexicalGlobalObject, JSClipboardItem& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<ClipboardItem::PresentationStyle>>(lexicalGlobalObject, throwScope, impl.presentationStyle())));
}

JSC_DEFINE_CUSTOM_GETTER(jsClipboardItem_presentationStyle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSClipboardItem>::get<jsClipboardItem_presentationStyleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsClipboardItemPrototypeFunction_getTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSClipboardItem>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLInterface<Blob>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getType(WTFMove(type), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsClipboardItemPrototypeFunction_getType, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSClipboardItem>::call<jsClipboardItemPrototypeFunction_getTypeBody>(*lexicalGlobalObject, *callFrame, "getType");
}

JSC::GCClient::IsoSubspace* JSClipboardItem::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSClipboardItem, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForClipboardItem.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForClipboardItem = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForClipboardItem.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForClipboardItem = std::forward<decltype(space)>(space); }
    );
}

void JSClipboardItem::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSClipboardItem*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSClipboardItemOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsClipboardItem = jsCast<JSClipboardItem*>(handle.slot()->asCell());
    NavigatorBase* owner = WTF::getPtr(jsClipboardItem->wrapped().navigator());
    if (!owner)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from Navigator";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSClipboardItemOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsClipboardItem = static_cast<JSClipboardItem*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsClipboardItem->wrapped(), jsClipboardItem);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ClipboardItem@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13ClipboardItemE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ClipboardItem>&& impl)
{

    if constexpr (std::is_polymorphic_v<ClipboardItem>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ClipboardItem@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore13ClipboardItemE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ClipboardItem has subclasses. If ClipboardItem has subclasses that get passed
        // to toJS() we currently require ClipboardItem you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<ClipboardItem>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ClipboardItem& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ClipboardItem* JSClipboardItem::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSClipboardItem*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
