/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSChannelSplitterNode.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSBaseAudioContext.h"
#include "JSChannelSplitterOptions.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsChannelSplitterNodeConstructor);

class JSChannelSplitterNodePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSChannelSplitterNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSChannelSplitterNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSChannelSplitterNodePrototype>(vm)) JSChannelSplitterNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSChannelSplitterNodePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSChannelSplitterNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSChannelSplitterNodePrototype, JSChannelSplitterNodePrototype::Base);

using JSChannelSplitterNodeDOMConstructor = JSDOMConstructor<JSChannelSplitterNode>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSChannelSplitterNodeDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSChannelSplitterNodeDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())->settingsValues().webAudioEnabled) {
        throwTypeError(lexicalGlobalObject, throwScope, "Illegal constructor"_s);
        return JSValue::encode(jsNull());
    }
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto context = convert<IDLInterface<BaseAudioContext>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "context", "ChannelSplitterNode", nullptr, "BaseAudioContext"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = convert<IDLDictionary<ChannelSplitterOptions>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = ChannelSplitterNode::create(*context, WTFMove(options));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<ChannelSplitterNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<ChannelSplitterNode>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSChannelSplitterNodeDOMConstructorConstruct, JSChannelSplitterNodeDOMConstructor::construct);

template<> const ClassInfo JSChannelSplitterNodeDOMConstructor::s_info = { "ChannelSplitterNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSChannelSplitterNodeDOMConstructor) };

template<> JSValue JSChannelSplitterNodeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSChannelSplitterNodeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ChannelSplitterNode"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSChannelSplitterNode::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSChannelSplitterNodePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsChannelSplitterNodeConstructor, 0 } },
};

const ClassInfo JSChannelSplitterNodePrototype::s_info = { "ChannelSplitterNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSChannelSplitterNodePrototype) };

void JSChannelSplitterNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSChannelSplitterNode::info(), JSChannelSplitterNodePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSChannelSplitterNode::s_info = { "ChannelSplitterNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSChannelSplitterNode) };

JSChannelSplitterNode::JSChannelSplitterNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ChannelSplitterNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, ChannelSplitterNode>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSChannelSplitterNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSChannelSplitterNodePrototype::createStructure(vm, &globalObject, JSAudioNode::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSChannelSplitterNodePrototype::create(vm, &globalObject, structure);
}

JSObject* JSChannelSplitterNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSChannelSplitterNode>(vm, globalObject);
}

JSValue JSChannelSplitterNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSChannelSplitterNodeDOMConstructor, DOMConstructorID::ChannelSplitterNode>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsChannelSplitterNodeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSChannelSplitterNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSChannelSplitterNode::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSChannelSplitterNode::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSChannelSplitterNode, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForChannelSplitterNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForChannelSplitterNode = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForChannelSplitterNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForChannelSplitterNode = std::forward<decltype(space)>(space); }
    );
}

void JSChannelSplitterNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSChannelSplitterNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ChannelSplitterNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19ChannelSplitterNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ChannelSplitterNode>&& impl)
{

    if constexpr (std::is_polymorphic_v<ChannelSplitterNode>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ChannelSplitterNode@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore19ChannelSplitterNodeE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ChannelSplitterNode has subclasses. If ChannelSplitterNode has subclasses that get passed
        // to toJS() we currently require ChannelSplitterNode you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<ChannelSplitterNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ChannelSplitterNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
