/*
 * THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 * This file was generated by the dom/make_names.pl script.
 *
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2013 Apple Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "TagName.h"

#include "HTMLNames.h"
#include "MathMLNames.h"
#include "SVGNames.h"
#include "XLinkNames.h"
#include "XMLNames.h"
#include "XMLNSNames.h"

namespace WebCore {

static constexpr void* tagQualifiedNamePointers[] = {
    &HTMLNames::abbrTag,
    &HTMLNames::acronymTag,
    &HTMLNames::addressTag,
    &HTMLNames::appletTag,
    &HTMLNames::areaTag,
    &HTMLNames::articleTag,
    &HTMLNames::asideTag,
    &HTMLNames::attachmentTag,
    &HTMLNames::audioTag,
    &HTMLNames::bTag,
    &HTMLNames::baseTag,
    &HTMLNames::basefontTag,
    &HTMLNames::bdiTag,
    &HTMLNames::bdoTag,
    &HTMLNames::bgsoundTag,
    &HTMLNames::bigTag,
    &HTMLNames::blockquoteTag,
    &HTMLNames::bodyTag,
    &HTMLNames::brTag,
    &HTMLNames::buttonTag,
    &HTMLNames::canvasTag,
    &HTMLNames::captionTag,
    &HTMLNames::centerTag,
    &HTMLNames::citeTag,
    &HTMLNames::codeTag,
    &HTMLNames::colTag,
    &HTMLNames::colgroupTag,
    &HTMLNames::dataTag,
    &HTMLNames::datalistTag,
    &HTMLNames::ddTag,
    &HTMLNames::delTag,
    &HTMLNames::detailsTag,
    &HTMLNames::dfnTag,
    &HTMLNames::dialogTag,
    &HTMLNames::dirTag,
    &HTMLNames::divTag,
    &HTMLNames::dlTag,
    &HTMLNames::dtTag,
    &HTMLNames::emTag,
    &HTMLNames::embedTag,
    &HTMLNames::fieldsetTag,
    &HTMLNames::figcaptionTag,
    &HTMLNames::figureTag,
    &HTMLNames::footerTag,
    &HTMLNames::formTag,
    &HTMLNames::frameTag,
    &HTMLNames::framesetTag,
    &HTMLNames::h1Tag,
    &HTMLNames::h2Tag,
    &HTMLNames::h3Tag,
    &HTMLNames::h4Tag,
    &HTMLNames::h5Tag,
    &HTMLNames::h6Tag,
    &HTMLNames::headTag,
    &HTMLNames::headerTag,
    &HTMLNames::hgroupTag,
    &HTMLNames::hrTag,
    &HTMLNames::htmlTag,
    &HTMLNames::iTag,
    &HTMLNames::iframeTag,
    &HTMLNames::imgTag,
    &HTMLNames::inputTag,
    &HTMLNames::insTag,
    &HTMLNames::kbdTag,
    &HTMLNames::keygenTag,
    &HTMLNames::labelTag,
    &HTMLNames::legendTag,
    &HTMLNames::liTag,
    &HTMLNames::linkTag,
    &HTMLNames::listingTag,
    &HTMLNames::mainTag,
    &HTMLNames::mapTag,
    &HTMLNames::markTag,
    &HTMLNames::marqueeTag,
    &HTMLNames::menuTag,
    &HTMLNames::menuitemTag,
    &HTMLNames::metaTag,
    &HTMLNames::meterTag,
    &HTMLNames::modelTag,
    &HTMLNames::navTag,
    &HTMLNames::nobrTag,
    &HTMLNames::noembedTag,
    &HTMLNames::noframesTag,
    &HTMLNames::noscriptTag,
    &HTMLNames::objectTag,
    &HTMLNames::olTag,
    &HTMLNames::optgroupTag,
    &HTMLNames::optionTag,
    &HTMLNames::outputTag,
    &HTMLNames::pTag,
    &HTMLNames::paramTag,
    &HTMLNames::pictureTag,
    &HTMLNames::plaintextTag,
    &HTMLNames::preTag,
    &HTMLNames::progressTag,
    &HTMLNames::qTag,
    &HTMLNames::rbTag,
    &HTMLNames::rpTag,
    &HTMLNames::rtTag,
    &HTMLNames::rtcTag,
    &HTMLNames::rubyTag,
    &HTMLNames::sTag,
    &HTMLNames::sampTag,
    &HTMLNames::searchTag,
    &HTMLNames::sectionTag,
    &HTMLNames::selectTag,
    &HTMLNames::slotTag,
    &HTMLNames::smallTag,
    &HTMLNames::sourceTag,
    &HTMLNames::spanTag,
    &HTMLNames::strikeTag,
    &HTMLNames::strongTag,
    &HTMLNames::subTag,
    &HTMLNames::summaryTag,
    &HTMLNames::supTag,
    &HTMLNames::tableTag,
    &HTMLNames::tbodyTag,
    &HTMLNames::tdTag,
    &HTMLNames::templateTag,
    &HTMLNames::textareaTag,
    &HTMLNames::tfootTag,
    &HTMLNames::thTag,
    &HTMLNames::theadTag,
    &HTMLNames::timeTag,
    &HTMLNames::trTag,
    &HTMLNames::trackTag,
    &HTMLNames::ttTag,
    &HTMLNames::uTag,
    &HTMLNames::ulTag,
    &HTMLNames::varTag,
    &HTMLNames::videoTag,
    &HTMLNames::wbrTag,
    &HTMLNames::xmpTag,
    &MathMLNames::annotationTag,
    &MathMLNames::annotation_xmlTag,
    &MathMLNames::mactionTag,
    &MathMLNames::maligngroupTag,
    &MathMLNames::malignmarkTag,
    &MathMLNames::mathTag,
    &MathMLNames::mencloseTag,
    &MathMLNames::merrorTag,
    &MathMLNames::mfencedTag,
    &MathMLNames::mfracTag,
    &MathMLNames::mglyphTag,
    &MathMLNames::miTag,
    &MathMLNames::mlabeledtrTag,
    &MathMLNames::mlongdivTag,
    &MathMLNames::mmultiscriptsTag,
    &MathMLNames::mnTag,
    &MathMLNames::moTag,
    &MathMLNames::moverTag,
    &MathMLNames::mpaddedTag,
    &MathMLNames::mphantomTag,
    &MathMLNames::mprescriptsTag,
    &MathMLNames::mrootTag,
    &MathMLNames::mrowTag,
    &MathMLNames::msTag,
    &MathMLNames::mscarriesTag,
    &MathMLNames::mscarryTag,
    &MathMLNames::msgroupTag,
    &MathMLNames::mslineTag,
    &MathMLNames::mspaceTag,
    &MathMLNames::msqrtTag,
    &MathMLNames::msrowTag,
    &MathMLNames::mstackTag,
    &MathMLNames::mstyleTag,
    &MathMLNames::msubTag,
    &MathMLNames::msubsupTag,
    &MathMLNames::msupTag,
    &MathMLNames::mtableTag,
    &MathMLNames::mtdTag,
    &MathMLNames::mtextTag,
    &MathMLNames::mtrTag,
    &MathMLNames::munderTag,
    &MathMLNames::munderoverTag,
    &MathMLNames::noneTag,
    &MathMLNames::semanticsTag,
    &SVGNames::altGlyphTag,
    &SVGNames::altGlyphDefTag,
    &SVGNames::altGlyphItemTag,
    &SVGNames::animateTag,
    &SVGNames::animateColorTag,
    &SVGNames::animateMotionTag,
    &SVGNames::animateTransformTag,
    &SVGNames::circleTag,
    &SVGNames::clipPathTag,
    &SVGNames::cursorTag,
    &SVGNames::defsTag,
    &SVGNames::descTag,
    &SVGNames::ellipseTag,
    &SVGNames::feBlendTag,
    &SVGNames::feColorMatrixTag,
    &SVGNames::feComponentTransferTag,
    &SVGNames::feCompositeTag,
    &SVGNames::feConvolveMatrixTag,
    &SVGNames::feDiffuseLightingTag,
    &SVGNames::feDisplacementMapTag,
    &SVGNames::feDistantLightTag,
    &SVGNames::feDropShadowTag,
    &SVGNames::feFloodTag,
    &SVGNames::feFuncATag,
    &SVGNames::feFuncBTag,
    &SVGNames::feFuncGTag,
    &SVGNames::feFuncRTag,
    &SVGNames::feGaussianBlurTag,
    &SVGNames::feImageTag,
    &SVGNames::feMergeTag,
    &SVGNames::feMergeNodeTag,
    &SVGNames::feMorphologyTag,
    &SVGNames::feOffsetTag,
    &SVGNames::fePointLightTag,
    &SVGNames::feSpecularLightingTag,
    &SVGNames::feSpotLightTag,
    &SVGNames::feTileTag,
    &SVGNames::feTurbulenceTag,
    &SVGNames::filterTag,
    &SVGNames::font_faceTag,
    &SVGNames::font_face_formatTag,
    &SVGNames::font_face_nameTag,
    &SVGNames::font_face_srcTag,
    &SVGNames::font_face_uriTag,
    &SVGNames::foreignObjectTag,
    &SVGNames::gTag,
    &SVGNames::glyphTag,
    &SVGNames::glyphRefTag,
    &SVGNames::hkernTag,
    &SVGNames::lineTag,
    &SVGNames::linearGradientTag,
    &SVGNames::markerTag,
    &SVGNames::maskTag,
    &SVGNames::metadataTag,
    &SVGNames::missing_glyphTag,
    &SVGNames::mpathTag,
    &SVGNames::pathTag,
    &SVGNames::patternTag,
    &SVGNames::polygonTag,
    &SVGNames::polylineTag,
    &SVGNames::radialGradientTag,
    &SVGNames::rectTag,
    &SVGNames::setTag,
    &SVGNames::stopTag,
    &SVGNames::svgTag,
    &SVGNames::switchTag,
    &SVGNames::symbolTag,
    &SVGNames::textTag,
    &SVGNames::textPathTag,
    &SVGNames::trefTag,
    &SVGNames::tspanTag,
    &SVGNames::useTag,
    &SVGNames::viewTag,
    &SVGNames::vkernTag,
    &HTMLNames::aTag,
    &HTMLNames::fontTag,
    &HTMLNames::imageTag,
    &HTMLNames::scriptTag,
    &HTMLNames::styleTag,
    &HTMLNames::titleTag,
};

static constexpr StringImpl::StaticStringImpl unadjustedTagNames[] = {
    StringImpl::StaticStringImpl { "altglyph" },
    StringImpl::StaticStringImpl { "altglyphdef" },
    StringImpl::StaticStringImpl { "altglyphitem" },
    StringImpl::StaticStringImpl { "animatecolor" },
    StringImpl::StaticStringImpl { "animatemotion" },
    StringImpl::StaticStringImpl { "animatetransform" },
    StringImpl::StaticStringImpl { "clippath" },
    StringImpl::StaticStringImpl { "feblend" },
    StringImpl::StaticStringImpl { "fecolormatrix" },
    StringImpl::StaticStringImpl { "fecomponenttransfer" },
    StringImpl::StaticStringImpl { "fecomposite" },
    StringImpl::StaticStringImpl { "feconvolvematrix" },
    StringImpl::StaticStringImpl { "fediffuselighting" },
    StringImpl::StaticStringImpl { "fedisplacementmap" },
    StringImpl::StaticStringImpl { "fedistantlight" },
    StringImpl::StaticStringImpl { "fedropshadow" },
    StringImpl::StaticStringImpl { "feflood" },
    StringImpl::StaticStringImpl { "fefunca" },
    StringImpl::StaticStringImpl { "fefuncb" },
    StringImpl::StaticStringImpl { "fefuncg" },
    StringImpl::StaticStringImpl { "fefuncr" },
    StringImpl::StaticStringImpl { "fegaussianblur" },
    StringImpl::StaticStringImpl { "feimage" },
    StringImpl::StaticStringImpl { "femerge" },
    StringImpl::StaticStringImpl { "femergenode" },
    StringImpl::StaticStringImpl { "femorphology" },
    StringImpl::StaticStringImpl { "feoffset" },
    StringImpl::StaticStringImpl { "fepointlight" },
    StringImpl::StaticStringImpl { "fespecularlighting" },
    StringImpl::StaticStringImpl { "fespotlight" },
    StringImpl::StaticStringImpl { "fetile" },
    StringImpl::StaticStringImpl { "feturbulence" },
    StringImpl::StaticStringImpl { "foreignobject" },
    StringImpl::StaticStringImpl { "glyphref" },
    StringImpl::StaticStringImpl { "lineargradient" },
    StringImpl::StaticStringImpl { "radialgradient" },
    StringImpl::StaticStringImpl { "textpath" },
};

void initializeTagNameStrings() {
    static bool initialized = false;
    if (std::exchange(initialized, true))
        return;

    tagNameStrings.construct();
    auto tagNamesEntry = tagNameStrings->begin();
    ++tagNamesEntry; // Skip TagName::Unknown
    for (auto* qualifiedName : tagQualifiedNamePointers)
        *(tagNamesEntry++) = reinterpret_cast<LazyNeverDestroyed<QualifiedName>*>(qualifiedName)->get().localName();
    for (auto& string : unadjustedTagNames) {
        reinterpret_cast<const StringImpl&>(string).assertHashIsCorrect();
        *(tagNamesEntry++) = AtomString(&string);
    }
    ASSERT(tagNamesEntry == tagNameStrings->end());
}

template <typename characterType>
static inline TagName findTagFromBuffer(std::span<const characterType> buffer)
{
    switch (buffer.size()) {
    case 1: {
        switch (buffer[0]) {
        case 'a': {
            return TagName::a;
        }
        case 'b': {
            return TagName::b;
        }
        case 'g': {
            return TagName::g;
        }
        case 'i': {
            return TagName::i;
        }
        case 'p': {
            return TagName::p;
        }
        case 'q': {
            return TagName::q;
        }
        case 's': {
            return TagName::s;
        }
        case 'u': {
            return TagName::u;
        }
        default:
            break;
        }
        break;
    }
    case 2: {
        switch (buffer[0]) {
        case 'b': {
            if (buffer[1] == 'r') {
                return TagName::br;
            }
            break;
        }
        case 'd': {
            switch (buffer[1]) {
            case 'd': {
                return TagName::dd;
            }
            case 'l': {
                return TagName::dl;
            }
            case 't': {
                return TagName::dt;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'e': {
            if (buffer[1] == 'm') {
                return TagName::em;
            }
            break;
        }
        case 'h': {
            switch (buffer[1]) {
            case '1': {
                return TagName::h1;
            }
            case '2': {
                return TagName::h2;
            }
            case '3': {
                return TagName::h3;
            }
            case '4': {
                return TagName::h4;
            }
            case '5': {
                return TagName::h5;
            }
            case '6': {
                return TagName::h6;
            }
            case 'r': {
                return TagName::hr;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'l': {
            if (buffer[1] == 'i') {
                return TagName::li;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'i': {
                return TagName::mi;
            }
            case 'n': {
                return TagName::mn;
            }
            case 'o': {
                return TagName::mo;
            }
            case 's': {
                return TagName::ms;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'o': {
            if (buffer[1] == 'l') {
                return TagName::ol;
            }
            break;
        }
        case 'r': {
            switch (buffer[1]) {
            case 'b': {
                return TagName::rb;
            }
            case 'p': {
                return TagName::rp;
            }
            case 't': {
                return TagName::rt;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 't': {
            switch (buffer[1]) {
            case 'd': {
                return TagName::td;
            }
            case 'h': {
                return TagName::th;
            }
            case 'r': {
                return TagName::tr;
            }
            case 't': {
                return TagName::tt;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'u': {
            if (buffer[1] == 'l') {
                return TagName::ul;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 3: {
        switch (buffer[0]) {
        case 'b': {
            switch (buffer[1]) {
            case 'd': {
                switch (buffer[2]) {
                case 'i': {
                    return TagName::bdi;
                }
                case 'o': {
                    return TagName::bdo;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'i': {
                if (buffer[2] == 'g') {
                    return TagName::big;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'c': {
            static constexpr characterType rest[] = { 'o', 'l', };
            if (WTF::equal(buffer.data() + 1, rest, 2)) {
                return TagName::col;
            }
            break;
        }
        case 'd': {
            switch (buffer[1]) {
            case 'e': {
                if (buffer[2] == 'l') {
                    return TagName::del;
                }
                break;
            }
            case 'f': {
                if (buffer[2] == 'n') {
                    return TagName::dfn;
                }
                break;
            }
            case 'i': {
                switch (buffer[2]) {
                case 'r': {
                    return TagName::dir;
                }
                case 'v': {
                    return TagName::div;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'i': {
            switch (buffer[1]) {
            case 'm': {
                if (buffer[2] == 'g') {
                    return TagName::img;
                }
                break;
            }
            case 'n': {
                if (buffer[2] == 's') {
                    return TagName::ins;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'k': {
            static constexpr characterType rest[] = { 'b', 'd', };
            if (WTF::equal(buffer.data() + 1, rest, 2)) {
                return TagName::kbd;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                if (buffer[2] == 'p') {
                    return TagName::map;
                }
                break;
            }
            case 't': {
                switch (buffer[2]) {
                case 'd': {
                    return TagName::mtd;
                }
                case 'r': {
                    return TagName::mtr;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'n': {
            static constexpr characterType rest[] = { 'a', 'v', };
            if (WTF::equal(buffer.data() + 1, rest, 2)) {
                return TagName::nav;
            }
            break;
        }
        case 'p': {
            static constexpr characterType rest[] = { 'r', 'e', };
            if (WTF::equal(buffer.data() + 1, rest, 2)) {
                return TagName::pre;
            }
            break;
        }
        case 'r': {
            static constexpr characterType rest[] = { 't', 'c', };
            if (WTF::equal(buffer.data() + 1, rest, 2)) {
                return TagName::rtc;
            }
            break;
        }
        case 's': {
            switch (buffer[1]) {
            case 'e': {
                if (buffer[2] == 't') {
                    return TagName::set;
                }
                break;
            }
            case 'u': {
                switch (buffer[2]) {
                case 'b': {
                    return TagName::sub;
                }
                case 'p': {
                    return TagName::sup;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'v': {
                if (buffer[2] == 'g') {
                    return TagName::svg;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'u': {
            static constexpr characterType rest[] = { 's', 'e', };
            if (WTF::equal(buffer.data() + 1, rest, 2)) {
                return TagName::use;
            }
            break;
        }
        case 'v': {
            static constexpr characterType rest[] = { 'a', 'r', };
            if (WTF::equal(buffer.data() + 1, rest, 2)) {
                return TagName::var;
            }
            break;
        }
        case 'w': {
            static constexpr characterType rest[] = { 'b', 'r', };
            if (WTF::equal(buffer.data() + 1, rest, 2)) {
                return TagName::wbr;
            }
            break;
        }
        case 'x': {
            static constexpr characterType rest[] = { 'm', 'p', };
            if (WTF::equal(buffer.data() + 1, rest, 2)) {
                return TagName::xmp;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 4: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'b': {
                static constexpr characterType rest[] = { 'b', 'r', };
                if (WTF::equal(buffer.data() + 2, rest, 2)) {
                    return TagName::abbr;
                }
                break;
            }
            case 'r': {
                static constexpr characterType rest[] = { 'e', 'a', };
                if (WTF::equal(buffer.data() + 2, rest, 2)) {
                    return TagName::area;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'b': {
            switch (buffer[1]) {
            case 'a': {
                static constexpr characterType rest[] = { 's', 'e', };
                if (WTF::equal(buffer.data() + 2, rest, 2)) {
                    return TagName::base;
                }
                break;
            }
            case 'o': {
                static constexpr characterType rest[] = { 'd', 'y', };
                if (WTF::equal(buffer.data() + 2, rest, 2)) {
                    return TagName::body;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'c': {
            switch (buffer[1]) {
            case 'i': {
                static constexpr characterType rest[] = { 't', 'e', };
                if (WTF::equal(buffer.data() + 2, rest, 2)) {
                    return TagName::cite;
                }
                break;
            }
            case 'o': {
                static constexpr characterType rest[] = { 'd', 'e', };
                if (WTF::equal(buffer.data() + 2, rest, 2)) {
                    return TagName::code;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'd': {
            switch (buffer[1]) {
            case 'a': {
                static constexpr characterType rest[] = { 't', 'a', };
                if (WTF::equal(buffer.data() + 2, rest, 2)) {
                    return TagName::data;
                }
                break;
            }
            case 'e': {
                switch (buffer[2]) {
                case 'f': {
                    if (buffer[3] == 's') {
                        return TagName::defs;
                    }
                    break;
                }
                case 's': {
                    if (buffer[3] == 'c') {
                        return TagName::desc;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'o': {
                switch (buffer[2]) {
                case 'n': {
                    if (buffer[3] == 't') {
                        return TagName::font;
                    }
                    break;
                }
                case 'r': {
                    if (buffer[3] == 'm') {
                        return TagName::form;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'h': {
            switch (buffer[1]) {
            case 'e': {
                static constexpr characterType rest[] = { 'a', 'd', };
                if (WTF::equal(buffer.data() + 2, rest, 2)) {
                    return TagName::head;
                }
                break;
            }
            case 't': {
                static constexpr characterType rest[] = { 'm', 'l', };
                if (WTF::equal(buffer.data() + 2, rest, 2)) {
                    return TagName::html;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'l': {
            switch (buffer[1]) {
            case 'i': {
                switch (buffer[2]) {
                case 'n': {
                    switch (buffer[3]) {
                    case 'e': {
                        return TagName::line;
                    }
                    case 'k': {
                        return TagName::link;
                    }
                    default:
                        break;
                    }
                    return TagName::Unknown;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                switch (buffer[2]) {
                case 'i': {
                    if (buffer[3] == 'n') {
                        return TagName::main;
                    }
                    break;
                }
                case 'r': {
                    if (buffer[3] == 'k') {
                        return TagName::mark;
                    }
                    break;
                }
                case 's': {
                    if (buffer[3] == 'k') {
                        return TagName::mask;
                    }
                    break;
                }
                case 't': {
                    if (buffer[3] == 'h') {
                        return TagName::math;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'e': {
                switch (buffer[2]) {
                case 'n': {
                    if (buffer[3] == 'u') {
                        return TagName::menu;
                    }
                    break;
                }
                case 't': {
                    if (buffer[3] == 'a') {
                        return TagName::meta;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'r': {
                static constexpr characterType rest[] = { 'o', 'w', };
                if (WTF::equal(buffer.data() + 2, rest, 2)) {
                    return TagName::mrow;
                }
                break;
            }
            case 's': {
                switch (buffer[2]) {
                case 'u': {
                    switch (buffer[3]) {
                    case 'b': {
                        return TagName::msub;
                    }
                    case 'p': {
                        return TagName::msup;
                    }
                    default:
                        break;
                    }
                    return TagName::Unknown;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'n': {
            switch (buffer[1]) {
            case 'o': {
                switch (buffer[2]) {
                case 'b': {
                    if (buffer[3] == 'r') {
                        return TagName::nobr;
                    }
                    break;
                }
                case 'n': {
                    if (buffer[3] == 'e') {
                        return TagName::none;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'p': {
            static constexpr characterType rest[] = { 'a', 't', 'h', };
            if (WTF::equal(buffer.data() + 1, rest, 3)) {
                return TagName::path;
            }
            break;
        }
        case 'r': {
            switch (buffer[1]) {
            case 'e': {
                static constexpr characterType rest[] = { 'c', 't', };
                if (WTF::equal(buffer.data() + 2, rest, 2)) {
                    return TagName::rect;
                }
                break;
            }
            case 'u': {
                static constexpr characterType rest[] = { 'b', 'y', };
                if (WTF::equal(buffer.data() + 2, rest, 2)) {
                    return TagName::ruby;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 's': {
            switch (buffer[1]) {
            case 'a': {
                static constexpr characterType rest[] = { 'm', 'p', };
                if (WTF::equal(buffer.data() + 2, rest, 2)) {
                    return TagName::samp;
                }
                break;
            }
            case 'l': {
                static constexpr characterType rest[] = { 'o', 't', };
                if (WTF::equal(buffer.data() + 2, rest, 2)) {
                    return TagName::slot;
                }
                break;
            }
            case 'p': {
                static constexpr characterType rest[] = { 'a', 'n', };
                if (WTF::equal(buffer.data() + 2, rest, 2)) {
                    return TagName::span;
                }
                break;
            }
            case 't': {
                static constexpr characterType rest[] = { 'o', 'p', };
                if (WTF::equal(buffer.data() + 2, rest, 2)) {
                    return TagName::stop;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 't': {
            switch (buffer[1]) {
            case 'e': {
                static constexpr characterType rest[] = { 'x', 't', };
                if (WTF::equal(buffer.data() + 2, rest, 2)) {
                    return TagName::text;
                }
                break;
            }
            case 'i': {
                static constexpr characterType rest[] = { 'm', 'e', };
                if (WTF::equal(buffer.data() + 2, rest, 2)) {
                    return TagName::time;
                }
                break;
            }
            case 'r': {
                static constexpr characterType rest[] = { 'e', 'f', };
                if (WTF::equal(buffer.data() + 2, rest, 2)) {
                    return TagName::tref;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'v': {
            static constexpr characterType rest[] = { 'i', 'e', 'w', };
            if (WTF::equal(buffer.data() + 1, rest, 3)) {
                return TagName::view;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 5: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 's': {
                static constexpr characterType rest[] = { 'i', 'd', 'e', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::aside;
                }
                break;
            }
            case 'u': {
                static constexpr characterType rest[] = { 'd', 'i', 'o', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::audio;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'e': {
            static constexpr characterType rest[] = { 'm', 'b', 'e', 'd', };
            if (WTF::equal(buffer.data() + 1, rest, 4)) {
                return TagName::embed;
            }
            break;
        }
        case 'f': {
            static constexpr characterType rest[] = { 'r', 'a', 'm', 'e', };
            if (WTF::equal(buffer.data() + 1, rest, 4)) {
                return TagName::frame;
            }
            break;
        }
        case 'g': {
            static constexpr characterType rest[] = { 'l', 'y', 'p', 'h', };
            if (WTF::equal(buffer.data() + 1, rest, 4)) {
                return TagName::glyph;
            }
            break;
        }
        case 'h': {
            static constexpr characterType rest[] = { 'k', 'e', 'r', 'n', };
            if (WTF::equal(buffer.data() + 1, rest, 4)) {
                return TagName::hkern;
            }
            break;
        }
        case 'i': {
            switch (buffer[1]) {
            case 'm': {
                static constexpr characterType rest[] = { 'a', 'g', 'e', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::image;
                }
                break;
            }
            case 'n': {
                static constexpr characterType rest[] = { 'p', 'u', 't', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::input;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'l': {
            static constexpr characterType rest[] = { 'a', 'b', 'e', 'l', };
            if (WTF::equal(buffer.data() + 1, rest, 4)) {
                return TagName::label;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'e': {
                static constexpr characterType rest[] = { 't', 'e', 'r', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::meter;
                }
                break;
            }
            case 'f': {
                static constexpr characterType rest[] = { 'r', 'a', 'c', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::mfrac;
                }
                break;
            }
            case 'o': {
                switch (buffer[2]) {
                case 'd': {
                    static constexpr characterType rest[] = { 'e', 'l', };
                    if (WTF::equal(buffer.data() + 3, rest, 2)) {
                        return TagName::model;
                    }
                    break;
                }
                case 'v': {
                    static constexpr characterType rest[] = { 'e', 'r', };
                    if (WTF::equal(buffer.data() + 3, rest, 2)) {
                        return TagName::mover;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'p': {
                static constexpr characterType rest[] = { 'a', 't', 'h', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::mpath;
                }
                break;
            }
            case 'r': {
                static constexpr characterType rest[] = { 'o', 'o', 't', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::mroot;
                }
                break;
            }
            case 's': {
                switch (buffer[2]) {
                case 'q': {
                    static constexpr characterType rest[] = { 'r', 't', };
                    if (WTF::equal(buffer.data() + 3, rest, 2)) {
                        return TagName::msqrt;
                    }
                    break;
                }
                case 'r': {
                    static constexpr characterType rest[] = { 'o', 'w', };
                    if (WTF::equal(buffer.data() + 3, rest, 2)) {
                        return TagName::msrow;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 't': {
                static constexpr characterType rest[] = { 'e', 'x', 't', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::mtext;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'p': {
            static constexpr characterType rest[] = { 'a', 'r', 'a', 'm', };
            if (WTF::equal(buffer.data() + 1, rest, 4)) {
                return TagName::param;
            }
            break;
        }
        case 's': {
            switch (buffer[1]) {
            case 'm': {
                static constexpr characterType rest[] = { 'a', 'l', 'l', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::small_;
                }
                break;
            }
            case 't': {
                static constexpr characterType rest[] = { 'y', 'l', 'e', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::style;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 't': {
            switch (buffer[1]) {
            case 'a': {
                static constexpr characterType rest[] = { 'b', 'l', 'e', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::table;
                }
                break;
            }
            case 'b': {
                static constexpr characterType rest[] = { 'o', 'd', 'y', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::tbody;
                }
                break;
            }
            case 'f': {
                static constexpr characterType rest[] = { 'o', 'o', 't', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::tfoot;
                }
                break;
            }
            case 'h': {
                static constexpr characterType rest[] = { 'e', 'a', 'd', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::thead;
                }
                break;
            }
            case 'i': {
                static constexpr characterType rest[] = { 't', 'l', 'e', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::title;
                }
                break;
            }
            case 'r': {
                static constexpr characterType rest[] = { 'a', 'c', 'k', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::track;
                }
                break;
            }
            case 's': {
                static constexpr characterType rest[] = { 'p', 'a', 'n', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::tspan;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'v': {
            switch (buffer[1]) {
            case 'i': {
                static constexpr characterType rest[] = { 'd', 'e', 'o', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::video;
                }
                break;
            }
            case 'k': {
                static constexpr characterType rest[] = { 'e', 'r', 'n', };
                if (WTF::equal(buffer.data() + 2, rest, 3)) {
                    return TagName::vkern;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 6: {
        switch (buffer[0]) {
        case 'a': {
            static constexpr characterType rest[] = { 'p', 'p', 'l', 'e', 't', };
            if (WTF::equal(buffer.data() + 1, rest, 5)) {
                return TagName::applet;
            }
            break;
        }
        case 'b': {
            static constexpr characterType rest[] = { 'u', 't', 't', 'o', 'n', };
            if (WTF::equal(buffer.data() + 1, rest, 5)) {
                return TagName::button;
            }
            break;
        }
        case 'c': {
            switch (buffer[1]) {
            case 'a': {
                static constexpr characterType rest[] = { 'n', 'v', 'a', 's', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::canvas;
                }
                break;
            }
            case 'e': {
                static constexpr characterType rest[] = { 'n', 't', 'e', 'r', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::center;
                }
                break;
            }
            case 'i': {
                static constexpr characterType rest[] = { 'r', 'c', 'l', 'e', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::circle;
                }
                break;
            }
            case 'u': {
                static constexpr characterType rest[] = { 'r', 's', 'o', 'r', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::cursor;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'd': {
            static constexpr characterType rest[] = { 'i', 'a', 'l', 'o', 'g', };
            if (WTF::equal(buffer.data() + 1, rest, 5)) {
                return TagName::dialog;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                static constexpr characterType rest[] = { 't', 'i', 'l', 'e', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::fetileCaseUnadjusted;
                }
                break;
            }
            case 'i': {
                switch (buffer[2]) {
                case 'g': {
                    static constexpr characterType rest[] = { 'u', 'r', 'e', };
                    if (WTF::equal(buffer.data() + 3, rest, 3)) {
                        return TagName::figure;
                    }
                    break;
                }
                case 'l': {
                    static constexpr characterType rest[] = { 't', 'e', 'r', };
                    if (WTF::equal(buffer.data() + 3, rest, 3)) {
                        return TagName::filter;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'o': {
                static constexpr characterType rest[] = { 'o', 't', 'e', 'r', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::footer;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'h': {
            switch (buffer[1]) {
            case 'e': {
                static constexpr characterType rest[] = { 'a', 'd', 'e', 'r', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::header;
                }
                break;
            }
            case 'g': {
                static constexpr characterType rest[] = { 'r', 'o', 'u', 'p', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::hgroup;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'i': {
            static constexpr characterType rest[] = { 'f', 'r', 'a', 'm', 'e', };
            if (WTF::equal(buffer.data() + 1, rest, 5)) {
                return TagName::iframe;
            }
            break;
        }
        case 'k': {
            static constexpr characterType rest[] = { 'e', 'y', 'g', 'e', 'n', };
            if (WTF::equal(buffer.data() + 1, rest, 5)) {
                return TagName::keygen;
            }
            break;
        }
        case 'l': {
            static constexpr characterType rest[] = { 'e', 'g', 'e', 'n', 'd', };
            if (WTF::equal(buffer.data() + 1, rest, 5)) {
                return TagName::legend;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                static constexpr characterType rest[] = { 'r', 'k', 'e', 'r', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::marker;
                }
                break;
            }
            case 'e': {
                static constexpr characterType rest[] = { 'r', 'r', 'o', 'r', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::merror;
                }
                break;
            }
            case 'g': {
                static constexpr characterType rest[] = { 'l', 'y', 'p', 'h', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::mglyph;
                }
                break;
            }
            case 's': {
                switch (buffer[2]) {
                case 'l': {
                    static constexpr characterType rest[] = { 'i', 'n', 'e', };
                    if (WTF::equal(buffer.data() + 3, rest, 3)) {
                        return TagName::msline;
                    }
                    break;
                }
                case 'p': {
                    static constexpr characterType rest[] = { 'a', 'c', 'e', };
                    if (WTF::equal(buffer.data() + 3, rest, 3)) {
                        return TagName::mspace;
                    }
                    break;
                }
                case 't': {
                    switch (buffer[3]) {
                    case 'a': {
                        static constexpr characterType rest[] = { 'c', 'k', };
                        if (WTF::equal(buffer.data() + 4, rest, 2)) {
                            return TagName::mstack;
                        }
                        break;
                    }
                    case 'y': {
                        static constexpr characterType rest[] = { 'l', 'e', };
                        if (WTF::equal(buffer.data() + 4, rest, 2)) {
                            return TagName::mstyle;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return TagName::Unknown;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 't': {
                static constexpr characterType rest[] = { 'a', 'b', 'l', 'e', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::mtable;
                }
                break;
            }
            case 'u': {
                static constexpr characterType rest[] = { 'n', 'd', 'e', 'r', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::munder;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'b': {
                static constexpr characterType rest[] = { 'j', 'e', 'c', 't', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::object;
                }
                break;
            }
            case 'p': {
                static constexpr characterType rest[] = { 't', 'i', 'o', 'n', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::option;
                }
                break;
            }
            case 'u': {
                static constexpr characterType rest[] = { 't', 'p', 'u', 't', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::output;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 's': {
            switch (buffer[1]) {
            case 'c': {
                static constexpr characterType rest[] = { 'r', 'i', 'p', 't', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::script;
                }
                break;
            }
            case 'e': {
                switch (buffer[2]) {
                case 'a': {
                    static constexpr characterType rest[] = { 'r', 'c', 'h', };
                    if (WTF::equal(buffer.data() + 3, rest, 3)) {
                        return TagName::search;
                    }
                    break;
                }
                case 'l': {
                    static constexpr characterType rest[] = { 'e', 'c', 't', };
                    if (WTF::equal(buffer.data() + 3, rest, 3)) {
                        return TagName::select;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'o': {
                static constexpr characterType rest[] = { 'u', 'r', 'c', 'e', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::source;
                }
                break;
            }
            case 't': {
                switch (buffer[2]) {
                case 'r': {
                    switch (buffer[3]) {
                    case 'i': {
                        static constexpr characterType rest[] = { 'k', 'e', };
                        if (WTF::equal(buffer.data() + 4, rest, 2)) {
                            return TagName::strike;
                        }
                        break;
                    }
                    case 'o': {
                        static constexpr characterType rest[] = { 'n', 'g', };
                        if (WTF::equal(buffer.data() + 4, rest, 2)) {
                            return TagName::strong;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return TagName::Unknown;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'w': {
                static constexpr characterType rest[] = { 'i', 't', 'c', 'h', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::switch_;
                }
                break;
            }
            case 'y': {
                static constexpr characterType rest[] = { 'm', 'b', 'o', 'l', };
                if (WTF::equal(buffer.data() + 2, rest, 4)) {
                    return TagName::symbol;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 7: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'c': {
                static constexpr characterType rest[] = { 'r', 'o', 'n', 'y', 'm', };
                if (WTF::equal(buffer.data() + 2, rest, 5)) {
                    return TagName::acronym;
                }
                break;
            }
            case 'd': {
                static constexpr characterType rest[] = { 'd', 'r', 'e', 's', 's', };
                if (WTF::equal(buffer.data() + 2, rest, 5)) {
                    return TagName::address;
                }
                break;
            }
            case 'n': {
                static constexpr characterType rest[] = { 'i', 'm', 'a', 't', 'e', };
                if (WTF::equal(buffer.data() + 2, rest, 5)) {
                    return TagName::animate;
                }
                break;
            }
            case 'r': {
                static constexpr characterType rest[] = { 't', 'i', 'c', 'l', 'e', };
                if (WTF::equal(buffer.data() + 2, rest, 5)) {
                    return TagName::article;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'b': {
            static constexpr characterType rest[] = { 'g', 's', 'o', 'u', 'n', 'd', };
            if (WTF::equal(buffer.data() + 1, rest, 6)) {
                return TagName::bgsound;
            }
            break;
        }
        case 'c': {
            static constexpr characterType rest[] = { 'a', 'p', 't', 'i', 'o', 'n', };
            if (WTF::equal(buffer.data() + 1, rest, 6)) {
                return TagName::caption;
            }
            break;
        }
        case 'd': {
            static constexpr characterType rest[] = { 'e', 't', 'a', 'i', 'l', 's', };
            if (WTF::equal(buffer.data() + 1, rest, 6)) {
                return TagName::details;
            }
            break;
        }
        case 'e': {
            static constexpr characterType rest[] = { 'l', 'l', 'i', 'p', 's', 'e', };
            if (WTF::equal(buffer.data() + 1, rest, 6)) {
                return TagName::ellipse;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'b': {
                    static constexpr characterType rest[] = { 'l', 'e', 'n', 'd', };
                    if (WTF::equal(buffer.data() + 3, rest, 4)) {
                        return TagName::feblendCaseUnadjusted;
                    }
                    break;
                }
                case 'f': {
                    switch (buffer[3]) {
                    case 'l': {
                        static constexpr characterType rest[] = { 'o', 'o', 'd', };
                        if (WTF::equal(buffer.data() + 4, rest, 3)) {
                            return TagName::fefloodCaseUnadjusted;
                        }
                        break;
                    }
                    case 'u': {
                        switch (buffer[4]) {
                        case 'n': {
                            switch (buffer[5]) {
                            case 'c': {
                                switch (buffer[6]) {
                                case 'a': {
                                    return TagName::fefuncaCaseUnadjusted;
                                }
                                case 'b': {
                                    return TagName::fefuncbCaseUnadjusted;
                                }
                                case 'g': {
                                    return TagName::fefuncgCaseUnadjusted;
                                }
                                case 'r': {
                                    return TagName::fefuncrCaseUnadjusted;
                                }
                                default:
                                    break;
                                }
                                return TagName::Unknown;
                            }
                            default:
                                break;
                            }
                            return TagName::Unknown;
                        }
                        default:
                            break;
                        }
                        return TagName::Unknown;
                    }
                    default:
                        break;
                    }
                    return TagName::Unknown;
                }
                case 'i': {
                    static constexpr characterType rest[] = { 'm', 'a', 'g', 'e', };
                    if (WTF::equal(buffer.data() + 3, rest, 4)) {
                        return TagName::feimageCaseUnadjusted;
                    }
                    break;
                }
                case 'm': {
                    static constexpr characterType rest[] = { 'e', 'r', 'g', 'e', };
                    if (WTF::equal(buffer.data() + 3, rest, 4)) {
                        return TagName::femergeCaseUnadjusted;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'l': {
            static constexpr characterType rest[] = { 'i', 's', 't', 'i', 'n', 'g', };
            if (WTF::equal(buffer.data() + 1, rest, 6)) {
                return TagName::listing;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                switch (buffer[2]) {
                case 'c': {
                    static constexpr characterType rest[] = { 't', 'i', 'o', 'n', };
                    if (WTF::equal(buffer.data() + 3, rest, 4)) {
                        return TagName::maction;
                    }
                    break;
                }
                case 'r': {
                    static constexpr characterType rest[] = { 'q', 'u', 'e', 'e', };
                    if (WTF::equal(buffer.data() + 3, rest, 4)) {
                        return TagName::marquee;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'f': {
                static constexpr characterType rest[] = { 'e', 'n', 'c', 'e', 'd', };
                if (WTF::equal(buffer.data() + 2, rest, 5)) {
                    return TagName::mfenced;
                }
                break;
            }
            case 'p': {
                static constexpr characterType rest[] = { 'a', 'd', 'd', 'e', 'd', };
                if (WTF::equal(buffer.data() + 2, rest, 5)) {
                    return TagName::mpadded;
                }
                break;
            }
            case 's': {
                switch (buffer[2]) {
                case 'c': {
                    static constexpr characterType rest[] = { 'a', 'r', 'r', 'y', };
                    if (WTF::equal(buffer.data() + 3, rest, 4)) {
                        return TagName::mscarry;
                    }
                    break;
                }
                case 'g': {
                    static constexpr characterType rest[] = { 'r', 'o', 'u', 'p', };
                    if (WTF::equal(buffer.data() + 3, rest, 4)) {
                        return TagName::msgroup;
                    }
                    break;
                }
                case 'u': {
                    static constexpr characterType rest[] = { 'b', 's', 'u', 'p', };
                    if (WTF::equal(buffer.data() + 3, rest, 4)) {
                        return TagName::msubsup;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'n': {
            static constexpr characterType rest[] = { 'o', 'e', 'm', 'b', 'e', 'd', };
            if (WTF::equal(buffer.data() + 1, rest, 6)) {
                return TagName::noembed;
            }
            break;
        }
        case 'p': {
            switch (buffer[1]) {
            case 'a': {
                static constexpr characterType rest[] = { 't', 't', 'e', 'r', 'n', };
                if (WTF::equal(buffer.data() + 2, rest, 5)) {
                    return TagName::pattern;
                }
                break;
            }
            case 'i': {
                static constexpr characterType rest[] = { 'c', 't', 'u', 'r', 'e', };
                if (WTF::equal(buffer.data() + 2, rest, 5)) {
                    return TagName::picture;
                }
                break;
            }
            case 'o': {
                static constexpr characterType rest[] = { 'l', 'y', 'g', 'o', 'n', };
                if (WTF::equal(buffer.data() + 2, rest, 5)) {
                    return TagName::polygon;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 's': {
            switch (buffer[1]) {
            case 'e': {
                static constexpr characterType rest[] = { 'c', 't', 'i', 'o', 'n', };
                if (WTF::equal(buffer.data() + 2, rest, 5)) {
                    return TagName::section;
                }
                break;
            }
            case 'u': {
                static constexpr characterType rest[] = { 'm', 'm', 'a', 'r', 'y', };
                if (WTF::equal(buffer.data() + 2, rest, 5)) {
                    return TagName::summary;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 8: {
        switch (buffer[0]) {
        case 'a': {
            static constexpr characterType rest[] = { 'l', 't', 'g', 'l', 'y', 'p', 'h', };
            if (WTF::equal(buffer.data() + 1, rest, 7)) {
                return TagName::altglyphCaseUnadjusted;
            }
            break;
        }
        case 'b': {
            static constexpr characterType rest[] = { 'a', 's', 'e', 'f', 'o', 'n', 't', };
            if (WTF::equal(buffer.data() + 1, rest, 7)) {
                return TagName::basefont;
            }
            break;
        }
        case 'c': {
            switch (buffer[1]) {
            case 'l': {
                static constexpr characterType rest[] = { 'i', 'p', 'p', 'a', 't', 'h', };
                if (WTF::equal(buffer.data() + 2, rest, 6)) {
                    return TagName::clippathCaseUnadjusted;
                }
                break;
            }
            case 'o': {
                static constexpr characterType rest[] = { 'l', 'g', 'r', 'o', 'u', 'p', };
                if (WTF::equal(buffer.data() + 2, rest, 6)) {
                    return TagName::colgroup;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'd': {
            static constexpr characterType rest[] = { 'a', 't', 'a', 'l', 'i', 's', 't', };
            if (WTF::equal(buffer.data() + 1, rest, 7)) {
                return TagName::datalist;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                static constexpr characterType rest[] = { 'o', 'f', 'f', 's', 'e', 't', };
                if (WTF::equal(buffer.data() + 2, rest, 6)) {
                    return TagName::feoffsetCaseUnadjusted;
                }
                break;
            }
            case 'i': {
                static constexpr characterType rest[] = { 'e', 'l', 'd', 's', 'e', 't', };
                if (WTF::equal(buffer.data() + 2, rest, 6)) {
                    return TagName::fieldset;
                }
                break;
            }
            case 'r': {
                static constexpr characterType rest[] = { 'a', 'm', 'e', 's', 'e', 't', };
                if (WTF::equal(buffer.data() + 2, rest, 6)) {
                    return TagName::frameset;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'g': {
            static constexpr characterType rest[] = { 'l', 'y', 'p', 'h', 'r', 'e', 'f', };
            if (WTF::equal(buffer.data() + 1, rest, 7)) {
                return TagName::glyphrefCaseUnadjusted;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'n': {
                    switch (buffer[3]) {
                    case 'c': {
                        static constexpr characterType rest[] = { 'l', 'o', 's', 'e', };
                        if (WTF::equal(buffer.data() + 4, rest, 4)) {
                            return TagName::menclose;
                        }
                        break;
                    }
                    case 'u': {
                        static constexpr characterType rest[] = { 'i', 't', 'e', 'm', };
                        if (WTF::equal(buffer.data() + 4, rest, 4)) {
                            return TagName::menuitem;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return TagName::Unknown;
                }
                case 't': {
                    static constexpr characterType rest[] = { 'a', 'd', 'a', 't', 'a', };
                    if (WTF::equal(buffer.data() + 3, rest, 5)) {
                        return TagName::metadata;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'l': {
                static constexpr characterType rest[] = { 'o', 'n', 'g', 'd', 'i', 'v', };
                if (WTF::equal(buffer.data() + 2, rest, 6)) {
                    return TagName::mlongdiv;
                }
                break;
            }
            case 'p': {
                static constexpr characterType rest[] = { 'h', 'a', 'n', 't', 'o', 'm', };
                if (WTF::equal(buffer.data() + 2, rest, 6)) {
                    return TagName::mphantom;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'n': {
            switch (buffer[1]) {
            case 'o': {
                switch (buffer[2]) {
                case 'f': {
                    static constexpr characterType rest[] = { 'r', 'a', 'm', 'e', 's', };
                    if (WTF::equal(buffer.data() + 3, rest, 5)) {
                        return TagName::noframes;
                    }
                    break;
                }
                case 's': {
                    static constexpr characterType rest[] = { 'c', 'r', 'i', 'p', 't', };
                    if (WTF::equal(buffer.data() + 3, rest, 5)) {
                        return TagName::noscript;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'o': {
            static constexpr characterType rest[] = { 'p', 't', 'g', 'r', 'o', 'u', 'p', };
            if (WTF::equal(buffer.data() + 1, rest, 7)) {
                return TagName::optgroup;
            }
            break;
        }
        case 'p': {
            switch (buffer[1]) {
            case 'o': {
                static constexpr characterType rest[] = { 'l', 'y', 'l', 'i', 'n', 'e', };
                if (WTF::equal(buffer.data() + 2, rest, 6)) {
                    return TagName::polyline;
                }
                break;
            }
            case 'r': {
                static constexpr characterType rest[] = { 'o', 'g', 'r', 'e', 's', 's', };
                if (WTF::equal(buffer.data() + 2, rest, 6)) {
                    return TagName::progress;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 't': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'm': {
                    static constexpr characterType rest[] = { 'p', 'l', 'a', 't', 'e', };
                    if (WTF::equal(buffer.data() + 3, rest, 5)) {
                        return TagName::template_;
                    }
                    break;
                }
                case 'x': {
                    switch (buffer[3]) {
                    case 't': {
                        switch (buffer[4]) {
                        case 'a': {
                            static constexpr characterType rest[] = { 'r', 'e', 'a', };
                            if (WTF::equal(buffer.data() + 5, rest, 3)) {
                                return TagName::textarea;
                            }
                            break;
                        }
                        case 'p': {
                            static constexpr characterType rest[] = { 'a', 't', 'h', };
                            if (WTF::equal(buffer.data() + 5, rest, 3)) {
                                return TagName::textpathCaseUnadjusted;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return TagName::Unknown;
                    }
                    default:
                        break;
                    }
                    return TagName::Unknown;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 9: {
        switch (buffer[0]) {
        case 'f': {
            static constexpr characterType rest[] = { 'o', 'n', 't', '-', 'f', 'a', 'c', 'e', };
            if (WTF::equal(buffer.data() + 1, rest, 8)) {
                return TagName::font_face;
            }
            break;
        }
        case 'm': {
            static constexpr characterType rest[] = { 's', 'c', 'a', 'r', 'r', 'i', 'e', 's', };
            if (WTF::equal(buffer.data() + 1, rest, 8)) {
                return TagName::mscarries;
            }
            break;
        }
        case 'p': {
            static constexpr characterType rest[] = { 'l', 'a', 'i', 'n', 't', 'e', 'x', 't', };
            if (WTF::equal(buffer.data() + 1, rest, 8)) {
                return TagName::plaintext;
            }
            break;
        }
        case 's': {
            static constexpr characterType rest[] = { 'e', 'm', 'a', 'n', 't', 'i', 'c', 's', };
            if (WTF::equal(buffer.data() + 1, rest, 8)) {
                return TagName::semantics;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 10: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'n': {
                static constexpr characterType rest[] = { 'n', 'o', 't', 'a', 't', 'i', 'o', 'n', };
                if (WTF::equal(buffer.data() + 2, rest, 8)) {
                    return TagName::annotation;
                }
                break;
            }
            case 't': {
                static constexpr characterType rest[] = { 't', 'a', 'c', 'h', 'm', 'e', 'n', 't', };
                if (WTF::equal(buffer.data() + 2, rest, 8)) {
                    return TagName::attachment;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'b': {
            static constexpr characterType rest[] = { 'l', 'o', 'c', 'k', 'q', 'u', 'o', 't', 'e', };
            if (WTF::equal(buffer.data() + 1, rest, 9)) {
                return TagName::blockquote;
            }
            break;
        }
        case 'f': {
            static constexpr characterType rest[] = { 'i', 'g', 'c', 'a', 'p', 't', 'i', 'o', 'n', };
            if (WTF::equal(buffer.data() + 1, rest, 9)) {
                return TagName::figcaption;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                static constexpr characterType rest[] = { 'l', 'i', 'g', 'n', 'm', 'a', 'r', 'k', };
                if (WTF::equal(buffer.data() + 2, rest, 8)) {
                    return TagName::malignmark;
                }
                break;
            }
            case 'l': {
                static constexpr characterType rest[] = { 'a', 'b', 'e', 'l', 'e', 'd', 't', 'r', };
                if (WTF::equal(buffer.data() + 2, rest, 8)) {
                    return TagName::mlabeledtr;
                }
                break;
            }
            case 'u': {
                static constexpr characterType rest[] = { 'n', 'd', 'e', 'r', 'o', 'v', 'e', 'r', };
                if (WTF::equal(buffer.data() + 2, rest, 8)) {
                    return TagName::munderover;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 11: {
        switch (buffer[0]) {
        case 'a': {
            static constexpr characterType rest[] = { 'l', 't', 'g', 'l', 'y', 'p', 'h', 'd', 'e', 'f', };
            if (WTF::equal(buffer.data() + 1, rest, 10)) {
                return TagName::altglyphdefCaseUnadjusted;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'c': {
                    static constexpr characterType rest[] = { 'o', 'm', 'p', 'o', 's', 'i', 't', 'e', };
                    if (WTF::equal(buffer.data() + 3, rest, 8)) {
                        return TagName::fecompositeCaseUnadjusted;
                    }
                    break;
                }
                case 'm': {
                    static constexpr characterType rest[] = { 'e', 'r', 'g', 'e', 'n', 'o', 'd', 'e', };
                    if (WTF::equal(buffer.data() + 3, rest, 8)) {
                        return TagName::femergenodeCaseUnadjusted;
                    }
                    break;
                }
                case 's': {
                    static constexpr characterType rest[] = { 'p', 'o', 't', 'l', 'i', 'g', 'h', 't', };
                    if (WTF::equal(buffer.data() + 3, rest, 8)) {
                        return TagName::fespotlightCaseUnadjusted;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                static constexpr characterType rest[] = { 'l', 'i', 'g', 'n', 'g', 'r', 'o', 'u', 'p', };
                if (WTF::equal(buffer.data() + 2, rest, 9)) {
                    return TagName::maligngroup;
                }
                break;
            }
            case 'p': {
                static constexpr characterType rest[] = { 'r', 'e', 's', 'c', 'r', 'i', 'p', 't', 's', };
                if (WTF::equal(buffer.data() + 2, rest, 9)) {
                    return TagName::mprescripts;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 12: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'l': {
                static constexpr characterType rest[] = { 't', 'g', 'l', 'y', 'p', 'h', 'i', 't', 'e', 'm', };
                if (WTF::equal(buffer.data() + 2, rest, 10)) {
                    return TagName::altglyphitemCaseUnadjusted;
                }
                break;
            }
            case 'n': {
                static constexpr characterType rest[] = { 'i', 'm', 'a', 't', 'e', 'c', 'o', 'l', 'o', 'r', };
                if (WTF::equal(buffer.data() + 2, rest, 10)) {
                    return TagName::animatecolorCaseUnadjusted;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'd': {
                    static constexpr characterType rest[] = { 'r', 'o', 'p', 's', 'h', 'a', 'd', 'o', 'w', };
                    if (WTF::equal(buffer.data() + 3, rest, 9)) {
                        return TagName::fedropshadowCaseUnadjusted;
                    }
                    break;
                }
                case 'm': {
                    static constexpr characterType rest[] = { 'o', 'r', 'p', 'h', 'o', 'l', 'o', 'g', 'y', };
                    if (WTF::equal(buffer.data() + 3, rest, 9)) {
                        return TagName::femorphologyCaseUnadjusted;
                    }
                    break;
                }
                case 'p': {
                    static constexpr characterType rest[] = { 'o', 'i', 'n', 't', 'l', 'i', 'g', 'h', 't', };
                    if (WTF::equal(buffer.data() + 3, rest, 9)) {
                        return TagName::fepointlightCaseUnadjusted;
                    }
                    break;
                }
                case 't': {
                    static constexpr characterType rest[] = { 'u', 'r', 'b', 'u', 'l', 'e', 'n', 'c', 'e', };
                    if (WTF::equal(buffer.data() + 3, rest, 9)) {
                        return TagName::feturbulenceCaseUnadjusted;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 13: {
        switch (buffer[0]) {
        case 'a': {
            static constexpr characterType rest[] = { 'n', 'i', 'm', 'a', 't', 'e', 'm', 'o', 't', 'i', 'o', 'n', };
            if (WTF::equal(buffer.data() + 1, rest, 12)) {
                return TagName::animatemotionCaseUnadjusted;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                static constexpr characterType rest[] = { 'c', 'o', 'l', 'o', 'r', 'm', 'a', 't', 'r', 'i', 'x', };
                if (WTF::equal(buffer.data() + 2, rest, 11)) {
                    return TagName::fecolormatrixCaseUnadjusted;
                }
                break;
            }
            case 'o': {
                switch (buffer[2]) {
                case 'n': {
                    switch (buffer[3]) {
                    case 't': {
                        switch (buffer[4]) {
                        case '-': {
                            switch (buffer[5]) {
                            case 'f': {
                                switch (buffer[6]) {
                                case 'a': {
                                    switch (buffer[7]) {
                                    case 'c': {
                                        switch (buffer[8]) {
                                        case 'e': {
                                            switch (buffer[9]) {
                                            case '-': {
                                                switch (buffer[10]) {
                                                case 's': {
                                                    static constexpr characterType rest[] = { 'r', 'c', };
                                                    if (WTF::equal(buffer.data() + 11, rest, 2)) {
                                                        return TagName::font_face_src;
                                                    }
                                                    break;
                                                }
                                                case 'u': {
                                                    static constexpr characterType rest[] = { 'r', 'i', };
                                                    if (WTF::equal(buffer.data() + 11, rest, 2)) {
                                                        return TagName::font_face_uri;
                                                    }
                                                    break;
                                                }
                                                default:
                                                    break;
                                                }
                                                return TagName::Unknown;
                                            }
                                            default:
                                                break;
                                            }
                                            return TagName::Unknown;
                                        }
                                        default:
                                            break;
                                        }
                                        return TagName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return TagName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return TagName::Unknown;
                            }
                            default:
                                break;
                            }
                            return TagName::Unknown;
                        }
                        default:
                            break;
                        }
                        return TagName::Unknown;
                    }
                    default:
                        break;
                    }
                    return TagName::Unknown;
                }
                case 'r': {
                    static constexpr characterType rest[] = { 'e', 'i', 'g', 'n', 'o', 'b', 'j', 'e', 'c', 't', };
                    if (WTF::equal(buffer.data() + 3, rest, 10)) {
                        return TagName::foreignobjectCaseUnadjusted;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'i': {
                static constexpr characterType rest[] = { 's', 's', 'i', 'n', 'g', '-', 'g', 'l', 'y', 'p', 'h', };
                if (WTF::equal(buffer.data() + 2, rest, 11)) {
                    return TagName::missing_glyph;
                }
                break;
            }
            case 'm': {
                static constexpr characterType rest[] = { 'u', 'l', 't', 'i', 's', 'c', 'r', 'i', 'p', 't', 's', };
                if (WTF::equal(buffer.data() + 2, rest, 11)) {
                    return TagName::mmultiscripts;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 14: {
        switch (buffer[0]) {
        case 'a': {
            static constexpr characterType rest[] = { 'n', 'n', 'o', 't', 'a', 't', 'i', 'o', 'n', '-', 'x', 'm', 'l', };
            if (WTF::equal(buffer.data() + 1, rest, 13)) {
                return TagName::annotation_xml;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'd': {
                    static constexpr characterType rest[] = { 'i', 's', 't', 'a', 'n', 't', 'l', 'i', 'g', 'h', 't', };
                    if (WTF::equal(buffer.data() + 3, rest, 11)) {
                        return TagName::fedistantlightCaseUnadjusted;
                    }
                    break;
                }
                case 'g': {
                    static constexpr characterType rest[] = { 'a', 'u', 's', 's', 'i', 'a', 'n', 'b', 'l', 'u', 'r', };
                    if (WTF::equal(buffer.data() + 3, rest, 11)) {
                        return TagName::fegaussianblurCaseUnadjusted;
                    }
                    break;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            case 'o': {
                static constexpr characterType rest[] = { 'n', 't', '-', 'f', 'a', 'c', 'e', '-', 'n', 'a', 'm', 'e', };
                if (WTF::equal(buffer.data() + 2, rest, 12)) {
                    return TagName::font_face_name;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        case 'l': {
            static constexpr characterType rest[] = { 'i', 'n', 'e', 'a', 'r', 'g', 'r', 'a', 'd', 'i', 'e', 'n', 't', };
            if (WTF::equal(buffer.data() + 1, rest, 13)) {
                return TagName::lineargradientCaseUnadjusted;
            }
            break;
        }
        case 'r': {
            static constexpr characterType rest[] = { 'a', 'd', 'i', 'a', 'l', 'g', 'r', 'a', 'd', 'i', 'e', 'n', 't', };
            if (WTF::equal(buffer.data() + 1, rest, 13)) {
                return TagName::radialgradientCaseUnadjusted;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 16: {
        switch (buffer[0]) {
        case 'a': {
            static constexpr characterType rest[] = { 'n', 'i', 'm', 'a', 't', 'e', 't', 'r', 'a', 'n', 's', 'f', 'o', 'r', 'm', };
            if (WTF::equal(buffer.data() + 1, rest, 15)) {
                return TagName::animatetransformCaseUnadjusted;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                static constexpr characterType rest[] = { 'c', 'o', 'n', 'v', 'o', 'l', 'v', 'e', 'm', 'a', 't', 'r', 'i', 'x', };
                if (WTF::equal(buffer.data() + 2, rest, 14)) {
                    return TagName::feconvolvematrixCaseUnadjusted;
                }
                break;
            }
            case 'o': {
                static constexpr characterType rest[] = { 'n', 't', '-', 'f', 'a', 'c', 'e', '-', 'f', 'o', 'r', 'm', 'a', 't', };
                if (WTF::equal(buffer.data() + 2, rest, 14)) {
                    return TagName::font_face_format;
                }
                break;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 17: {
        switch (buffer[0]) {
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'd': {
                    switch (buffer[3]) {
                    case 'i': {
                        switch (buffer[4]) {
                        case 'f': {
                            static constexpr characterType rest[] = { 'f', 'u', 's', 'e', 'l', 'i', 'g', 'h', 't', 'i', 'n', 'g', };
                            if (WTF::equal(buffer.data() + 5, rest, 12)) {
                                return TagName::fediffuselightingCaseUnadjusted;
                            }
                            break;
                        }
                        case 's': {
                            static constexpr characterType rest[] = { 'p', 'l', 'a', 'c', 'e', 'm', 'e', 'n', 't', 'm', 'a', 'p', };
                            if (WTF::equal(buffer.data() + 5, rest, 12)) {
                                return TagName::fedisplacementmapCaseUnadjusted;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return TagName::Unknown;
                    }
                    default:
                        break;
                    }
                    return TagName::Unknown;
                }
                default:
                    break;
                }
                return TagName::Unknown;
            }
            default:
                break;
            }
            return TagName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 18: {
        static constexpr characterType rest[] = { 'f', 'e', 's', 'p', 'e', 'c', 'u', 'l', 'a', 'r', 'l', 'i', 'g', 'h', 't', 'i', 'n', 'g', };
        if (WTF::equal(buffer.data(), rest, 18)) {
            return TagName::fespecularlightingCaseUnadjusted;
        }
        break;
    }
    case 19: {
        static constexpr characterType rest[] = { 'f', 'e', 'c', 'o', 'm', 'p', 'o', 'n', 'e', 'n', 't', 't', 'r', 'a', 'n', 's', 'f', 'e', 'r', };
        if (WTF::equal(buffer.data(), rest, 19)) {
            return TagName::fecomponenttransferCaseUnadjusted;
        }
        break;
    }
    default:
        break;
    };
    return TagName::Unknown;
}

TagName findTagName(std::span<const UChar> buffer)
{
    return findTagFromBuffer(buffer);
}

#if ASSERT_ENABLED
TagName findTagName(const String& name)
{
    if (name.is8Bit())
        return findTagFromBuffer(std::span(name.characters8(), name.length()));
    return findTagFromBuffer(std::span(name.characters16(), name.length()));
}
#endif

} // namespace WebCore
