/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebLockManagerSnapshot.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include "JSWebLockMode.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

template<> WebLockManagerSnapshot convertDictionary<WebLockManagerSnapshot>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebLockManagerSnapshot result;
    JSValue heldValue;
    if (isNullOrUndefined)
        heldValue = jsUndefined();
    else {
        heldValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "held"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!heldValue.isUndefined()) {
        result.held = convert<IDLSequence<IDLDictionary<WebLockManagerSnapshot::Info>>>(lexicalGlobalObject, heldValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue pendingValue;
    if (isNullOrUndefined)
        pendingValue = jsUndefined();
    else {
        pendingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pending"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!pendingValue.isUndefined()) {
        result.pending = convert<IDLSequence<IDLDictionary<WebLockManagerSnapshot::Info>>>(lexicalGlobalObject, pendingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const WebLockManagerSnapshot& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLSequence<IDLDictionary<WebLockManagerSnapshot::Info>>::isNullValue(dictionary.held)) {
        auto heldValue = toJS<IDLSequence<IDLDictionary<WebLockManagerSnapshot::Info>>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLDictionary<WebLockManagerSnapshot::Info>>::extractValueFromNullable(dictionary.held));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "held"_s), heldValue);
    }
    if (!IDLSequence<IDLDictionary<WebLockManagerSnapshot::Info>>::isNullValue(dictionary.pending)) {
        auto pendingValue = toJS<IDLSequence<IDLDictionary<WebLockManagerSnapshot::Info>>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLDictionary<WebLockManagerSnapshot::Info>>::extractValueFromNullable(dictionary.pending));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "pending"_s), pendingValue);
    }
    return result;
}

template<> WebLockManagerSnapshot::Info convertDictionary<WebLockManagerSnapshot::Info>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebLockManagerSnapshot::Info result;
    JSValue clientIdValue;
    if (isNullOrUndefined)
        clientIdValue = jsUndefined();
    else {
        clientIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clientId"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!clientIdValue.isUndefined()) {
        result.clientId = convert<IDLDOMString>(lexicalGlobalObject, clientIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue modeValue;
    if (isNullOrUndefined)
        modeValue = jsUndefined();
    else {
        modeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!modeValue.isUndefined()) {
        result.mode = convert<IDLEnumeration<WebLockMode>>(lexicalGlobalObject, modeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!nameValue.isUndefined()) {
        result.name = convert<IDLDOMString>(lexicalGlobalObject, nameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const WebLockManagerSnapshot::Info& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.clientId)) {
        auto clientIdValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.clientId));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "clientId"_s), clientIdValue);
    }
    if (!IDLEnumeration<WebLockMode>::isNullValue(dictionary.mode)) {
        auto modeValue = toJS<IDLEnumeration<WebLockMode>>(lexicalGlobalObject, throwScope, IDLEnumeration<WebLockMode>::extractValueFromNullable(dictionary.mode));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "mode"_s), modeValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.name)) {
        auto nameValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.name));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "name"_s), nameValue);
    }
    return result;
}

} // namespace WebCore
