/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLContextAttributes.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMGlobalObject.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGL)

template<> WebGLContextAttributes convertDictionary<WebGLContextAttributes>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebGLContextAttributes result;
    JSValue alphaValue;
    if (isNullOrUndefined)
        alphaValue = jsUndefined();
    else {
        alphaValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "alpha"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!alphaValue.isUndefined()) {
        result.alpha = convert<IDLBoolean>(lexicalGlobalObject, alphaValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.alpha = true;
    JSValue antialiasValue;
    if (isNullOrUndefined)
        antialiasValue = jsUndefined();
    else {
        antialiasValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "antialias"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!antialiasValue.isUndefined()) {
        result.antialias = convert<IDLBoolean>(lexicalGlobalObject, antialiasValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.antialias = true;
    JSValue depthValue;
    if (isNullOrUndefined)
        depthValue = jsUndefined();
    else {
        depthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depth"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!depthValue.isUndefined()) {
        result.depth = convert<IDLBoolean>(lexicalGlobalObject, depthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.depth = true;
    JSValue failIfMajorPerformanceCaveatValue;
    if (isNullOrUndefined)
        failIfMajorPerformanceCaveatValue = jsUndefined();
    else {
        failIfMajorPerformanceCaveatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "failIfMajorPerformanceCaveat"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!failIfMajorPerformanceCaveatValue.isUndefined()) {
        result.failIfMajorPerformanceCaveat = convert<IDLBoolean>(lexicalGlobalObject, failIfMajorPerformanceCaveatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.failIfMajorPerformanceCaveat = false;
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().domTestingAPIsEnabled) {
        JSValue failPlatformContextCreationForTestingValue;
        if (isNullOrUndefined)
            failPlatformContextCreationForTestingValue = jsUndefined();
        else {
            failPlatformContextCreationForTestingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "failPlatformContextCreationForTesting"_s));
            RETURN_IF_EXCEPTION(throwScope, { });
        }
        if (!failPlatformContextCreationForTestingValue.isUndefined()) {
            result.failPlatformContextCreationForTesting = convert<IDLBoolean>(lexicalGlobalObject, failPlatformContextCreationForTestingValue);
            RETURN_IF_EXCEPTION(throwScope, { });
        } else
            result.failPlatformContextCreationForTesting = false;
    }
    JSValue powerPreferenceValue;
    if (isNullOrUndefined)
        powerPreferenceValue = jsUndefined();
    else {
        powerPreferenceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "powerPreference"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!powerPreferenceValue.isUndefined()) {
        result.powerPreference = convert<IDLEnumeration<WebGLContextAttributes::PowerPreference>>(lexicalGlobalObject, powerPreferenceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.powerPreference = WebGLContextAttributes::PowerPreference::Default;
    JSValue premultipliedAlphaValue;
    if (isNullOrUndefined)
        premultipliedAlphaValue = jsUndefined();
    else {
        premultipliedAlphaValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "premultipliedAlpha"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!premultipliedAlphaValue.isUndefined()) {
        result.premultipliedAlpha = convert<IDLBoolean>(lexicalGlobalObject, premultipliedAlphaValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.premultipliedAlpha = true;
    JSValue preserveDrawingBufferValue;
    if (isNullOrUndefined)
        preserveDrawingBufferValue = jsUndefined();
    else {
        preserveDrawingBufferValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "preserveDrawingBuffer"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!preserveDrawingBufferValue.isUndefined()) {
        result.preserveDrawingBuffer = convert<IDLBoolean>(lexicalGlobalObject, preserveDrawingBufferValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.preserveDrawingBuffer = false;
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().domTestingAPIsEnabled) {
        JSValue remoteIPCBufferSizeLog2ForTestingValue;
        if (isNullOrUndefined)
            remoteIPCBufferSizeLog2ForTestingValue = jsUndefined();
        else {
            remoteIPCBufferSizeLog2ForTestingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "remoteIPCBufferSizeLog2ForTesting"_s));
            RETURN_IF_EXCEPTION(throwScope, { });
        }
        if (!remoteIPCBufferSizeLog2ForTestingValue.isUndefined()) {
            result.remoteIPCBufferSizeLog2ForTesting = convert<IDLUnsignedLong>(lexicalGlobalObject, remoteIPCBufferSizeLog2ForTestingValue);
            RETURN_IF_EXCEPTION(throwScope, { });
        } else
            result.remoteIPCBufferSizeLog2ForTesting = 0;
    }
    JSValue stencilValue;
    if (isNullOrUndefined)
        stencilValue = jsUndefined();
    else {
        stencilValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stencil"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!stencilValue.isUndefined()) {
        result.stencil = convert<IDLBoolean>(lexicalGlobalObject, stencilValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.stencil = false;
#if ENABLE(WEBXR)
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().webXREnabled) {
        JSValue xrCompatibleValue;
        if (isNullOrUndefined)
            xrCompatibleValue = jsUndefined();
        else {
            xrCompatibleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "xrCompatible"_s));
            RETURN_IF_EXCEPTION(throwScope, { });
        }
        if (!xrCompatibleValue.isUndefined()) {
            result.xrCompatible = convert<IDLBoolean>(lexicalGlobalObject, xrCompatibleValue);
            RETURN_IF_EXCEPTION(throwScope, { });
        } else
            result.xrCompatible = false;
    }
#endif
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const WebGLContextAttributes& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto alphaValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.alpha);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "alpha"_s), alphaValue);
    auto antialiasValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.antialias);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "antialias"_s), antialiasValue);
    auto depthValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.depth);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "depth"_s), depthValue);
    auto failIfMajorPerformanceCaveatValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.failIfMajorPerformanceCaveat);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "failIfMajorPerformanceCaveat"_s), failIfMajorPerformanceCaveatValue);
    if (jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext()->settingsValues().domTestingAPIsEnabled) {
        auto failPlatformContextCreationForTestingValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.failPlatformContextCreationForTesting);
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "failPlatformContextCreationForTesting"_s), failPlatformContextCreationForTestingValue);
    }
    auto powerPreferenceValue = toJS<IDLEnumeration<WebGLContextAttributes::PowerPreference>>(lexicalGlobalObject, throwScope, dictionary.powerPreference);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "powerPreference"_s), powerPreferenceValue);
    auto premultipliedAlphaValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.premultipliedAlpha);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "premultipliedAlpha"_s), premultipliedAlphaValue);
    auto preserveDrawingBufferValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.preserveDrawingBuffer);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "preserveDrawingBuffer"_s), preserveDrawingBufferValue);
    if (jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext()->settingsValues().domTestingAPIsEnabled) {
        auto remoteIPCBufferSizeLog2ForTestingValue = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, dictionary.remoteIPCBufferSizeLog2ForTesting);
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "remoteIPCBufferSizeLog2ForTesting"_s), remoteIPCBufferSizeLog2ForTestingValue);
    }
    auto stencilValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.stencil);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "stencil"_s), stencilValue);
#if ENABLE(WEBXR)
    if (jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext()->settingsValues().webXREnabled) {
        auto xrCompatibleValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.xrCompatible);
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "xrCompatible"_s), xrCompatibleValue);
    }
#endif
    return result;
}

#endif

String convertEnumerationToString(WebGLContextAttributes::PowerPreference enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("default"),
        MAKE_STATIC_STRING_IMPL("low-power"),
        MAKE_STATIC_STRING_IMPL("high-performance"),
    };
    static_assert(static_cast<size_t>(WebGLContextAttributes::PowerPreference::Default) == 0, "WebGLContextAttributes::PowerPreference::Default is not 0 as expected");
    static_assert(static_cast<size_t>(WebGLContextAttributes::PowerPreference::LowPower) == 1, "WebGLContextAttributes::PowerPreference::LowPower is not 1 as expected");
    static_assert(static_cast<size_t>(WebGLContextAttributes::PowerPreference::HighPerformance) == 2, "WebGLContextAttributes::PowerPreference::HighPerformance is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, WebGLContextAttributes::PowerPreference enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<WebGLContextAttributes::PowerPreference> parseEnumerationFromString<WebGLContextAttributes::PowerPreference>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, WebGLContextAttributes::PowerPreference> mappings[] = {
        { "default", WebGLContextAttributes::PowerPreference::Default },
        { "high-performance", WebGLContextAttributes::PowerPreference::HighPerformance },
        { "low-power", WebGLContextAttributes::PowerPreference::LowPower },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<WebGLContextAttributes::PowerPreference> parseEnumeration<WebGLContextAttributes::PowerPreference>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<WebGLContextAttributes::PowerPreference>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<WebGLContextAttributes::PowerPreference>()
{
    return "\"default\", \"low-power\", \"high-performance\"";
}

} // namespace WebCore

#endif // ENABLE(WEBGL)
