/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSVideoFrameMetadata.h"

#include "JSDOMConvertNumbers.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(VIDEO)

template<> VideoFrameMetadata convertDictionary<VideoFrameMetadata>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    VideoFrameMetadata result;
    JSValue captureTimeValue;
    if (isNullOrUndefined)
        captureTimeValue = jsUndefined();
    else {
        captureTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "captureTime"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!captureTimeValue.isUndefined()) {
        result.captureTime = convert<IDLDouble>(lexicalGlobalObject, captureTimeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue expectedDisplayTimeValue;
    if (isNullOrUndefined)
        expectedDisplayTimeValue = jsUndefined();
    else {
        expectedDisplayTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "expectedDisplayTime"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!expectedDisplayTimeValue.isUndefined()) {
        result.expectedDisplayTime = convert<IDLDouble>(lexicalGlobalObject, expectedDisplayTimeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "expectedDisplayTime", "VideoFrameMetadata", "double");
        return { };
    }
    JSValue heightValue;
    if (isNullOrUndefined)
        heightValue = jsUndefined();
    else {
        heightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "height"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!heightValue.isUndefined()) {
        result.height = convert<IDLUnsignedLong>(lexicalGlobalObject, heightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "height", "VideoFrameMetadata", "unsigned long");
        return { };
    }
    JSValue mediaTimeValue;
    if (isNullOrUndefined)
        mediaTimeValue = jsUndefined();
    else {
        mediaTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mediaTime"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!mediaTimeValue.isUndefined()) {
        result.mediaTime = convert<IDLDouble>(lexicalGlobalObject, mediaTimeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "mediaTime", "VideoFrameMetadata", "double");
        return { };
    }
    JSValue presentationTimeValue;
    if (isNullOrUndefined)
        presentationTimeValue = jsUndefined();
    else {
        presentationTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "presentationTime"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!presentationTimeValue.isUndefined()) {
        result.presentationTime = convert<IDLDouble>(lexicalGlobalObject, presentationTimeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "presentationTime", "VideoFrameMetadata", "double");
        return { };
    }
    JSValue presentedFramesValue;
    if (isNullOrUndefined)
        presentedFramesValue = jsUndefined();
    else {
        presentedFramesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "presentedFrames"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!presentedFramesValue.isUndefined()) {
        result.presentedFrames = convert<IDLUnsignedLong>(lexicalGlobalObject, presentedFramesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "presentedFrames", "VideoFrameMetadata", "unsigned long");
        return { };
    }
    JSValue processingDurationValue;
    if (isNullOrUndefined)
        processingDurationValue = jsUndefined();
    else {
        processingDurationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "processingDuration"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!processingDurationValue.isUndefined()) {
        result.processingDuration = convert<IDLDouble>(lexicalGlobalObject, processingDurationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue receiveTimeValue;
    if (isNullOrUndefined)
        receiveTimeValue = jsUndefined();
    else {
        receiveTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "receiveTime"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!receiveTimeValue.isUndefined()) {
        result.receiveTime = convert<IDLDouble>(lexicalGlobalObject, receiveTimeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue rtpTimestampValue;
    if (isNullOrUndefined)
        rtpTimestampValue = jsUndefined();
    else {
        rtpTimestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rtpTimestamp"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rtpTimestampValue.isUndefined()) {
        result.rtpTimestamp = convert<IDLUnsignedLong>(lexicalGlobalObject, rtpTimestampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue widthValue;
    if (isNullOrUndefined)
        widthValue = jsUndefined();
    else {
        widthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "width"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!widthValue.isUndefined()) {
        result.width = convert<IDLUnsignedLong>(lexicalGlobalObject, widthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "width", "VideoFrameMetadata", "unsigned long");
        return { };
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const VideoFrameMetadata& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDouble::isNullValue(dictionary.captureTime)) {
        auto captureTimeValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.captureTime));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "captureTime"_s), captureTimeValue);
    }
    auto expectedDisplayTimeValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, dictionary.expectedDisplayTime);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "expectedDisplayTime"_s), expectedDisplayTimeValue);
    auto heightValue = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, dictionary.height);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "height"_s), heightValue);
    auto mediaTimeValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, dictionary.mediaTime);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "mediaTime"_s), mediaTimeValue);
    auto presentationTimeValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, dictionary.presentationTime);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "presentationTime"_s), presentationTimeValue);
    auto presentedFramesValue = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, dictionary.presentedFrames);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "presentedFrames"_s), presentedFramesValue);
    if (!IDLDouble::isNullValue(dictionary.processingDuration)) {
        auto processingDurationValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.processingDuration));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "processingDuration"_s), processingDurationValue);
    }
    if (!IDLDouble::isNullValue(dictionary.receiveTime)) {
        auto receiveTimeValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.receiveTime));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "receiveTime"_s), receiveTimeValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.rtpTimestamp)) {
        auto rtpTimestampValue = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, IDLUnsignedLong::extractValueFromNullable(dictionary.rtpTimestamp));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "rtpTimestamp"_s), rtpTimestampValue);
    }
    auto widthValue = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, dictionary.width);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "width"_s), widthValue);
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(VIDEO)
