/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSValidityStateFlags.h"

#include "JSDOMConvertBoolean.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ValidityStateFlags convertDictionary<ValidityStateFlags>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    ValidityStateFlags result;
    JSValue badInputValue;
    if (isNullOrUndefined)
        badInputValue = jsUndefined();
    else {
        badInputValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "badInput"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!badInputValue.isUndefined()) {
        result.badInput = convert<IDLBoolean>(lexicalGlobalObject, badInputValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.badInput = false;
    JSValue customErrorValue;
    if (isNullOrUndefined)
        customErrorValue = jsUndefined();
    else {
        customErrorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "customError"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!customErrorValue.isUndefined()) {
        result.customError = convert<IDLBoolean>(lexicalGlobalObject, customErrorValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.customError = false;
    JSValue patternMismatchValue;
    if (isNullOrUndefined)
        patternMismatchValue = jsUndefined();
    else {
        patternMismatchValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "patternMismatch"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!patternMismatchValue.isUndefined()) {
        result.patternMismatch = convert<IDLBoolean>(lexicalGlobalObject, patternMismatchValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.patternMismatch = false;
    JSValue rangeOverflowValue;
    if (isNullOrUndefined)
        rangeOverflowValue = jsUndefined();
    else {
        rangeOverflowValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rangeOverflow"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rangeOverflowValue.isUndefined()) {
        result.rangeOverflow = convert<IDLBoolean>(lexicalGlobalObject, rangeOverflowValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.rangeOverflow = false;
    JSValue rangeUnderflowValue;
    if (isNullOrUndefined)
        rangeUnderflowValue = jsUndefined();
    else {
        rangeUnderflowValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rangeUnderflow"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rangeUnderflowValue.isUndefined()) {
        result.rangeUnderflow = convert<IDLBoolean>(lexicalGlobalObject, rangeUnderflowValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.rangeUnderflow = false;
    JSValue stepMismatchValue;
    if (isNullOrUndefined)
        stepMismatchValue = jsUndefined();
    else {
        stepMismatchValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stepMismatch"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!stepMismatchValue.isUndefined()) {
        result.stepMismatch = convert<IDLBoolean>(lexicalGlobalObject, stepMismatchValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.stepMismatch = false;
    JSValue tooLongValue;
    if (isNullOrUndefined)
        tooLongValue = jsUndefined();
    else {
        tooLongValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tooLong"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!tooLongValue.isUndefined()) {
        result.tooLong = convert<IDLBoolean>(lexicalGlobalObject, tooLongValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.tooLong = false;
    JSValue tooShortValue;
    if (isNullOrUndefined)
        tooShortValue = jsUndefined();
    else {
        tooShortValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tooShort"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!tooShortValue.isUndefined()) {
        result.tooShort = convert<IDLBoolean>(lexicalGlobalObject, tooShortValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.tooShort = false;
    JSValue typeMismatchValue;
    if (isNullOrUndefined)
        typeMismatchValue = jsUndefined();
    else {
        typeMismatchValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "typeMismatch"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeMismatchValue.isUndefined()) {
        result.typeMismatch = convert<IDLBoolean>(lexicalGlobalObject, typeMismatchValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.typeMismatch = false;
    JSValue valueMissingValue;
    if (isNullOrUndefined)
        valueMissingValue = jsUndefined();
    else {
        valueMissingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "valueMissing"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!valueMissingValue.isUndefined()) {
        result.valueMissing = convert<IDLBoolean>(lexicalGlobalObject, valueMissingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.valueMissing = false;
    return result;
}

} // namespace WebCore
