/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGAnimatedNumber.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGAnimatedNumberConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGAnimatedNumber_baseVal);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGAnimatedNumber_baseVal);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGAnimatedNumber_animVal);

class JSSVGAnimatedNumberPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGAnimatedNumberPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGAnimatedNumberPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGAnimatedNumberPrototype>(vm)) JSSVGAnimatedNumberPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGAnimatedNumberPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGAnimatedNumberPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGAnimatedNumberPrototype, JSSVGAnimatedNumberPrototype::Base);

using JSSVGAnimatedNumberDOMConstructor = JSDOMConstructorNotConstructable<JSSVGAnimatedNumber>;

template<> const ClassInfo JSSVGAnimatedNumberDOMConstructor::s_info = { "SVGAnimatedNumber"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGAnimatedNumberDOMConstructor) };

template<> JSValue JSSVGAnimatedNumberDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGAnimatedNumberDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGAnimatedNumber"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGAnimatedNumber::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedNumberPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGAnimatedNumberConstructor, 0 } },
    { "baseVal"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGAnimatedNumber_baseVal, setJSSVGAnimatedNumber_baseVal } },
    { "animVal"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGAnimatedNumber_animVal, 0 } },
};

const ClassInfo JSSVGAnimatedNumberPrototype::s_info = { "SVGAnimatedNumber"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGAnimatedNumberPrototype) };

void JSSVGAnimatedNumberPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGAnimatedNumber::info(), JSSVGAnimatedNumberPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGAnimatedNumber::s_info = { "SVGAnimatedNumber"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGAnimatedNumber) };

JSSVGAnimatedNumber::JSSVGAnimatedNumber(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGAnimatedNumber>&& impl)
    : JSDOMWrapper<SVGAnimatedNumber>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, SVGAnimatedNumber>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSVGAnimatedNumber::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGAnimatedNumberPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSSVGAnimatedNumberPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGAnimatedNumber::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGAnimatedNumber>(vm, globalObject);
}

JSValue JSSVGAnimatedNumber::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimatedNumberDOMConstructor, DOMConstructorID::SVGAnimatedNumber>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGAnimatedNumber::destroy(JSC::JSCell* cell)
{
    JSSVGAnimatedNumber* thisObject = static_cast<JSSVGAnimatedNumber*>(cell);
    thisObject->JSSVGAnimatedNumber::~JSSVGAnimatedNumber();
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGAnimatedNumberConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGAnimatedNumberPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGAnimatedNumber::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsSVGAnimatedNumber_baseValGetter(JSGlobalObject& lexicalGlobalObject, JSSVGAnimatedNumber& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.baseVal())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGAnimatedNumber_baseVal, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGAnimatedNumber>::get<jsSVGAnimatedNumber_baseValGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGAnimatedNumber_baseValSetter(JSGlobalObject& lexicalGlobalObject, JSSVGAnimatedNumber& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBaseVal(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGAnimatedNumber_baseVal, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGAnimatedNumber>::set<setJSSVGAnimatedNumber_baseValSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGAnimatedNumber_animValGetter(JSGlobalObject& lexicalGlobalObject, JSSVGAnimatedNumber& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.animVal())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGAnimatedNumber_animVal, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGAnimatedNumber>::get<jsSVGAnimatedNumber_animValGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSVGAnimatedNumber::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGAnimatedNumber, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGAnimatedNumber.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGAnimatedNumber = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGAnimatedNumber.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGAnimatedNumber = std::forward<decltype(space)>(space); }
    );
}

void JSSVGAnimatedNumber::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGAnimatedNumber*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSSVGAnimatedNumberOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSVGAnimatedNumberOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGAnimatedNumber = static_cast<JSSVGAnimatedNumber*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGAnimatedNumber->wrapped(), jsSVGAnimatedNumber);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SVGAnimatedNumber>&& impl)
{
    return createWrapper<SVGAnimatedNumber>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SVGAnimatedNumber& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SVGAnimatedNumber* JSSVGAnimatedNumber::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGAnimatedNumber*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
