/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSKeyframeEffect.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSCompositeOperation.h"
#include "JSCompositeOperationOrAuto.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "JSIterationCompositeOperation.h"
#include "JSKeyframeEffect.h"
#include "JSKeyframeEffectOptions.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> KeyframeEffect::BasePropertyIndexedKeyframe convertDictionary<KeyframeEffect::BasePropertyIndexedKeyframe>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    KeyframeEffect::BasePropertyIndexedKeyframe result;
    JSValue compositeValue;
    if (isNullOrUndefined)
        compositeValue = jsUndefined();
    else {
        compositeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composite"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!compositeValue.isUndefined()) {
        result.composite = convert<IDLUnion<IDLSequence<IDLEnumeration<CompositeOperationOrAuto>>, IDLEnumeration<CompositeOperationOrAuto>>>(lexicalGlobalObject, compositeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composite = Converter<IDLUnion<IDLSequence<IDLEnumeration<CompositeOperationOrAuto>>, IDLEnumeration<CompositeOperationOrAuto>>>::ReturnType{ };
    JSValue easingValue;
    if (isNullOrUndefined)
        easingValue = jsUndefined();
    else {
        easingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "easing"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!easingValue.isUndefined()) {
        result.easing = convert<IDLUnion<IDLSequence<IDLDOMString>, IDLDOMString>>(lexicalGlobalObject, easingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.easing = Converter<IDLUnion<IDLSequence<IDLDOMString>, IDLDOMString>>::ReturnType{ };
    JSValue offsetValue;
    if (isNullOrUndefined)
        offsetValue = jsUndefined();
    else {
        offsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "offset"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!offsetValue.isUndefined()) {
        result.offset = convert<IDLUnion<IDLNull, IDLSequence<IDLNullable<IDLDouble>>, IDLDouble>>(lexicalGlobalObject, offsetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.offset = Converter<IDLUnion<IDLNull, IDLSequence<IDLNullable<IDLDouble>>, IDLDouble>>::ReturnType{ };
    return result;
}

template<> KeyframeEffect::BaseKeyframe convertDictionary<KeyframeEffect::BaseKeyframe>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    KeyframeEffect::BaseKeyframe result;
    JSValue compositeValue;
    if (isNullOrUndefined)
        compositeValue = jsUndefined();
    else {
        compositeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composite"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!compositeValue.isUndefined()) {
        result.composite = convert<IDLEnumeration<CompositeOperationOrAuto>>(lexicalGlobalObject, compositeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composite = CompositeOperationOrAuto::Auto;
    JSValue easingValue;
    if (isNullOrUndefined)
        easingValue = jsUndefined();
    else {
        easingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "easing"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!easingValue.isUndefined()) {
        result.easing = convert<IDLDOMString>(lexicalGlobalObject, easingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.easing = "linear"_s;
    JSValue offsetValue;
    if (isNullOrUndefined)
        offsetValue = jsUndefined();
    else {
        offsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "offset"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!offsetValue.isUndefined()) {
        result.offset = convert<IDLNullable<IDLDouble>>(lexicalGlobalObject, offsetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.offset = std::nullopt;
    return result;
}

template<> KeyframeEffect::BaseComputedKeyframe convertDictionary<KeyframeEffect::BaseComputedKeyframe>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    KeyframeEffect::BaseComputedKeyframe result;
    JSValue compositeValue;
    if (isNullOrUndefined)
        compositeValue = jsUndefined();
    else {
        compositeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composite"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!compositeValue.isUndefined()) {
        result.composite = convert<IDLEnumeration<CompositeOperationOrAuto>>(lexicalGlobalObject, compositeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composite = CompositeOperationOrAuto::Auto;
    JSValue computedOffsetValue;
    if (isNullOrUndefined)
        computedOffsetValue = jsUndefined();
    else {
        computedOffsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "computedOffset"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!computedOffsetValue.isUndefined()) {
        result.computedOffset = convert<IDLDouble>(lexicalGlobalObject, computedOffsetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue easingValue;
    if (isNullOrUndefined)
        easingValue = jsUndefined();
    else {
        easingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "easing"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!easingValue.isUndefined()) {
        result.easing = convert<IDLDOMString>(lexicalGlobalObject, easingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.easing = "linear"_s;
    JSValue offsetValue;
    if (isNullOrUndefined)
        offsetValue = jsUndefined();
    else {
        offsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "offset"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!offsetValue.isUndefined()) {
        result.offset = convert<IDLNullable<IDLDouble>>(lexicalGlobalObject, offsetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.offset = std::nullopt;
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const KeyframeEffect::BaseComputedKeyframe& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto compositeValue = toJS<IDLEnumeration<CompositeOperationOrAuto>>(lexicalGlobalObject, throwScope, dictionary.composite);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "composite"_s), compositeValue);
    if (!IDLDouble::isNullValue(dictionary.computedOffset)) {
        auto computedOffsetValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.computedOffset));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "computedOffset"_s), computedOffsetValue);
    }
    auto easingValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.easing);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "easing"_s), easingValue);
    auto offsetValue = toJS<IDLNullable<IDLDouble>>(lexicalGlobalObject, throwScope, dictionary.offset);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "offset"_s), offsetValue);
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsKeyframeEffectPrototypeFunction_getKeyframes);
static JSC_DECLARE_HOST_FUNCTION(jsKeyframeEffectPrototypeFunction_setKeyframes);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsKeyframeEffectConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyframeEffect_target);
static JSC_DECLARE_CUSTOM_SETTER(setJSKeyframeEffect_target);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyframeEffect_pseudoElement);
static JSC_DECLARE_CUSTOM_SETTER(setJSKeyframeEffect_pseudoElement);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyframeEffect_iterationComposite);
static JSC_DECLARE_CUSTOM_SETTER(setJSKeyframeEffect_iterationComposite);
static JSC_DECLARE_CUSTOM_GETTER(jsKeyframeEffect_composite);
static JSC_DECLARE_CUSTOM_SETTER(setJSKeyframeEffect_composite);

class JSKeyframeEffectPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSKeyframeEffectPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSKeyframeEffectPrototype* ptr = new (NotNull, JSC::allocateCell<JSKeyframeEffectPrototype>(vm)) JSKeyframeEffectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSKeyframeEffectPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSKeyframeEffectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSKeyframeEffectPrototype, JSKeyframeEffectPrototype::Base);

using JSKeyframeEffectDOMConstructor = JSDOMConstructor<JSKeyframeEffect>;

static inline EncodedJSValue constructJSKeyframeEffect1(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSKeyframeEffectDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "KeyframeEffect");
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLNullable<IDLInterface<Element>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "target", "KeyframeEffect", nullptr, "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto keyframes = convert<IDLNullable<IDLObject>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto options = argument2.value().isUndefined() ? std::optional<Converter<IDLUnion<IDLUnrestrictedDouble, IDLDictionary<KeyframeEffectOptions>>>::ReturnType>() : std::optional<Converter<IDLUnion<IDLUnrestrictedDouble, IDLDictionary<KeyframeEffectOptions>>>::ReturnType>(convert<IDLUnion<IDLUnrestrictedDouble, IDLDictionary<KeyframeEffectOptions>>>(*lexicalGlobalObject, argument2.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = KeyframeEffect::create(*castedThis->globalObject(), document, WTFMove(target), WTFMove(keyframes), WTFMove(options));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<KeyframeEffect>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<KeyframeEffect>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}

static inline EncodedJSValue constructJSKeyframeEffect2(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSKeyframeEffectDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto source = convert<IDLInterface<KeyframeEffect>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "source", "KeyframeEffect", nullptr, "KeyframeEffect"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = KeyframeEffect::create(*source);
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<KeyframeEffect>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<KeyframeEffect>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSKeyframeEffectDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    size_t argsCount = std::min<size_t>(3, callFrame->argumentCount());
    if (argsCount == 1) {
        RELEASE_AND_RETURN(throwScope, (constructJSKeyframeEffect2(lexicalGlobalObject, callFrame)));
    }
    if (argsCount == 2) {
        RELEASE_AND_RETURN(throwScope, (constructJSKeyframeEffect1(lexicalGlobalObject, callFrame)));
    }
    if (argsCount == 3) {
        RELEASE_AND_RETURN(throwScope, (constructJSKeyframeEffect1(lexicalGlobalObject, callFrame)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}
JSC_ANNOTATE_HOST_FUNCTION(JSKeyframeEffectConstructorConstruct, JSKeyframeEffectDOMConstructor::construct);

template<> const ClassInfo JSKeyframeEffectDOMConstructor::s_info = { "KeyframeEffect"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSKeyframeEffectDOMConstructor) };

template<> JSValue JSKeyframeEffectDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAnimationEffect::getConstructor(vm, &globalObject);
}

template<> void JSKeyframeEffectDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "KeyframeEffect"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSKeyframeEffect::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSKeyframeEffectPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyframeEffectConstructor, 0 } },
    { "target"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyframeEffect_target, setJSKeyframeEffect_target } },
    { "pseudoElement"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyframeEffect_pseudoElement, setJSKeyframeEffect_pseudoElement } },
    { "iterationComposite"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyframeEffect_iterationComposite, setJSKeyframeEffect_iterationComposite } },
    { "composite"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsKeyframeEffect_composite, setJSKeyframeEffect_composite } },
    { "getKeyframes"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsKeyframeEffectPrototypeFunction_getKeyframes, 0 } },
    { "setKeyframes"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsKeyframeEffectPrototypeFunction_setKeyframes, 1 } },
};

const ClassInfo JSKeyframeEffectPrototype::s_info = { "KeyframeEffect"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSKeyframeEffectPrototype) };

void JSKeyframeEffectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSKeyframeEffect::info(), JSKeyframeEffectPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().webAnimationsIterationCompositeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "iterationComposite"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().webAnimationsCompositeOperationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "composite"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSKeyframeEffect::s_info = { "KeyframeEffect"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSKeyframeEffect) };

JSKeyframeEffect::JSKeyframeEffect(Structure* structure, JSDOMGlobalObject& globalObject, Ref<KeyframeEffect>&& impl)
    : JSAnimationEffect(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, KeyframeEffect>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSKeyframeEffect::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSKeyframeEffectPrototype::createStructure(vm, &globalObject, JSAnimationEffect::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSKeyframeEffectPrototype::create(vm, &globalObject, structure);
}

JSObject* JSKeyframeEffect::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSKeyframeEffect>(vm, globalObject);
}

JSValue JSKeyframeEffect::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSKeyframeEffectDOMConstructor, DOMConstructorID::KeyframeEffect>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyframeEffectConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSKeyframeEffectPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSKeyframeEffect::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsKeyframeEffect_targetGetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.target())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyframeEffect_target, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyframeEffect>::get<jsKeyframeEffect_targetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSKeyframeEffect_targetSetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "KeyframeEffect", "target", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setTarget(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSKeyframeEffect_target, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyframeEffect>::set<setJSKeyframeEffect_targetSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsKeyframeEffect_pseudoElementGetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.pseudoElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyframeEffect_pseudoElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyframeEffect>::get<jsKeyframeEffect_pseudoElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSKeyframeEffect_pseudoElementSetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLUSVString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPseudoElement(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSKeyframeEffect_pseudoElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyframeEffect>::set<setJSKeyframeEffect_pseudoElementSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsKeyframeEffect_iterationCompositeGetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<IterationCompositeOperation>>(lexicalGlobalObject, throwScope, impl.iterationComposite())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyframeEffect_iterationComposite, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyframeEffect>::get<jsKeyframeEffect_iterationCompositeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSKeyframeEffect_iterationCompositeSetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<IterationCompositeOperation>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setIterationComposite(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSKeyframeEffect_iterationComposite, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyframeEffect>::set<setJSKeyframeEffect_iterationCompositeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsKeyframeEffect_compositeGetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<CompositeOperation>>(lexicalGlobalObject, throwScope, impl.bindingsComposite())));
}

JSC_DEFINE_CUSTOM_GETTER(jsKeyframeEffect_composite, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyframeEffect>::get<jsKeyframeEffect_compositeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSKeyframeEffect_compositeSetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<CompositeOperation>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBindingsComposite(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSKeyframeEffect_composite, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSKeyframeEffect>::set<setJSKeyframeEffect_compositeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsKeyframeEffectPrototypeFunction_getKeyframesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSKeyframeEffect>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    RELEASE_AND_RETURN(throwScope, (JSValue::encode(castedThis->getKeyframes(*lexicalGlobalObject, *callFrame))));
}

JSC_DEFINE_HOST_FUNCTION(jsKeyframeEffectPrototypeFunction_getKeyframes, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSKeyframeEffect>::call<jsKeyframeEffectPrototypeFunction_getKeyframesBody>(*lexicalGlobalObject, *callFrame, "getKeyframes");
}

static inline JSC::EncodedJSValue jsKeyframeEffectPrototypeFunction_setKeyframesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSKeyframeEffect>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto keyframes = convert<IDLNullable<IDLObject>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setBindingsKeyframes(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), document, WTFMove(keyframes)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsKeyframeEffectPrototypeFunction_setKeyframes, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSKeyframeEffect>::call<jsKeyframeEffectPrototypeFunction_setKeyframesBody>(*lexicalGlobalObject, *callFrame, "setKeyframes");
}

JSC::GCClient::IsoSubspace* JSKeyframeEffect::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSKeyframeEffect, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForKeyframeEffect.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForKeyframeEffect = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForKeyframeEffect.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForKeyframeEffect = std::forward<decltype(space)>(space); }
    );
}

void JSKeyframeEffect::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSKeyframeEffect*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7KeyframeEffect@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14KeyframeEffectE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<KeyframeEffect>&& impl)
{

    if constexpr (std::is_polymorphic_v<KeyframeEffect>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7KeyframeEffect@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14KeyframeEffectE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // KeyframeEffect has subclasses. If KeyframeEffect has subclasses that get passed
        // to toJS() we currently require KeyframeEffect you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<KeyframeEffect>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, KeyframeEffect& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

KeyframeEffect* JSKeyframeEffect::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSKeyframeEffect*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
