/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInputEvent.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDataTransfer.h"
#include "JSStaticRange.h"
#include "JSWindowProxy.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> InputEvent::Init convertDictionary<InputEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    InputEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue detailValue;
    if (isNullOrUndefined)
        detailValue = jsUndefined();
    else {
        detailValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detail"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!detailValue.isUndefined()) {
        result.detail = convert<IDLLong>(lexicalGlobalObject, detailValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.detail = 0;
    JSValue viewValue;
    if (isNullOrUndefined)
        viewValue = jsUndefined();
    else {
        viewValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "view"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!viewValue.isUndefined()) {
        result.view = convert<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, viewValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.view = nullptr;
    JSValue dataValue;
    if (isNullOrUndefined)
        dataValue = jsUndefined();
    else {
        dataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "data"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dataValue.isUndefined()) {
        result.data = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, dataValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.data = String();
    JSValue inputTypeValue;
    if (isNullOrUndefined)
        inputTypeValue = jsUndefined();
    else {
        inputTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "inputType"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!inputTypeValue.isUndefined()) {
        result.inputType = convert<IDLDOMString>(lexicalGlobalObject, inputTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.inputType = emptyString();
    JSValue isComposingValue;
    if (isNullOrUndefined)
        isComposingValue = jsUndefined();
    else {
        isComposingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isComposing"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!isComposingValue.isUndefined()) {
        result.isComposing = convert<IDLBoolean>(lexicalGlobalObject, isComposingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.isComposing = false;
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsInputEventPrototypeFunction_getTargetRanges);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsInputEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsInputEvent_inputType);
static JSC_DECLARE_CUSTOM_GETTER(jsInputEvent_data);
static JSC_DECLARE_CUSTOM_GETTER(jsInputEvent_isComposing);
static JSC_DECLARE_CUSTOM_GETTER(jsInputEvent_dataTransfer);

class JSInputEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSInputEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSInputEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSInputEventPrototype>(vm)) JSInputEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSInputEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSInputEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSInputEventPrototype, JSInputEventPrototype::Base);

using JSInputEventDOMConstructor = JSDOMConstructor<JSInputEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSInputEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSInputEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto type = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto eventInitDict = convert<IDLDictionary<InputEvent::Init>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = InputEvent::create(WTFMove(type), WTFMove(eventInitDict));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<InputEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<InputEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSInputEventDOMConstructorConstruct, JSInputEventDOMConstructor::construct);

template<> const ClassInfo JSInputEventDOMConstructor::s_info = { "InputEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInputEventDOMConstructor) };

template<> JSValue JSInputEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSUIEvent::getConstructor(vm, &globalObject);
}

template<> void JSInputEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "InputEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSInputEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSInputEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsInputEventConstructor, 0 } },
    { "inputType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsInputEvent_inputType, 0 } },
    { "data"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsInputEvent_data, 0 } },
    { "isComposing"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsInputEvent_isComposing, 0 } },
    { "dataTransfer"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsInputEvent_dataTransfer, 0 } },
    { "getTargetRanges"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInputEventPrototypeFunction_getTargetRanges, 0 } },
};

const ClassInfo JSInputEventPrototype::s_info = { "InputEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInputEventPrototype) };

void JSInputEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSInputEvent::info(), JSInputEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSInputEvent::s_info = { "InputEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInputEvent) };

JSInputEvent::JSInputEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<InputEvent>&& impl)
    : JSUIEvent(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, InputEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSInputEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSInputEventPrototype::createStructure(vm, &globalObject, JSUIEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSInputEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSInputEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSInputEvent>(vm, globalObject);
}

JSValue JSInputEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSInputEventDOMConstructor, DOMConstructorID::InputEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsInputEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSInputEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSInputEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsInputEvent_inputTypeGetter(JSGlobalObject& lexicalGlobalObject, JSInputEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.inputType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsInputEvent_inputType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSInputEvent>::get<jsInputEvent_inputTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsInputEvent_dataGetter(JSGlobalObject& lexicalGlobalObject, JSInputEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.data())));
}

JSC_DEFINE_CUSTOM_GETTER(jsInputEvent_data, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSInputEvent>::get<jsInputEvent_dataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsInputEvent_isComposingGetter(JSGlobalObject& lexicalGlobalObject, JSInputEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isInputMethodComposing())));
}

JSC_DEFINE_CUSTOM_GETTER(jsInputEvent_isComposing, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSInputEvent>::get<jsInputEvent_isComposingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsInputEvent_dataTransferGetter(JSGlobalObject& lexicalGlobalObject, JSInputEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<DataTransfer>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.dataTransfer())));
}

JSC_DEFINE_CUSTOM_GETTER(jsInputEvent_dataTransfer, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSInputEvent>::get<jsInputEvent_dataTransferGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsInputEventPrototypeFunction_getTargetRangesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInputEvent>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLInterface<StaticRange>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getTargetRanges())));
}

JSC_DEFINE_HOST_FUNCTION(jsInputEventPrototypeFunction_getTargetRanges, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInputEvent>::call<jsInputEventPrototypeFunction_getTargetRangesBody>(*lexicalGlobalObject, *callFrame, "getTargetRanges");
}

JSC::GCClient::IsoSubspace* JSInputEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSInputEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForInputEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForInputEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForInputEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForInputEvent = std::forward<decltype(space)>(space); }
    );
}

void JSInputEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSInputEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7InputEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10InputEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<InputEvent>&& impl)
{

    if constexpr (std::is_polymorphic_v<InputEvent>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7InputEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore10InputEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // InputEvent has subclasses. If InputEvent has subclasses that get passed
        // to toJS() we currently require InputEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<InputEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, InputEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
