/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSImageData.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSImageDataSettings.h"
#include "JSPredefinedColorSpace.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsImageDataConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsImageData_width);
static JSC_DECLARE_CUSTOM_GETTER(jsImageData_height);
static JSC_DECLARE_CUSTOM_GETTER(jsImageData_data);
static JSC_DECLARE_CUSTOM_GETTER(jsImageData_colorSpace);

class JSImageDataPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSImageDataPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSImageDataPrototype* ptr = new (NotNull, JSC::allocateCell<JSImageDataPrototype>(vm)) JSImageDataPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSImageDataPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSImageDataPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSImageDataPrototype, JSImageDataPrototype::Base);

using JSImageDataDOMConstructor = JSDOMConstructor<JSImageData>;

static inline EncodedJSValue constructJSImageData1(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSImageDataDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto sw = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto sh = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto settings = convert<IDLDictionary<ImageDataSettings>>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = ImageData::create(WTFMove(sw), WTFMove(sh), WTFMove(settings));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<ImageData>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<ImageData>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}

static inline EncodedJSValue constructJSImageData2(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSImageDataDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto data = convert<IDLUint8ClampedArray>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "data", "ImageData", nullptr, "Uint8ClampedArray"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto sw = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto sh = argument2.value().isUndefined() ? std::optional<Converter<IDLUnsignedLong>::ReturnType>() : std::optional<Converter<IDLUnsignedLong>::ReturnType>(convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto settings = convert<IDLDictionary<ImageDataSettings>>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = ImageData::create(data.releaseNonNull(), WTFMove(sw), WTFMove(sh), WTFMove(settings));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<ImageData>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<ImageData>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSImageDataDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    size_t argsCount = std::min<size_t>(4, callFrame->argumentCount());
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSUint8ClampedArray>())
            RELEASE_AND_RETURN(throwScope, (constructJSImageData2(lexicalGlobalObject, callFrame)));
        if (distinguishingArg.isNumber())
            RELEASE_AND_RETURN(throwScope, (constructJSImageData1(lexicalGlobalObject, callFrame)));
        RELEASE_AND_RETURN(throwScope, (constructJSImageData1(lexicalGlobalObject, callFrame)));
    }
    if (argsCount == 3) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSUint8ClampedArray>())
            RELEASE_AND_RETURN(throwScope, (constructJSImageData2(lexicalGlobalObject, callFrame)));
        if (distinguishingArg.isNumber())
            RELEASE_AND_RETURN(throwScope, (constructJSImageData1(lexicalGlobalObject, callFrame)));
        RELEASE_AND_RETURN(throwScope, (constructJSImageData1(lexicalGlobalObject, callFrame)));
    }
    if (argsCount == 4) {
        RELEASE_AND_RETURN(throwScope, (constructJSImageData2(lexicalGlobalObject, callFrame)));
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}
JSC_ANNOTATE_HOST_FUNCTION(JSImageDataConstructorConstruct, JSImageDataDOMConstructor::construct);

template<> const ClassInfo JSImageDataDOMConstructor::s_info = { "ImageData"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSImageDataDOMConstructor) };

template<> JSValue JSImageDataDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSImageDataDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ImageData"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSImageData::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSImageDataPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsImageDataConstructor, 0 } },
    { "width"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsImageData_width, 0 } },
    { "height"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsImageData_height, 0 } },
    { "data"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsImageData_data, 0 } },
    { "colorSpace"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsImageData_colorSpace, 0 } },
};

const ClassInfo JSImageDataPrototype::s_info = { "ImageData"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSImageDataPrototype) };

void JSImageDataPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSImageData::info(), JSImageDataPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().canvasColorSpaceEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "colorSpace"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSImageData::s_info = { "ImageData"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSImageData) };

JSImageData::JSImageData(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ImageData>&& impl)
    : JSDOMWrapper<ImageData>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, ImageData>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSImageData::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSImageDataPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSImageDataPrototype::create(vm, &globalObject, structure);
}

JSObject* JSImageData::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSImageData>(vm, globalObject);
}

JSValue JSImageData::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSImageDataDOMConstructor, DOMConstructorID::ImageData>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSImageData::destroy(JSC::JSCell* cell)
{
    JSImageData* thisObject = static_cast<JSImageData*>(cell);
    thisObject->JSImageData::~JSImageData();
}

JSC_DEFINE_CUSTOM_GETTER(jsImageDataConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSImageDataPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSImageData::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsImageData_widthGetter(JSGlobalObject& lexicalGlobalObject, JSImageData& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.width())));
}

JSC_DEFINE_CUSTOM_GETTER(jsImageData_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSImageData>::get<jsImageData_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsImageData_heightGetter(JSGlobalObject& lexicalGlobalObject, JSImageData& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.height())));
}

JSC_DEFINE_CUSTOM_GETTER(jsImageData_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSImageData>::get<jsImageData_heightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsImageData_dataGetter(JSGlobalObject& lexicalGlobalObject, JSImageData& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUint8ClampedArray>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.data())));
}

JSC_DEFINE_CUSTOM_GETTER(jsImageData_data, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSImageData>::get<jsImageData_dataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsImageData_colorSpaceGetter(JSGlobalObject& lexicalGlobalObject, JSImageData& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<PredefinedColorSpace>>(lexicalGlobalObject, throwScope, impl.colorSpace())));
}

JSC_DEFINE_CUSTOM_GETTER(jsImageData_colorSpace, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSImageData>::get<jsImageData_colorSpaceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSImageData::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSImageData, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForImageData.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForImageData = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForImageData.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForImageData = std::forward<decltype(space)>(space); }
    );
}

void JSImageData::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSImageData*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSImageDataOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSImageDataOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsImageData = static_cast<JSImageData*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsImageData->wrapped(), jsImageData);
}

ImageData* JSImageData::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSImageData*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
