/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUVertexStepMode.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUVertexStepMode enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("vertex"),
        MAKE_STATIC_STRING_IMPL("instance"),
    };
    static_assert(static_cast<size_t>(GPUVertexStepMode::Vertex) == 0, "GPUVertexStepMode::Vertex is not 0 as expected");
    static_assert(static_cast<size_t>(GPUVertexStepMode::Instance) == 1, "GPUVertexStepMode::Instance is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GPUVertexStepMode enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GPUVertexStepMode> parseEnumerationFromString<GPUVertexStepMode>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, GPUVertexStepMode> mappings[] = {
        { "instance", GPUVertexStepMode::Instance },
        { "vertex", GPUVertexStepMode::Vertex },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GPUVertexStepMode> parseEnumeration<GPUVertexStepMode>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GPUVertexStepMode>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<GPUVertexStepMode>()
{
    return "\"vertex\", \"instance\"";
}

} // namespace WebCore
