/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPURenderPassLayout.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSGPUTextureFormat.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPURenderPassLayout convertDictionary<GPURenderPassLayout>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPURenderPassLayout result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!labelValue.isUndefined()) {
        result.label = convert<IDLUSVString>(lexicalGlobalObject, labelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue colorFormatsValue;
    if (isNullOrUndefined)
        colorFormatsValue = jsUndefined();
    else {
        colorFormatsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "colorFormats"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!colorFormatsValue.isUndefined()) {
        result.colorFormats = convert<IDLSequence<IDLNullable<IDLEnumeration<GPUTextureFormat>>>>(lexicalGlobalObject, colorFormatsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "colorFormats", "GPURenderPassLayout", "sequence");
        return { };
    }
    JSValue depthStencilFormatValue;
    if (isNullOrUndefined)
        depthStencilFormatValue = jsUndefined();
    else {
        depthStencilFormatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthStencilFormat"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!depthStencilFormatValue.isUndefined()) {
        result.depthStencilFormat = convert<IDLEnumeration<GPUTextureFormat>>(lexicalGlobalObject, depthStencilFormatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sampleCountValue;
    if (isNullOrUndefined)
        sampleCountValue = jsUndefined();
    else {
        sampleCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleCount"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleCountValue.isUndefined()) {
        result.sampleCount = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, sampleCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.sampleCount = 1;
    return result;
}

} // namespace WebCore
