/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTColorBufferFloat.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSEXTColorBufferFloatPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTColorBufferFloatPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTColorBufferFloatPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTColorBufferFloatPrototype>(vm)) JSEXTColorBufferFloatPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTColorBufferFloatPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTColorBufferFloatPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTColorBufferFloatPrototype, JSEXTColorBufferFloatPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSEXTColorBufferFloatPrototype::s_info = { "EXTColorBufferFloat"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTColorBufferFloatPrototype) };

void JSEXTColorBufferFloatPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSEXTColorBufferFloat::s_info = { "EXTColorBufferFloat"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTColorBufferFloat) };

JSEXTColorBufferFloat::JSEXTColorBufferFloat(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTColorBufferFloat>&& impl)
    : JSDOMWrapper<EXTColorBufferFloat>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, EXTColorBufferFloat>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSEXTColorBufferFloat::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSEXTColorBufferFloatPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSEXTColorBufferFloatPrototype::create(vm, &globalObject, structure);
}

JSObject* JSEXTColorBufferFloat::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTColorBufferFloat>(vm, globalObject);
}

void JSEXTColorBufferFloat::destroy(JSC::JSCell* cell)
{
    JSEXTColorBufferFloat* thisObject = static_cast<JSEXTColorBufferFloat*>(cell);
    thisObject->JSEXTColorBufferFloat::~JSEXTColorBufferFloat();
}

JSC::GCClient::IsoSubspace* JSEXTColorBufferFloat::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSEXTColorBufferFloat, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForEXTColorBufferFloat.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForEXTColorBufferFloat = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForEXTColorBufferFloat.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForEXTColorBufferFloat = std::forward<decltype(space)>(space); }
    );
}

void JSEXTColorBufferFloat::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTColorBufferFloat*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTColorBufferFloatOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsEXTColorBufferFloat = jsCast<JSEXTColorBufferFloat*>(handle.slot()->asCell());
    WebGLRenderingContextBase* owner = WTF::getPtr(jsEXTColorBufferFloat->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from EXTColorBufferFloat";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSEXTColorBufferFloatOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTColorBufferFloat = static_cast<JSEXTColorBufferFloat*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsEXTColorBufferFloat->wrapped(), jsEXTColorBufferFloat);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTColorBufferFloat@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19EXTColorBufferFloatE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTColorBufferFloat>&& impl)
{

    if constexpr (std::is_polymorphic_v<EXTColorBufferFloat>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7EXTColorBufferFloat@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore19EXTColorBufferFloatE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // EXTColorBufferFloat has subclasses. If EXTColorBufferFloat has subclasses that get passed
        // to toJS() we currently require EXTColorBufferFloat you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<EXTColorBufferFloat>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTColorBufferFloat& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTColorBufferFloat* JSEXTColorBufferFloat::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTColorBufferFloat*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
