/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSContactInfo.h"

#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

template<> ContactInfo convertDictionary<ContactInfo>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    ContactInfo result;
    JSValue emailValue;
    if (isNullOrUndefined)
        emailValue = jsUndefined();
    else {
        emailValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "email"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!emailValue.isUndefined()) {
        result.email = convert<IDLSequence<IDLUSVString>>(lexicalGlobalObject, emailValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!nameValue.isUndefined()) {
        result.name = convert<IDLSequence<IDLUSVString>>(lexicalGlobalObject, nameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue telValue;
    if (isNullOrUndefined)
        telValue = jsUndefined();
    else {
        telValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tel"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!telValue.isUndefined()) {
        result.tel = convert<IDLSequence<IDLUSVString>>(lexicalGlobalObject, telValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const ContactInfo& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLSequence<IDLUSVString>::isNullValue(dictionary.email)) {
        auto emailValue = toJS<IDLSequence<IDLUSVString>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLUSVString>::extractValueFromNullable(dictionary.email));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "email"_s), emailValue);
    }
    if (!IDLSequence<IDLUSVString>::isNullValue(dictionary.name)) {
        auto nameValue = toJS<IDLSequence<IDLUSVString>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLUSVString>::extractValueFromNullable(dictionary.name));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "name"_s), nameValue);
    }
    if (!IDLSequence<IDLUSVString>::isNullValue(dictionary.tel)) {
        auto telValue = toJS<IDLSequence<IDLUSVString>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLUSVString>::extractValueFromNullable(dictionary.tel));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "tel"_s), telValue);
    }
    return result;
}

} // namespace WebCore
