/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSBarProp.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsBarPropConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsBarProp_visible);

class JSBarPropPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSBarPropPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSBarPropPrototype* ptr = new (NotNull, JSC::allocateCell<JSBarPropPrototype>(vm)) JSBarPropPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBarPropPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSBarPropPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBarPropPrototype, JSBarPropPrototype::Base);

using JSBarPropDOMConstructor = JSDOMConstructorNotConstructable<JSBarProp>;

template<> const ClassInfo JSBarPropDOMConstructor::s_info = { "BarProp"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBarPropDOMConstructor) };

template<> JSValue JSBarPropDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSBarPropDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "BarProp"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSBarProp::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSBarPropPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsBarPropConstructor, 0 } },
    { "visible"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBarProp_visible, 0 } },
};

const ClassInfo JSBarPropPrototype::s_info = { "BarProp"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBarPropPrototype) };

void JSBarPropPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSBarProp::info(), JSBarPropPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSBarProp::s_info = { "BarProp"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBarProp) };

JSBarProp::JSBarProp(Structure* structure, JSDOMGlobalObject& globalObject, Ref<BarProp>&& impl)
    : JSDOMWrapper<BarProp>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, BarProp>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSBarProp::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSBarPropPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSBarPropPrototype::create(vm, &globalObject, structure);
}

JSObject* JSBarProp::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSBarProp>(vm, globalObject);
}

JSValue JSBarProp::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSBarPropDOMConstructor, DOMConstructorID::BarProp>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSBarProp::destroy(JSC::JSCell* cell)
{
    JSBarProp* thisObject = static_cast<JSBarProp*>(cell);
    thisObject->JSBarProp::~JSBarProp();
}

JSC_DEFINE_CUSTOM_GETTER(jsBarPropConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSBarPropPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSBarProp::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsBarProp_visibleGetter(JSGlobalObject& lexicalGlobalObject, JSBarProp& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.visible())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBarProp_visible, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBarProp>::get<jsBarProp_visibleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSBarProp::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSBarProp, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForBarProp.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForBarProp = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForBarProp.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForBarProp = std::forward<decltype(space)>(space); }
    );
}

void JSBarProp::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSBarProp*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSBarPropOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsBarProp = jsCast<JSBarProp*>(handle.slot()->asCell());
    auto* owner = WTF::getPtr(jsBarProp->wrapped().window());
    if (!owner)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from Window";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSBarPropOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsBarProp = static_cast<JSBarProp*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsBarProp->wrapped(), jsBarProp);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7BarProp@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore7BarPropE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<BarProp>&& impl)
{

    if constexpr (std::is_polymorphic_v<BarProp>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7BarProp@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore7BarPropE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // BarProp has subclasses. If BarProp has subclasses that get passed
        // to toJS() we currently require BarProp you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<BarProp>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, BarProp& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

BarProp* JSBarProp::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSBarProp*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
