/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSAudioConfiguration.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

template<> AudioConfiguration convertDictionary<AudioConfiguration>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    AudioConfiguration result;
    JSValue bitrateValue;
    if (isNullOrUndefined)
        bitrateValue = jsUndefined();
    else {
        bitrateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bitrate"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bitrateValue.isUndefined()) {
        result.bitrate = convert<IDLUnsignedLongLong>(lexicalGlobalObject, bitrateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue channelsValue;
    if (isNullOrUndefined)
        channelsValue = jsUndefined();
    else {
        channelsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channels"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelsValue.isUndefined()) {
        result.channels = convert<IDLDOMString>(lexicalGlobalObject, channelsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue contentTypeValue;
    if (isNullOrUndefined)
        contentTypeValue = jsUndefined();
    else {
        contentTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "contentType"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!contentTypeValue.isUndefined()) {
        result.contentType = convert<IDLDOMString>(lexicalGlobalObject, contentTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "contentType", "AudioConfiguration", "DOMString");
        return { };
    }
    JSValue samplerateValue;
    if (isNullOrUndefined)
        samplerateValue = jsUndefined();
    else {
        samplerateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "samplerate"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!samplerateValue.isUndefined()) {
        result.samplerate = convert<IDLUnsignedLong>(lexicalGlobalObject, samplerateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue spatialRenderingValue;
    if (isNullOrUndefined)
        spatialRenderingValue = jsUndefined();
    else {
        spatialRenderingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "spatialRendering"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!spatialRenderingValue.isUndefined()) {
        result.spatialRendering = convert<IDLBoolean>(lexicalGlobalObject, spatialRenderingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const AudioConfiguration& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLUnsignedLongLong::isNullValue(dictionary.bitrate)) {
        auto bitrateValue = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, IDLUnsignedLongLong::extractValueFromNullable(dictionary.bitrate));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "bitrate"_s), bitrateValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.channels)) {
        auto channelsValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.channels));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "channels"_s), channelsValue);
    }
    auto contentTypeValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.contentType);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "contentType"_s), contentTypeValue);
    if (!IDLUnsignedLong::isNullValue(dictionary.samplerate)) {
        auto samplerateValue = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, IDLUnsignedLong::extractValueFromNullable(dictionary.samplerate));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "samplerate"_s), samplerateValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.spatialRendering)) {
        auto spatialRenderingValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, IDLBoolean::extractValueFromNullable(dictionary.spatialRendering));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "spatialRendering"_s), spatialRenderingValue);
    }
    return result;
}

} // namespace WebCore
