#include <gio/gio.h>

#if defined (__ELF__) && ( __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 6))
# define SECTION __attribute__ ((section (".gresource.gth"), aligned (8)))
#else
# define SECTION
#endif

static const SECTION union { const guint8 data[1073]; const double alignment; void * const ptr;}  gth_resource_data = {
  "\107\126\141\162\151\141\156\164\000\000\000\000\000\000\000\000"
  "\030\000\000\000\000\001\000\000\000\000\000\050\010\000\000\000"
  "\000\000\000\000\001\000\000\000\002\000\000\000\004\000\000\000"
  "\005\000\000\000\006\000\000\000\006\000\000\000\007\000\000\000"
  "\260\267\044\060\004\000\000\000\000\001\000\000\006\000\114\000"
  "\010\001\000\000\014\001\000\000\251\051\023\250\006\000\000\000"
  "\014\001\000\000\015\000\114\000\034\001\000\000\040\001\000\000"
  "\222\130\365\340\001\000\000\000\040\001\000\000\005\000\114\000"
  "\050\001\000\000\054\001\000\000\022\055\022\125\007\000\000\000"
  "\054\001\000\000\024\000\166\000\100\001\000\000\011\004\000\000"
  "\113\120\220\013\005\000\000\000\011\004\000\000\004\000\114\000"
  "\020\004\000\000\024\004\000\000\324\265\002\000\377\377\377\377"
  "\024\004\000\000\001\000\114\000\030\004\000\000\034\004\000\000"
  "\146\361\116\140\000\000\000\000\034\004\000\000\007\000\114\000"
  "\044\004\000\000\050\004\000\000\277\146\150\151\002\000\000\000"
  "\050\004\000\000\003\000\114\000\054\004\000\000\060\004\000\000"
  "\147\156\157\155\145\057\000\000\006\000\000\000\151\155\141\147"
  "\145\137\166\151\145\167\145\162\057\000\000\000\002\000\000\000"
  "\144\141\164\141\057\000\000\000\007\000\000\000\164\157\157\154"
  "\142\141\162\055\172\157\157\155\055\155\145\156\165\056\165\151"
  "\261\034\000\000\001\000\000\000\170\332\355\231\337\157\332\060"
  "\020\307\337\373\127\104\226\246\076\121\102\253\116\233\004\251"
  "\332\111\355\123\245\111\353\264\307\310\070\007\161\161\354\314"
  "\276\360\243\177\375\056\141\210\000\051\015\124\125\320\226\067"
  "\022\373\173\167\174\077\027\073\230\376\315\074\121\336\024\254"
  "\223\106\017\130\357\302\147\036\150\141\042\251\307\003\366\363"
  "\351\276\363\205\335\004\147\175\251\021\354\210\013\010\316\074"
  "\257\157\206\317\040\320\023\212\073\347\015\330\003\116\276\233"
  "\324\120\224\107\320\031\363\144\064\140\150\271\166\051\267\024"
  "\154\021\246\313\121\226\213\111\056\142\251\242\345\347\255\140"
  "\105\254\073\063\147\253\121\032\117\255\111\301\342\302\323\074"
  "\201\001\233\112\047\207\012\130\360\144\063\350\167\127\243\257"
  "\013\004\327\341\310\210\314\261\340\236\053\127\113\063\064\066"
  "\002\033\316\144\204\061\013\276\326\221\030\053\101\043\107\362"
  "\221\005\364\145\121\012\256\352\010\213\044\241\205\337\031\070"
  "\144\301\245\357\127\252\066\114\253\066\356\321\104\240\356\062"
  "\304\274\204\322\314\043\114\174\303\310\103\144\010\163\144\136"
  "\321\017\212\043\247\264\003\266\000\012\362\055\006\061\001\013"
  "\121\335\110\134\344\356\166\362\013\026\314\244\276\050\067\131"
  "\307\341\102\301\201\241\220\333\061\220\351\347\142\125\313\171"
  "\165\204\176\167\351\166\011\110\167\213\310\077\110\350\127\054"
  "\021\116\200\316\054\257\243\045\123\042\363\140\371\342\004\300"
  "\214\251\214\226\113\211\313\235\342\142\162\002\140\206\171\035"
  "\307\222\331\234\120\032\054\017\324\171\011\170\061\046\151\067"
  "\377\166\363\257\170\120\156\063\064\011\031\046\216\176\130\144"
  "\302\307\320\311\133\354\330\207\204\257\152\150\227\260\022\231"
  "\173\211\036\032\217\054\216\314\254\101\072\043\211\055\227\052"
  "\056\264\142\064\213\245\123\324\320\302\331\205\023\203\034\307"
  "\330\060\235\145\021\037\213\347\007\320\153\012\107\143\077\002"
  "\316\306\156\032\323\325\213\241\113\125\127\236\220\031\222\074"
  "\061\051\013\076\037\050\032\032\352\270\344\125\335\377\331\334"
  "\327\376\247\006\133\372\332\157\127\232\022\214\236\337\050\015"
  "\112\337\342\050\341\270\154\026\307\145\213\143\003\307\125\263"
  "\070\256\076\032\107\273\357\276\313\075\372\125\016\245\243\011"
  "\005\123\120\241\053\356\236\116\163\107\226\317\302\051\127\031"
  "\354\071\264\250\022\306\334\205\104\215\374\074\120\310\243\347"
  "\314\141\102\360\131\120\030\263\276\121\067\204\065\231\216\302"
  "\210\222\043\175\135\277\266\014\034\132\051\060\104\023\216\244"
  "\122\113\044\173\313\337\355\205\074\054\027\023\251\307\373\223"
  "\301\074\345\072\072\014\106\136\324\076\005\335\335\116\375\356"
  "\323\264\242\127\157\327\114\326\015\133\006\165\126\125\256\062"
  "\263\374\250\155\307\377\355\171\131\232\346\363\172\376\233\063"
  "\035\102\032\112\055\054\054\323\366\336\022\244\264\210\036\044"
  "\370\333\352\133\363\326\356\364\273\245\177\037\377\000\164\022"
  "\311\347\000\050\165\165\141\171\051\157\162\147\057\000\000\000"
  "\000\000\000\000\057\000\000\000\004\000\000\000\147\124\150\165"
  "\155\142\057\000\001\000\000\000\165\151\057\000\003\000\000\000"
  "" };

static GStaticResource static_resource = { gth_resource_data.data, sizeof (gth_resource_data.data) - 1 /* nul terminator */, NULL, NULL, NULL };

G_GNUC_INTERNAL
GResource *gth_get_resource (void);
GResource *gth_get_resource (void)
{
  return g_static_resource_get_resource (&static_resource);
}
/* GLIB - Library of useful routines for C programming
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GLib Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GLib Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GLib at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __G_CONSTRUCTOR_H__
#define __G_CONSTRUCTOR_H__

/*
  If G_HAS_CONSTRUCTORS is true then the compiler support *both* constructors and
  destructors, in a usable way, including e.g. on library unload. If not you're on
  your own.

  Some compilers need #pragma to handle this, which does not work with macros,
  so the way you need to use this is (for constructors):

  #ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
  #pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(my_constructor)
  #endif
  G_DEFINE_CONSTRUCTOR(my_constructor)
  static void my_constructor(void) {
   ...
  }

*/

#ifndef __GTK_DOC_IGNORE__

#if  __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7)

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR(_func) static void __attribute__((constructor)) _func (void);
#define G_DEFINE_DESTRUCTOR(_func) static void __attribute__((destructor)) _func (void);

#elif defined (_MSC_VER) && (_MSC_VER >= 1500)
/* Visual studio 2008 and later has _Pragma */

/*
 * Only try to include gslist.h if not already included via glib.h,
 * so that items using gconstructor.h outside of GLib (such as
 * GResources) continue to build properly.
 */
#ifndef __G_LIB_H__
#include "gslist.h"
#endif

#include <stdlib.h>

#define G_HAS_CONSTRUCTORS 1

/* We do some weird things to avoid the constructors being optimized
 * away on VS2015 if WholeProgramOptimization is enabled. First we
 * make a reference to the array from the wrapper to make sure its
 * references. Then we use a pragma to make sure the wrapper function
 * symbol is always included at the link stage. Also, the symbols
 * need to be extern (but not dllexport), even though they are not
 * really used from another object file.
 */

/* We need to account for differences between the mangling of symbols
 * for x86 and x64/ARM/ARM64 programs, as symbols on x86 are prefixed
 * with an underscore but symbols on x64/ARM/ARM64 are not.
 */
#ifdef _M_IX86
#define G_MSVC_SYMBOL_PREFIX "_"
#else
#define G_MSVC_SYMBOL_PREFIX ""
#endif

#define G_DEFINE_CONSTRUCTOR(_func) G_MSVC_CTOR (_func, G_MSVC_SYMBOL_PREFIX)
#define G_DEFINE_DESTRUCTOR(_func) G_MSVC_DTOR (_func, G_MSVC_SYMBOL_PREFIX)

#define G_MSVC_CTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _wrapper(void);              \
  int _func ## _wrapper(void) { _func(); g_slist_find (NULL,  _array ## _func); return 0; } \
  __pragma(comment(linker,"/include:" _sym_prefix # _func "_wrapper")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _wrapper;

#define G_MSVC_DTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _constructor(void);              \
  int _func ## _constructor(void) { atexit (_func); g_slist_find (NULL,  _array ## _func); return 0; } \
   __pragma(comment(linker,"/include:" _sym_prefix # _func "_constructor")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _constructor;

#elif defined (_MSC_VER)

#define G_HAS_CONSTRUCTORS 1

/* Pre Visual studio 2008 must use #pragma section */
#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _wrapper(void) { _func(); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (*p)(void) = _func ## _wrapper;

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _constructor(void) { atexit (_func); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (* _array ## _func)(void) = _func ## _constructor;

#elif defined(__SUNPRO_C)

/* This is not tested, but i believe it should work, based on:
 * http://opensource.apple.com/source/OpenSSL098/OpenSSL098-35/src/fips/fips_premain.c
 */

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  init(_func)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void);

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  fini(_func)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void);

#else

/* constructors not supported for this compiler */

#endif

#endif /* __GTK_DOC_IGNORE__ */
#endif /* __G_CONSTRUCTOR_H__ */

#ifdef G_HAS_CONSTRUCTORS

#ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(gthresource_constructor)
#endif
G_DEFINE_CONSTRUCTOR(gthresource_constructor)
#ifdef G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(gthresource_destructor)
#endif
G_DEFINE_DESTRUCTOR(gthresource_destructor)

#else
#warning "Constructor not supported on this compiler, linking in resources will not work"
#endif

static void gthresource_constructor (void)
{
  g_static_resource_init (&static_resource);
}

static void gthresource_destructor (void)
{
  g_static_resource_fini (&static_resource);
}
