/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.tomcat.util.res.StringManager;

public class ConcurrentMessageDigest {
    private static final StringManager sm = StringManager.getManager(ConcurrentMessageDigest.class);
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA-1";
    private static final Map<String, Queue<MessageDigest>> queues = new ConcurrentHashMap<String, Queue<MessageDigest>>();

    private ConcurrentMessageDigest() {
    }

    public static byte[] digestMD5(byte[] ... byArray) {
        return ConcurrentMessageDigest.digest(MD5, byArray);
    }

    public static byte[] digestSHA1(byte[] ... byArray) {
        return ConcurrentMessageDigest.digest(SHA1, byArray);
    }

    public static byte[] digest(String string, byte[] ... byArray) {
        return ConcurrentMessageDigest.digest(string, 1, byArray);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] digest(String string, int n, byte[] ... byArray) {
        void var5_8;
        Queue<MessageDigest> queue = queues.get(string);
        if (queue == null) {
            throw new IllegalStateException(sm.getString("concurrentMessageDigest.noDigest"));
        }
        MessageDigest messageDigest = queue.poll();
        if (messageDigest == null) {
            try {
                messageDigest = MessageDigest.getInstance(string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IllegalStateException(sm.getString("concurrentMessageDigest.noDigest"), noSuchAlgorithmException);
            }
        }
        byte[][] object = byArray;
        int n2 = object.length;
        for (int i = 0; i < n2; ++i) {
            byte[] byArray2 = object[i];
            messageDigest.update(byArray2);
        }
        byte[] byArray3 = messageDigest.digest();
        if (n > 1) {
            for (n2 = 1; n2 < n; ++n2) {
                messageDigest.update((byte[])var5_8);
                byte[] byArray4 = messageDigest.digest();
            }
        }
        queue.add(messageDigest);
        return var5_8;
    }

    public static void init(String string) throws NoSuchAlgorithmException {
        if (!queues.containsKey(string)) {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            ConcurrentLinkedQueue<MessageDigest> concurrentLinkedQueue = new ConcurrentLinkedQueue<MessageDigest>();
            concurrentLinkedQueue.add(messageDigest);
            queues.putIfAbsent(string, concurrentLinkedQueue);
        }
    }

    static {
        try {
            ConcurrentMessageDigest.init(MD5);
            ConcurrentMessageDigest.init(SHA1);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException(sm.getString("concurrentMessageDigest.noDigest"), noSuchAlgorithmException);
        }
    }
}

