from types import TracebackType
from typing import Any
from typing_extensions import Literal

from .request import RequestMethods

class PoolManager(RequestMethods):
    proxy: Any
    connection_pool_kw: Any
    pools: Any
    def __init__(self, num_pools=10, headers=None, **connection_pool_kw) -> None: ...
    def __enter__(self): ...
    def __exit__(
        self, exc_type: type[BaseException] | None, exc_val: BaseException | None, exc_tb: TracebackType | None
    ) -> Literal[False]: ...
    def clear(self): ...
    def connection_from_host(self, host, port=None, scheme="http"): ...
    def connection_from_url(self, url): ...
    # TODO: This was the original signature -- copied another one from base class to fix complaint.
    # def urlopen(self, method, url, redirect=True, **kw): ...
    def urlopen(self, method, url, body=..., headers=..., encode_multipart=..., multipart_boundary=..., **kw): ...

class ProxyManager(PoolManager):
    proxy: Any
    proxy_headers: Any
    def __init__(self, proxy_url, num_pools=10, headers=None, proxy_headers=None, **connection_pool_kw) -> None: ...
    def connection_from_host(self, host, port=None, scheme="http"): ...
    # TODO: This was the original signature -- copied another one from base class to fix complaint.
    # def urlopen(self, method, url, redirect=True, **kw): ...
    def urlopen(self, method, url, body=..., headers=..., encode_multipart=..., multipart_boundary=..., **kw): ...

def proxy_from_url(url, **kw): ...
