/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_wae extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TO = "Tonga";
        final String metaValue_ar = "Arabi\u0161";
        final String metaValue_bn = "Bengali\u0161";
        final String metaValue_el = "Gri\u010di\u0161";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Hebr\u00e4i\u0161";
        final String metaValue_hy = "Armeni\u0161";
        final String metaValue_ja = "Japani\u0161";
        final String metaValue_ka = "Georgi\u0161";
        final String metaValue_kn = "Kannada";
        final String metaValue_la = "Latini\u0161";
        final String metaValue_lo = "Laoti\u0161";
        final String metaValue_my = "Burmesi\u0161";
        final String metaValue_or = "Oriya";
        final String metaValue_si = "Singalesi\u0161";
        final String metaValue_ta = "Tamili\u0161";
        final String metaValue_te = "Telugu";
        final Object[][] data = new Object[][] {
            { "fil", "Filipini\u0161" },
            { "es_ES", "Iberi\u0161es Schpani\u0161" },
            { "ab", "Ab\u010dasi\u0161" },
            { "AC", "Himmelf\u00e1rtsinsla" },
            { "tet", "Tetum" },
            { "AD", "Andorra" },
            { "AE", "Vereinigti Arabi\u0161e Emirat" },
            { "nl_BE", "Fl\u00e4mi\u0161" },
            { "AF", "Afgani\u0161tan" },
            { "af", "Afrik\u00e1ns" },
            { "AG", "Antigua und Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanie" },
            { "AM", "Armenie" },
            { "am", "Amhari\u0161" },
            { "Arab", metaValue_ar },
            { "AO", "Angola" },
            { "Jpan", metaValue_ja },
            { "AQ", "Antarktis" },
            { "ar", metaValue_ar },
            { "AR", "Argentinie" },
            { "AS", "Amerikani\u0161 Samoa" },
            { "as", "Assamesi\u0161" },
            { "AT", "\u00d6\u0161tri\u010d" },
            { "AU", "Australie" },
            { "AW", "Aruba" },
            { "en_US", "Amerikani\u0161es Engli\u0161" },
            { "AX", "Alandinsl\u00e4" },
            { "ay", "Aymara" },
            { "AZ", "Aserbaid\u0161an" },
            { "az", "Serbaid\u0161ani\u0161" },
            { "BA", "Bosnie und Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Banglade\u0161" },
            { "BE", "Belgie" },
            { "be", "W\u00edsrussi\u0161" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarie" },
            { "bg", "Bulgari\u0161" },
            { "BH", "Ba\u010drain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Bartholom\u00e4us-Insla" },
            { "BM", "Bermuda" },
            { "bn", metaValue_bn },
            { "BN", "Brunei" },
            { "BO", "Boliwie" },
            { "bo", "Tibeti\u0161" },
            { "BR", "Brasilie" },
            { "BS", "Bahamas" },
            { "bs", "Bosni\u0161" },
            { "BT", "Bhutan" },
            { "BV", "Bouvetinsla" },
            { "Mymr", metaValue_my },
            { "BW", "Botswana" },
            { "BY", "W\u00edsrussland" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "ca", "Katalani\u0161" },
            { "CC", "Kokosinsl\u00e4" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Zentralafrikani\u0161i Rebublik" },
            { "CG", "Kongo Brazzaville" },
            { "CH", "Schwiz" },
            { "CI", "Elfebeik\u00fc\u0161ta" },
            { "CK", "Cookinsl\u00e4" },
            { "CL", "T\u0161ile" },
            { "CM", "Kamerun" },
            { "CN", "China" },
            { "CO", "Kolumbie" },
            { "CP", "Clipperton Insla" },
            { "Orya", metaValue_or },
            { "CR", "Costa Rica" },
            { "cs", "T\u0161e\u010di\u0161" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CX", "Wien\u00e4\u010dtsinsl\u00e4" },
            { "CY", "Zypre" },
            { "cy", "Walisi\u0161" },
            { "CZ", "T\u0161e\u010die" },
            { "da", "D\u00e4ni\u0161" },
            { "pt_PT", "Iberi\u0161es Portugisi\u0161" },
            { "DE", "Tit\u0161land" },
            { "de", "Tit\u0161" },
            { "DG", "Diego Garcia" },
            { "DJ", "D\u0161ibuti" },
            { "DK", "D\u00e4nemark" },
            { "DM", "Doninica" },
            { "DO", "Dominikani\u0161i Rebublik" },
            { "dv", "Malediwi\u0161" },
            { "es_419", "Latiamerikani\u0161es Schpani\u0161" },
            { "DZ", "Algerie" },
            { "dz", "Butani\u0161" },
            { "EA", "Ceuta und Melilla" },
            { "EC", "Ecuador" },
            { "EE", "E\u0161tland" },
            { "EG", "Egypte" },
            { "EH", "We\u0161tsahara" },
            { "el", metaValue_el },
            { "en", "Engli\u0161" },
            { "ER", "Eritrea" },
            { "ES", "Schpanie" },
            { "es", "Schpani\u0161" },
            { "ET", "Ethiopie" },
            { "et", "Estni\u0161" },
            { "EU", "Europ\u00e4i\u0161i Unio" },
            { "eu", "Baski\u0161" },
            { "type.ca.gregorian", "Gregoriani\u0161\u00e4 Kal\u00e4nder" },
            { "fa", "Persi\u0161" },
            { "Hans", "Vereifa\u010dt" },
            { "type.nu.latn", "Arabi\u0161i Z\u00e1l\u00e4" },
            { "Hant", "Traditionell" },
            { "FI", "Finnland" },
            { "fi", "Fini\u0161" },
            { "FJ", "Fid\u0161i" },
            { "fj", "Fid\u0161iani\u0161" },
            { "FK", "Falklandinsl\u00e4" },
            { "FM", "Mikronesie" },
            { "FO", "F\u00e4r\u00f6e" },
            { "Taml", metaValue_ta },
            { "FR", "Frankri\u010d" },
            { "fr", "W\u00e4l\u0161" },
            { "GA", "Gabon" },
            { "ga", "Iri\u0161" },
            { "GB", "England" },
            { "GD", "Grenada" },
            { "GE", "Georgie" },
            { "GF", "Franz\u00f6si\u0161 Guiana" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Gibraltar" },
            { "GL", "Gr\u00f6nland" },
            { "gl", "Galizi\u0161" },
            { "GM", "Gambia" },
            { "GN", "Ginea" },
            { "gn", "Guarani" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatorialginea" },
            { "und", "Unbekannti Schpra\u010d" },
            { "GR", "Gri\u010deland" },
            { "GS", "S\u00fcdgeorgie und d\u2019s\u00fcdli\u010de Senwi\u010dinsl\u00e4" },
            { "GT", "Guatemala" },
            { "gu", metaValue_gu },
            { "GU", "Guam" },
            { "GW", "Ginea Bissau" },
            { "GY", "Guyana" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "de_AT", "\u00d6\u0161tri\u010di\u0161es Tit\u0161" },
            { "HK", "Sonderverwaltigszona Hongkong" },
            { "HM", "Heard- und McDonald-Insl\u00e4" },
            { "HN", "Honduras" },
            { "HR", "Kroatie" },
            { "hr", "Kroati\u0161" },
            { "HT", "Haiti" },
            { "ht", "Haitiani\u0161" },
            { "HU", "Ungare" },
            { "hu", "Ungari\u0161" },
            { "hy", metaValue_hy },
            { "IC", "Kanari\u0161e Insl\u00e4" },
            { "ID", "Indonesie" },
            { "id", "Indonesi\u0161" },
            { "IE", "Irland" },
            { "ig", "Igbo" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "Indie" },
            { "IO", "Briti\u0161es Territorium em indi\u0161e Ozean" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "is", "Iisl\u00e4ndi\u0161" },
            { "IT", "Italie" },
            { "it", "Italieni\u0161" },
            { "ja", metaValue_ja },
            { "Mlym", "Malaisi\u0161" },
            { "JE", "Jersey" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaika" },
            { "JO", "Jordanie" },
            { "JP", "Japan" },
            { "de_CH", "Schwizer Ho\u010dtit\u0161" },
            { "ka", metaValue_ka },
            { "KE", "Kenya" },
            { "419", "Lat\u00edamerika" },
            { "KG", "Kirgi\u0161tan" },
            { "KH", "Kambod\u0161a" },
            { "KI", "Kiribati" },
            { "kk", "Kaza\u010di\u0161" },
            { "KM", "Komore" },
            { "km", "Kambod\u0161ani\u0161" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "St. Kitts und Nevis" },
            { "fr_CA", "Kanadi\u0161es W\u00e4l\u0161" },
            { "ko", "Koreani\u0161" },
            { "KP", "Nordkorea" },
            { "KR", "S\u00fcdkorea" },
            { "ks", "Ka\u0161miri\u0161" },
            { "ku", "Kurdi\u0161" },
            { "fr_CH", "Schwizer W\u00e4l\u0161" },
            { "KW", "Kuweit" },
            { "tpi", "Niwmelanesi\u0161" },
            { "KY", "Kaimaninsl\u00e4" },
            { "ky", "Kirgisi\u0161" },
            { "KZ", "Kasa\u010dstan" },
            { "Cyrl", "Kirilli\u0161" },
            { "la", metaValue_la },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "lb", "Luxemburgi\u0161" },
            { "LC", "St. Lucia" },
            { "LI", "Lie\u010dte\u0161tei" },
            { "LK", "Sri Lanka" },
            { "ln", "Lingala" },
            { "lo", metaValue_lo },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Litaue" },
            { "lt", "Litaui\u0161" },
            { "LU", "Luxeburg" },
            { "LV", "Lettland" },
            { "lv", "Letti\u0161" },
            { "LY", "L\u00fcbie" },
            { "Thaa", "Th\u00e1na" },
            { "MA", "Maroko" },
            { "MC", "Monago" },
            { "MD", "Moldau" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "MG", "Madagaskar" },
            { "mg", "Malag\u00e1si" },
            { "MH", "Mar\u0161alinsl\u00e4" },
            { "Thai", "Thai" },
            { "type.co.ducet", "Standard Unicode Sortierreiefolg" },
            { "mi", "Maori" },
            { "MK", "Mazedonie" },
            { "mk", "Mazedoni\u0161" },
            { "ML", "Mali" },
            { "ml", "Malayalam" },
            { "MM", "Burma" },
            { "MN", "Mongolei" },
            { "mn", "Mongoli\u0161" },
            { "MO", "Sonderverwaltigszona Makau" },
            { "MP", "N\u00f6rdli\u010di Mariane" },
            { "MQ", "Martinique" },
            { "MR", "Mauretanie" },
            { "mr", "Marathi" },
            { "MS", "Monserrat" },
            { "ms", "Mala\u00ed\u0161" },
            { "MT", "Malta" },
            { "mt", "Maltesi\u0161" },
            { "MU", "Mauritius" },
            { "MV", "Malediwe" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "my", metaValue_my },
            { "MY", "Malaysia" },
            { "Armn", metaValue_hy },
            { "MZ", "Mosambik" },
            { "NA", "Namibia" },
            { "type.co.search", "Allgmeini S\u00fce\u010d" },
            { "nb", "Norwegi\u0161 Bokm\u00e5l" },
            { "NC", "Niwkaledonie" },
            { "nd", "Nordndebele" },
            { "NE", "Niger" },
            { "ne", "Nepalesi\u0161" },
            { "NF", "Norfolkinsla" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Holand" },
            { "nl", "Hol\u00e4ndi\u0161" },
            { "nn", "Norwegi\u0161 Nynorsk" },
            { "NO", "Norw\u00e4ge" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "ny", "Nyanja" },
            { "NZ", "Niws\u00e9land" },
            { "OM", "Oman" },
            { "or", metaValue_or },
            { "os", "Os\u00e9ti\u0161" },
            { "PA", "Panama" },
            { "pa", "Pand\u0161abi\u0161" },
            { "en_GB", "Briti\u0161es Engli\u0161" },
            { "PE", "Peru" },
            { "PF", "Franz\u00f6si\u0161 Polinesie" },
            { "PG", "Papua Niwginea" },
            { "PH", "Philippine" },
            { "PK", "Paki\u0161tan" },
            { "PL", "Pole" },
            { "pl", "Polni\u0161" },
            { "PM", "St. Pierre und Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Pale\u0161tina" },
            { "ps", "Pa\u0161tu" },
            { "PT", "Portugal" },
            { "pt", "Portugisi\u0161" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "pt_BR", "Brasiliani\u0161es Portugisi\u0161" },
            { "Hebr", metaValue_he },
            { "QA", "Katar" },
            { "Laoo", metaValue_lo },
            { "QO", "\u00dcssers Ozeanie" },
            { "qu", "Que\u010dua" },
            { "001", "W\u00e4ld" },
            { "Ethi", "Ethiopi\u0161" },
            { "002", "Afrika" },
            { "003", "Nordamerika" },
            { "RE", "R\u00e9union" },
            { "005", "S\u00fcdamerika" },
            { "009", "Ozeanie" },
            { "rm", "R\u00e4tromani\u0161" },
            { "rn", "Rundi" },
            { "RO", "Rum\u00e4nie" },
            { "ro", "Rum\u00e4ni\u0161" },
            { "RS", "Serbie" },
            { "RU", "Russland" },
            { "ru", "Rusi\u0161" },
            { "RW", "Ruanda" },
            { "rw", "Ruandi\u0161" },
            { "en_AU", "Au\u0161trali\u0161es Engli\u0161" },
            { "SA", "Saudi Arabie" },
            { "sa", "Sanskrit" },
            { "SB", "Salomone" },
            { "011", "We\u0161tafrika" },
            { "SC", "Se\u010delle" },
            { "SD", "Sudan" },
            { "sd", "Sindhi" },
            { "013", "Zentralamerika" },
            { "SE", "Schwede" },
            { "se", "Nordsami\u0161" },
            { "014", "O\u0161tafrika" },
            { "015", "Nordafrika" },
            { "SG", "Singapur" },
            { "sg", "Sango" },
            { "SH", "St. Helena" },
            { "si", metaValue_si },
            { "017", "Mittelafrika" },
            { "SI", "Slowenie" },
            { "018", "S\u00fcdli\u010ds Afrika" },
            { "SJ", "Svalbard und Jan Mayen" },
            { "019", "Amerikani\u0161 Kontin\u00e4nt" },
            { "SK", "Slowakei" },
            { "sk", "Slowaki\u0161" },
            { "SL", "Sierra Leone" },
            { "sl", "Sloweni\u0161" },
            { "SM", "San Marino" },
            { "sm", "Samoani\u0161" },
            { "SN", "Senegal" },
            { "sn", "Shona" },
            { "SO", "Somalia" },
            { "so", "Somali\u0161" },
            { "sq", "Albani\u0161" },
            { "SR", "Suriname" },
            { "sr", "Serbi\u0161" },
            { "ss", "Swazi" },
            { "ST", "S\u00e3o Tom\u00e9 and Pr\u00edncipe" },
            { "st", "S\u00fcdsotho" },
            { "su", "Sundanesi\u0161" },
            { "SV", "El Salvador" },
            { "sv", "Schwedi\u0161" },
            { "sw", "Suaheli\u0161" },
            { "SY", "S\u00fcrie" },
            { "SZ", "Swasiland" },
            { "ta", metaValue_ta },
            { "TA", "Tristan da Cunha" },
            { "021", "N\u00f6rdli\u010ds Amerika" },
            { "142", "Asie" },
            { "TC", "Turks- und Caicosinsl\u00e4" },
            { "143", "Zentralasie" },
            { "TD", "T\u0161ad" },
            { "te", metaValue_te },
            { "145", "We\u0161tasie" },
            { "TF", "Franz\u00f6si\u0161i S\u00fcd- und Antarktisgebiet" },
            { "TG", "Togo" },
            { "tg", "Tad\u0161iki\u0161" },
            { "TH", "Thailand" },
            { "th", "Thail\u00e4ndi\u0161" },
            { "ti", "Tigrinja" },
            { "TJ", "Tad\u0161ikistan" },
            { "en_CA", "Kanadi\u0161es Engli\u0161" },
            { "029", "Karibik" },
            { "TK", "Tokelau" },
            { "tk", "Turkmeni\u0161" },
            { "TL", "O\u0161ttimor" },
            { "TM", "Turkmeni\u0161tan" },
            { "TN", "Tunesie" },
            { "tn", "Tswana" },
            { "to", metaValue_TO },
            { "TO", metaValue_TO },
            { "TR", "T\u00fcrkei" },
            { "tr", "T\u00fcrki\u0161" },
            { "ts", "Tsonga" },
            { "TT", "Trinidad und Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ty", "Taiti\u0161" },
            { "TZ", "Tansania" },
            { "Zzzz", "Unkodierti Schrift" },
            { "150", "Europa" },
            { "UA", "Ukraine" },
            { "030", "O\u0161tasie" },
            { "151", "O\u0161teuropa" },
            { "154", "Nordeuropa" },
            { "034", "S\u00fcdasie" },
            { "155", "We\u0161teuropa" },
            { "035", "S\u00fcdo\u0161tasie" },
            { "UG", "Uganda" },
            { "ug", "Uiguri\u0161" },
            { "Kore", "Koriani\u0161" },
            { "039", "S\u00fcdeuropa" },
            { "uk", "Ukraini\u0161" },
            { "Sinh", metaValue_si },
            { "UM", "Amerikani\u0161 Ozeanie" },
            { "ur", "Urdu" },
            { "US", "Amerika" },
            { "haw", "Hawa\u00edani\u0161" },
            { "UY", "Urugauy" },
            { "UZ", "Usbeki\u0161tan" },
            { "uz", "Usbeki\u0161" },
            { "VA", "Vatikan" },
            { "VC", "St. Vincent und d\u2019Grenadine" },
            { "VE", "Venezuela" },
            { "ve", "Venda" },
            { "VG", "Briti\u0161i Jungfr\u00f6iwinsl\u00e4" },
            { "VI", "Amerikani\u0161i Jungfr\u00f6iwinsl\u00e4" },
            { "vi", "Vietnamesi\u0161" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "053", "Au\u0161tralie und Niws\u00e9land" },
            { "054", "Melanesie" },
            { "WF", "Wallis und Futuna" },
            { "Grek", metaValue_el },
            { "057", "Mikronesi\u0161es Inselgebiet" },
            { "wo", "Wolof" },
            { "wae", "Walser" },
            { "WS", "Samoa" },
            { "Latn", metaValue_la },
            { "061", "Polinesie" },
            { "xh", "Xhosa" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "Schriftlos" },
            { "YE", "J\u00e9me" },
            { "yo", "Yoruba" },
            { "YT", "Moyette" },
            { "ZA", "S\u00fcdafrika" },
            { "Deva", "Devanagari" },
            { "zh", "Chinesi\u0161" },
            { "ZM", "Sambia" },
            { "zu", "Zulu" },
            { "ZW", "Simbabwe" },
            { "Geor", metaValue_ka },
            { "ZZ", "Unbekannti Regio" },
            { "nso", "Nordsotho" },
            { "zh_Hans", "Vereifa\u010dts Chinesi\u0161" },
            { "zh_Hant", "Traditionells Chinesi\u0161" },
            { "Khmr", "Khmer" },
            { "sah", "Jakuti\u0161" },
            { "efi", "Efik" },
            { "Telu", metaValue_te },
        };
        return data;
    }
}
