;; mlang-tab.scm

;; Copyright 2015-2018 Matthew R. Wette
;; 
;; This library is free software; you can redistribute it and/or
;; modify it under the terms of the GNU Lesser General Public
;; License as published by the Free Software Foundation; either
;; version 3 of the License, or (at your option) any later version.
;; See the file COPYING included with the this distribution.

(define mlang-mtab
  '(($start . 106) ($lone-comm . 3) ($string . 4) ($float . 5) ($fixed . 6) 
    ($ident . 7) (";" . 8) ("." . 9) (".'" . 10) ("'" . 11) ("~" . 12) 
    (".^" . 13) (".\\" . 14) ("./" . 15) (".*" . 16) ("^" . 17) ("\\" . 18) 
    ("/" . 19) ("*" . 20) (".-" . 21) (".+" . 22) ("-" . 23) ("+" . 24) 
    (">=" . 25) ("<=" . 26) (">" . 27) ("<" . 28) ("~=" . 29) ("==" . 30) 
    ("&" . 31) ("|" . 32) (":" . 33) ("}" . 34) ("{" . 35) ("case" . 36) 
    ("elseif" . 37) ("clear" . 38) ("global" . 39) ("return" . 40) (
    "otherwise" . 41) ("switch" . 42) ("else" . 43) ("if" . 44) ("while" . 45)
    ("for" . 46) ("\n" . 47) ("," . 48) (")" . 49) ("(" . 50) ("=" . 51) 
    ("]" . 52) ("[" . 53) ("function" . 54) ("end" . 55) ($error . 2) ($end . 
    57)))

(define mlang-ntab
  '((58 . float) (59 . lone-comment-list-1) (60 . term-list) (61 . nl) 
    (62 . row-term) (63 . matrix-row) (64 . matrix-row-list) (65 . number) 
    (66 . primary-expr) (67 . postfix-expr) (68 . unary-expr) (69 . mul-expr) 
    (70 . add-expr) (71 . rel-expr) (72 . equality-expr) (73 . and-expr) 
    (74 . or-expr) (75 . expr-list) (76 . string-list) (77 . fixed-list) 
    (78 . string) (79 . fixed) (80 . case-expr) (81 . arg-list) (82 . command)
    (83 . case-list) (84 . elseif-list) (85 . expr) (86 . 
    nontrivial-statement-1) (87 . lone-comment) (88 . trivial-statement) 
    (89 . triv-stmt-list-1) (90 . ident) (91 . ident-list) (92 . 
    lone-comment-list) (93 . function-decl-line) (94 . term) (95 . the-end) 
    (96 . stmt-list) (97 . non-comment-statement) (98 . function-decl) 
    (99 . statement) (100 . mlang-item) (101 . mlang-item-list-1) (102 . 
    function-defn) (103 . mlang-item-list) (104 . nontrivial-statement) 
    (105 . triv-stmt-list) (106 . translation-unit)))

(define mlang-len-v
  #(1 3 3 2 2 1 0 2 1 1 4 3 2 2 2 1 10 9 8 7 6 5 1 3 1 2 1 1 2 1 1 1 1 2 1 2 
    1 3 7 5 8 6 7 5 8 5 1 2 1 1 1 2 4 5 0 5 1 1 3 3 1 2 1 2 1 3 1 1 3 5 3 5 1 
    3 1 3 1 3 3 1 3 3 3 3 1 3 3 3 3 1 3 3 3 3 3 3 3 3 1 2 2 2 1 2 2 4 3 3 1 1 
    1 3 2 3 2 3 1 3 1 1 1 3 1 2 1 1 1 1 2 3 1 1 1 1 1 1 1 1))

(define mlang-rto-v
  #(#f 106 106 106 106 103 101 101 100 100 102 102 102 95 98 98 93 93 93 93 
    93 93 91 91 96 96 105 89 89 99 99 97 97 88 88 104 86 86 86 86 86 86 86 86 
    86 86 86 86 82 82 81 81 84 84 83 83 80 80 80 80 77 77 76 76 75 75 85 85 85
    85 85 85 74 74 73 73 72 72 72 71 71 71 71 71 70 70 70 70 70 69 69 69 69 69
    69 69 69 69 68 68 68 68 67 67 67 67 67 67 66 66 66 66 66 66 66 66 64 64 62
    62 63 63 60 60 94 94 94 92 59 59 90 79 58 65 65 78 87 61))

(define mlang-pat-v
  #(((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) 
    (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) 
    (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 21) (47 . 22) 
    (72 . 23) (3 . 24) (48 . 25) (8 . 26) (61 . 27) (73 . 28) (33 . 29) 
    (74 . 30) (38 . 31) (39 . 32) (94 . 33) (87 . 34) (54 . 35) (82 . 36) 
    (40 . 37) (42 . 38) (44 . 39) (45 . 40) (46 . 41) (85 . 42) (88 . 43) 
    (93 . 44) (86 . 45) (89 . 46) (98 . 47) (102 . 48) (104 . 49) (105 . 50) 
    (106 . 51)) ((1 . -132)) ((1 . -131)) ((1 . -135)) ((1 . -134)) ((1 . -133
    )) ((1 . -130)) ((34 . 110) (5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) 
    (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13)
    (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) 
    (71 . 21) (72 . 23) (73 . 28) (33 . 29) (74 . 30) (85 . 107) (63 . 108) 
    (64 . 111)) ((52 . 106) (5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) 
    (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) 
    (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) 
    (71 . 21) (72 . 23) (73 . 28) (33 . 29) (74 . 30) (85 . 107) (63 . 108) 
    (64 . 109)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) 
    (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) 
    (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 21) 
    (72 . 23) (73 . 28) (33 . 29) (74 . 30) (85 . 105)) ((1 . -110)) ((1 . 
    -109)) ((1 . -108)) ((1 . -102)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) 
    (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) 
    (66 . 13) (67 . 104)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) 
    (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) 
    (67 . 103)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) 
    (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (67 . 102)) 
    ((11 . 98) (10 . 99) (50 . 100) (9 . 101) (1 . -98)) ((1 . -89)) ((20 . 90
    ) (19 . 91) (18 . 92) (17 . 93) (16 . 94) (15 . 95) (14 . 96) (13 . 97) 
    (1 . -84)) ((24 . 86) (23 . 87) (22 . 88) (21 . 89) (1 . -79)) ((28 . 82) 
    (27 . 83) (26 . 84) (25 . 85) (1 . -76)) ((1 . -137)) ((30 . 80) (29 . 81)
    (1 . -74)) ((1 . -136)) ((1 . -126)) ((1 . -125)) ((1 . -124)) ((31 . 79) 
    (1 . -72)) ((1 . -67)) ((33 . 77) (32 . 78) (1 . -66)) ((1 . -49)) 
    ((1 . -48)) ((1 . -34)) ((47 . 76)) ((53 . 74) (7 . 6) (90 . 75)) (
    (7 . 6) (90 . 72) (81 . 73)) ((1 . -46)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4)
    (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) 
    (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) 
    (70 . 20) (71 . 21) (72 . 23) (73 . 28) (33 . 29) (74 . 30) (85 . 71)) 
    ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) 
    (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) 
    (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 21) (72 . 23) 
    (73 . 28) (33 . 29) (74 . 30) (85 . 70)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4)
    (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) 
    (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) 
    (70 . 20) (71 . 21) (72 . 23) (73 . 28) (33 . 29) (74 . 30) (85 . 69)) 
    ((7 . 6) (90 . 68)) ((51 . 67) (1 . -36)) ((1 . -27)) ((3 . 24) (87 . 64) 
    (59 . 65) (92 . 66) (1 . -15)) ((47 . 22) (48 . 25) (8 . 26) (61 . 27) 
    (94 . 63)) ((47 . 22) (3 . 24) (48 . 25) (8 . 26) (61 . 27) (94 . 33) 
    (87 . 34) (88 . 62) (1 . -26)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) 
    (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13)
    (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) 
    (71 . 21) (72 . 23) (73 . 28) (33 . 29) (74 . 30) (38 . 31) (39 . 32) 
    (47 . 22) (82 . 36) (40 . 37) (42 . 38) (44 . 39) (45 . 40) (46 . 41) 
    (85 . 42) (48 . 25) (8 . 26) (61 . 27) (86 . 45) (104 . 57) (94 . 58) 
    (97 . 59) (55 . 60) (95 . 61)) ((101 . 54) (103 . 56) (1 . -6)) ((101 . 54
    ) (103 . 55) (1 . -6)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) 
    (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) 
    (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) 
    (71 . 21) (72 . 23) (73 . 28) (33 . 29) (74 . 30) (38 . 31) (39 . 32) 
    (82 . 36) (40 . 37) (42 . 38) (44 . 39) (45 . 40) (46 . 41) (85 . 42) 
    (86 . 45) (104 . 52) (54 . 35) (93 . 44) (98 . 47) (102 . 53)) ((57 . 0)) 
    ((101 . 54) (103 . 167) (1 . -6)) ((101 . 54) (103 . 166) (1 . -6)) 
    ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) 
    (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) 
    (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 21) (72 . 23) 
    (73 . 28) (47 . 22) (33 . 29) (74 . 30) (38 . 31) (39 . 32) (3 . 24) 
    (48 . 25) (8 . 26) (61 . 27) (82 . 36) (40 . 37) (42 . 38) (44 . 39) 
    (45 . 40) (46 . 41) (85 . 42) (54 . 35) (86 . 45) (94 . 33) (87 . 34) 
    (93 . 44) (104 . 159) (88 . 160) (98 . 47) (99 . 163) (102 . 164) (100 . 
    165) (1 . -5)) ((1 . -3)) ((1 . -4)) ((1 . -32)) ((1 . -31)) ((55 . 60) 
    (95 . 158) (5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) 
    (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) 
    (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 21) 
    (72 . 23) (73 . 28) (47 . 22) (33 . 29) (74 . 30) (38 . 31) (39 . 32) 
    (3 . 24) (48 . 25) (8 . 26) (61 . 27) (82 . 36) (40 . 37) (42 . 38) 
    (44 . 39) (45 . 40) (46 . 41) (85 . 42) (86 . 45) (94 . 33) (87 . 34) 
    (104 . 159) (88 . 160) (99 . 161) (96 . 162)) ((47 . 22) (48 . 25) 
    (8 . 26) (61 . 27) (94 . 157)) ((1 . -12)) ((1 . -28)) ((1 . -35)) 
    ((47 . 22) (61 . 156)) ((3 . 24) (87 . 155) (1 . -127)) ((1 . -14)) 
    ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) 
    (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) 
    (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 21) (72 . 23) 
    (73 . 28) (33 . 29) (74 . 30) (85 . 154)) ((51 . 153)) ((47 . 22) (48 . 25
    ) (8 . 26) (61 . 27) (94 . 152)) ((47 . 22) (48 . 25) (8 . 26) (61 . 27) 
    (94 . 151)) ((47 . 22) (48 . 25) (8 . 26) (61 . 27) (94 . 150)) ((1 . -50)
    ) ((7 . 6) (90 . 149) (1 . -47)) ((7 . 6) (90 . 147) (91 . 148)) ((50 . 
    145) (51 . 146)) ((1 . -33)) ((55 . 143) (5 . 1) (6 . 2) (4 . 3) (58 . 4) 
    (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) 
    (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) 
    (70 . 20) (71 . 21) (72 . 23) (73 . 28) (74 . 144)) ((5 . 1) (6 . 2) 
    (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) 
    (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) 
    (68 . 18) (69 . 19) (70 . 20) (71 . 21) (72 . 23) (73 . 142)) ((5 . 1) 
    (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) 
    (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) (23 . 16) 
    (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 21) (72 . 141)) ((5 . 1) 
    (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) 
    (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) (23 . 16) 
    (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 140)) ((5 . 1) (6 . 2) 
    (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) 
    (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) 
    (68 . 18) (69 . 19) (70 . 20) (71 . 139)) ((5 . 1) (6 . 2) (4 . 3) 
    (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) 
    (90 . 12) (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) 
    (69 . 19) (70 . 138)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) 
    (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) 
    (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 137)) 
    ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) 
    (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) 
    (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 136)) ((5 . 1) (6 . 2) 
    (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) 
    (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) 
    (68 . 18) (69 . 19) (70 . 135)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5)
    (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13)
    (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 134)) ((5 . 1) 
    (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) 
    (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) (23 . 16) 
    (67 . 17) (68 . 18) (69 . 133)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5)
    (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13)
    (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 132)) ((5 . 1) 
    (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) 
    (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) (23 . 16) 
    (67 . 17) (68 . 18) (69 . 131)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5)
    (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13)
    (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 130)) ((5 . 1) (6 . 2) 
    (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) 
    (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) 
    (68 . 129)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) 
    (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) 
    (24 . 15) (23 . 16) (67 . 17) (68 . 128)) ((5 . 1) (6 . 2) (4 . 3) 
    (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) 
    (90 . 12) (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 127)) 
    ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) 
    (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) 
    (23 . 16) (67 . 17) (68 . 126)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5)
    (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13)
    (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 125)) ((5 . 1) (6 . 2) 
    (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) 
    (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) 
    (68 . 124)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) 
    (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) 
    (24 . 15) (23 . 16) (67 . 17) (68 . 123)) ((1 . -103)) ((1 . -104)) 
    ((49 . 120) (5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) 
    (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) 
    (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 21) 
    (72 . 23) (73 . 28) (33 . 29) (74 . 30) (85 . 121) (75 . 122)) ((7 . 6) 
    (90 . 119)) ((11 . 98) (10 . 99) (50 . 100) (9 . 101) (1 . -99)) ((11 . 98
    ) (10 . 99) (50 . 100) (9 . 101) (1 . -100)) ((11 . 98) (10 . 99) (50 . 
    100) (9 . 101) (1 . -101)) ((49 . 118)) ((1 . -112)) ((1 . -120)) (
    (48 . 117) (1 . -116)) ((52 . 116) (47 . 22) (61 . 113) (8 . 114) (62 . 
    115)) ((1 . -114)) ((34 . 112) (47 . 22) (61 . 113) (8 . 114) (62 . 115)) 
    ((1 . -115)) ((1 . -119)) ((1 . -118)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) 
    (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) 
    (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) 
    (70 . 20) (71 . 21) (72 . 23) (73 . 28) (33 . 29) (74 . 30) (85 . 107) 
    (63 . 184)) ((1 . -113)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) 
    (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13)
    (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) 
    (71 . 21) (72 . 23) (73 . 28) (33 . 29) (74 . 30) (85 . 183)) ((1 . -111))
    ((1 . -107)) ((1 . -106)) ((1 . -64)) ((49 . 181) (48 . 182)) ((1 . -97)) 
    ((1 . -96)) ((1 . -95)) ((1 . -94)) ((1 . -93)) ((1 . -92)) ((1 . -91)) 
    ((1 . -90)) ((20 . 90) (19 . 91) (18 . 92) (17 . 93) (16 . 94) (15 . 95) 
    (14 . 96) (13 . 97) (1 . -88)) ((20 . 90) (19 . 91) (18 . 92) (17 . 93) 
    (16 . 94) (15 . 95) (14 . 96) (13 . 97) (1 . -87)) ((20 . 90) (19 . 91) 
    (18 . 92) (17 . 93) (16 . 94) (15 . 95) (14 . 96) (13 . 97) (1 . -86)) 
    ((20 . 90) (19 . 91) (18 . 92) (17 . 93) (16 . 94) (15 . 95) (14 . 96) 
    (13 . 97) (1 . -85)) ((24 . 86) (23 . 87) (22 . 88) (21 . 89) (1 . -83)) 
    ((24 . 86) (23 . 87) (22 . 88) (21 . 89) (1 . -82)) ((24 . 86) (23 . 87) 
    (22 . 88) (21 . 89) (1 . -81)) ((24 . 86) (23 . 87) (22 . 88) (21 . 89) 
    (1 . -80)) ((28 . 82) (27 . 83) (26 . 84) (25 . 85) (1 . -78)) ((28 . 82) 
    (27 . 83) (26 . 84) (25 . 85) (1 . -77)) ((30 . 80) (29 . 81) (1 . -75)) 
    ((31 . 79) (1 . -73)) ((1 . -70)) ((32 . 78) (33 . 180) (1 . -68)) 
    ((7 . 6) (90 . 147) (91 . 178) (49 . 179)) ((7 . 6) (90 . 177)) ((1 . -22)
    ) ((48 . 175) (52 . 176)) ((1 . -51)) ((83 . 174) (1 . -54)) ((5 . 1) 
    (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) 
    (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) (23 . 16) 
    (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 21) (72 . 23) (73 . 28) 
    (47 . 22) (33 . 29) (74 . 30) (38 . 31) (39 . 32) (3 . 24) (48 . 25) 
    (8 . 26) (61 . 27) (82 . 36) (40 . 37) (42 . 38) (44 . 39) (45 . 40) 
    (46 . 41) (85 . 42) (86 . 45) (94 . 33) (87 . 34) (104 . 159) (88 . 160) 
    (99 . 161) (96 . 173)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) 
    (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) 
    (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) 
    (71 . 21) (72 . 23) (73 . 28) (47 . 22) (33 . 29) (74 . 30) (38 . 31) 
    (39 . 32) (3 . 24) (48 . 25) (8 . 26) (61 . 27) (82 . 36) (40 . 37) 
    (42 . 38) (44 . 39) (45 . 40) (46 . 41) (85 . 42) (86 . 45) (94 . 33) 
    (87 . 34) (104 . 159) (88 . 160) (99 . 161) (96 . 172)) ((5 . 1) (6 . 2) 
    (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) 
    (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) 
    (68 . 18) (69 . 19) (70 . 20) (71 . 21) (72 . 23) (73 . 28) (33 . 29) 
    (74 . 30) (85 . 171)) ((1 . -37)) ((47 . 22) (61 . 170)) ((1 . -128)) 
    ((1 . -13)) ((1 . -11)) ((1 . -30)) ((1 . -29)) ((1 . -24)) ((55 . 60) 
    (95 . 168) (5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) 
    (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) 
    (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 21) 
    (72 . 23) (73 . 28) (47 . 22) (33 . 29) (74 . 30) (38 . 31) (39 . 32) 
    (3 . 24) (48 . 25) (8 . 26) (61 . 27) (82 . 36) (40 . 37) (42 . 38) 
    (44 . 39) (45 . 40) (46 . 41) (85 . 42) (86 . 45) (94 . 33) (87 . 34) 
    (104 . 159) (88 . 160) (99 . 169)) ((1 . -9)) ((1 . -8)) ((1 . -7)) 
    ((1 . -2)) ((1 . -1)) ((1 . -10)) ((1 . -25)) ((1 . -129)) ((47 . 22) 
    (48 . 25) (8 . 26) (61 . 27) (94 . 201)) ((55 . 200) (5 . 1) (6 . 2) 
    (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) 
    (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) 
    (68 . 18) (69 . 19) (70 . 20) (71 . 21) (72 . 23) (73 . 28) (47 . 22) 
    (33 . 29) (74 . 30) (38 . 31) (39 . 32) (3 . 24) (48 . 25) (8 . 26) 
    (61 . 27) (82 . 36) (40 . 37) (42 . 38) (44 . 39) (45 . 40) (46 . 41) 
    (85 . 42) (86 . 45) (94 . 33) (87 . 34) (104 . 159) (88 . 160) (99 . 169))
    ((55 . 196) (5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) 
    (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) 
    (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 21) 
    (72 . 23) (73 . 28) (47 . 22) (33 . 29) (74 . 30) (38 . 31) (39 . 32) 
    (3 . 24) (48 . 25) (8 . 26) (61 . 27) (82 . 36) (40 . 37) (42 . 38) 
    (44 . 39) (45 . 40) (46 . 41) (85 . 42) (86 . 45) (94 . 33) (87 . 34) 
    (104 . 159) (88 . 160) (99 . 169) (43 . 197) (37 . 198) (84 . 199)) 
    ((55 . 193) (36 . 194) (41 . 195)) ((7 . 6) (90 . 192)) ((51 . 191)) 
    ((50 . 190)) ((49 . 189) (48 . 175)) ((47 . 22) (48 . 25) (8 . 26) 
    (61 . 27) (94 . 188)) ((55 . 186) (5 . 1) (6 . 2) (4 . 3) (58 . 4) 
    (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) 
    (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) 
    (70 . 20) (71 . 21) (72 . 23) (73 . 28) (74 . 187)) ((1 . -105)) ((5 . 1) 
    (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) 
    (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) (23 . 16) 
    (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 21) (72 . 23) (73 . 28) 
    (33 . 29) (74 . 30) (85 . 185)) ((1 . -121)) ((48 . 117) (1 . -117)) 
    ((1 . -65)) ((1 . -71)) ((32 . 78) (1 . -69)) ((1 . -21)) ((47 . 22) 
    (48 . 25) (8 . 26) (61 . 27) (94 . 216)) ((7 . 6) (90 . 147) (91 . 214) 
    (49 . 215)) ((7 . 6) (90 . 213)) ((1 . -23)) ((1 . -45)) ((4 . 3) (6 . 2) 
    (35 . 209) (78 . 210) (79 . 211) (80 . 212)) ((47 . 22) (48 . 25) (8 . 26)
    (61 . 27) (94 . 208)) ((1 . -43)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) 
    (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) 
    (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) 
    (70 . 20) (71 . 21) (72 . 23) (73 . 28) (47 . 22) (33 . 29) (74 . 30) 
    (38 . 31) (39 . 32) (3 . 24) (48 . 25) (8 . 26) (61 . 27) (82 . 36) 
    (40 . 37) (42 . 38) (44 . 39) (45 . 40) (46 . 41) (85 . 42) (86 . 45) 
    (94 . 33) (87 . 34) (104 . 159) (88 . 160) (99 . 161) (96 . 207)) (
    (5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) 
    (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) 
    (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 21) (72 . 23) 
    (73 . 28) (33 . 29) (74 . 30) (85 . 206)) ((43 . 203) (37 . 204) (55 . 205
    )) ((1 . -39)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7)
    (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) 
    (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 21) 
    (72 . 23) (73 . 28) (47 . 22) (33 . 29) (74 . 30) (38 . 31) (39 . 32) 
    (3 . 24) (48 . 25) (8 . 26) (61 . 27) (82 . 36) (40 . 37) (42 . 38) 
    (44 . 39) (45 . 40) (46 . 41) (85 . 42) (86 . 45) (94 . 33) (87 . 34) 
    (104 . 159) (88 . 160) (99 . 161) (96 . 202)) ((55 . 230) (5 . 1) (6 . 2) 
    (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) 
    (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) 
    (68 . 18) (69 . 19) (70 . 20) (71 . 21) (72 . 23) (73 . 28) (47 . 22) 
    (33 . 29) (74 . 30) (38 . 31) (39 . 32) (3 . 24) (48 . 25) (8 . 26) 
    (61 . 27) (82 . 36) (40 . 37) (42 . 38) (44 . 39) (45 . 40) (46 . 41) 
    (85 . 42) (86 . 45) (94 . 33) (87 . 34) (104 . 159) (88 . 160) (99 . 169))
    ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) 
    (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) 
    (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 21) (72 . 23) 
    (73 . 28) (47 . 22) (33 . 29) (74 . 30) (38 . 31) (39 . 32) (3 . 24) 
    (48 . 25) (8 . 26) (61 . 27) (82 . 36) (40 . 37) (42 . 38) (44 . 39) 
    (45 . 40) (46 . 41) (85 . 42) (86 . 45) (94 . 33) (87 . 34) (104 . 159) 
    (88 . 160) (99 . 161) (96 . 229)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) 
    (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) 
    (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) 
    (70 . 20) (71 . 21) (72 . 23) (73 . 28) (33 . 29) (74 . 30) (85 . 228)) 
    ((1 . -41)) ((47 . 22) (48 . 25) (8 . 26) (61 . 27) (94 . 227)) ((55 . 226
    ) (5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) 
    (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) 
    (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 21) (72 . 23) 
    (73 . 28) (47 . 22) (33 . 29) (74 . 30) (38 . 31) (39 . 32) (3 . 24) 
    (48 . 25) (8 . 26) (61 . 27) (82 . 36) (40 . 37) (42 . 38) (44 . 39) 
    (45 . 40) (46 . 41) (85 . 42) (86 . 45) (94 . 33) (87 . 34) (104 . 159) 
    (88 . 160) (99 . 169)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) 
    (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) 
    (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) 
    (71 . 21) (72 . 23) (73 . 28) (47 . 22) (33 . 29) (74 . 30) (38 . 31) 
    (39 . 32) (3 . 24) (48 . 25) (8 . 26) (61 . 27) (82 . 36) (40 . 37) 
    (42 . 38) (44 . 39) (45 . 40) (46 . 41) (85 . 42) (86 . 45) (94 . 33) 
    (87 . 34) (104 . 159) (88 . 160) (99 . 161) (96 . 225)) ((6 . 2) (79 . 221
    ) (77 . 222) (4 . 3) (78 . 223) (76 . 224)) ((1 . -57)) ((1 . -56)) 
    ((47 . 22) (48 . 25) (8 . 26) (61 . 27) (94 . 220)) ((50 . 219)) ((49 . 
    218) (48 . 175)) ((47 . 22) (48 . 25) (8 . 26) (61 . 27) (94 . 217)) 
    ((1 . -20)) ((1 . -19)) ((47 . 22) (48 . 25) (8 . 26) (61 . 27) (94 . 242)
    ) ((7 . 6) (90 . 147) (91 . 240) (49 . 241)) ((5 . 1) (6 . 2) (4 . 3) 
    (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) 
    (90 . 12) (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) 
    (69 . 19) (70 . 20) (71 . 21) (72 . 23) (73 . 28) (47 . 22) (33 . 29) 
    (74 . 30) (38 . 31) (39 . 32) (3 . 24) (48 . 25) (8 . 26) (61 . 27) 
    (82 . 36) (40 . 37) (42 . 38) (44 . 39) (45 . 40) (46 . 41) (85 . 42) 
    (86 . 45) (94 . 33) (87 . 34) (104 . 159) (88 . 160) (99 . 161) (96 . 239)
    ) ((1 . -60)) ((34 . 237) (6 . 2) (79 . 238)) ((1 . -62)) ((34 . 235) 
    (4 . 3) (78 . 236)) ((55 . 234) (5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) 
    (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13)
    (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) 
    (71 . 21) (72 . 23) (73 . 28) (47 . 22) (33 . 29) (74 . 30) (38 . 31) 
    (39 . 32) (3 . 24) (48 . 25) (8 . 26) (61 . 27) (82 . 36) (40 . 37) 
    (42 . 38) (44 . 39) (45 . 40) (46 . 41) (85 . 42) (86 . 45) (94 . 33) 
    (87 . 34) (104 . 159) (88 . 160) (99 . 169)) ((1 . -42)) ((5 . 1) (6 . 2) 
    (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) 
    (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) 
    (68 . 18) (69 . 19) (70 . 20) (71 . 21) (72 . 23) (73 . 28) (47 . 22) 
    (33 . 29) (74 . 30) (38 . 31) (39 . 32) (3 . 24) (48 . 25) (8 . 26) 
    (61 . 27) (82 . 36) (40 . 37) (42 . 38) (44 . 39) (45 . 40) (46 . 41) 
    (85 . 42) (86 . 45) (94 . 33) (87 . 34) (104 . 159) (88 . 160) (99 . 161) 
    (96 . 233)) ((47 . 22) (48 . 25) (8 . 26) (61 . 27) (94 . 232)) ((55 . 231
    ) (5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) 
    (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) 
    (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 21) (72 . 23) 
    (73 . 28) (47 . 22) (33 . 29) (74 . 30) (38 . 31) (39 . 32) (3 . 24) 
    (48 . 25) (8 . 26) (61 . 27) (82 . 36) (40 . 37) (42 . 38) (44 . 39) 
    (45 . 40) (46 . 41) (85 . 42) (86 . 45) (94 . 33) (87 . 34) (104 . 159) 
    (88 . 160) (99 . 169)) ((1 . -38)) ((1 . -40)) ((5 . 1) (6 . 2) (4 . 3) 
    (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) 
    (90 . 12) (66 . 13) (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) 
    (69 . 19) (70 . 20) (71 . 21) (72 . 23) (73 . 28) (47 . 22) (33 . 29) 
    (74 . 30) (38 . 31) (39 . 32) (3 . 24) (48 . 25) (8 . 26) (61 . 27) 
    (82 . 36) (40 . 37) (42 . 38) (44 . 39) (45 . 40) (46 . 41) (85 . 42) 
    (86 . 45) (94 . 33) (87 . 34) (104 . 159) (88 . 160) (99 . 161) (96 . 245)
    ) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) 
    (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) 
    (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 21) (72 . 23) 
    (73 . 28) (47 . 22) (33 . 29) (74 . 30) (38 . 31) (39 . 32) (3 . 24) 
    (48 . 25) (8 . 26) (61 . 27) (82 . 36) (40 . 37) (42 . 38) (44 . 39) 
    (45 . 40) (46 . 41) (85 . 42) (86 . 45) (94 . 33) (87 . 34) (104 . 159) 
    (88 . 160) (99 . 169) (1 . -52)) ((1 . -44)) ((1 . -59)) ((1 . -63)) 
    ((1 . -58)) ((1 . -61)) ((5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) 
    (7 . 6) (35 . 7) (53 . 8) (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13)
    (12 . 14) (24 . 15) (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) 
    (71 . 21) (72 . 23) (73 . 28) (47 . 22) (33 . 29) (74 . 30) (38 . 31) 
    (39 . 32) (3 . 24) (48 . 25) (8 . 26) (61 . 27) (82 . 36) (40 . 37) 
    (42 . 38) (44 . 39) (45 . 40) (46 . 41) (85 . 42) (86 . 45) (94 . 33) 
    (87 . 34) (104 . 159) (88 . 160) (99 . 169) (1 . -55)) ((49 . 244) 
    (48 . 175)) ((47 . 22) (48 . 25) (8 . 26) (61 . 27) (94 . 243)) ((1 . -18)
    ) ((1 . -17)) ((47 . 22) (48 . 25) (8 . 26) (61 . 27) (94 . 246)) (
    (5 . 1) (6 . 2) (4 . 3) (58 . 4) (79 . 5) (7 . 6) (35 . 7) (53 . 8) 
    (50 . 9) (78 . 10) (65 . 11) (90 . 12) (66 . 13) (12 . 14) (24 . 15) 
    (23 . 16) (67 . 17) (68 . 18) (69 . 19) (70 . 20) (71 . 21) (72 . 23) 
    (73 . 28) (47 . 22) (33 . 29) (74 . 30) (38 . 31) (39 . 32) (3 . 24) 
    (48 . 25) (8 . 26) (61 . 27) (82 . 36) (40 . 37) (42 . 38) (44 . 39) 
    (45 . 40) (46 . 41) (85 . 42) (86 . 45) (94 . 33) (87 . 34) (104 . 159) 
    (88 . 160) (99 . 169) (1 . -53)) ((1 . -16))))

(define mlang-tables
  (list
   (cons 'mtab mlang-mtab)
   (cons 'ntab mlang-ntab)
   (cons 'len-v mlang-len-v)
   (cons 'rto-v mlang-rto-v)
   (cons 'pat-v mlang-pat-v)
   ))

;;; end tables
