# -*- coding: binary -*-

#
# This mixin is a simplistic implementation of X11 initial connection protocol
#
# Wireshark dissector: https://wiki.wireshark.org/X11
#

module Msf::Exploit::Remote::X11::Connect
  include Rex::Proto::X11::Connect

  # function used to send the request and receive the response
  # for establishing an X11 session.
  def x11_connect
    sock.put(X11ConnectionRequest.new.to_binary_s) # x11 session establish
    packet = ''
    connection = nil
    begin
      header_data = sock.timed_read(X11ConnectHeader.new.num_bytes)
      return nil if header_data.nil?

      header = X11ConnectHeader.read(header_data)
      if header.success == 0
        body_data = sock.timed_read(header.pad0)
      else
        body_data = sock.timed_read(header.response_length * 4)
      end
      return nil if body_data.nil?

      return X11Connection.read(header_data + body_data)
    rescue StandardError => e
      vprint_bad("Error (#{e}) processing data: #{packet.bytes.map { |b| %(\\x) + b.to_s(16).rjust(2, '0') }.join}")
    end
    connection
  end

  # print out the information for an x11 connection which was
  # successfully established
  def x11_print_connection_info(connection, ip, port)
    print_good("#{ip} - Successfully established X11 connection")
    vprint_status("  Vendor: #{connection.body.vendor}")
    vprint_status("  Version: #{connection.header.protocol_version_major}.#{connection.header.protocol_version_minor}")
    vprint_status("  Screen Resolution: #{connection.body.screen_width_in_pixels}x#{connection.body.screen_height_in_pixels}")
    vprint_status("  Resource ID: #{connection.body.resource_id_base.inspect}")
    vprint_status("  Screen root: #{connection.body.screen_root.inspect}")
    report_note(
      host: ip,
      proto: 'tcp',
      sname: 'x11',
      port: port,
      type: 'x11.server_vendor',
      data: "Open X Server (#{connection.body.vendor})"
    )
  end
end
