/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.ChangePropertyKeyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.MergeSourceBuildingVisitor;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.data.validation.util.Entities;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetListener;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.tagging.presets.items.Check;
import org.openstreetmap.josm.gui.tagging.presets.items.CheckGroup;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.gui.widgets.EditableList;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;

public class TagChecker
extends Test.TagTest
implements TaggingPresetListener {
    public static final String IGNORE_FILE = "resource://data/validator/ignoretags.cfg";
    public static final String SPELL_FILE = "resource://data/validator/words.cfg";
    private static final Map<String, String> harmonizedKeys = new HashMap<String, String>();
    private static volatile HashSet<String> additionalPresetsValueData;
    private static final MultiMap<String, String> oftenUsedTags;
    private static final Map<TaggingPreset, List<TaggingPresetItem>> presetIndex;
    private static final Pattern UNWANTED_NON_PRINTING_CONTROL_CHARACTERS;
    private static final List<String> ignoreDataStartsWith;
    private static final Set<String> ignoreDataEquals;
    private static final List<String> ignoreDataEndsWith;
    private static final List<Tag> ignoreDataTag;
    private static final Set<String> ignoreForLevenshtein;
    private static final Set<String> ignoreForOuterMPSameTagCheck;
    protected static final String PREFIX;
    MapCSSTagChecker deprecatedChecker;
    public static final String PREF_CHECK_VALUES;
    public static final String PREF_CHECK_KEYS;
    public static final String PREF_CHECK_COMPLEX;
    public static final String PREF_CHECK_FIXMES;
    public static final String PREF_CHECK_PRESETS_TYPES;
    public static final String PREF_SOURCES;
    private static final String BEFORE_UPLOAD = "BeforeUpload";
    public static final String PREF_CHECK_KEYS_BEFORE_UPLOAD;
    public static final String PREF_CHECK_VALUES_BEFORE_UPLOAD;
    public static final String PREF_CHECK_COMPLEX_BEFORE_UPLOAD;
    public static final String PREF_CHECK_FIXMES_BEFORE_UPLOAD;
    public static final String PREF_CHECK_PRESETS_TYPES_BEFORE_UPLOAD;
    public static final String PREF_KEYS_IGNORE_OUTER_MP_SAME_TAG;
    private static final int MAX_LEVENSHTEIN_DISTANCE = 2;
    protected boolean includeOtherSeverity;
    protected boolean checkKeys;
    protected boolean checkValues;
    protected boolean checkComplex;
    protected boolean checkFixmes;
    protected boolean checkPresetsTypes;
    protected JCheckBox prefCheckKeys;
    protected JCheckBox prefCheckValues;
    protected JCheckBox prefCheckComplex;
    protected JCheckBox prefCheckFixmes;
    protected JCheckBox prefCheckPresetsTypes;
    protected JCheckBox prefCheckKeysBeforeUpload;
    protected JCheckBox prefCheckValuesBeforeUpload;
    protected JCheckBox prefCheckComplexBeforeUpload;
    protected JCheckBox prefCheckFixmesBeforeUpload;
    protected JCheckBox prefCheckPresetsTypesBeforeUpload;
    protected static final int EMPTY_VALUES = 1200;
    protected static final int INVALID_KEY = 1201;
    protected static final int INVALID_VALUE = 1202;
    protected static final int FIXME = 1203;
    protected static final int INVALID_SPACE = 1204;
    protected static final int INVALID_KEY_SPACE = 1205;
    protected static final int INVALID_HTML = 1206;
    protected static final int LONG_VALUE = 1208;
    protected static final int LONG_KEY = 1209;
    protected static final int LOW_CHAR_VALUE = 1210;
    protected static final int LOW_CHAR_KEY = 1211;
    protected static final int MISSPELLED_VALUE = 1212;
    protected static final int MISSPELLED_KEY = 1213;
    protected static final int MULTIPLE_SPACES = 1214;
    protected static final int MISSPELLED_VALUE_NO_FIX = 1215;
    protected static final int UNUSUAL_UNICODE_CHAR_VALUE = 1216;
    protected static final int INVALID_PRESETS_TYPE = 1217;
    protected static final int MULTIPOLYGON_NO_AREA = 1218;
    protected static final int MULTIPOLYGON_INCOMPLETE = 1219;
    protected static final int MULTIPOLYGON_MAYBE_NO_AREA = 1220;
    protected static final int MULTIPOLYGON_SAME_TAG_ON_OUTER = 1221;
    protected EditableList sourcesList;
    private static final List<String> DEFAULT_SOURCES;
    private static final Collection<String> NO_AREA_KEYS;

    public TagChecker() {
        super(I18n.tr("Tag checker", new Object[0]), I18n.tr("This test checks for errors in tag keys and values.", new Object[0]));
    }

    @Override
    public void initialize() throws IOException {
        TaggingPresets.addListener(this);
        TagChecker.initializeData();
        TagChecker.initializePresets();
        TagChecker.analysePresets();
    }

    private static void analysePresets() {
        for (String key : TaggingPresets.getPresetKeys()) {
            Set<String> values;
            boolean allNumerical;
            if (TagChecker.isKeyIgnored(key) || !(allNumerical = !Utils.isEmpty(values = TaggingPresets.getPresetValues(key)) && values.stream().allMatch(TagChecker::isNum))) continue;
            ignoreForLevenshtein.add(key);
        }
    }

    private static void initializeData() throws IOException {
        ignoreDataStartsWith.clear();
        ignoreDataEquals.clear();
        ignoreDataEndsWith.clear();
        ignoreDataTag.clear();
        harmonizedKeys.clear();
        ignoreForLevenshtein.clear();
        oftenUsedTags.clear();
        presetIndex.clear();
        ignoreForOuterMPSameTagCheck.clear();
        StringBuilder errorSources = new StringBuilder();
        for (String source : Config.getPref().getList(PREF_SOURCES, DEFAULT_SOURCES)) {
            try (CachedFile cf = new CachedFile(source);){
                BufferedReader reader = cf.getContentReader();
                Throwable throwable = null;
                try {
                    String line;
                    String okValue = null;
                    boolean tagcheckerfile = false;
                    boolean ignorefile = false;
                    boolean isFirstLine = true;
                    while ((line = reader.readLine()) != null) {
                        if (!line.isEmpty()) {
                            if (line.startsWith("#")) {
                                if (line.startsWith("# JOSM TagChecker")) {
                                    tagcheckerfile = true;
                                    Logging.error(I18n.tr("Ignoring {0}. Support was dropped", source));
                                } else if (line.startsWith("# JOSM IgnoreTags")) {
                                    ignorefile = true;
                                    if (!DEFAULT_SOURCES.contains(source)) {
                                        Logging.info(I18n.tr("Adding {0} to ignore tags", source));
                                    }
                                }
                            } else if (ignorefile) {
                                TagChecker.parseIgnoreFileLine(source, line);
                            } else if (!tagcheckerfile) {
                                if (line.charAt(0) == '+') {
                                    okValue = line.substring(1);
                                } else if (line.charAt(0) == '-' && okValue != null) {
                                    String hk = TagChecker.harmonizeKey(line.substring(1));
                                    if (!okValue.equals(hk) && harmonizedKeys.put(hk, okValue) != null && Logging.isDebugEnabled()) {
                                        Logging.debug("Line was ignored: " + line);
                                    }
                                } else {
                                    Logging.error(I18n.tr("Invalid spellcheck line: {0}", line));
                                }
                            }
                        }
                        if (!isFirstLine) continue;
                        isFirstLine = false;
                        if (tagcheckerfile || ignorefile || DEFAULT_SOURCES.contains(source)) continue;
                        Logging.info(I18n.tr("Adding {0} to spellchecker", source));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    TagChecker.$closeResource(throwable, reader);
                }
            }
            catch (IOException e) {
                Logging.error(e);
                errorSources.append(source).append('\n');
            }
        }
        if (errorSources.length() > 0) {
            throw new IOException(I18n.trn("Could not access data file:\n{0}", "Could not access data files:\n{0}", errorSources.length(), errorSources));
        }
    }

    private static void parseIgnoreFileLine(String source, String line) {
        if ((line = line.trim()).length() < 4) {
            return;
        }
        try {
            String key = line.substring(0, 2);
            line = line.substring(2);
            switch (key) {
                case "S:": {
                    ignoreDataStartsWith.add(line);
                    break;
                }
                case "E:": {
                    ignoreDataEquals.add(line);
                    TagChecker.addToKeyDictionary(line);
                    break;
                }
                case "F:": {
                    ignoreDataEndsWith.add(line);
                    break;
                }
                case "K:": {
                    Tag tag = Tag.ofString(line);
                    ignoreDataTag.add(tag);
                    oftenUsedTags.put(tag.getKey(), tag.getValue());
                    TagChecker.addToKeyDictionary(tag.getKey());
                    break;
                }
                default: {
                    if (!key.startsWith(";")) {
                        Logging.warn("Unsupported TagChecker key: " + key);
                    }
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            Logging.error("Invalid line in {0} : {1}", source, e.getMessage());
            Logging.trace(e);
        }
    }

    private static void addToKeyDictionary(String key) {
        String hk;
        if (key != null && !key.equals(hk = TagChecker.harmonizeKey(key))) {
            harmonizedKeys.put(hk, key);
        }
    }

    public static void initializePresets() {
        if (!Config.getPref().getBoolean(PREF_CHECK_VALUES, true)) {
            return;
        }
        Collection<TaggingPreset> presets = TaggingPresets.getTaggingPresets();
        if (!presets.isEmpty()) {
            TagChecker.initAdditionalPresetsValueData();
            for (TaggingPreset p : presets) {
                ArrayList<TaggingPresetItem> minData = new ArrayList<TaggingPresetItem>();
                for (TaggingPresetItem i : p.data) {
                    if (i instanceof KeyedItem) {
                        if (!"none".equals(((KeyedItem)i).match)) {
                            minData.add(i);
                        }
                        TagChecker.addPresetValue((KeyedItem)i);
                        continue;
                    }
                    if (!(i instanceof CheckGroup)) continue;
                    for (Check c : ((CheckGroup)i).checks) {
                        TagChecker.addPresetValue(c);
                    }
                }
                if (minData.isEmpty()) continue;
                presetIndex.put(p, minData);
            }
        }
    }

    private static void initAdditionalPresetsValueData() {
        additionalPresetsValueData = new HashSet();
        additionalPresetsValueData.addAll(AbstractPrimitive.getUninterestingKeys());
        additionalPresetsValueData.addAll(Config.getPref().getList("validator.knownkeys", Arrays.asList("is_in", "int_ref", "fixme", "population")));
    }

    private static void addPresetValue(KeyedItem ky) {
        if (ky.key != null && ky.getValues() != null) {
            TagChecker.addToKeyDictionary(ky.key);
        }
    }

    static boolean containsUnwantedNonPrintingControlCharacter(String s) {
        return !Utils.isEmpty(s) && (TagChecker.isJoiningChar(s.charAt(0)) || TagChecker.isJoiningChar(s.charAt(s.length() - 1)) || s.chars().anyMatch(c -> TagChecker.isAsciiControlChar(c) && !TagChecker.isNewLineChar(c) || TagChecker.isBidiControlChar(c)));
    }

    private static boolean isAsciiControlChar(int c) {
        return c < 32 || c == 127;
    }

    private static boolean isNewLineChar(int c) {
        return c == 10 || c == 13;
    }

    private static boolean isJoiningChar(int c) {
        return c == 8204 || c == 8205;
    }

    private static boolean isBidiControlChar(int c) {
        return c >= 8206 && c <= 8207 || c >= 8234 && c <= 8238;
    }

    static String removeUnwantedNonPrintingControlCharacters(String s) {
        String result = UNWANTED_NON_PRINTING_CONTROL_CHARACTERS.matcher(s).replaceAll("");
        while (!result.isEmpty() && TagChecker.isJoiningChar(result.charAt(0))) {
            result = result.substring(1);
        }
        while (!result.isEmpty() && TagChecker.isJoiningChar(result.charAt(result.length() - 1))) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    static boolean containsUnusualUnicodeCharacter(String key, String value) {
        return TagChecker.getUnusualUnicodeCharacter(key, value).isPresent();
    }

    static OptionalInt getUnusualUnicodeCharacter(String key, String value) {
        return value == null ? OptionalInt.empty() : value.chars().filter(c -> TagChecker.isUnusualUnicodeBlock(key, c)).findFirst();
    }

    private static boolean isUnusualUnicodeBlock(String key, int c) {
        Character.UnicodeBlock b = Character.UnicodeBlock.of(c);
        return TagChecker.isUnusualPhoneticUse(key, b, c) || TagChecker.isUnusualBmpUse(b) || TagChecker.isUnusualSmpUse(b);
    }

    private static boolean isAllowedPhoneticCharacter(String key, int c) {
        return c == 601 || c == 399 || c == 596 || c == 390 || c == 599 || c == 394 || c == 603 || c == 400 || c == 611 || c == 404 || c == 616 || c == 407 || c == 617 || c == 406 || c == 626 || c == 413 || c == 627 || c == 414 || c == 322 || c == 660 || c == 7611 || c == 695 || key.endsWith("ref") && 7468 <= c && c <= 7490;
    }

    private static boolean isUnusualPhoneticUse(String key, Character.UnicodeBlock b, int c) {
        return !TagChecker.isAllowedPhoneticCharacter(key, c) && (b == Character.UnicodeBlock.IPA_EXTENSIONS || b == Character.UnicodeBlock.PHONETIC_EXTENSIONS || b == Character.UnicodeBlock.PHONETIC_EXTENSIONS_SUPPLEMENT) && !key.endsWith(":pronunciation");
    }

    private static boolean isUnusualBmpUse(Character.UnicodeBlock b) {
        return b == Character.UnicodeBlock.COMBINING_MARKS_FOR_SYMBOLS || b == Character.UnicodeBlock.MATHEMATICAL_OPERATORS || b == Character.UnicodeBlock.ENCLOSED_ALPHANUMERICS || b == Character.UnicodeBlock.BOX_DRAWING || b == Character.UnicodeBlock.GEOMETRIC_SHAPES || b == Character.UnicodeBlock.DINGBATS || b == Character.UnicodeBlock.MISCELLANEOUS_SYMBOLS_AND_ARROWS || b == Character.UnicodeBlock.GLAGOLITIC || b == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO || b == Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS || b == Character.UnicodeBlock.LATIN_EXTENDED_D || b == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || b == Character.UnicodeBlock.ALPHABETIC_PRESENTATION_FORMS || b == Character.UnicodeBlock.VARIATION_SELECTORS || b == Character.UnicodeBlock.SPECIALS;
    }

    private static boolean isUnusualSmpUse(Character.UnicodeBlock b) {
        return b == Character.UnicodeBlock.MUSICAL_SYMBOLS || b == Character.UnicodeBlock.ENCLOSED_ALPHANUMERIC_SUPPLEMENT || b == Character.UnicodeBlock.EMOTICONS || b == Character.UnicodeBlock.TRANSPORT_AND_MAP_SYMBOLS;
    }

    private static Set<String> getPresetValues(String key) {
        if (TaggingPresets.isKeyInPresets(key)) {
            return TaggingPresets.getPresetValues(key);
        }
        if (additionalPresetsValueData.contains(key)) {
            return Collections.emptySet();
        }
        return null;
    }

    @Deprecated
    public static boolean isKeyInPresets(String key) {
        return TaggingPresets.isKeyInPresets(key);
    }

    public static boolean isTagInPresets(String key, String value) {
        Set<String> values = TagChecker.getPresetValues(key);
        return values != null && values.contains(value);
    }

    public static List<Tag> getIgnoredTags() {
        return new ArrayList<Tag>(ignoreDataTag);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isKeyIgnored(String key) {
        if (ignoreDataEquals.contains(key)) return true;
        if (ignoreDataStartsWith.stream().anyMatch(key::startsWith)) return true;
        if (!ignoreDataEndsWith.stream().anyMatch(key::endsWith)) return false;
        return true;
    }

    public static boolean isTagIgnored(String key, String value) {
        if (TagChecker.isKeyIgnored(key)) {
            return true;
        }
        Set<String> values = TagChecker.getPresetValues(key);
        if (values != null && values.isEmpty()) {
            return true;
        }
        if (!TagChecker.isTagInPresets(key, value)) {
            return ignoreDataTag.stream().anyMatch(a -> key.equals(a.getKey()) && value.equals(a.getValue()));
        }
        return false;
    }

    @Override
    public void check(OsmPrimitive p) {
        if (!p.isTagged()) {
            return;
        }
        MultiMap<OsmPrimitive, String> withErrors = new MultiMap<OsmPrimitive, String>();
        for (Map.Entry<String, String> prop : p.getKeys().entrySet()) {
            String s = I18n.marktr("Tag ''{0}'' invalid.");
            String key = prop.getKey();
            String value = prop.getValue();
            if (this.checkKeys) {
                this.checkSingleTagKeySimple(withErrors, p, s, key);
            }
            if (this.checkValues) {
                this.checkSingleTagValueSimple(withErrors, p, s, key, value);
                this.checkSingleTagComplex(withErrors, p, key, value);
            }
            if (!this.checkFixmes || key == null || Utils.isEmpty(value) || !TagChecker.isFixme(key, value) || withErrors.contains(p, "FIXME")) continue;
            this.errors.add(TestError.builder(this, Severity.OTHER, 1203).message(I18n.tr("fixme", new Object[0])).primitives(p).build());
            withErrors.put(p, "FIXME");
        }
        if (p instanceof Relation && p.hasTag("type", "multipolygon")) {
            this.checkMultipolygonTags(p);
        }
        if (this.checkPresetsTypes) {
            TagMap tags = p.getKeys();
            TaggingPresetType presetType = TaggingPresetType.forPrimitive(p);
            EnumSet<TaggingPresetType> presetTypes = EnumSet.of(presetType);
            Collection matchingPresets = presetIndex.entrySet().stream().filter(e -> TaggingPresetItem.matches((Iterable)e.getValue(), tags)).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
            Collection matchingPresetsOK = matchingPresets.stream().filter(tp -> tp.typeMatches(presetTypes)).collect(Collectors.toList());
            Collection matchingPresetsKO = matchingPresets.stream().filter(tp -> !tp.typeMatches(presetTypes)).collect(Collectors.toList());
            for (TaggingPreset tp3 : matchingPresetsKO) {
                Map<String, String> matchingTags = tp3.data.stream().filter(i -> Boolean.TRUE.equals(i.matches(tags))).filter(i -> i instanceof KeyedItem).map(i -> ((KeyedItem)i).key).collect(Collectors.toMap(k -> k, tags::get));
                if (!matchingPresetsOK.stream().noneMatch(tp2 -> matchingTags.entrySet().stream().allMatch(e -> tp2.data.stream().anyMatch(i -> i instanceof KeyedItem && ((KeyedItem)i).key.equals(e.getKey()))))) continue;
                this.errors.add(TestError.builder(this, Severity.OTHER, 1217).message(I18n.tr("Object type not in preset", new Object[0]), I18n.marktr("Object type {0} is not supported by tagging preset: {1}"), I18n.tr(presetType.getName(), new Object[0]), tp3.getLocaleName()).primitives(p).build());
            }
        }
    }

    private void checkMultipolygonTags(OsmPrimitive p) {
        if (p.isAnnotated() || p.keys().anyMatch(k -> k.matches("^(abandoned|construction|demolished|disused|planned|razed|removed|was).*"))) {
            return;
        }
        this.checkOuterWaysOfRelation((Relation)p);
        if (TagChecker.hasAcceptedPrimaryTagForMultipolygon(p)) {
            return;
        }
        TestError.Builder builder = null;
        if (p.hasKey("surface")) {
            builder = TestError.builder(this, Severity.OTHER, 1219).message(I18n.tr("Multipolygon tags", new Object[0]), I18n.marktr("only {0} tag"), "surface");
        } else {
            Map<String, String> filteredTags = p.getInterestingTags();
            filteredTags.remove("type");
            NO_AREA_KEYS.forEach(filteredTags::remove);
            filteredTags.keySet().removeIf(key -> !key.matches("[a-z0-9:_]+"));
            if (filteredTags.isEmpty()) {
                builder = TestError.builder(this, Severity.ERROR, 1218).message(I18n.tr("Multipolygon tags", new Object[0]), I18n.marktr("tag describing the area is missing"), new Object());
            }
        }
        if (builder == null) {
            builder = TestError.builder(this, Severity.WARNING, 1220).message(I18n.tr("Multipolygon tags", new Object[0]), I18n.marktr("tag describing the area might be missing"), new Object());
        }
        this.errors.add(builder.primitives(p).build());
    }

    private void checkOuterWaysOfRelation(Relation rel) {
        for (Map.Entry<String, String> tag : rel.getInterestingTags().entrySet()) {
            Set sameOuters;
            if (ignoreForOuterMPSameTagCheck.contains(tag.getKey()) || (sameOuters = rel.getMembers().stream().filter(rm -> rm.isWay() && rm.getWay().isArea() && "outer".equals(rm.getRole()) && ((String)tag.getValue()).equals(rm.getWay().get((String)tag.getKey()))).map(RelationMember::getWay).collect(Collectors.toSet())).isEmpty()) continue;
            ArrayList<Relation> primitives = new ArrayList<Relation>(sameOuters.size() + 1);
            primitives.add(rel);
            primitives.addAll(sameOuters);
            Way w = new Way();
            w.put(tag.getKey(), tag.getValue());
            if (TagChecker.hasAcceptedPrimaryTagForMultipolygon(w)) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1221).message(I18n.tr("Multipolygon outer way repeats major tag of relation", new Object[0]), I18n.marktr("Same tag:''{0}''=''{1}''"), tag.getKey(), tag.getValue()).primitives(primitives).build());
                continue;
            }
            this.errors.add(TestError.builder(this, Severity.OTHER, 1221).message(I18n.tr("Multipolygon outer way repeats tag of relation", new Object[0]), I18n.marktr("Same tag:''{0}''=''{1}''"), tag.getKey(), tag.getValue()).primitives(primitives).build());
        }
    }

    private static boolean hasAcceptedPrimaryTagForMultipolygon(OsmPrimitive p) {
        if (p.hasKey("landuse", "amenity", "building", "building:part", "area:highway", "shop", "place", "boundary", "landform", "piste:type", "sport", "golf", "landcover", "aeroway", "office", "healthcare", "craft", "room") || p.hasTagDifferent("natural", "tree", "peek", "saddle", "tree_row") || p.hasTagDifferent("man_made", "survey_point", "mast", "flagpole", "manhole", "watertap") || p.hasTagDifferent("highway", "crossing", "bus_stop", "turning_circle", "street_lamp", "traffic_signals", "stop", "milestone", "mini_roundabout", "motorway_junction", "passing_place", "speed_camera", "traffic_mirror", "trailhead", "turning_circle", "turning_loop", "toll_gantry") || p.hasTagDifferent("tourism", "attraction", "artwork") || p.hasTagDifferent("leisure", "picnic_table", "slipway", "firepit") || p.hasTagDifferent("historic", "wayside_cross", "milestone")) {
            return true;
        }
        if (p.hasTag("barrier", "hedge", "retaining_wall") || p.hasTag("public_transport", "platform", "station") || p.hasTag("railway", "platform") || p.hasTag("waterway", "riverbank", "dam", "rapids", "dock", "boatyard", "fuel") || p.hasTag("indoor", "corridor", "room", "area") || p.hasTag("power", "substation", "generator", "plant", "switchgear", "converter", "sub_station") || p.hasTag("seamark:type", "harbour", "fairway", "anchorage", "landmark", "berth", "harbour_basin", "separation_zone") || p.get("seamark:type") != null && p.get("seamark:type").matches(".*\\_(area|zone)$")) {
            return true;
        }
        return p.hasTag("harbour", "yes") || p.hasTag("flood_prone", "yes") || p.hasTag("bridge", "yes") || p.hasTag("ruins", "yes") || p.hasTag("junction", "yes");
    }

    private void checkSingleTagValueSimple(MultiMap<OsmPrimitive, String> withErrors, OsmPrimitive p, String s, String key, String value) {
        OptionalInt unusualUnicodeCharacter;
        if (!this.checkValues || value == null) {
            return;
        }
        if (TagChecker.containsUnwantedNonPrintingControlCharacter(value) && !withErrors.contains(p, "ICV")) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1210).message(I18n.tr("Tag value contains non-printing (usually invisible) character", new Object[0]), s, key).primitives(p).fix(() -> new ChangePropertyCommand(p, key, TagChecker.removeUnwantedNonPrintingControlCharacters(value))).build());
            withErrors.put(p, "ICV");
        }
        if ((unusualUnicodeCharacter = TagChecker.getUnusualUnicodeCharacter(key, value)).isPresent() && !withErrors.contains(p, "UUCV")) {
            String codepoint = String.format(Locale.ROOT, "U+%04X", unusualUnicodeCharacter.getAsInt());
            this.errors.add(TestError.builder(this, Severity.WARNING, 1216).message(I18n.tr("Tag value contains unusual Unicode character {0}", codepoint), s, key).primitives(p).build());
            withErrors.put(p, "UUCV");
        }
        if (value.length() > 255 && !withErrors.contains(p, "LV")) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1208).message(I18n.tr("Tag value longer than {0} characters ({1} characters)", 255, value.length()), s, key).primitives(p).build());
            withErrors.put(p, "LV");
        }
        if (value.trim().isEmpty() && !withErrors.contains(p, "EV")) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1200).message(I18n.tr("Tags with empty values", new Object[0]), s, key).primitives(p).build());
            withErrors.put(p, "EV");
        }
        String errTypeSpace = "SPACE";
        if ((value.startsWith(" ") || value.endsWith(" ")) && !withErrors.contains(p, "SPACE")) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1204).message(I18n.tr("Property values start or end with white space", new Object[0]), s, key).primitives(p).build());
            withErrors.put(p, "SPACE");
        }
        if (value.contains("  ") && !withErrors.contains(p, "SPACE")) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1214).message(I18n.tr("Property values contain multiple white spaces", new Object[0]), s, key).primitives(p).build());
            withErrors.put(p, "SPACE");
        }
        if (this.includeOtherSeverity && !value.equals(Entities.unescape(value)) && !withErrors.contains(p, "HTML")) {
            this.errors.add(TestError.builder(this, Severity.OTHER, 1206).message(I18n.tr("Property values contain HTML entity", new Object[0]), s, key).primitives(p).build());
            withErrors.put(p, "HTML");
        }
    }

    private void checkSingleTagKeySimple(MultiMap<OsmPrimitive, String> withErrors, OsmPrimitive p, String s, String key) {
        if (!this.checkKeys || key == null) {
            return;
        }
        if (TagChecker.containsUnwantedNonPrintingControlCharacter(key) && !withErrors.contains(p, "ICK")) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1211).message(I18n.tr("Tag key contains non-printing character", new Object[0]), s, key).primitives(p).fix(() -> new ChangePropertyCommand(p, key, TagChecker.removeUnwantedNonPrintingControlCharacters(key))).build());
            withErrors.put(p, "ICK");
        }
        if (key.length() > 255 && !withErrors.contains(p, "LK")) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1209).message(I18n.tr("Tag key longer than {0} characters ({1} characters)", 255, key.length()), s, key).primitives(p).build());
            withErrors.put(p, "LK");
        }
        if (key.indexOf(32) >= 0 && !withErrors.contains(p, "IPK")) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1205).message(I18n.tr("Invalid white space in property key", new Object[0]), s, key).primitives(p).build());
            withErrors.put(p, "IPK");
        }
    }

    private void checkSingleTagComplex(MultiMap<OsmPrimitive, String> withErrors, OsmPrimitive p, String key, String value) {
        if (!this.checkValues || key == null || Utils.isEmpty(value)) {
            return;
        }
        if (additionalPresetsValueData != null && !TagChecker.isTagIgnored(key, value)) {
            if (!TaggingPresets.isKeyInPresets(key)) {
                this.spellCheckKey(withErrors, p, key);
            } else if (!TagChecker.isTagInPresets(key, value)) {
                if (oftenUsedTags.contains(key, value)) {
                    this.errors.add(TestError.builder(this, Severity.OTHER, 1202).message(I18n.tr("Presets do not contain property value", new Object[0]), I18n.marktr("Value ''{0}'' for key ''{1}'' not in presets, but is known."), value, key).primitives(p).build());
                    withErrors.put(p, "UPV");
                } else {
                    this.tryGuess(p, key, value, withErrors);
                }
            }
        }
    }

    private void spellCheckKey(MultiMap<OsmPrimitive, String> withErrors, OsmPrimitive p, String key) {
        String fixedKey;
        String prettifiedKey = TagChecker.harmonizeKey(key);
        if (ignoreDataEquals.contains(prettifiedKey)) {
            fixedKey = prettifiedKey;
        } else {
            String string = fixedKey = TaggingPresets.isKeyInPresets(prettifiedKey) ? prettifiedKey : harmonizedKeys.get(prettifiedKey);
        }
        if (fixedKey == null && ignoreDataTag.stream().anyMatch(a -> a.getKey().equals(prettifiedKey))) {
            fixedKey = prettifiedKey;
        }
        if (!Utils.isEmpty(fixedKey) && !fixedKey.equals(key)) {
            String proposedKey = fixedKey;
            TestError.Builder error = TestError.builder(this, Severity.WARNING, 1213).message(I18n.tr("Misspelled property key", new Object[0]), I18n.marktr("Key ''{0}'' looks like ''{1}''."), key, proposedKey).primitives(p);
            if (p.hasKey(fixedKey)) {
                this.errors.add(error.build());
            } else {
                this.errors.add(error.fix(() -> new ChangePropertyKeyCommand(p, key, proposedKey)).build());
            }
            withErrors.put(p, "WPK");
        } else if (this.includeOtherSeverity) {
            this.errors.add(TestError.builder(this, Severity.OTHER, 1201).message(I18n.tr("Presets do not contain property key", new Object[0]), I18n.marktr("Key ''{0}'' not in presets."), key).primitives(p).build());
            withErrors.put(p, "UPK");
        }
    }

    private void tryGuess(OsmPrimitive p, String key, String value, MultiMap<OsmPrimitive, String> withErrors) {
        String fixedValue;
        Set<String> usedValues;
        String harmonizedValue = TagChecker.harmonizeValue(value);
        if (Utils.isEmpty(harmonizedValue)) {
            return;
        }
        ArrayList<Set<String>> sets = new ArrayList<Set<String>>();
        Set<String> presetValues = TagChecker.getPresetValues(key);
        if (presetValues != null) {
            sets.add(presetValues);
        }
        if ((usedValues = oftenUsedTags.get(key)) != null) {
            sets.add(usedValues);
        }
        String string = fixedValue = sets.stream().anyMatch(possibleValues -> possibleValues.contains(harmonizedValue)) ? harmonizedValue : null;
        if (fixedValue == null && !ignoreForLevenshtein.contains(key)) {
            int maxPresetValueLen = 0;
            ArrayList<String> fixVals = new ArrayList<String>();
            int minDist = 3;
            for (Set set : sets) {
                for (String possibleVal : set) {
                    int dist;
                    if (possibleVal.isEmpty()) continue;
                    maxPresetValueLen = Math.max(maxPresetValueLen, possibleVal.length());
                    if (harmonizedValue.length() < 3 && possibleVal.length() >= harmonizedValue.length() + 2 || (dist = Utils.getLevenshteinDistance(possibleVal, harmonizedValue)) >= harmonizedValue.length()) continue;
                    if (dist < minDist) {
                        minDist = dist;
                        fixVals.clear();
                        fixVals.add(possibleVal);
                        continue;
                    }
                    if (dist != minDist) continue;
                    fixVals.add(possibleVal);
                }
            }
            if (!(minDist > 2 || maxPresetValueLen <= 2 || fixVals.isEmpty() || harmonizedValue.length() <= 3 && minDist >= 2)) {
                this.filterDeprecatedTags(p, key, fixVals);
                if (!fixVals.isEmpty()) {
                    if (fixVals.size() < 2) {
                        fixedValue = (String)fixVals.get(0);
                    } else {
                        Collections.sort(fixVals);
                        this.errors.add(TestError.builder(this, Severity.WARNING, 1215).message(I18n.tr("Unknown property value", new Object[0]), I18n.marktr("Value ''{0}'' for key ''{1}'' is unknown, maybe one of {2} is meant?"), value, key, fixVals).primitives(p).build());
                        withErrors.put(p, "WPV");
                        return;
                    }
                }
            }
        }
        if (fixedValue != null && !fixedValue.equals(value)) {
            String newValue = fixedValue;
            this.errors.add(TestError.builder(this, Severity.WARNING, 1212).message(I18n.tr("Unknown property value", new Object[0]), I18n.marktr("Value ''{0}'' for key ''{1}'' is unknown, maybe ''{2}'' is meant?"), value, key, newValue).primitives(p).build());
            withErrors.put(p, "WPV");
        } else if (this.includeOtherSeverity) {
            this.errors.add(TestError.builder(this, Severity.OTHER, 1202).message(I18n.tr("Presets do not contain property value", new Object[0]), I18n.marktr("Value ''{0}'' for key ''{1}'' not in presets."), value, key).primitives(p).build());
            withErrors.put(p, "UPV");
        }
    }

    private void filterDeprecatedTags(OsmPrimitive p, String key, List<String> fixVals) {
        if (fixVals.isEmpty() || this.deprecatedChecker == null) {
            return;
        }
        int unchangedDeprecated = this.countDeprecated(p);
        MergeSourceBuildingVisitor builder = new MergeSourceBuildingVisitor(p.getDataSet());
        p.accept(builder);
        DataSet clonedDs = builder.build();
        OsmPrimitive clone = clonedDs.getPrimitiveById(p.getPrimitiveId());
        Iterator<String> iter = fixVals.iterator();
        while (iter.hasNext()) {
            clone.put(key, iter.next());
            if (this.countDeprecated(clone) <= unchangedDeprecated) continue;
            iter.remove();
        }
    }

    private int countDeprecated(OsmPrimitive p) {
        if (this.deprecatedChecker == null) {
            return 0;
        }
        this.deprecatedChecker.getErrors().clear();
        this.deprecatedChecker.visit(Collections.singleton(p), url -> url.endsWith("deprecated.mapcss"));
        return this.deprecatedChecker.getErrors().size();
    }

    private static boolean isNum(String harmonizedValue) {
        try {
            Double.parseDouble(harmonizedValue);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isFixme(String key, String value) {
        return key.toLowerCase(Locale.ENGLISH).contains("fixme") || key.contains("todo") || value.toLowerCase(Locale.ENGLISH).contains("fixme") || value.contains("check and delete");
    }

    private static String harmonizeKey(String key) {
        return Utils.strip(key.toLowerCase(Locale.ENGLISH).replace('-', '_').replace(':', '_').replace(' ', '_'), "-_;:,");
    }

    private static String harmonizeValue(String value) {
        return Utils.strip(value.toLowerCase(Locale.ENGLISH).replace('-', '_').replace(' ', '_'), "-_;:,");
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.includeOtherSeverity = this.includeOtherSeverityChecks();
        this.checkKeys = Config.getPref().getBoolean(PREF_CHECK_KEYS, true);
        if (this.isBeforeUpload) {
            this.checkKeys = this.checkKeys && Config.getPref().getBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, true);
        }
        this.checkValues = Config.getPref().getBoolean(PREF_CHECK_VALUES, true);
        if (this.isBeforeUpload) {
            this.checkValues = this.checkValues && Config.getPref().getBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, true);
        }
        this.checkComplex = Config.getPref().getBoolean(PREF_CHECK_COMPLEX, true);
        if (this.isBeforeUpload) {
            this.checkComplex = this.checkComplex && Config.getPref().getBoolean(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, true);
        }
        boolean bl = this.checkFixmes = this.includeOtherSeverity && Config.getPref().getBoolean(PREF_CHECK_FIXMES, true);
        if (this.isBeforeUpload) {
            this.checkFixmes = this.checkFixmes && Config.getPref().getBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, true);
        }
        boolean bl2 = this.checkPresetsTypes = this.includeOtherSeverity && Config.getPref().getBoolean(PREF_CHECK_PRESETS_TYPES, true);
        if (this.isBeforeUpload) {
            this.checkPresetsTypes = this.checkPresetsTypes && Config.getPref().getBoolean(PREF_CHECK_PRESETS_TYPES_BEFORE_UPLOAD, true);
        }
        this.deprecatedChecker = OsmValidator.getTest(MapCSSTagChecker.class);
        ignoreForOuterMPSameTagCheck.addAll(Config.getPref().getList(PREF_KEYS_IGNORE_OUTER_MP_SAME_TAG, Collections.emptyList()));
    }

    @Override
    public void endTest() {
        this.deprecatedChecker = null;
        super.endTest();
    }

    @Override
    public void visit(Collection<OsmPrimitive> selection) {
        if (this.checkKeys || this.checkValues || this.checkComplex || this.checkFixmes || this.checkPresetsTypes) {
            super.visit(selection);
        }
    }

    @Override
    public void addGui(JPanel testPanel) {
        GBC a = GBC.eol();
        a.anchor = 22;
        testPanel.add((Component)new JLabel(this.name + " :"), GBC.eol().insets(3, 0, 0, 0));
        this.prefCheckKeys = new JCheckBox(I18n.tr("Check property keys.", new Object[0]), Config.getPref().getBoolean(PREF_CHECK_KEYS, true));
        this.prefCheckKeys.setToolTipText(I18n.tr("Validate that property keys are valid checking against list of words.", new Object[0]));
        testPanel.add((Component)this.prefCheckKeys, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckKeysBeforeUpload = new JCheckBox();
        this.prefCheckKeysBeforeUpload.setSelected(Config.getPref().getBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckKeysBeforeUpload, a);
        this.prefCheckComplex = new JCheckBox(I18n.tr("Use complex property checker.", new Object[0]), Config.getPref().getBoolean(PREF_CHECK_COMPLEX, true));
        this.prefCheckComplex.setToolTipText(I18n.tr("Validate property values and tags using complex rules.", new Object[0]));
        testPanel.add((Component)this.prefCheckComplex, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckComplexBeforeUpload = new JCheckBox();
        this.prefCheckComplexBeforeUpload.setSelected(Config.getPref().getBoolean(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckComplexBeforeUpload, a);
        List<String> sources = Config.getPref().getList(PREF_SOURCES, DEFAULT_SOURCES);
        this.sourcesList = new EditableList(I18n.tr("TagChecker source", new Object[0]));
        this.sourcesList.setItems(sources);
        testPanel.add((Component)new JLabel(I18n.tr("Data sources ({0})", "*.cfg")), GBC.eol().insets(23, 0, 0, 0));
        testPanel.add((Component)this.sourcesList, GBC.eol().fill(2).insets(23, 0, 0, 0));
        ActionListener disableCheckActionListener = e -> this.handlePrefEnable();
        this.prefCheckKeys.addActionListener(disableCheckActionListener);
        this.prefCheckKeysBeforeUpload.addActionListener(disableCheckActionListener);
        this.prefCheckComplex.addActionListener(disableCheckActionListener);
        this.prefCheckComplexBeforeUpload.addActionListener(disableCheckActionListener);
        this.handlePrefEnable();
        this.prefCheckValues = new JCheckBox(I18n.tr("Check property values.", new Object[0]), Config.getPref().getBoolean(PREF_CHECK_VALUES, true));
        this.prefCheckValues.setToolTipText(I18n.tr("Validate that property values are valid checking against presets.", new Object[0]));
        testPanel.add((Component)this.prefCheckValues, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckValuesBeforeUpload = new JCheckBox();
        this.prefCheckValuesBeforeUpload.setSelected(Config.getPref().getBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckValuesBeforeUpload, a);
        this.prefCheckFixmes = new JCheckBox(I18n.tr("Check for fixme.", new Object[0]), Config.getPref().getBoolean(PREF_CHECK_FIXMES, true));
        this.prefCheckFixmes.setToolTipText(I18n.tr("Looks for nodes or ways with fixme in any property value.", new Object[0]));
        testPanel.add((Component)this.prefCheckFixmes, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckFixmesBeforeUpload = new JCheckBox();
        this.prefCheckFixmesBeforeUpload.setSelected(Config.getPref().getBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckFixmesBeforeUpload, a);
        this.prefCheckPresetsTypes = new JCheckBox(I18n.tr("Check for presets types.", new Object[0]), Config.getPref().getBoolean(PREF_CHECK_PRESETS_TYPES, true));
        this.prefCheckPresetsTypes.setToolTipText(I18n.tr("Validate that objects types are valid checking against presets.", new Object[0]));
        testPanel.add((Component)this.prefCheckPresetsTypes, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckPresetsTypesBeforeUpload = new JCheckBox();
        this.prefCheckPresetsTypesBeforeUpload.setSelected(Config.getPref().getBoolean(PREF_CHECK_PRESETS_TYPES_BEFORE_UPLOAD, true));
        testPanel.add((Component)this.prefCheckPresetsTypesBeforeUpload, a);
    }

    public void handlePrefEnable() {
        boolean selected = this.prefCheckKeys.isSelected() || this.prefCheckKeysBeforeUpload.isSelected() || this.prefCheckComplex.isSelected() || this.prefCheckComplexBeforeUpload.isSelected();
        this.sourcesList.setEnabled(selected);
    }

    @Override
    public boolean ok() {
        this.enabled = this.prefCheckKeys.isSelected() || this.prefCheckValues.isSelected() || this.prefCheckComplex.isSelected() || this.prefCheckFixmes.isSelected();
        this.testBeforeUpload = this.prefCheckKeysBeforeUpload.isSelected() || this.prefCheckValuesBeforeUpload.isSelected() || this.prefCheckFixmesBeforeUpload.isSelected() || this.prefCheckComplexBeforeUpload.isSelected();
        Config.getPref().putBoolean(PREF_CHECK_VALUES, this.prefCheckValues.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_COMPLEX, this.prefCheckComplex.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_KEYS, this.prefCheckKeys.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_FIXMES, this.prefCheckFixmes.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_PRESETS_TYPES, this.prefCheckPresetsTypes.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, this.prefCheckValuesBeforeUpload.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, this.prefCheckComplexBeforeUpload.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, this.prefCheckKeysBeforeUpload.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, this.prefCheckFixmesBeforeUpload.isSelected());
        Config.getPref().putBoolean(PREF_CHECK_PRESETS_TYPES_BEFORE_UPLOAD, this.prefCheckPresetsTypesBeforeUpload.isSelected());
        return Config.getPref().putList(PREF_SOURCES, this.sourcesList.getItems());
    }

    @Override
    public Command fixError(TestError testError) {
        ArrayList<Command> commands = new ArrayList<Command>(50);
        Collection<? extends OsmPrimitive> primitives = testError.getPrimitives();
        for (OsmPrimitive osmPrimitive : primitives) {
            TagMap tags = osmPrimitive.getKeys();
            if (tags.isEmpty()) continue;
            for (Map.Entry prop : tags.entrySet()) {
                String key = (String)prop.getKey();
                String value = (String)prop.getValue();
                if (Utils.isBlank(value)) {
                    commands.add(new ChangePropertyCommand(osmPrimitive, key, null));
                    continue;
                }
                if (value.startsWith(" ") || value.endsWith(" ") || value.contains("  ")) {
                    commands.add(new ChangePropertyCommand(osmPrimitive, key, Utils.removeWhiteSpaces(value)));
                    continue;
                }
                if (key.startsWith(" ") || key.endsWith(" ") || key.contains("  ")) {
                    commands.add(new ChangePropertyKeyCommand(osmPrimitive, key, Utils.removeWhiteSpaces(key)));
                    continue;
                }
                String evalue = Entities.unescape(value);
                if (evalue.equals(value)) continue;
                commands.add(new ChangePropertyCommand(osmPrimitive, key, evalue));
            }
        }
        if (commands.isEmpty()) {
            return null;
        }
        if (commands.size() == 1) {
            return (Command)commands.get(0);
        }
        return new SequenceCommand(I18n.tr("Fix tags", new Object[0]), commands);
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof TagChecker) {
            int code = testError.getCode();
            return code == 1200 || code == 1204 || code == 1205 || code == 1206 || code == 1214;
        }
        return false;
    }

    @Override
    public void taggingPresetsModified() {
        try {
            TagChecker.initializeData();
            TagChecker.initializePresets();
            TagChecker.analysePresets();
        }
        catch (IOException e) {
            Logging.error(e);
        }
    }

    static {
        oftenUsedTags = new MultiMap();
        presetIndex = new LinkedHashMap<TaggingPreset, List<TaggingPresetItem>>();
        UNWANTED_NON_PRINTING_CONTROL_CHARACTERS = Pattern.compile("[\\x00-\\x09\\x0B\\x0C\\x0E-\\x1F\\x7F\\u200e-\\u200f\\u202a-\\u202e]");
        ignoreDataStartsWith = new ArrayList<String>();
        ignoreDataEquals = new HashSet<String>();
        ignoreDataEndsWith = new ArrayList<String>();
        ignoreDataTag = new ArrayList<Tag>();
        ignoreForLevenshtein = new HashSet<String>();
        ignoreForOuterMPSameTagCheck = new HashSet<String>();
        PREFIX = "validator." + TagChecker.class.getSimpleName();
        PREF_CHECK_VALUES = PREFIX + ".checkValues";
        PREF_CHECK_KEYS = PREFIX + ".checkKeys";
        PREF_CHECK_COMPLEX = PREFIX + ".checkComplex";
        PREF_CHECK_FIXMES = PREFIX + ".checkFixmes";
        PREF_CHECK_PRESETS_TYPES = PREFIX + ".checkPresetsTypes";
        PREF_SOURCES = PREFIX + ".source";
        PREF_CHECK_KEYS_BEFORE_UPLOAD = PREF_CHECK_KEYS + BEFORE_UPLOAD;
        PREF_CHECK_VALUES_BEFORE_UPLOAD = PREF_CHECK_VALUES + BEFORE_UPLOAD;
        PREF_CHECK_COMPLEX_BEFORE_UPLOAD = PREF_CHECK_COMPLEX + BEFORE_UPLOAD;
        PREF_CHECK_FIXMES_BEFORE_UPLOAD = PREF_CHECK_FIXMES + BEFORE_UPLOAD;
        PREF_CHECK_PRESETS_TYPES_BEFORE_UPLOAD = PREF_CHECK_PRESETS_TYPES + BEFORE_UPLOAD;
        PREF_KEYS_IGNORE_OUTER_MP_SAME_TAG = PREFIX + ".ignore-keys-outer-mp-same-tag";
        DEFAULT_SOURCES = Arrays.asList(IGNORE_FILE, SPELL_FILE);
        NO_AREA_KEYS = Arrays.asList("name", "area", "ref", "access", "operator");
    }
}

