#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 text-manipulate
version:              0.3.0.0
visibility:           public
id:                   text-manipulate-0.3.0.0-IA1vwAbagmRJhy7paqdrR0
key:                  text-manipulate-0.3.0.0-IA1vwAbagmRJhy7paqdrR0
license:              MPL-2.0
copyright:            Copyright (c) 2014-2020 Brendan Hay
maintainer:           Brendan Hay <brendan.g.hay@gmail.com>
author:               Brendan Hay
homepage:             https://github.com/brendanhay/text-manipulate
synopsis:
    Case conversion, word boundary manipulation, and textual subjugation.

description:
    Manipulate identifiers and structurally non-complex pieces
    of text by delimiting word boundaries via a combination of whitespace,
    control-characters, and case-sensitivity.

    Has support for common idioms like casing of programmatic variable names,
    taking, dropping, and splitting by word, and modifying the first character
    of a piece of text.

    /Caution:/ this library makes heavy use of the <http://hackage.haskell.org/package/text text>
    library'\''s internal loop optimisation framework. Since internal modules are not
    guaranteed to have a stable API there is potential for build breakage when
    the text dependency is upgraded. Consider yourself warned!

category:             Data, Text
abi:                  8c778c18d3ed09690a0dade706fdfd48
exposed:              True
exposed-modules:      Data.Text.Lazy.Manipulate Data.Text.Manipulate
hidden-modules:
    Data.Text.Manipulate.Internal.Fusion
    Data.Text.Manipulate.Internal.Types

import-dirs:          /usr/lib/ghc-8.10.5/site-local/text-manipulate-0.3.0.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/text-manipulate-0.3.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/text-manipulate-0.3.0.0
hs-libraries:         HStext-manipulate-0.3.0.0-IA1vwAbagmRJhy7paqdrR0
depends:              base-4.14.2.0 text-1.2.4.1
haddock-interfaces:
    /usr/share/doc/haskell-text-manipulate/html/text-manipulate.haddock

haddock-html:         /usr/share/doc/haskell-text-manipulate/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

