#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 snap-server
version:              1.1.2.0
visibility:           public
id:                   snap-server-1.1.2.0-50B0DPbTr5JHJkqPUE2fiY
key:                  snap-server-1.1.2.0-50B0DPbTr5JHJkqPUE2fiY
license:              BSD-3-Clause
maintainer:           snap@snapframework.com
author:               Snap Framework Authors  (see CONTRIBUTORS)
homepage:             http://snapframework.com/
synopsis:             A web server for the Snap Framework
description:
    Snap is a simple and fast web development framework and server written in
    Haskell. For more information or to download the latest version, you can
    visit the Snap project website at <http://snapframework.com/>.

    The Snap HTTP server is a high performance web server library written in
    Haskell. Together with the @snap-core@ library upon which it depends, it
    provides a clean and efficient Haskell programming interface to the HTTP
    protocol.

category:             Web, Snap, IO-Streams
abi:                  1e55fcb624b2c4986ee5fa26318ec405
exposed:              True
exposed-modules:
    Snap.Http.Server Snap.Http.Server.Config Snap.Http.Server.Types
    Snap.Internal.Http.Server.Config Snap.Internal.Http.Server.Types
    System.FastLogger

hidden-modules:
    Paths_snap_server Control.Concurrent.Extended
    Snap.Internal.Http.Server.Address Snap.Internal.Http.Server.Clock
    Snap.Internal.Http.Server.Common Snap.Internal.Http.Server.Date
    Snap.Internal.Http.Server.Parser Snap.Internal.Http.Server.Session
    Snap.Internal.Http.Server.Socket Snap.Internal.Http.Server.Thread
    Snap.Internal.Http.Server.TimeoutManager
    Snap.Internal.Http.Server.TLS System.SendFile System.SendFile.Linux

import-dirs:          /usr/lib/ghc-8.10.5/site-local/snap-server-1.1.2.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/snap-server-1.1.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/snap-server-1.1.2.0
hs-libraries:         HSsnap-server-1.1.2.0-50B0DPbTr5JHJkqPUE2fiY
depends:
    attoparsec-0.14.1-IwUGXYiDhQIB5nUHrI5Wg8 base-4.14.2.0
    blaze-builder-0.4.2.1-CvyaA91rGJh3LGq34EOJVB bytestring-0.10.12.0
    case-insensitive-1.2.1.0-6tEs2ust6UoJNkdDoolIXx
    clock-0.8.2-CUh6FGzlB8CArRlXh1LKmY containers-0.6.4.1
    filepath-1.4.2.1 io-streams-1.5.2.1-on5nq7OVSrHHs81Uq5NSL
    io-streams-haproxy-1.0.1.0-B2t8ESRziVqKBBqZQqEiva
    lifted-base-0.2.3.12-HsHHuUVdYcr6iiSvL0hwyv mtl-2.2.2
    network-3.1.2.2-DhUKX0ZpAd35HJ7CPbrOZd
    old-locale-1.0.0.7-L6Wsx5CTYHFJNpULKIS1yv
    snap-core-1.0.4.2-LQ36wf2hhYuCroh19r11kG text-1.2.4.1 time-1.9.3
    transformers-0.5.6.2 unix-2.7.2.2
    unix-compat-0.5.3-1KqjYp6svTH6EdzCzH8QEz
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp

haddock-interfaces:   /usr/share/doc/haskell-snap-server/html/snap-server.haddock
haddock-html:         /usr/share/doc/haskell-snap-server/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

